/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import org.basex.core.MainOptions;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.func.fn.FnError;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.parse.Params;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Closure
extends Single
implements Scope,
XQFunctionExpr {
    private final QNm name;
    private final Var[] params;
    private SeqType declType;
    private AnnList anns;
    private boolean updating;
    private final EnumMap<Flag, Boolean> map = new EnumMap(Flag.class);
    private boolean compiled;
    private boolean dontEnter;
    private final VarScope vs;
    private final Map<Var, Expr> global;

    public Closure(InputInfo info, Expr expr, Params params, AnnList anns, VarScope vs, Map<Var, Expr> global) {
        this(info, expr, params.vars(), anns, vs, global, params.seqType(), null);
    }

    Closure(InputInfo info, Expr expr, Var[] params, AnnList anns, VarScope vs, Map<Var, Expr> global, SeqType declType, QNm name) {
        super(info, expr, Types.FUNCTION_O);
        this.params = params;
        this.anns = anns;
        this.vs = vs;
        this.global = global == null ? Collections.emptyMap() : global;
        this.declType = declType == null || declType.eq(Types.ITEM_ZM) ? null : declType;
        this.name = name;
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int pos) {
        return this.params[pos].name;
    }

    @Override
    public FuncType funcType() {
        FuncType ft = super.funcType();
        return ft != null ? ft : FuncType.get(this.anns, this.declType, this.params);
    }

    @Override
    public AnnList annotations() {
        return this.anns;
    }

    @Override
    public void reset() {
        this.compiled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        if (this.compiled) {
            return this;
        }
        this.compiled = true;
        this.checkUpdating();
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            Expr bound = entry.getValue().compile(cc);
            entry.setValue(bound);
            entry.getKey().refineType(bound.seqType(), cc);
        }
        cc.pushScope(this.vs);
        try {
            this.expr = cc.compileOrError(this.expr, false);
        }
        finally {
            cc.removeScope(this);
        }
        this.expr.markTailCalls(cc);
        return this.optimize(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr optimize(CompileContext cc) {
        cc.pushScope(this.vs);
        try {
            Iterator<Map.Entry<Var, Expr>> iter = this.global.entrySet().iterator();
            HashMap<Var, Expr> add = null;
            int limit = cc.qc.context.options.get(MainOptions.INLINELIMIT);
            while (iter.hasNext()) {
                Closure cl;
                Map.Entry<Var, Expr> entry = iter.next();
                Var var = entry.getKey();
                Expr ex = entry.getValue();
                Expr inline = null;
                if (ex instanceof Value) {
                    Value value = (Value)ex;
                    inline = var.checkType(value, cc.qc, cc);
                } else if (ex instanceof Closure && !(cl = (Closure)ex).has(Flag.NDT) && cl.global.size() < 5 && this.expr.count(var) != VarUsage.MORE_THAN_ONCE && cl.exprSize() < limit) {
                    cc.info("inline %", entry);
                    for (Map.Entry<Var, Expr> expr2 : cl.global.entrySet()) {
                        Var var2 = cc.copy(expr2.getKey(), null);
                        if (add == null) {
                            add = new HashMap<Var, Expr>();
                        }
                        add.put(var2, expr2.getValue());
                        expr2.setValue(new VarRef(cl.info, var2).optimize(cc));
                    }
                    inline = cl;
                }
                if (inline == null) continue;
                this.expr = new InlineContext(var, inline, cc).inline(this.expr);
                iter.remove();
            }
            if (add != null) {
                this.global.putAll(add);
            }
        }
        catch (QueryException ex) {
            this.expr = FnError.get(ex, this.expr);
        }
        finally {
            cc.removeScope(this);
        }
        SeqType st = this.expr.seqType();
        SeqType dt = this.declType == null || st.instanceOf(this.declType) ? st : this.declType;
        this.exprType.assign(FuncType.get(this.anns, dt, this.params));
        if (this.global.isEmpty() && !cc.largeResult(this.expr)) {
            try {
                return cc.preEval(this);
            }
            catch (QueryException ex) {
                this.expr = FnError.get(ex, this.expr);
            }
        }
        return this;
    }

    @Override
    public VarUsage count(Var var) {
        Expr ex;
        VarUsage all = VarUsage.NEVER;
        Iterator<Expr> iterator = this.global.values().iterator();
        while (iterator.hasNext() && (all = all.plus((ex = iterator.next()).count(var))) != VarUsage.MORE_THAN_ONCE) {
        }
        return all;
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = false;
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            Expr inlined = entry.getValue().inline(ic);
            if (inlined == null) continue;
            changed = true;
            entry.setValue(inlined);
        }
        if (!changed) {
            return null;
        }
        this.map.clear();
        return this.optimize(ic.cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        VarScope vsc = new VarScope();
        HashMap<Var, Expr> outer = new HashMap<Var, Expr>();
        this.global.forEach((key, value) -> outer.put((Var)key, value.copy(cc, vm)));
        cc.pushScope(vsc);
        try {
            IntObjectMap<Var> innerVars = new IntObjectMap<Var>();
            this.vs.copy(cc, innerVars);
            HashMap<Var, Expr> bindings = new HashMap<Var, Expr>();
            outer.forEach((key, value) -> bindings.put((Var)innerVars.get(key.id), (Expr)value));
            Var[] prms = (Var[])this.params.clone();
            int pl = prms.length;
            for (int p = 0; p < pl; ++p) {
                prms[p] = innerVars.get(prms[p].id);
            }
            Expr ex = this.expr.copy(cc, innerVars);
            ex.markTailCalls(null);
            Closure closure = this.copyType(new Closure(this.info, ex, prms, this.anns, cc.vs(), bindings, this.declType, this.name));
            return closure;
        }
        finally {
            cc.removeScope();
        }
    }

    @Override
    public Expr inline(Expr[] exprs, CompileContext cc) throws QueryException {
        if (!cc.inlineable(this.anns, this.expr) || this.expr.has(Flag.CTX)) {
            return null;
        }
        cc.info("inline %", this);
        LinkedList<Clause> clauses = new LinkedList<Clause>();
        IntObjectMap<Var> vm = new IntObjectMap<Var>();
        int pl = this.params.length;
        for (int p = 0; p < pl; ++p) {
            clauses.add(new Let(cc.copy(this.params[p], vm), exprs[p]).optimize(cc));
        }
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            clauses.add(new Let(cc.copy(entry.getKey(), vm), entry.getValue()).optimize(cc));
        }
        Expr body = this.expr.copy(cc, vm).optimize(cc);
        Expr rtrn = this.declType == null ? body : new TypeCheck(this.info, body, this.declType).optimize(cc);
        return clauses.isEmpty() ? rtrn : new GFLWOR(this.info, clauses, rtrn).optimize(cc);
    }

    @Override
    public FuncItem item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr checked;
        Expr body;
        if (this.global.isEmpty()) {
            body = this.expr;
        } else {
            LinkedList<Clause> clauses = new LinkedList<Clause>();
            for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
                clauses.add(new Let(entry.getKey(), entry.getValue().value(qc)));
            }
            body = new GFLWOR(this.info, clauses, this.expr);
        }
        SeqType argType = body.seqType();
        if (this.declType == null || argType.instanceOf(this.declType)) {
            checked = body;
        } else if (body instanceof Value) {
            Value value = (Value)body;
            checked = this.declType.coerce(value, this.name, qc, null, this.info);
        } else {
            if (argType.type.instanceOf(this.declType.type) && argType.occ.intersect(this.declType.occ) == null && !body.has(Flag.NDT)) {
                throw QueryError.typeError(body, this.declType, this.name, this.info);
            }
            checked = new TypeCheck(this.info, body, this.declType);
        }
        FuncType ft = (FuncType)this.seqType().type;
        return new FuncItem(this.info, checked, this.params, this.anns, ft, this.vs.stackSize(), this.name);
    }

    @Override
    public boolean has(Flag ... flags) {
        if (Flag.UPD.oneOf(flags)) {
            return false;
        }
        ArrayList<Flag> flgs = new ArrayList<Flag>();
        for (Object flag2 : flags) {
            if (this.map.containsKey(flag2)) continue;
            this.map.put((Flag)((Object)flag2), Boolean.FALSE);
            flgs.add((Flag)((Object)flag2));
        }
        for (Flag flag : flgs) {
            Object flag2;
            boolean f = false;
            flag2 = this.global.values().iterator();
            while (flag2.hasNext()) {
                Expr ex = (Expr)flag2.next();
                f = f || ex.has(flag);
            }
            this.map.put(flag, f || this.expr.has(flag));
        }
        for (Object flag2 : flags) {
            if (!this.map.get(flag2).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Expr ex : this.global.values()) {
            if (ex.inlineable(ic)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            if (entry.getValue().accept(visitor) && visitor.declared(entry.getKey())) continue;
            return false;
        }
        for (Var param : this.params) {
            if (visitor.declared(param)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkUpdating();
        if (this.updating) {
            this.expr.checkUp();
            if (this.declType != null && !this.declType.zero()) {
                throw QueryError.UUPFUNCTYPE.get(this.info, new Object[0]);
            }
        }
    }

    @Override
    public boolean vacuous() {
        return this.declType != null && this.declType.zero() && !this.has(Flag.UPD);
    }

    @Override
    public boolean vacuousBody() {
        return this.vacuous();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return !this.dontEnter && (Boolean)this.enter(() -> {
            for (Expr ex : this.global.values()) {
                if (ex.accept(visitor)) continue;
                return false;
            }
            return visitor.inlineFunc(this);
        }) != false;
    }

    @Override
    public int exprSize() {
        return this.dontEnter ? 1 : (Integer)this.enter(() -> {
            int size = 1;
            for (Expr ex : this.global.values()) {
                size += ex.exprSize();
            }
            return size + this.expr.exprSize();
        });
    }

    @Override
    public boolean compiled() {
        return this.compiled;
    }

    public Iterator<Map.Entry<Var, Expr>> globalBindings() {
        return this.global.entrySet().iterator();
    }

    void setSignature(FuncType ft) {
        this.anns = ft.anns;
        int pl = this.params.length;
        for (int p = 0; p < pl; ++p) {
            this.params[p].declType = ft.argTypes[p];
        }
        SeqType dt = ft.declType;
        if (!dt.eq(Types.ITEM_ZM)) {
            this.declType = dt;
        }
    }

    private void checkUpdating() throws QueryException {
        this.updating = this.expr.has(Flag.UPD);
        boolean upd = this.anns.contains(Annotation.UPDATING);
        if (this.updating != upd) {
            if (!upd) {
                this.anns = this.anns.attach(new Ann(this.info, Annotation.UPDATING, (Value)Empty.VALUE));
            } else if (!this.expr.vacuous()) {
                throw QueryError.UPEXPECTF.get(this.info, new Object[0]);
            }
        }
    }

    private Object enter(Supplier<Object> code) {
        this.dontEnter = true;
        try {
            Object object = code.get();
            return object;
        }
        finally {
            this.dontEnter = false;
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public void toXml(QueryPlan plan) {
        if (this.dontEnter) {
            return;
        }
        this.enter(() -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.params);
            this.global.forEach((key, value) -> {
                list.add(key);
                list.add(value);
            });
            list.add(this.expr);
            plan.add(plan.create(this, new Object[0]), list.toArray());
            return null;
        });
    }

    @Override
    public void toString(QueryString qs) {
        if (this.dontEnter) {
            qs.token("...");
        } else {
            this.enter(() -> {
                boolean inlined;
                boolean bl = inlined = !this.global.isEmpty();
                if (inlined) {
                    qs.token("((: closure :) ");
                    this.global.forEach((k, v) -> qs.token("let").token(k).token(":=").token(v));
                    qs.token("return");
                }
                qs.token("fn").params(this.params);
                qs.token("as").token(this.declType != null ? this.declType : Types.ITEM_ZM).brace(this.expr);
                if (inlined) {
                    qs.token(')');
                }
                return null;
            });
        }
    }
}

