/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryBiFunction;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.gflwor.FLWORBuilder;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.XQStruct;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.InputInfo;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjectMap;

public final class Lookup
extends Arr {
    public static final Str WILDCARD = Str.get(42);

    public Lookup(InputInfo info, Expr ... expr) {
        super(info, Types.ITEM_ZM, expr);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.exprs[1] = this.exprs[1].simplifyFor(CompileContext.Simplify.DATA, cc);
        Expr inputs = this.exprs[0];
        long is = inputs.size();
        if (is == 0L) {
            return cc.replaceWith(this, inputs);
        }
        Type tp = inputs.seqType().type;
        boolean map = tp instanceof MapType;
        boolean array = tp instanceof ArrayType;
        if (!map && !array) {
            return this;
        }
        Expr expr = this.opt(cc);
        if (expr != this) {
            return cc.replaceWith(this, expr);
        }
        Expr keys = this.exprs[1];
        SeqType kt = keys.seqType();
        SeqType st = map ? ((MapType)tp).valueType() : ((ArrayType)tp).valueType();
        Occ occ = st.occ;
        if (inputs.size() != 1L || keys == WILDCARD || !kt.one() || kt.mayBeArray()) {
            occ = occ.union(Occ.ZERO_OR_MORE);
        } else if (map) {
            occ = occ.union(Occ.ZERO);
        }
        this.exprType.assign(st.type, occ);
        return this;
    }

    private Expr opt(CompileContext cc) throws QueryException {
        long ks;
        Expr input = this.exprs[0];
        Expr keys = this.exprs[1];
        long is = input.size();
        long l = ks = keys.seqType().mayBeArray() || keys.has(Flag.NDT) ? -1L : keys.size();
        if (ks == 0L) {
            return keys;
        }
        Type it = input.seqType().type;
        boolean map = it instanceof MapType;
        boolean array = it instanceof ArrayType;
        if (map || array) {
            QueryBiFunction<Expr, Expr, Expr> rewrite = (in, arg) -> keys == WILDCARD ? cc.function(map ? Function._MAP_ITEMS : Function._ARRAY_ITEMS, this.info, (Expr)in) : cc.function(map ? Function._MAP_GET : Function._ARRAY_GET, this.info, (Expr)in, (Expr)arg);
            if (ks == 1L) {
                if (is == 1L) {
                    return rewrite.apply(input, keys);
                }
                return SimpleMap.get(cc, this.info, input, cc.get(input, true, () -> (Expr)rewrite.apply(ContextValue.get(cc, this.info), keys)));
            }
            if (ks != -1L && (input instanceof Value || input instanceof VarRef)) {
                if (is == 1L) {
                    return SimpleMap.get(cc, this.info, keys, cc.get(keys, true, () -> (Expr)rewrite.apply(input, ContextValue.get(cc, this.info))));
                }
                FLWORBuilder flwor = new FLWORBuilder(1, cc, this.info);
                Expr next = cc.get(keys, true, () -> (Expr)rewrite.apply(flwor.ref(flwor.item), ContextValue.get(cc, this.info)));
                Expr rtrn = SimpleMap.get(cc, this.info, keys, next);
                return flwor.finish(input, null, rtrn);
            }
        }
        return this;
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        return new Iter(){
            final Iter iter;
            Iter ir;
            {
                this.iter = Lookup.this.exprs[0].iter(qc);
            }

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.ir == null || (item = qc.next(this.ir)) == null) {
                    item = qc.next(this.iter);
                    if (item == null) {
                        return null;
                    }
                    this.ir = Lookup.this.valueFor(item, qc).iter();
                }
                return item;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item item;
        ValueBuilder vb = new ValueBuilder(qc);
        Iter iter = this.exprs[0].iter(qc);
        while ((item = qc.next(iter)) != null) {
            vb.add(this.valueFor(item, qc));
        }
        return vb.value(this);
    }

    private Value valueFor(Item item, QueryContext qc) throws QueryException {
        Item key;
        if (!(item instanceof XQStruct)) {
            throw QueryError.LOOKUP_X.get(this.info, item);
        }
        XQStruct struct = (XQStruct)item;
        Expr keys = this.exprs[1];
        if (keys == WILDCARD) {
            return struct.items(qc);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        Iter ir = keys.atomIter(qc, this.info);
        while ((key = ir.next()) != null) {
            vb.add(struct.invoke(qc, this.info, key));
        }
        return vb.value(this);
    }

    @Override
    public Lookup copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Lookup(this.info, Lookup.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Lookup && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        Itr itr;
        long l;
        qs.token(this.exprs[0]).token('?');
        Expr keys = this.exprs[1];
        Object key = null;
        if (keys == WILDCARD) {
            key = WILDCARD.string();
        } else if (keys instanceof Str) {
            Str str = (Str)keys;
            if (XMLToken.isNCName(str.string())) {
                key = str.toJava();
            }
        } else if (keys instanceof Itr && (l = (itr = (Itr)keys).itr()) >= 0L) {
            key = l;
        }
        if (key != null) {
            qs.token(key);
        } else {
            qs.paren(keys);
        }
    }
}

