/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Execute;
import org.basex.core.cmd.Test;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIMenu;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogBindings;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXHeader;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXSplit;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXToolBar;
import org.basex.gui.layout.GUICode;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.editor.EditorArea;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.InputException;
import org.basex.io.in.NewlineInput;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.parse.xml.XmlParser;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryParser;
import org.basex.query.func.Function;
import org.basex.query.value.item.Atm;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.xml.sax.SAXParseException;

public final class EditorView
extends View {
    private static final int WAIT_DELAY = 250;
    private static final int SEARCH_DELAY = 100;
    private static final Pattern LINK = Pattern.compile("(.*?), (\\d+)/(\\d+)");
    final ProjectView project;
    final AbstractButton test;
    private final AbstractButton history;
    private final AbstractButton stop;
    private final SearchBar search;
    private final BaseXLabel info;
    private final BaseXLabel pos;
    private final BaseXSplit split;
    private final BaseXTabs tabs;
    private final BaseXLabel context;
    private IOFile execFile;
    private DBNode doc;
    private final AtomicInteger parseID = new AtomicInteger();
    private final AtomicBoolean parsing = new AtomicBoolean();
    private InputInfo inputInfo;
    public final GUICode posCode = new GUICode(){

        @Override
        public void execute(Object arg) {
            int[] cp = EditorView.this.getEditor().caretPos();
            EditorView.this.pos.setText(cp[0] + " : " + cp[1]);
        }
    };

    public EditorView(ViewNotifier notifier) {
        super("editor", notifier);
        this.layout(new BorderLayout());
        this.setBackground(GUIConstants.PANEL);
        this.tabs = new BaseXTabs(this.gui);
        this.tabs.setFocusable(Prop.MAC);
        this.tabs.addDragDrop();
        this.tabs.setTabLayoutPolicy(this.gui.gopts.get(GUIOptions.SCROLLTABS) != false ? 1 : 0);
        this.tabs.addMouseListener(e -> {
            Component patt3188$temp;
            int i = this.tabs.indexAtLocation(e.getX(), e.getY());
            if (i != -1 && SwingUtilities.isMiddleMouseButton(e) && (patt3188$temp = this.tabs.getComponentAt(i)) instanceof EditorArea) {
                EditorArea edit = (EditorArea)patt3188$temp;
                this.close(edit);
            }
        });
        SearchEditor center = new SearchEditor(this.gui, this.tabs, null);
        this.search = center.bar();
        AbstractButton newB = BaseXButton.command(GUIMenuCmd.C_EDIT_NEW, this.gui);
        AbstractButton openB = BaseXButton.command(GUIMenuCmd.C_EDIT_OPEN, this.gui);
        AbstractButton saveB = BaseXButton.get("c_save", Text.SAVE, false, this.gui);
        AbstractButton find = this.search.button(Text.FIND_REPLACE);
        AbstractButton vars = BaseXButton.command(GUIMenuCmd.C_EXTERNAL_VARIABLES, this.gui);
        AbstractButton go = BaseXButton.command(GUIMenuCmd.C_GO, this.gui);
        this.history = BaseXButton.get("c_history", BaseXLayout.addShortcut(Text.RECENTLY_OPENED, BaseXKeys.HISTORY.toString()), false, this.gui);
        this.stop = BaseXButton.command(GUIMenuCmd.C_STOP, this.gui);
        this.stop.setEnabled(false);
        this.test = BaseXButton.get("c_test", BaseXLayout.addShortcut(Text.RUN_TESTS, BaseXKeys.TESTS.toString()), false, this.gui);
        BaseXToolBar buttons = new BaseXToolBar();
        buttons.add(newB);
        buttons.add(openB);
        buttons.add(saveB);
        buttons.add(this.history);
        buttons.addSeparator();
        buttons.add(go);
        buttons.add(this.stop);
        buttons.add(vars);
        buttons.add(this.test);
        buttons.addSeparator();
        buttons.add(find);
        this.context = new BaseXLabel("").resize(1.25f);
        this.context.setForeground(GUIConstants.dgray);
        BaseXBack north = new BaseXBack(false).layout(new BorderLayout(10, 0)).border(0, 0, 4, 0);
        north.add((Component)buttons, "West");
        north.add((Component)this.context, "Center");
        north.add((Component)new BaseXHeader(Text.EDITOR), "East");
        this.search.editor(this.addTab(), false);
        this.info = new BaseXLabel().setText("OK", GUIConstants.Msg.SUCCESS).resize(1.25f);
        this.pos = new BaseXLabel(" ").resize(1.25f);
        this.posCode.invokeLater();
        BaseXBack south = new BaseXBack(false).border(8, 0, 0, 0);
        south.layout(new BorderLayout(4, 0));
        south.add((Component)this.info, "Center");
        south.add((Component)this.pos, "East");
        BaseXBack main = new BaseXBack().border(5);
        main.setOpaque(false);
        main.layout(new BorderLayout());
        main.add((Component)north, "North");
        main.add((Component)center, "Center");
        main.add((Component)south, "South");
        this.project = new ProjectView(this);
        this.split = new BaseXSplit(true);
        this.split.setOpaque(false);
        this.split.add(this.project);
        this.split.add(main);
        this.split.init(new double[]{0.3, 0.7}, new double[]{0.0, 1.0});
        this.toggleProject();
        this.add((Component)this.split, "Center");
        this.refreshLayout();
        saveB.addActionListener(e -> {
            JPopupMenu pop = new JPopupMenu();
            StringBuilder mnem = new StringBuilder();
            JMenuItem sa = GUIMenu.newItem(GUIMenuCmd.C_EDIT_SAVE, this.gui, mnem);
            JMenuItem sas = GUIMenu.newItem(GUIMenuCmd.C_EDIT_SAVE_AS, this.gui, mnem);
            sa.setEnabled(GUIMenuCmd.C_EDIT_SAVE.enabled(this.gui));
            sas.setEnabled(GUIMenuCmd.C_EDIT_SAVE_AS.enabled(this.gui));
            pop.add(sa);
            pop.add(sas);
            pop.show(saveB, 0, saveB.getHeight());
        });
        this.history.addActionListener(e -> this.historyPopup(0));
        this.refreshHistory(null);
        this.info.addMouseListener(e -> this.markError(true));
        this.test.addActionListener(e -> this.run(this.getEditor(), TextPanel.Action.TEST));
        this.tabs.addChangeListener(e -> {
            EditorArea ea = this.getEditor();
            if (ea == null) {
                return;
            }
            this.search.editor(ea, true);
            this.gui.refreshControls(false);
            this.posCode.invokeLater();
            this.refreshMark();
            this.run(ea, TextPanel.Action.PARSE);
            this.gui.setTitle();
        });
        BaseXLayout.addDrop(this, obj -> {
            if (obj instanceof File) {
                File file = (File)obj;
                this.open(new IOFile(file));
            }
        });
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
        EditorArea edit = this.getEditor();
        this.test.setEnabled(edit.file().hasSuffix(IO.XQSUFFIXES) && !edit.modified());
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshLayout() {
        for (EditorArea edit : this.editors()) {
            edit.refreshLayout(GUIConstants.mfont);
        }
        this.project.refreshLayout();
        this.search.refreshLayout();
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWEDITOR);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWEDITOR, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void historyPopup(int start) {
        HashSet<String> opened = new HashSet<String>();
        for (EditorArea edit : this.editors()) {
            opened.add(edit.file().path());
        }
        ArrayList<String> paths = new ArrayList<String>(opened);
        for (String path : this.gui.gopts.get(GUIOptions.EDITOR)) {
            if (paths.contains(path)) continue;
            paths.add(path);
        }
        paths.sort((path1, path2) -> {
            boolean c2;
            boolean c1 = opened.contains(path1);
            return c1 == (c2 = opened.contains(path2)) ? path1.compareTo((String)path2) : (c1 ? -1 : 1);
        });
        JPopupMenu menu = new JPopupMenu();
        int p = start - 1;
        int max = Math.min(paths.size(), start + 25);
        if (start > 0) {
            menu.add(new JMenuItem("...")).addActionListener(ac -> this.historyPopup(start - 25));
        }
        while (++p < max) {
            String path;
            path = (String)paths.get(p);
            IOFile file = new IOFile(path);
            String label = file.name() + " \u00b7 " + BaseXLayout.reversePath(file);
            JMenuItem item = new JMenuItem(label);
            item.setToolTipText(BaseXLayout.info(file, true));
            if (opened.contains(path)) {
                BaseXLayout.boldFont(item);
            }
            menu.add(item).addActionListener(ac -> this.open(file));
        }
        if (p < paths.size()) {
            menu.add(new JMenuItem("...")).addActionListener(ac -> this.historyPopup(start + 25));
        }
        menu.show(this.history, 0, this.history.getHeight());
    }

    public void refreshContextLabel() {
        Object label = this.context();
        Object object = label = ((String)label).isEmpty() ? "" : "Context: " + (String)label;
        if (!this.context.getText().equals(label)) {
            this.context.setText((String)label);
        }
    }

    public void setContext(IOFile file) {
        try {
            if (Close.close(this.gui.context)) {
                this.gui.notify.init();
            }
            this.doc = new DBNode(file);
            Map<String, String> map = this.gui.context.options.toMap(MainOptions.BINDINGS);
            map.remove("");
            DialogBindings.assign(map, this.gui);
            this.refreshContextLabel();
        }
        catch (IOException ex) {
            Util.debug(ex);
            BaseXDialog.error(this.gui, Util.info(ex, new Object[0]));
        }
    }

    public String context() {
        Data data;
        String value = this.gui.context.options.toMap(MainOptions.BINDINGS).get("");
        if (value != null) {
            value = Strings.concat("xs:untypedAtomic(", Atm.get(value), Character.valueOf(')'));
        }
        if (value == null && (data = this.gui.context.data()) != null) {
            value = Function._DB_GET.args(data.meta.name);
        }
        if (value == null) {
            if (this.doc != null) {
                value = Function.DOC.args(new IOFile(this.doc.data().meta.original).name());
            }
        } else {
            this.doc = null;
        }
        return value != null ? value.trim() : "";
    }

    public void showProject() {
        if (!this.gui.gopts.get(GUIOptions.SHOWPROJECT).booleanValue()) {
            this.gui.gopts.invert(GUIOptions.SHOWPROJECT);
            this.split.visible(true);
        }
    }

    public void toggleProject() {
        boolean show = this.gui.gopts.get(GUIOptions.SHOWPROJECT);
        this.split.visible(show);
        if (show) {
            this.project.focus();
        } else {
            this.focusEditor();
        }
    }

    public void findFiles() {
        this.project.findFiles(this.getEditor());
    }

    public void focusEditor() {
        SwingUtilities.invokeLater(() -> this.getEditor().requestFocusInWindow());
    }

    public void jumpToFile() {
        this.project.jumpTo(this.getEditor().file(), true);
    }

    public void tab(boolean next) {
        int s = this.tabs.getTabCount();
        int i = (s + this.tabs.getSelectedIndex() + (next ? 1 : -1)) % s;
        this.tabs.setSelectedIndex(i);
    }

    public void init(ArrayList<IOFile> files) {
        for (String file : this.gui.gopts.get(GUIOptions.OPEN)) {
            this.open(new IOFile(file), true, false);
        }
        for (IOFile file : files) {
            this.open(file, true, false);
        }
        EditorArea edit = this.getEditor();
        String prefix = Prop.HOMEDIR.hashCode() + "-";
        for (IOFile file : new IOFile(Prop.TEMPDIR, Prop.PROJECT).children()) {
            if (!file.name().startsWith(prefix)) continue;
            try {
                byte[] text = this.read(file);
                if (text == null) continue;
                EditorArea ea = this.addTab();
                ea.setText(text);
                this.refreshControls(ea, true);
                file.delete();
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        if (!edit.opened()) {
            this.closeEditor(edit);
        }
        this.gui.setTitle();
    }

    public void open() {
        BaseXFileChooser fc = new BaseXFileChooser(this.gui, Text.OPEN, this.gui.gopts.get(GUIOptions.WORKPATH));
        fc.filter("XQuery Files", false, IO.XQSUFFIXES);
        fc.filter("Command Scripts", false, ".bxs");
        fc.textFilters();
        for (IOFile f : fc.multi().selectAll(BaseXFileChooser.Mode.FOPEN)) {
            this.open(f);
        }
    }

    public boolean save() {
        EditorArea edit = this.getEditor();
        return edit.opened() ? edit.save() : this.saveAs();
    }

    public boolean saveAs() {
        EditorArea edit = this.getEditor();
        String path = edit.opened() ? edit.file().path() : this.gui.gopts.get(GUIOptions.WORKPATH);
        BaseXFileChooser fc = new BaseXFileChooser(this.gui, Text.SAVE_AS, path);
        fc.filter("XQuery Files", false, IO.XQSUFFIXES);
        fc.filter("Command Scripts", false, ".bxs");
        fc.textFilters();
        fc.suffix(".xq");
        IOFile file = fc.select(BaseXFileChooser.Mode.FSAVE);
        if (file == null || !edit.save(file)) {
            return false;
        }
        this.run(edit, TextPanel.Action.PARSE);
        return true;
    }

    public void newFile() {
        if (!this.visible()) {
            GUIMenuCmd.C_SHOW_EDITOR.execute(this.gui);
        }
        this.refreshControls(this.addTab(), true);
    }

    public boolean delete(IOFile file) {
        EditorArea edit = this.find(file);
        if (edit != null) {
            this.close(edit);
        }
        return file.delete();
    }

    public EditorArea open(IOFile file) {
        return this.open(file, true, true);
    }

    private EditorArea open(IOFile file, boolean parse, boolean error) {
        EditorArea edit;
        if (!this.visible()) {
            GUIMenuCmd.C_SHOW_EDITOR.execute(this.gui);
        }
        if ((edit = this.find(file)) != null) {
            this.tabs.setSelectedComponent(edit);
        } else {
            try {
                byte[] text = this.read(file);
                if (text == null) {
                    return null;
                }
                edit = this.getEditor();
                if (edit.opened() || edit.modified()) {
                    edit = this.addTab();
                }
                edit.initText(text);
                edit.file(file, error);
                if (parse) {
                    this.run(edit, TextPanel.Action.PARSE);
                }
            }
            catch (IOException ex) {
                this.refreshHistory(null);
                Util.debug(ex);
                if (error) {
                    BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_OPENED_X, file));
                }
                return null;
            }
        }
        this.focusEditor();
        return edit;
    }

    public void run() {
        this.run(this.getEditor(), TextPanel.Action.EXECUTE);
    }

    void run(EditorArea editor, TextPanel.Action action) {
        IOFile file;
        this.refreshControls(editor, false);
        byte[] text = editor.getText();
        if (Token.eq(text, editor.last) && action == TextPanel.Action.CHECK) {
            return;
        }
        editor.last = text;
        if (this.gui.gopts.get(GUIOptions.SAVERUN).booleanValue() && (action == TextPanel.Action.EXECUTE || action == TextPanel.Action.TEST)) {
            for (EditorArea edit : this.editors()) {
                if (!edit.opened()) continue;
                edit.save();
            }
        }
        boolean xquery = (file = editor.file()).hasSuffix(IO.XQSUFFIXES) || !file.name().contains(".");
        boolean script = file.hasSuffix(".bxs");
        if (action == TextPanel.Action.TEST) {
            if (xquery) {
                this.gui.execute(true, new Test(file.path()));
            }
        } else if (action == TextPanel.Action.EXECUTE && script) {
            this.gui.execute(true, new Execute(Token.string(text)).baseURI(file.path()));
        } else if (action == TextPanel.Action.EXECUTE || xquery) {
            String input = Token.string(text);
            if (action == TextPanel.Action.EXECUTE || this.gui.gopts.get(GUIOptions.EXECRT).booleanValue()) {
                if (!xquery || QueryParser.isLibrary(input)) {
                    EditorArea ea = this.execEditor();
                    if (ea == null) {
                        return;
                    }
                    file = ea.file();
                    input = Token.string(ea.getText());
                }
                XQuery cmd = new XQuery(input);
                if (this.doc != null) {
                    cmd.bind(null, this.doc);
                }
                this.gui.execute(true, cmd.baseURI(file.path()));
                this.execFile = file;
            } else {
                this.parse(input.isEmpty() ? "()" : input, file);
            }
        } else if (file.hasSuffix(".json")) {
            try {
                IOContent io = new IOContent(text);
                io.name(file.path());
                JsonConverter.get(new JsonParserOptions()).convert(io);
                this.info(null);
            }
            catch (IOException | QueryException ex) {
                this.info(ex);
            }
        } else if (script || file.hasSuffix(this.gui.gopts.xmlSuffixes()) || file.hasSuffix(IO.XSLSUFFIXES)) {
            ArrayInput ai = new ArrayInput(text);
            try {
                if (Token.startsWith(text, 60) || !script) {
                    new XmlParser().parse(ai);
                }
                if (script) {
                    CommandParser.get(Token.string(text), this.gui.context).parse();
                }
                this.info(null);
            }
            catch (Exception ex) {
                this.info(ex);
            }
        } else if (action != TextPanel.Action.CHECK) {
            this.info(null);
        } else {
            this.info.setText("OK", GUIConstants.Msg.SUCCESS);
        }
    }

    private void info(Exception ex) {
        this.info(ex, false, false);
    }

    private EditorArea execEditor() {
        IOFile file = this.execFile;
        if (file != null) {
            for (EditorArea edit : this.editors()) {
                if (!edit.file().path().equals(file.path())) continue;
                return edit;
            }
            this.execFile = null;
        }
        return null;
    }

    private byte[] read(IOFile file) throws IOException {
        try {
            return new NewlineInput(file).validate(true).content();
        }
        catch (InputException ex) {
            Util.debug(ex);
            String button = BaseXDialog.yesNoCancel(this.gui, Text.H_FILE_BINARY, new String[0]);
            if (button == Text.B_NO) {
                return new NewlineInput(file).content();
            }
            if (button == Text.B_YES) {
                try {
                    file.open();
                }
                catch (IOException ioex) {
                    Util.debug(ioex);
                    Desktop.getDesktop().open(file.file());
                }
            }
            return null;
        }
    }

    void refreshHistory(IOFile file) {
        StringList paths = new StringList();
        if (file != null) {
            this.gui.gopts.setFile(GUIOptions.WORKPATH, file.parent());
            paths.add(file.path());
            this.tabs.setToolTipTextAt(this.tabs.getSelectedIndex(), BaseXLayout.info(file, true));
        }
        for (String old : this.gui.gopts.get(GUIOptions.EDITOR)) {
            if (paths.size() >= 20) continue;
            paths.addUnique(old);
        }
        this.gui.gopts.setFiles(GUIOptions.EDITOR, (String[])paths.finish());
        this.history.setEnabled(!paths.isEmpty());
    }

    public void closeAll() {
        for (EditorArea ea : this.editors()) {
            this.closeEditor(ea);
        }
        this.gui.saveOptions();
    }

    public void close(EditorArea edit) {
        this.closeEditor(edit);
        this.gui.saveOptions();
    }

    private void closeEditor(EditorArea edit) {
        EditorArea ea;
        EditorArea editorArea = ea = edit != null ? edit : this.getEditor();
        if (ea.modified() && !this.confirm(ea)) {
            return;
        }
        if (this.execFile != null && ea.file().path().equals(this.execFile.path())) {
            this.execFile = null;
        }
        this.tabs.remove(ea);
        if (this.tabs.getTabCount() == 0) {
            this.addTab();
            SwingUtilities.invokeLater(this::toggleProject);
        } else {
            this.focusEditor();
        }
    }

    public void pleaseWait(final int id) {
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                if (EditorView.this.gui.running(id)) {
                    EditorView.this.info.setText(Text.PLEASE_WAIT_D, GUIConstants.Msg.SUCCESS).setToolTipText(null);
                    EditorView.this.stop.setEnabled(true);
                }
            }
        }, 250L);
    }

    private void parse(final String input, final IO file) {
        final int id = this.parseID.incrementAndGet();
        new Timer(true).schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (EditorView.this.parsing.get()) {
                    Performance.sleep(1L);
                }
                if (id != EditorView.this.parseID.get()) {
                    return;
                }
                EditorView.this.parsing.set(true);
                try (QueryContext qc = new QueryContext(EditorView.this.gui.context);){
                    qc.parse(input, file.path());
                    if (id == EditorView.this.parseID.get()) {
                        EditorView.this.info(null);
                    }
                }
                catch (QueryException ex) {
                    if (id == EditorView.this.parseID.get()) {
                        EditorView.this.info(ex);
                    }
                }
                finally {
                    EditorView.this.parsing.set(false);
                }
            }
        }, 100L);
    }

    public void info(Throwable th, boolean stopped, boolean refresh) {
        if (!refresh && this.stop.isEnabled()) {
            return;
        }
        this.parseID.incrementAndGet();
        EditorArea editor = this.getEditor();
        String path = "";
        if (editor != null) {
            path = editor.file().path();
            editor.resetError();
        }
        if (refresh) {
            this.stop.setEnabled(false);
            this.refreshMark();
        }
        if (stopped || th == null) {
            this.info.setCursor(GUIConstants.CURSORARROW);
            this.info.setText(stopped ? Text.INTERRUPTED : "OK", GUIConstants.Msg.SUCCESS);
            this.info.setToolTipText(null);
            this.inputInfo = null;
        } else {
            this.info.setCursor(GUIConstants.CURSORHAND);
            String msg = Util.message(th);
            String local = th.getLocalizedMessage();
            this.info.setText(local != null ? local : msg, GUIConstants.Msg.ERROR);
            String tt = msg.replace("<", "&lt;").replace(">", "&gt;").replaceAll("\r?\n", "<br/>").replaceAll("(<br/>.*?)<br/>.*", "$1");
            this.info.setToolTipText("<html>" + tt + "</html>");
            if (th instanceof QueryIOException) {
                QueryIOException ex = (QueryIOException)th;
                this.inputInfo = ex.getCause().info();
            } else if (th instanceof QueryException) {
                QueryException ex = (QueryException)th;
                this.inputInfo = ex.info();
            } else if (th instanceof SAXParseException) {
                SAXParseException ex = (SAXParseException)th;
                this.inputInfo = new InputInfo(path, ex.getLineNumber(), ex.getColumnNumber());
            } else {
                this.inputInfo = new InputInfo(path, 1, 1);
            }
            this.markError(false);
        }
    }

    public void jump(String link) {
        Matcher m = LINK.matcher(link);
        if (m.matches()) {
            this.inputInfo = new InputInfo(m.group(1), Strings.toInt(m.group(2)), Strings.toInt(m.group(3)));
            this.markError(true);
        } else {
            Util.stack("No match found: " + link);
        }
    }

    public void markError(boolean jump) {
        EditorArea opened;
        String path;
        boolean error;
        InputInfo ii = this.inputInfo;
        boolean bl = error = ii == null;
        if (error) {
            TreeMap<String, InputInfo> errors = this.project.errors();
            if (errors.isEmpty()) {
                return;
            }
            path = errors.get(errors.keySet().iterator().next()).path();
        } else {
            path = ii.path();
        }
        if (path == null) {
            return;
        }
        IOFile file = new IOFile(path);
        EditorArea found = this.find(file);
        if (jump) {
            opened = this.open(file, error, true);
            if (found == null && error) {
                ii = this.inputInfo;
            }
        } else {
            opened = found;
        }
        if (opened == null || ii == null) {
            return;
        }
        int ep = EditorView.pos(opened.last, ii.line(), ii.column());
        opened.error(ep);
        if (jump) {
            opened.setCaret(ep);
            this.posCode.invokeLater();
            if (found == null) {
                this.project.jumpTo(opened.file(), false);
            }
        }
    }

    private static int pos(byte[] text, int line, int col) {
        int tl;
        int ep = tl = text.length;
        int l = 1;
        int c = 1;
        for (int t = 0; t < tl; t += Token.cl(text, t)) {
            if (l > line || l == line && c == col) {
                ep = t;
                break;
            }
            if (text[t] == 10) {
                ++l;
                c = 0;
            }
            ++c;
        }
        if (ep < tl && Character.isLetterOrDigit(Token.cp(text, ep))) {
            while (ep > 0 && Character.isLetterOrDigit(Token.cp(text, ep - 1))) {
                --ep;
            }
        }
        return ep;
    }

    public String[] openFiles() {
        StringList files = new StringList();
        for (EditorArea edit : this.editors()) {
            if (!edit.opened()) continue;
            files.add(edit.file().path());
        }
        return (String[])files.finish();
    }

    public EditorArea getEditor() {
        EditorArea edit;
        Component component = this.tabs.getSelectedComponent();
        return component instanceof EditorArea ? (edit = (EditorArea)component) : null;
    }

    public void rename(IOFile old, IOFile renamed) {
        try {
            boolean dir = renamed.isDir();
            String oldPath = old.file().getCanonicalPath() + (dir ? File.separator : "");
            for (Component c : this.tabs.getComponents()) {
                EditorArea ea;
                if (!(c instanceof EditorArea) || !(ea = (EditorArea)c).opened()) continue;
                String editPath = ea.file().file().getCanonicalPath();
                if (dir) {
                    if (!editPath.startsWith(oldPath)) continue;
                    ea.file(new IOFile(renamed, editPath.substring(oldPath.length())), true);
                    continue;
                }
                if (!oldPath.equals(editPath)) continue;
                ea.file(renamed, true);
                ea.label.setText(renamed.name());
                break;
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
    }

    void refreshControls(EditorArea edit, boolean enforce) {
        boolean modified;
        boolean bl = modified = edit.hist != null && edit.hist.modified();
        if (modified == edit.modified() && !enforce) {
            return;
        }
        edit.modified(modified);
        Object title = edit.file().name();
        if (modified) {
            title = (String)title + "*";
        }
        edit.label.setText((String)title);
        this.gui.refreshControls(false);
        this.gui.setTitle();
        this.posCode.invokeLater();
        this.refreshMark();
    }

    private EditorArea find(IO file) {
        for (EditorArea edit : this.editors()) {
            if (!edit.file().eq(file)) continue;
            return edit;
        }
        return null;
    }

    private IOFile newTabFile() {
        int n = 0;
        for (EditorArea edit : this.editors()) {
            String name = edit.file().name();
            String num = name.replaceAll("^" + Text.FILE + "(\\d*)$", "$1");
            if (edit.opened() || name.equals(num)) continue;
            n = Math.max(n, num.isEmpty() ? 1 : Strings.toInt(num));
        }
        return new IOFile(this.gui.gopts.get(GUIOptions.WORKPATH), Text.FILE + String.valueOf(n == 0 ? "" : Integer.valueOf(n + 1)));
    }

    private EditorArea addTab() {
        EditorArea edit = new EditorArea(this, this.newTabFile());
        edit.setFont(GUIConstants.mfont);
        BaseXBack tab = new BaseXBack(false).layout(new BorderLayout(10, 0));
        tab.add((Component)edit.label, "Center");
        AbstractButton close = this.tabButton("e_close", "e_close_hover");
        close.addActionListener(e -> this.close(edit));
        tab.add((Component)close, "East");
        this.tabs.add((Component)edit, tab, this.tabs.getTabCount());
        return edit;
    }

    private AbstractButton tabButton(String icon, String rollover) {
        AbstractButton close = BaseXButton.get(icon, null, false, this.gui);
        close.setBorder(BaseXLayout.border(2, 0, 2, 0));
        close.setContentAreaFilled(false);
        close.setFocusable(false);
        close.setRolloverIcon(BaseXImages.icon(rollover));
        return close;
    }

    public boolean confirm(EditorArea edit) {
        String[] stringArray;
        EditorArea[] editorAreaArray;
        boolean all;
        boolean bl = all = edit == null;
        if (all) {
            editorAreaArray = this.editors();
        } else {
            EditorArea[] editorAreaArray2 = new EditorArea[1];
            editorAreaArray = editorAreaArray2;
            editorAreaArray2[0] = edit;
        }
        EditorArea[] eas = editorAreaArray;
        if (all && eas.length > 1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = Text.CLOSE_ALL;
        } else {
            stringArray = new String[]{};
        }
        String[] buttons = stringArray;
        for (EditorArea ea : eas) {
            this.tabs.setSelectedComponent(ea);
            if (!ea.modified() || !ea.opened() && (edit == null || Token.trim(ea.getText()).length == 0)) continue;
            String msg = Util.info(Text.CLOSE_FILE_X, ea.file().name());
            String action = BaseXDialog.yesNoCancel(this.gui, msg, buttons);
            if (action == null || action.equals(Text.B_YES) && !this.save()) {
                return false;
            }
            if (action.equals(Text.CLOSE_ALL)) break;
        }
        IOFile tmpDir = new IOFile(Prop.TEMPDIR, Prop.PROJECT);
        if (edit == null && eas.length > 0 && tmpDir.md()) {
            try {
                String prefix = Prop.HOMEDIR.hashCode() + "-";
                int c = 0;
                for (EditorArea ea : eas) {
                    byte[] text = ea.getText();
                    if (ea.opened() || text.length <= 0) continue;
                    new IOFile(tmpDir, prefix + c++ + ".tmp").write(text);
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        return true;
    }

    private EditorArea[] editors() {
        ArrayList<EditorArea> edits = new ArrayList<EditorArea>();
        for (Component c : this.tabs.getComponents()) {
            if (!(c instanceof EditorArea)) continue;
            EditorArea edit = (EditorArea)c;
            edits.add(edit);
        }
        return (EditorArea[])edits.toArray(EditorArea[]::new);
    }
}

