/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import org.basex.util.Util;

public final class TableLayout
implements LayoutManager {
    private final int cols;
    private final int rows;
    private final int hgap;
    private final int vgap;
    private final int[] posX;
    private final int[] posY;

    public TableLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public TableLayout(int rows, int cols, int hgap, int vgap) {
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
        this.posX = new int[cols];
        this.posY = new int[rows];
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container cont) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            Insets in = cont.getInsets();
            int nr = cont.getComponentCount();
            if (nr > this.cols * this.rows) {
                Util.errln("Too many components specified in TableLayout (%/%): %", nr, this.cols, cont.getComponent(this.cols * this.rows));
            }
            int maxW = 0;
            int maxH = 0;
            for (int c = 0; c < this.cols; ++c) {
                int n;
                this.posX[c] = maxW;
                int w = maxW;
                int h = 0;
                for (int r = 0; r < this.rows && (n = r * this.cols + c) < nr; ++r) {
                    Dimension d = cont.getComponent(n).getPreferredSize();
                    maxW = Math.max(maxW, w + d.width);
                    if (this.posY[r] < h) {
                        this.posY[r] = h;
                    } else {
                        h = this.posY[r];
                    }
                    h += d.height;
                }
                maxH = Math.max(maxH, h);
            }
            int w = in.left + maxW + (this.cols - 1) * this.hgap + in.right;
            int h = in.top + maxH + (this.rows - 1) * this.vgap + in.bottom;
            return new Dimension(w, h);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container cont) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            this.preferredLayoutSize(cont);
            Insets in = cont.getInsets();
            int nr = cont.getComponentCount();
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.cols; ++c) {
                    int n = r * this.cols + c;
                    if (n >= nr) {
                        return;
                    }
                    Component comp = cont.getComponent(n);
                    Dimension cs = comp.getPreferredSize();
                    int x = in.left + this.posX[c] + c * this.hgap;
                    int y = in.top + this.posY[r] + r * this.vgap;
                    comp.setBounds(x, y, cs.width, cs.height);
                }
            }
        }
    }
}

