/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.IdPreMap;
import org.basex.index.Index;
import org.basex.index.IndexBuilder;
import org.basex.index.IndexType;
import org.basex.index.ft.FTBuilder;
import org.basex.index.ft.FTIndex;
import org.basex.index.name.Names;
import org.basex.index.path.PathIndex;
import org.basex.index.value.DiskValues;
import org.basex.index.value.DiskValuesBuilder;
import org.basex.index.value.UpdatableDiskValues;
import org.basex.index.value.ValueIndex;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.io.random.TableDiskAccess;
import org.basex.util.Compress;
import org.basex.util.Inline;
import org.basex.util.Num;
import org.basex.util.Token;
import org.basex.util.Util;

public final class DiskData
extends Data {
    private DataAccess texts;
    private DataAccess values;

    public DiskData(MetaData meta) throws IOException {
        super(meta);
        try (DataInput in = new DataInput(meta.dbFile("inf"));){
            String k;
            meta.read(in);
            while (!(k = Token.string(in.readToken())).isEmpty()) {
                switch (k) {
                    case "TAGS": {
                        this.elemNames = new Names(in, meta);
                        break;
                    }
                    case "ATTS": {
                        this.attrNames = new Names(in, meta);
                        break;
                    }
                    case "PATH": {
                        this.paths = new PathIndex(this, in);
                        break;
                    }
                    case "NS": {
                        this.nspaces = new Namespaces(in);
                        break;
                    }
                    case "DOCS": {
                        this.resources.read(in);
                    }
                }
            }
        }
        this.init();
        if (meta.updindex) {
            this.idmap = new IdPreMap(meta.dbFile("idp"));
            if (meta.textindex) {
                this.textIndex = new UpdatableDiskValues(this, IndexType.TEXT);
            }
            if (meta.attrindex) {
                this.attrIndex = new UpdatableDiskValues(this, IndexType.ATTRIBUTE);
            }
            if (meta.tokenindex) {
                this.tokenIndex = new UpdatableDiskValues(this, IndexType.TOKEN);
            }
        } else {
            if (meta.textindex) {
                this.textIndex = new DiskValues(this, IndexType.TEXT);
            }
            if (meta.attrindex) {
                this.attrIndex = new DiskValues(this, IndexType.ATTRIBUTE);
            }
            if (meta.tokenindex) {
                this.tokenIndex = new DiskValues(this, IndexType.TOKEN);
            }
        }
        if (meta.ftindex) {
            this.ftIndex = new FTIndex(this);
        }
    }

    public DiskData(MetaData meta, Names elemNames, Names attrNames, PathIndex paths, Namespaces nspaces) throws IOException {
        super(meta);
        this.elemNames = elemNames;
        this.attrNames = attrNames;
        this.paths = paths;
        this.nspaces = nspaces;
        paths.data(this);
        if (meta.updindex) {
            this.idmap = new IdPreMap(meta.lastid);
        }
        this.init();
    }

    private void init() throws IOException {
        this.table = new TableDiskAccess(this.meta, false);
        this.texts = new DataAccess(this.meta.dbFile("txt"));
        this.values = new DataAccess(this.meta.dbFile("atv"));
    }

    private void write() throws IOException {
        if (!this.meta.dirty) {
            return;
        }
        try (DataOutput out = new DataOutput(this.meta.dbFile("inf"));){
            this.meta.write(out);
            out.writeToken(Token.token("TAGS"));
            this.elemNames.write(out);
            out.writeToken(Token.token("ATTS"));
            this.attrNames.write(out);
            out.writeToken(Token.token("PATH"));
            this.paths.write(out);
            out.writeToken(Token.token("NS"));
            this.nspaces.write(out);
            out.writeToken(Token.token("DOCS"));
            this.resources.write(out);
            out.write(0);
        }
        if (this.meta.updindex && this.idmap != null) {
            this.idmap.write(this.meta.dbFile("idp"));
        }
        this.meta.dirty = false;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        super.close();
        try {
            this.write();
            this.table.close();
            this.texts.close();
            this.values.close();
            this.close(IndexType.TEXT);
            this.close(IndexType.ATTRIBUTE);
            this.close(IndexType.TOKEN);
            this.close(IndexType.FULLTEXT);
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    private synchronized void close(IndexType type) {
        Index index = this.index(type);
        if (index != null) {
            index.close();
            this.set(type, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndex(IndexType type, Command cmd) throws IOException {
        this.close(type);
        IndexBuilder ib = switch (type) {
            case IndexType.TEXT, IndexType.ATTRIBUTE, IndexType.TOKEN -> new DiskValuesBuilder(this, type);
            case IndexType.FULLTEXT -> new FTBuilder(this);
            default -> throw Util.notExpected();
        };
        try {
            if (cmd != null) {
                cmd.pushJob(ib);
            }
            this.set(type, ib.build());
        }
        finally {
            if (cmd != null) {
                cmd.popJob();
            }
        }
    }

    @Override
    public void dropIndex(IndexType type) throws BaseXException {
        this.close(type);
        Index index = this.index(type);
        if (index != null && !index.drop()) {
            throw new BaseXException(Text.INDEX_NOT_DROPPED_X, new Object[]{type});
        }
    }

    private void set(IndexType type, ValueIndex index) {
        this.meta.dirty = true;
        switch (type) {
            case TEXT: {
                this.textIndex = index;
                break;
            }
            case ATTRIBUTE: {
                this.attrIndex = index;
                break;
            }
            case TOKEN: {
                this.tokenIndex = index;
                break;
            }
            case FULLTEXT: {
                this.ftIndex = index;
                break;
            }
            default: {
                throw Util.notExpected();
            }
        }
    }

    @Override
    public void startUpdate(MainOptions opts) throws BaseXException {
        if (!this.table.lock(true)) {
            throw new BaseXException(Text.DB_PINNED_X, this.meta.name);
        }
        if (opts.get(MainOptions.AUTOFLUSH).booleanValue()) {
            IOFile upd = this.meta.updateFile();
            if (upd.exists()) {
                throw new BaseXException(Text.DB_UPDATED_X, this.meta.name);
            }
            if (!upd.touch()) {
                throw Util.notExpected("%: could not create lock file.", this.meta.name);
            }
        }
    }

    @Override
    public synchronized void finishUpdate(MainOptions opts) {
        if (this.closed) {
            return;
        }
        boolean auto = opts.get(MainOptions.AUTOFLUSH);
        if (auto) {
            IOFile upd = this.meta.updateFile();
            if (!upd.exists()) {
                throw Util.notExpected("%: lock file does not exist.", this.meta.name);
            }
            if (!upd.delete()) {
                throw Util.notExpected("%: could not delete lock file.", this.meta.name);
            }
        }
        this.flush(auto);
        if (!this.table.lock(false)) {
            throw Util.notExpected("Database '%': could not unlock.", this.meta.name);
        }
    }

    @Override
    public synchronized void flush(boolean all) {
        try {
            this.table.flush(all);
            if (all) {
                this.write();
                this.texts.flush();
                this.values.flush();
                if (this.textIndex != null) {
                    this.textIndex.flush();
                }
                if (this.attrIndex != null) {
                    this.attrIndex.flush();
                }
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    @Override
    public byte[] text(int pre, boolean text) {
        long value = this.textRef(pre);
        return Inline.inlined(value) ? Inline.unpack(value) : this.txt(value, text);
    }

    @Override
    public long textItr(int pre, boolean text) {
        long value = this.textRef(pre);
        return Inline.inlined(value) ? Inline.unpackLong(value) : Token.toLong(this.txt(value, text));
    }

    @Override
    public double textDbl(int pre, boolean text) {
        long value = this.textRef(pre);
        return Inline.inlined(value) ? Inline.unpackDouble(value) : Token.toDouble(this.txt(value, text));
    }

    @Override
    public int textLen(int pre, boolean text) {
        long value = this.textRef(pre);
        if (Inline.inlined(value)) {
            return Inline.unpackLength(value);
        }
        DataAccess da = text ? this.texts : this.values;
        int l = da.readNum(value & 0x3FFFFFFFFFL);
        return Compress.compressed(value) ? da.readNum() : l;
    }

    private byte[] txt(long offset, boolean text) {
        byte[] txt = (text ? this.texts : this.values).readToken(offset & 0x3FFFFFFFFFL);
        return Compress.compressed(offset) ? Compress.unpack(txt) : txt;
    }

    @Override
    public boolean inMemory() {
        return false;
    }

    @Override
    protected void delete(int pre, boolean text) {
        long old = this.textRef(pre);
        if (!Inline.inlined(old)) {
            (text ? this.texts : this.values).free(old & 0x3FFFFFFFFFL, 0);
        }
    }

    @Override
    protected void updateText(int pre, byte[] value, int kind) {
        this.indexDelete(pre, -1, 1);
        DataAccess store = kind == 3 ? this.values : this.texts;
        long oldRef = this.textRef(pre);
        long v = Inline.packInt(value);
        if (v != -1L) {
            if (!Inline.inlined(oldRef)) {
                store.free(oldRef & 0x3FFFFFFFFFL, 0);
            }
            this.textRef(pre, v);
        } else {
            long off;
            byte[] val = Compress.pack(value);
            if (Inline.inlined(oldRef)) {
                off = store.length();
            } else {
                int vl = val.length;
                off = store.free(oldRef & 0x3FFFFFFFFFL, vl + Num.length(vl));
            }
            store.writeToken(off, val);
            this.textRef(pre, val == value ? off : off | 0x4000000000L);
        }
        this.indexAdd(pre, -1, 1, null);
    }

    @Override
    protected long textRef(byte[] value, boolean text) {
        long inlined = Inline.pack(value);
        if (inlined != 0L) {
            return inlined;
        }
        byte[] packed = Compress.pack(value);
        DataAccess store = text ? this.texts : this.values;
        long offset = store.length();
        store.writeToken(offset, packed);
        return packed == value ? offset : 0x4000000000L | offset;
    }
}

