/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.AlterBackup;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.AlterPassword;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.BinaryGet;
import org.basex.core.cmd.BinaryPut;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Dir;
import org.basex.core.cmd.DropBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.DropIndex;
import org.basex.core.cmd.DropUser;
import org.basex.core.cmd.Execute;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Flush;
import org.basex.core.cmd.Get;
import org.basex.core.cmd.Grant;
import org.basex.core.cmd.Help;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.InfoIndex;
import org.basex.core.cmd.InfoStorage;
import org.basex.core.cmd.Inspect;
import org.basex.core.cmd.Kill;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.core.cmd.Password;
import org.basex.core.cmd.Put;
import org.basex.core.cmd.Rename;
import org.basex.core.cmd.RepoDelete;
import org.basex.core.cmd.RepoInstall;
import org.basex.core.cmd.RepoList;
import org.basex.core.cmd.Restore;
import org.basex.core.cmd.Run;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.ShowBackups;
import org.basex.core.cmd.ShowOptions;
import org.basex.core.cmd.ShowSessions;
import org.basex.core.cmd.ShowUsers;
import org.basex.core.cmd.Test;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.Commands;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;
import org.basex.util.Array;
import org.basex.util.InputParser;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.similarity.Levenshtein;

final class StringParser
extends CommandParser {
    private InputParser parser;

    StringParser(String input, Context context) {
        super(input, context);
    }

    @Override
    protected void parse(ArrayList<Command> cmds) throws QueryException {
        Scanner sc = new Scanner(this.input).useDelimiter(this.single ? "\u0000" : "\r\n?|\n");
        while (sc.hasNext()) {
            String line = sc.next().trim();
            if (line.isEmpty() || Strings.startsWith(line, '#')) continue;
            this.parser = new InputParser(line);
            this.parser.path = this.path;
            while (this.parser.more()) {
                Commands.Cmd cmd = this.consume(Commands.Cmd.class, null);
                if (cmd != null) {
                    cmds.add(this.parse(cmd).baseURI(this.path));
                }
                if (!this.parser.more() || this.parser.consume(59)) continue;
                throw this.help(null, cmd);
            }
        }
    }

    private Command parse(Commands.Cmd cmd) throws QueryException {
        switch (cmd) {
            case CREATE: {
                return switch (this.consume(Commands.CmdCreate.class, cmd)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Commands.CmdCreate.BACKUP -> new CreateBackup(this.glob(null), this.string(null));
                    case Commands.CmdCreate.DATABASE, Commands.CmdCreate.DB -> new CreateDB(this.name(cmd), this.remaining(null, true));
                    case Commands.CmdCreate.INDEX -> new CreateIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    case Commands.CmdCreate.USER -> new CreateUser(this.name(cmd), this.password());
                };
            }
            case COPY: {
                return new Copy(this.name(cmd), this.name(cmd));
            }
            case ALTER: {
                return switch (this.consume(Commands.CmdAlter.class, cmd)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Commands.CmdAlter.BACKUP -> new AlterBackup(this.name(cmd), this.name(cmd));
                    case Commands.CmdAlter.DATABASE, Commands.CmdAlter.DB -> new AlterDB(this.name(cmd), this.name(cmd));
                    case Commands.CmdAlter.PASSWORD -> new AlterPassword(this.name(cmd), this.password());
                    case Commands.CmdAlter.USER -> new AlterUser(this.name(cmd), this.name(cmd));
                };
            }
            case OPEN: {
                return new Open(this.name(cmd));
            }
            case CHECK: {
                return new Check(this.string(cmd));
            }
            case ADD: {
                String aa = this.key("TO", null) ? this.string(cmd) : null;
                return new Add(aa, this.remaining(cmd, true));
            }
            case GET: {
                return new Get(this.string(cmd));
            }
            case BINARY: {
                return switch (this.consume(Commands.CmdBinary.class, cmd)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Commands.CmdBinary.GET -> new BinaryGet(this.string(cmd));
                    case Commands.CmdBinary.PUT -> new BinaryPut(this.key("TO", null) ? this.string(cmd) : null, this.remaining(cmd, true));
                };
            }
            case DELETE: {
                return new Delete(this.string(cmd));
            }
            case RENAME: {
                return new Rename(this.string(cmd), this.string(cmd));
            }
            case PUT: {
                return new Put(this.string(cmd), this.remaining(cmd, true));
            }
            case INFO: {
                return switch (this.consume(Commands.CmdInfo.class, cmd)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Commands.CmdInfo.NULL -> new Info();
                    case Commands.CmdInfo.DATABASE, Commands.CmdInfo.DB -> new InfoDB();
                    case Commands.CmdInfo.INDEX -> new InfoIndex((Object)this.consume(Commands.CmdIndexInfo.class, null));
                    case Commands.CmdInfo.STORAGE -> {
                        String arg1 = this.number();
                        yield new InfoStorage(arg1, arg1 != null ? this.number() : null);
                    }
                };
            }
            case INSPECT: {
                return new Inspect();
            }
            case CLOSE: {
                return new Close();
            }
            case LIST: {
                return new List(this.name(null), this.string(null));
            }
            case DIR: {
                return new Dir(this.string(null));
            }
            case DROP: {
                return switch (this.consume(Commands.CmdDrop.class, cmd)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Commands.CmdDrop.DATABASE, Commands.CmdDrop.DB -> new DropDB(this.glob(cmd));
                    case Commands.CmdDrop.INDEX -> new DropIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    case Commands.CmdDrop.USER -> new DropUser(this.glob(cmd), this.key("ON", null) ? this.glob(cmd) : null);
                    case Commands.CmdDrop.BACKUP -> new DropBackup(this.glob(null));
                };
            }
            case OPTIMIZE: {
                return switch (this.consume(Commands.CmdOptimize.class, cmd)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Commands.CmdOptimize.NULL -> new Optimize();
                    case Commands.CmdOptimize.ALL -> new OptimizeAll();
                };
            }
            case EXPORT: {
                return new Export(this.string(cmd));
            }
            case XQUERY: {
                return new XQuery(this.remaining(cmd, false));
            }
            case RUN: {
                return new Run(this.string(cmd));
            }
            case TEST: {
                return new Test(this.string(cmd));
            }
            case EXECUTE: {
                return new Execute(this.remaining(cmd, true));
            }
            case FIND: {
                return new Find(this.remaining(cmd, true));
            }
            case SET: {
                return new Set(this.name(cmd), (Object)this.remaining(null, true));
            }
            case PASSWORD: {
                return new Password(this.password());
            }
            case HELP: {
                return new Help(this.name(null));
            }
            case EXIT: 
            case QUIT: {
                return new Exit();
            }
            case FLUSH: {
                return new Flush();
            }
            case KILL: {
                return new Kill(this.string(cmd));
            }
            case RESTORE: {
                return new Restore(this.name(null));
            }
            case SHOW: {
                return switch (this.consume(Commands.CmdShow.class, cmd)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Commands.CmdShow.SESSIONS -> new ShowSessions();
                    case Commands.CmdShow.USERS -> new ShowUsers(this.key("ON", null) ? this.name(cmd) : null);
                    case Commands.CmdShow.BACKUPS -> new ShowBackups();
                    case Commands.CmdShow.OPTIONS -> new ShowOptions(this.name(null));
                };
            }
            case GRANT: {
                Commands.CmdPerm perm = this.consume(Commands.CmdPerm.class, cmd);
                if (perm == null) {
                    throw this.help(null, cmd);
                }
                String db = this.key("ON", null) ? this.glob(cmd) : null;
                this.key("TO", cmd);
                return new Grant((Object)perm, this.glob(cmd), db);
            }
            case REPO: {
                return switch (this.consume(Commands.CmdRepo.class, cmd)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Commands.CmdRepo.INSTALL -> new RepoInstall(this.string(cmd), this.parser.info());
                    case Commands.CmdRepo.DELETE -> new RepoDelete(this.string(cmd), this.parser.info());
                    case Commands.CmdRepo.LIST -> new RepoList();
                };
            }
        }
        throw Util.notExpected("Command specified, but not implemented yet", new Object[0]);
    }

    private String string(Commands.Cmd cmd) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        this.consumeWS();
        boolean more = true;
        boolean quoted = false;
        while (more && this.parser.more()) {
            int cp = this.parser.current();
            if (quoted) {
                if (cp == 34) {
                    more = false;
                }
            } else {
                if (cp <= 32 || this.eoc()) break;
                if (cp == 34 && tb.isEmpty()) {
                    quoted = true;
                }
            }
            tb.add(this.parser.consume());
        }
        return this.finish(tb.toString().replaceAll("^\"|\"$", ""), cmd);
    }

    private String remaining(Commands.Cmd cmd, boolean quotes) throws QueryException {
        this.consumeWS();
        TokenBuilder tb = new TokenBuilder();
        while (this.parser.more()) {
            tb.add(this.parser.consume());
        }
        String str = tb.toString();
        return this.finish(quotes ? str.replaceAll("^\"|\"$", "") : str, cmd);
    }

    private String command() throws QueryException {
        this.consumeWS();
        TokenBuilder tb = new TokenBuilder();
        while (!this.eoc() && !Token.ws(this.parser.current())) {
            tb.add(this.parser.consume());
        }
        return this.finish(tb.toString(), null);
    }

    private String name(Commands.Cmd cmd) throws QueryException {
        return this.name(cmd, false);
    }

    private String password() throws QueryException {
        String pw = this.string(null);
        return pw != null ? pw : (this.pwReader == null ? "" : this.pwReader.password());
    }

    private String glob(Commands.Cmd cmd) throws QueryException {
        return this.name(cmd, true);
    }

    private String name(Commands.Cmd cmd, boolean glob) throws QueryException {
        this.consumeWS();
        TokenBuilder tb = new TokenBuilder();
        int last = 0;
        int cp;
        while (Databases.validChar(cp = this.parser.current(), tb.isEmpty()) || glob && (cp == 42 || cp == 63 || cp == 44)) {
            tb.add(this.parser.consume());
            last = cp;
        }
        return this.finish((this.eoc() || Token.ws(cp)) && last != 46 ? tb.toString() : null, cmd);
    }

    private boolean key(String key, Commands.Cmd cmd) throws QueryException {
        boolean ok;
        this.consumeWS();
        int p = this.parser.pos;
        boolean bl = ok = !(!this.parser.consume(key) && !this.parser.consume(key.toLowerCase(Locale.ENGLISH)) || !this.parser.current(0) && !Token.ws(this.parser.current()));
        if (!ok) {
            this.parser.pos = p;
            if (cmd != null) {
                throw this.help(null, cmd);
            }
        }
        return ok;
    }

    private String finish(CharSequence string, Commands.Cmd cmd) throws QueryException {
        if (string != null && !string.isEmpty()) {
            return string.toString();
        }
        if (cmd != null) {
            throw this.help(null, cmd);
        }
        return null;
    }

    private String number() throws QueryException {
        this.consumeWS();
        TokenBuilder tb = new TokenBuilder();
        if (this.parser.current() == 45) {
            tb.add(this.parser.consume());
        }
        while (Token.digit(this.parser.current())) {
            tb.add(this.parser.consume());
        }
        return this.finish(this.eoc() || Token.ws(this.parser.current()) ? tb.toString() : null, null);
    }

    private void consumeWS() {
        int pl = this.parser.length;
        while (this.parser.pos < pl && this.parser.input[this.parser.pos] <= 32) {
            ++this.parser.pos;
        }
        this.parser.mark = this.parser.pos - 1;
    }

    private <E extends Enum<E>> E consume(Class<E> complete, Commands.Cmd parent) throws QueryException {
        byte[] name;
        Object similar;
        String token = this.command();
        if (!this.suggest || token == null || !token.isEmpty()) {
            try {
                return Enum.valueOf(complete, token == null ? "NULL" : token.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
            }
        }
        Enum<?>[] alt = StringParser.startWith(complete, token);
        if (token == null) {
            if (parent != null) {
                throw this.help(alt, parent);
            }
            if (this.suggest) {
                throw this.error(alt, Text.EXPECTING_CMD, new Object[0]);
            }
            return null;
        }
        if (token.matches("^\\w+$") && (similar = Levenshtein.similar(name = Token.uc(Token.token(token)), StringParser.startWith(complete, null), cmd -> ((Enum)cmd).name())) != null) {
            throw this.error(alt, Text.UNKNOWN_SIMILAR_X_X, name, similar);
        }
        throw parent == null ? this.error(alt, Text.UNKNOWN_TRY_X, token) : this.help(alt, parent);
    }

    private QueryException help(Enum<?>[] alt, Commands.Cmd cmd) {
        return this.error(alt, Text.SYNTAX + ": " + cmd.help(true), new Object[0]);
    }

    private static <T extends Enum<T>> Enum<?>[] startWith(Class<T> en, String prefix) {
        Enum[] list = new Enum[]{};
        String t = prefix == null ? "" : prefix.toUpperCase(Locale.ENGLISH);
        for (Enum e : (Enum[])en.getEnumConstants()) {
            if (!e.name().startsWith(t)) continue;
            int s = list.length;
            list = Array.copy(list, new Enum[s + 1]);
            list[s] = e;
        }
        return list;
    }

    private boolean eoc() {
        return !this.parser.more() || this.parser.current() == 59;
    }

    private QueryException error(Enum<?>[] complete, String msg, Object ... ext) {
        this.completions = complete;
        return new QueryException(this.parser.info(), QNm.EMPTY, msg, ext).suggest(this.parser);
    }
}

