/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.ann.Ann;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.FType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FuncType
extends FType {
    public final AnnList anns;
    public final SeqType declType;
    public final SeqType[] argTypes;

    FuncType(SeqType declType, SeqType ... argTypes) {
        this(AnnList.EMPTY, declType, argTypes);
    }

    private FuncType(AnnList anns, SeqType declType, SeqType ... argTypes) {
        this.anns = anns;
        this.declType = declType == null ? Types.ITEM_ZM : declType;
        this.argTypes = argTypes;
    }

    @Override
    public FuncType funcType() {
        return this;
    }

    @Override
    public FItem cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
        if (!(item instanceof FItem)) {
            throw QueryError.typeError(item, this, info);
        }
        FItem func = (FItem)item;
        return this == Types.FUNCTION ? func : func.coerceTo(this, qc, null, info);
    }

    @Override
    public Item read(DataInput in, QueryContext qc) {
        throw Util.notExpected();
    }

    @Override
    public boolean eq(Type type) {
        if (this == type) {
            return true;
        }
        if (this == Types.FUNCTION || type == Types.FUNCTION || !(type instanceof FuncType)) {
            return false;
        }
        FuncType ft = (FuncType)type;
        int arity = this.argTypes.length;
        int nargs = ft.argTypes.length;
        if (arity != nargs) {
            return false;
        }
        for (int a = 0; a < arity; ++a) {
            if (this.argTypes[a].eq(ft.argTypes[a])) continue;
            return false;
        }
        return this.declType.eq(ft.declType);
    }

    @Override
    public boolean instanceOf(Type type) {
        if (this == type || type.oneOf(Types.FUNCTION, AtomType.ITEM)) {
            return true;
        }
        if (type instanceof ChoiceItemType) {
            ChoiceItemType cit = (ChoiceItemType)type;
            return cit.hasInstance(this);
        }
        if (this == Types.FUNCTION || !(type instanceof FuncType)) {
            return false;
        }
        FuncType ft = (FuncType)type;
        int arity = this.argTypes.length;
        int nargs = ft.argTypes.length;
        if (arity != nargs) {
            return false;
        }
        for (int a = 0; a < arity; ++a) {
            if (ft.argTypes[a].instanceOf(this.argTypes[a])) continue;
            return false;
        }
        for (Ann ann : ft.anns) {
            if (this.anns.contains(ann)) continue;
            return false;
        }
        return this.declType.instanceOf(ft.declType);
    }

    @Override
    public Type union(Type type) {
        if (type instanceof ChoiceItemType) {
            return type.union(this);
        }
        if (this.instanceOf(type)) {
            return type;
        }
        if (type.instanceOf(this)) {
            return this;
        }
        FuncType ft = type.funcType();
        if (ft == null) {
            return AtomType.ITEM;
        }
        int arity = this.argTypes.length;
        int nargs = ft.argTypes.length;
        if (arity != nargs) {
            return Types.FUNCTION;
        }
        SeqType[] arg = new SeqType[arity];
        for (int a = 0; a < arity; ++a) {
            arg[a] = this.argTypes[a].intersect(ft.argTypes[a]);
            if (arg[a] != null) continue;
            return Types.FUNCTION;
        }
        return FuncType.get(this.anns.union(ft.anns), this.declType.union(ft.declType), arg);
    }

    @Override
    public Type intersect(Type type) {
        if (type instanceof ChoiceItemType) {
            return type.intersect(this);
        }
        if (this.instanceOf(type)) {
            return this;
        }
        if (type.instanceOf(this)) {
            return type;
        }
        if (type instanceof MapType || type instanceof ArrayType) {
            return type.intersect(this);
        }
        FuncType ft = type.funcType();
        if (ft == null) {
            return null;
        }
        int arity = this.argTypes.length;
        int nargs = ft.argTypes.length;
        if (arity != nargs) {
            return null;
        }
        AnnList an = this.anns.intersect(ft.anns);
        if (an == null) {
            return null;
        }
        SeqType dt = this.declType.intersect(ft.declType);
        if (dt == null) {
            return null;
        }
        SeqType[] arg = new SeqType[arity];
        for (int a = 0; a < arity; ++a) {
            arg[a] = this.argTypes[a].union(ft.argTypes[a]);
        }
        return FuncType.get(an, dt, arg);
    }

    public static FuncType get(AnnList anns, SeqType declType, SeqType ... args) {
        return new FuncType(anns, declType, args);
    }

    public static FuncType get(SeqType declType, SeqType ... args) {
        return FuncType.get(AnnList.EMPTY, declType, args);
    }

    public FuncType with(int arity) {
        return FuncType.get(this.anns, this.declType, Arrays.copyOf(this.argTypes, arity));
    }

    public static Type find(QNm name) {
        if (name.uri().length == 0) {
            switch (Token.string(name.local())) {
                case "function": 
                case "fn": {
                    return Types.FUNCTION;
                }
                case "map": {
                    return Types.MAP;
                }
                case "record": {
                    return Types.RECORD;
                }
                case "array": {
                    return Types.ARRAY;
                }
            }
        }
        return null;
    }

    public static FuncType get(AnnList anns, SeqType declType, Var[] params) {
        int pl = params.length;
        SeqType[] argTypes = new SeqType[pl];
        for (int p = 0; p < pl; ++p) {
            argTypes[p] = params[p] == null ? Types.ITEM_ZM : params[p].declaredType();
        }
        return new FuncType(anns, declType, argTypes);
    }

    @Override
    public AtomType atomic() {
        return null;
    }

    @Override
    public Type.ID id() {
        return Type.ID.FUN;
    }

    @Override
    public String toString() {
        QueryString qs = new QueryString().token(this.anns).token("function");
        if (this == Types.FUNCTION) {
            qs.params(WILDCARD);
        } else {
            qs.params(this.argTypes).token("as").token(this.declType);
        }
        return qs.toString();
    }
}

