/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.basex.io.IOFile;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.options.Option;

public final class Prop {
    public static final String NAME = "BaseX";
    private static final String CURRENT_VERSION = "12.0";
    public static final String PROJECT;
    public static final String VERSION;
    public static final String NL;
    public static final Charset CHARSET;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VERSION;
    public static final String OS_ARCH;
    public static final String OS;
    public static final boolean MAC;
    public static final boolean WIN;
    public static final boolean CASE;
    public static final String DBPREFIX = "org.basex.";
    public static final String PATH = "org.basex.path";
    public static final URL LOCATION;
    public static final String TEMPDIR;
    public static final String HOMEDIR;
    public static final boolean ICU;
    private static final Map<String, String> OPTIONS;
    public static String language;
    public static boolean debug;

    private Prop() {
    }

    private static String configDir(String dir) {
        if (dir != null) {
            String home = ".basexhome";
            IOFile file = new IOFile(dir, ".basexhome");
            if (file.exists() || new IOFile(dir, ".basex").exists()) {
                return dir;
            }
        }
        return null;
    }

    private static String applicationDir(URL location) {
        try {
            if (location != null && "file".equals(location.getProtocol())) {
                return new IOFile(Paths.get(location.toURI()).toString()).dir();
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
        return null;
    }

    private static String dir(String path) {
        return path.isEmpty() || Strings.endsWith(path, '/') || Strings.endsWith(path, '\\') ? path : path + File.separator;
    }

    public static void put(Option<?> option, String value) {
        Prop.put(DBPREFIX + option.name().toLowerCase(Locale.ENGLISH), value);
    }

    public static void put(String name, String value) {
        OPTIONS.put(name, value);
    }

    public static void clear() {
        OPTIONS.clear();
    }

    public static String get(String name) {
        String value = System.getProperty(name);
        return value != null ? value : OPTIONS.get(name);
    }

    public static List<Map.Entry<String, String>> entries() {
        HashMap<String, String> entries = new HashMap<String, String>(OPTIONS);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> entries.put(key.toString(), value.toString())));
        return entries.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
    }

    public static void setSystem(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Attributes manifest() {
        if (LOCATION == null) return new Attributes(0);
        try {
            URL url;
            String jar = LOCATION.getFile();
            ClassLoader cl = Prop.class.getClassLoader();
            Iterator<URL> iterator = Collections.list(cl.getResources("META-INF/MANIFEST.MF")).iterator();
            do {
                if (!iterator.hasNext()) return new Attributes(0);
            } while (!(url = iterator.next()).getFile().contains(jar));
            try (InputStream in = url.openStream();){
                Attributes attributes = new Manifest(in).getMainAttributes();
                return attributes;
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
        return new Attributes(0);
    }

    static {
        CodeSource cs;
        PROJECT = NAME.toLowerCase(Locale.ENGLISH);
        NL = System.lineSeparator();
        CHARSET = Charset.defaultCharset();
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VERSION = System.getProperty("java.version");
        OS_ARCH = System.getProperty("os.arch");
        OS = System.getProperty("os.name");
        MAC = OS.startsWith("Mac");
        WIN = OS.startsWith("Windows");
        CASE = !MAC && !WIN;
        TEMPDIR = Prop.dir(System.getProperty("java.io.tmpdir"));
        ICU = Reflect.available("com.ibm.icu.text.BreakIterator", new Object[0]);
        OPTIONS = new ConcurrentHashMap<String, String>();
        URL location = null;
        ProtectionDomain pd = Prop.class.getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            location = cs.getLocation();
        }
        LOCATION = location;
        Object homedir = System.getProperty(PATH);
        if (homedir == null) {
            homedir = Prop.configDir(System.getProperty("user.dir"));
        }
        if (homedir == null) {
            homedir = Prop.configDir(Prop.applicationDir(LOCATION));
        }
        if (homedir == null) {
            String home = WIN ? null : System.getenv("HOME");
            homedir = Prop.dir(home != null ? home : System.getProperty("user.home")) + PROJECT;
        }
        HOMEDIR = Prop.dir((String)homedir);
        Attributes atts = Prop.manifest();
        Object version = atts.getValue("Implementation-Version");
        if (version != null && ((String)version).contains("-SNAPSHOT")) {
            String build = atts.getValue("Implementation-Build");
            if (build != null) {
                version = (String)version + " " + build;
            }
        } else {
            version = CURRENT_VERSION;
        }
        VERSION = ((String)version).replace("-SNAPSHOT", " beta");
        language = "English";
    }
}

