/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.GZIPOut;
import org.basex.query.func.archive.ZIPOut;
import org.basex.query.value.item.Bin;
import org.basex.util.InputInfo;

abstract class ArchiveOut
implements Closeable {
    ArchiveOut() {
    }

    static ArchiveOut get(String format, InputInfo info, OutputStream os) throws QueryException {
        try {
            if (format.equals("zip")) {
                return new ZIPOut(os);
            }
            if (format.equals("gzip")) {
                return new GZIPOut(os);
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(info, ex);
        }
        throw QueryError.ARCHIVE_FORMAT.get(info, new Object[0]);
    }

    public abstract void level(int var1);

    public abstract void write(ArchiveIn var1) throws IOException;

    public abstract void write(ZipEntry var1, byte[] var2) throws IOException;

    public abstract void write(ZipEntry var1, Bin var2, InputInfo var3) throws IOException, QueryException;

    @Override
    public abstract void close();

    public static void write(ArchiveIn in, OutputStream out) throws IOException {
        int c;
        byte[] data = new byte[4096];
        while ((c = in.read(data)) != -1) {
            out.write(data, 0, c);
        }
    }

    static void writeBin(Bin bin, OutputStream out, InputInfo info) throws IOException, QueryException {
        byte[] data = new byte[4096];
        try (BufferInput bi = bin.input(info);){
            int c;
            while ((c = bi.read(data)) != -1) {
                out.write(data, 0, c);
            }
        }
    }
}

