/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.function.Predicate;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.func.util.UtilRoot;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;

public final class PathCache {
    State state = State.INIT;
    Predicate<Value> test;
    Value context;
    Value result;

    void init(Value value, AxisPath path) {
        if (!path.hasFreeVars() && !path.has(Flag.NDT)) {
            this.update(value, null);
            Expr root = path.root;
            if (root instanceof UtilRoot && root.arg(0) instanceof ContextValue && this.context instanceof ANode) {
                this.test = v -> {
                    ANode n;
                    return v instanceof ANode && (n = (ANode)v).root().equals(((ANode)this.context).root());
                };
            } else if (root != null && !root.has(Flag.CTX)) {
                this.test = v -> true;
            } else if (!(value instanceof DBNode)) {
                this.test = v -> v == this.context;
            }
        }
        this.state = this.test != null ? State.ENABLED : State.DISABLED;
    }

    boolean valid(Value value) {
        return this.test.test(value);
    }

    void cache(Value res) {
        this.result = res;
        this.state = State.CACHED;
    }

    void update(Value value, Value res) {
        Value value2;
        if (value instanceof DBNode) {
            DBNode dbnode = (DBNode)value;
            value2 = dbnode.finish();
        } else {
            value2 = value;
        }
        this.context = value2;
        this.result = res;
    }

    void disable() {
        this.context = null;
        this.result = null;
        this.state = State.DISABLED;
    }

    static enum State {
        INIT,
        ENABLED,
        CACHED,
        DISABLED;

    }
}

