/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import java.io.IOException;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.io.in.TextInput;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Itr;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.list.TokenList;

public final class CsvParser {
    private final TextInput input;
    private final CsvConverter conv;
    private final boolean header;
    private final boolean backslashes;
    private final int fieldDelimiter;
    private final int rowDelimiter;
    private final int quoteCharacter;
    private final boolean quotes;
    private final boolean trimWhitespace;
    private final boolean trimRows;
    private final boolean strictQuoting;
    private final int[] selectColumns;
    private boolean first = true;
    private int rowSize = -1;
    private boolean data;
    private final TokenList fields = new TokenList();

    public CsvParser(TextInput input, CsvParserOptions opts, CsvConverter conv) throws QueryException {
        this.input = input;
        this.conv = conv;
        this.header = opts.get(CsvOptions.HEADER) == Bln.TRUE;
        this.fieldDelimiter = opts.fieldDelimiter();
        this.rowDelimiter = opts.rowDelimiter();
        this.quoteCharacter = opts.quoteCharacter();
        this.strictQuoting = opts.get(CsvOptions.STRICT_QUOTING);
        this.quotes = this.strictQuoting || opts.get(CsvOptions.QUOTES) != false;
        this.backslashes = opts.get(CsvOptions.BACKSLASHES);
        this.trimWhitespace = opts.get(CsvOptions.TRIM_WHITESPACE);
        this.trimRows = opts.get(CsvOptions.TRIM_ROWS);
        for (int sc : this.selectColumns = opts.get(CsvOptions.SELECT_COLUMNS)) {
            if (sc >= 1) continue;
            throw QueryError.typeError((Expr)Itr.get(sc), SeqType.POSITIVE_INTEGER_O, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(InputInfo ii) throws QueryException, IOException {
        TokenBuilder entry = new TokenBuilder();
        boolean quoted = false;
        this.data = !this.header;
        int ch = this.input.read();
        while (ch != -1) {
            block18: {
                if (quoted) {
                    if (ch == this.quoteCharacter) {
                        ch = this.input.read();
                        if (ch != this.quoteCharacter) {
                            quoted = false;
                            if (!this.strictQuoting || ch == this.fieldDelimiter || ch == this.rowDelimiter || ch == -1) continue;
                            throw QueryError.CSV_QUOTING_X.get(ii, new TokenBuilder().add(this.quoteCharacter).add(entry).add(this.quoteCharacter).add(ch));
                        }
                        if (this.backslashes) {
                            CsvParser.add(entry, this.quoteCharacter);
                        }
                    } else if (ch == 92 && this.backslashes) {
                        ch = this.bs();
                    }
                    CsvParser.add(entry, ch);
                } else {
                    if (ch == this.quoteCharacter) {
                        if (this.quotes && entry.isEmpty()) {
                            quoted = true;
                            break block18;
                        } else {
                            if (this.strictQuoting) {
                                throw QueryError.CSV_QUOTING_X.get(ii, new TokenBuilder().add(entry).add(this.quoteCharacter));
                            }
                            ch = this.input.read();
                            if (ch == this.quoteCharacter && !this.backslashes) continue;
                            CsvParser.add(entry, this.quoteCharacter);
                            continue;
                        }
                    }
                    if (ch == this.fieldDelimiter) {
                        this.record(entry, false, false);
                        this.first = false;
                    } else if (ch == this.rowDelimiter) {
                        this.record(entry, false, true);
                        this.first = true;
                        this.data = true;
                    } else {
                        if (ch == 92 && this.backslashes) {
                            ch = this.bs();
                        }
                        CsvParser.add(entry, ch);
                    }
                }
            }
            ch = this.input.read();
        }
        if (quoted && this.strictQuoting) {
            throw QueryError.CSV_QUOTING_X.get(ii, new TokenBuilder().add(this.quoteCharacter).add(entry));
        }
        this.record(entry, true, true);
    }

    private int bs() throws IOException {
        int ch = this.input.read();
        if (ch == 114) {
            return 13;
        }
        if (ch == 110) {
            return 10;
        }
        if (ch == 116) {
            return 9;
        }
        return ch;
    }

    private static void add(TokenBuilder entry, int ch) {
        if (ch != -1) {
            entry.add(XMLToken.valid(ch) ? ch : 65533);
        }
    }

    private void record(TokenBuilder entry, boolean lastRow, boolean lastField) throws IOException {
        byte[] field;
        byte[] next = entry.next();
        byte[] byArray = field = this.trimWhitespace || !this.data ? Token.trim(next) : next;
        if (field.length > 0 || !this.first || !lastField) {
            this.fields.add(field);
        }
        if (!(!lastField || lastRow && this.fields.isEmpty())) {
            if (this.data) {
                this.conv.record();
            }
            if (this.rowSize == -1) {
                this.rowSize = this.fields.size();
            }
            int n = this.selectColumns.length != 0 ? this.selectColumns.length : (this.trimRows ? this.rowSize : this.fields.size());
            for (int i = 0; i < n; ++i) {
                byte[] f;
                int index = this.selectColumns.length != 0 ? this.selectColumns[i] - 1 : i;
                byte[] byArray2 = f = index < this.fields.size() ? (byte[])this.fields.get(index) : Token.EMPTY;
                if (this.data) {
                    this.conv.entry(f);
                    continue;
                }
                this.conv.header(f);
            }
            this.fields.reset();
        }
    }
}

