/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.IncludePathSupport;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.IgnorePathSupport;
import org.netbeans.modules.php.project.ui.customizer.SeleniumTestDirectoriesPathSupport;
import org.netbeans.modules.php.project.ui.customizer.TestDirectoriesPathSupport;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.project.util.UsageLogging;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class PhpProjectProperties
implements ConfigManager.ConfigProvider {
    private static final Logger LOGGER = Logger.getLogger(PhpProjectProperties.class.getName());
    public static final int DEFAULT_DEBUG_PROXY_PORT = 9001;
    public static final String SRC_DIR = "src.dir";
    public static final String TEST_SRC_DIR = "test.src.dir";
    public static final String SELENIUM_SRC_DIR = "selenium.src.dir";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String COPY_SRC_FILES = "copy.src.files";
    public static final String COPY_SRC_TARGET = "copy.src.target";
    public static final String COPY_SRC_ON_OPEN = "copy.src.on.open";
    public static final String BROWSER_ID = "browser.id";
    public static final String BROWSER_RELOAD_ON_SAVE = "browser.reload.on.save";
    public static final String WEB_ROOT = "web.root";
    public static final String URL = "url";
    public static final String INDEX_FILE = "index.file";
    public static final String INCLUDE_PATH = "include.path";
    public static final String PRIVATE_INCLUDE_PATH = "include.path.private";
    public static final String GLOBAL_INCLUDE_PATH = "php.global.include.path";
    public static final String ARGS = "script.arguments";
    public static final String PHP_ARGS = "php.arguments";
    public static final String WORK_DIR = "work.dir";
    public static final String INTERPRETER = "interpreter";
    public static final String HOSTNAME = "hostname";
    public static final String PORT = "port";
    public static final String ROUTER = "router";
    public static final String RUN_AS = "run.as";
    public static final String REMOTE_CONNECTION = "remote.connection";
    public static final String REMOTE_DIRECTORY = "remote.directory";
    public static final String REMOTE_UPLOAD = "remote.upload";
    public static final String REMOTE_PERMISSIONS = "remote.permissions";
    public static final String REMOTE_UPLOAD_DIRECTLY = "remote.upload.directly";
    public static final String DEBUG_URL = "debug.url";
    public static final String DEBUG_PATH_MAPPING_REMOTE = "debug.path.mapping.remote";
    public static final String DEBUG_PATH_MAPPING_LOCAL = "debug.path.mapping.local";
    public static final String DEBUG_PROXY_HOST = "debug.proxy.host";
    public static final String DEBUG_PROXY_PORT = "debug.proxy.port";
    public static final String SHORT_TAGS = "tags.short";
    public static final String ASP_TAGS = "tags.asp";
    public static final String PHP_VERSION = "php.version";
    public static final String IGNORE_PATH = "ignore.path";
    public static final String CODE_ANALYSIS_EXCLUDES = "code.analysis.excludes";
    public static final String LICENSE_NAME = "project.license";
    public static final String LICENSE_PATH = "project.licensePath";
    public static final String TESTING_PROVIDERS = "testing.providers";
    public static final String AUTOCONFIGURED = "autoconfigured";
    public static final String DEBUG_PATH_MAPPING_SEPARATOR = "||NB||";
    public static final String TESTING_PROVIDERS_SEPARATOR = ";";
    private static final String[] CFG_PROPS = new String[]{"url", "index.file", "script.arguments", "php.arguments", "work.dir", "interpreter", "hostname", "port", "router", "run.as", "remote.connection", "remote.directory", "remote.upload", "remote.permissions", "remote.upload.directly", "debug.url", "debug.path.mapping.remote", "debug.path.mapping.local", "debug.proxy.host", "debug.proxy.port"};
    static final String CONFIG_PRIVATE_PROPERTIES_PATH = "nbproject/private/config.properties";
    private static final RequestProcessor RP = new RequestProcessor(PhpProjectProperties.class.getName(), 2);
    private final PhpProject project;
    private final IncludePathSupport includePathSupport;
    private final IgnorePathSupport ignorePathSupport;
    private final TestDirectoriesPathSupport testDirectoriesPathSupport;
    private final SeleniumTestDirectoriesPathSupport seleniumTestDirectoriesPathSupport;
    private String srcDir;
    private String copySrcFiles;
    private String copySrcTarget;
    private Boolean copySrcOnOpen;
    private String browserId;
    private String browserReloadOnSave;
    private String webRoot;
    private String url;
    private String indexFile;
    private String encoding;
    private String shortTags;
    private String aspTags;
    private String phpVersion;
    private Set<PhpModuleCustomizerExtender> customizerExtenders;
    private List<String> testingProviders;
    final Map<String, Map<String, String>> runConfigs;
    private final ConfigManager configManager;
    private DefaultListModel<BasePathSupport.Item> includePathListModel = null;
    private DefaultListModel<BasePathSupport.Item> privateIncludePathListModel = null;
    private ListCellRenderer<BasePathSupport.Item> includePathListRenderer = null;
    private DefaultListModel<BasePathSupport.Item> ignorePathListModel = null;
    private ListCellRenderer<BasePathSupport.Item> ignorePathListRenderer = null;
    private DefaultListModel<BasePathSupport.Item> codeAnalysisExcludesListModel = null;
    private ListCellRenderer<BasePathSupport.Item> codeAnalysisExcludesListRenderer = null;
    private DefaultListModel<BasePathSupport.Item> testDirectoriesListModel = null;
    private ListCellRenderer<BasePathSupport.Item> testDirectoriesListRenderer = null;
    private DefaultListModel<BasePathSupport.Item> seleniumTestDirectoriesListModel = null;
    private ListCellRenderer<BasePathSupport.Item> seleniumTestDirectoriesListRenderer = null;
    private String licenseNameValue;
    private boolean licenseNameChanged = false;
    private String licensePathValue;
    private boolean licensePathChanged = false;
    private String changedLicensePathContent;
    private volatile Boolean autoconfigured = null;

    public PhpProjectProperties(PhpProject project) {
        this(project, null, null, null, null);
    }

    public PhpProjectProperties(PhpProject project, IncludePathSupport includePathSupport, IgnorePathSupport ignorePathSupport, TestDirectoriesPathSupport testDirectoriesPathSupport, SeleniumTestDirectoriesPathSupport seleniumTestDirectoriesPathSupport) {
        assert (project != null);
        this.project = project;
        this.includePathSupport = includePathSupport;
        this.ignorePathSupport = ignorePathSupport;
        this.testDirectoriesPathSupport = testDirectoriesPathSupport;
        this.seleniumTestDirectoriesPathSupport = seleniumTestDirectoriesPathSupport;
        this.runConfigs = this.readRunConfigs();
        String currentConfig = ProjectPropertiesSupport.getPropertyEvaluator(project).getProperty("config");
        this.configManager = new ConfigManager(this, currentConfig);
    }

    @Override
    public String[] getConfigProperties() {
        return (String[])CFG_PROPS.clone();
    }

    @Override
    public Map<String, Map<String, String>> getConfigs() {
        return this.runConfigs;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public String getCopySrcFiles() {
        if (this.copySrcFiles == null) {
            this.copySrcFiles = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(COPY_SRC_FILES);
        }
        return this.copySrcFiles;
    }

    public void setCopySrcFiles(String copySrcFiles) {
        this.copySrcFiles = copySrcFiles;
    }

    public String getCopySrcTarget() {
        if (this.copySrcTarget == null) {
            this.copySrcTarget = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(COPY_SRC_TARGET);
        }
        return this.copySrcTarget;
    }

    public void setCopySrcTarget(String copySrcTarget) {
        this.copySrcTarget = copySrcTarget;
    }

    public boolean getCopySrcOnOpen() {
        if (this.copySrcOnOpen == null) {
            this.copySrcOnOpen = ProjectPropertiesSupport.isCopySourcesOnOpen(this.project);
        }
        return this.copySrcOnOpen;
    }

    public void setCopySrcOnOpen(boolean copySrcOnOpen) {
        this.copySrcOnOpen = copySrcOnOpen;
    }

    public void setShortTags(String shortTags) {
        this.shortTags = shortTags;
    }

    public void setAspTags(String aspTags) {
        this.aspTags = aspTags;
    }

    public void setPhpVersion(String phpVersion) {
        this.phpVersion = phpVersion;
    }

    public String getBrowserId() {
        if (this.browserId == null) {
            this.browserId = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(BROWSER_ID);
        }
        return this.browserId;
    }

    public void setBrowserId(String browserId) {
        this.browserId = browserId;
    }

    public String getBrowserReloadOnSave() {
        if (this.browserReloadOnSave == null) {
            this.browserReloadOnSave = String.valueOf(ProjectPropertiesSupport.getBrowserReloadOnSave(this.project));
        }
        return this.browserReloadOnSave;
    }

    public void setBrowserReloadOnSave(String browserReloadOnSave) {
        this.browserReloadOnSave = browserReloadOnSave;
    }

    public String getWebRoot() {
        if (this.webRoot == null) {
            this.webRoot = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(WEB_ROOT);
        }
        return this.webRoot != null ? this.webRoot : "";
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(SOURCE_ENCODING);
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSrcDir() {
        if (this.srcDir == null) {
            this.srcDir = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(SRC_DIR);
        }
        return this.srcDir;
    }

    public void setSrcDir(String srcDir) {
        assert (srcDir != null);
        this.srcDir = srcDir;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(URL);
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getIndexFile() {
        if (this.indexFile == null) {
            this.indexFile = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(INDEX_FILE);
        }
        return this.indexFile;
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public DefaultListModel<BasePathSupport.Item> getIncludePathListModel() {
        if (this.includePathListModel == null) {
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
            this.includePathListModel = PathUiSupport.createListModel(this.includePathSupport.itemsIterator(properties.getProperty(INCLUDE_PATH)));
        }
        return this.includePathListModel;
    }

    public DefaultListModel<BasePathSupport.Item> getPrivateIncludePathListModel() {
        if (this.privateIncludePathListModel == null) {
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/private/private.properties");
            this.privateIncludePathListModel = PathUiSupport.createListModel(this.includePathSupport.itemsIterator(properties.getProperty(PRIVATE_INCLUDE_PATH)));
        }
        return this.privateIncludePathListModel;
    }

    public ListCellRenderer<BasePathSupport.Item> getIncludePathListRenderer() {
        if (this.includePathListRenderer == null) {
            this.includePathListRenderer = new PathUiSupport.ClassPathListCellRenderer(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getProjectDirectory());
        }
        return this.includePathListRenderer;
    }

    public DefaultListModel<BasePathSupport.Item> getIgnorePathListModel() {
        if (this.ignorePathListModel == null) {
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
            this.ignorePathListModel = PathUiSupport.createListModel(this.ignorePathSupport.itemsIterator(properties.getProperty(IGNORE_PATH)));
        }
        return this.ignorePathListModel;
    }

    public ListCellRenderer<BasePathSupport.Item> getIgnorePathListRenderer() {
        if (this.ignorePathListRenderer == null) {
            this.ignorePathListRenderer = new PathUiSupport.ClassPathListCellRenderer(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getProjectDirectory());
        }
        return this.ignorePathListRenderer;
    }

    public DefaultListModel<BasePathSupport.Item> getCodeAnalysisExcludesListModel() {
        if (this.codeAnalysisExcludesListModel == null) {
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
            this.codeAnalysisExcludesListModel = PathUiSupport.createListModel(this.ignorePathSupport.itemsIterator(properties.getProperty(CODE_ANALYSIS_EXCLUDES)));
        }
        return this.codeAnalysisExcludesListModel;
    }

    public ListCellRenderer<BasePathSupport.Item> getCodeAnalysisExcludesListModelListRenderer() {
        if (this.codeAnalysisExcludesListRenderer == null) {
            this.codeAnalysisExcludesListRenderer = new PathUiSupport.ClassPathListCellRenderer(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getProjectDirectory());
        }
        return this.codeAnalysisExcludesListRenderer;
    }

    public DefaultListModel<BasePathSupport.Item> getTestDirectoriesListModel() {
        if (this.testDirectoriesListModel == null) {
            ArrayList<String> values = new ArrayList<String>();
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
            for (String property : this.project.getTestRoots().getRootProperties()) {
                String value = properties.getProperty(property);
                if (value != null) {
                    values.add(value);
                    continue;
                }
                LOGGER.log(Level.INFO, "Value must be found for property: {0}", property);
                assert (false) : String.valueOf(properties);
            }
            this.testDirectoriesListModel = PathUiSupport.createListModel(this.testDirectoriesPathSupport.itemsIterator(values.toArray(new String[0])));
        }
        return this.testDirectoriesListModel;
    }

    public ListCellRenderer<BasePathSupport.Item> getTestDirectoriesListRenderer() {
        if (this.testDirectoriesListRenderer == null) {
            this.testDirectoriesListRenderer = new PathUiSupport.ClassPathListCellRenderer(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getProjectDirectory());
        }
        return this.testDirectoriesListRenderer;
    }

    public DefaultListModel<BasePathSupport.Item> getSeleniumTestDirectoriesListModel() {
        if (this.seleniumTestDirectoriesListModel == null) {
            ArrayList<String> values = new ArrayList<String>();
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
            for (String property : this.project.getSeleniumRoots().getRootProperties()) {
                String value = properties.getProperty(property);
                if (value != null) {
                    values.add(value);
                    continue;
                }
                LOGGER.log(Level.INFO, "Value must be found for property: {0}", property);
                assert (false) : String.valueOf(properties);
            }
            this.seleniumTestDirectoriesListModel = PathUiSupport.createListModel(this.seleniumTestDirectoriesPathSupport.itemsIterator(values.toArray(new String[0])));
        }
        return this.seleniumTestDirectoriesListModel;
    }

    public ListCellRenderer<BasePathSupport.Item> getSeleniumTestDirectoriesListRenderer() {
        if (this.seleniumTestDirectoriesListRenderer == null) {
            this.seleniumTestDirectoriesListRenderer = new PathUiSupport.ClassPathListCellRenderer(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getProjectDirectory());
        }
        return this.seleniumTestDirectoriesListRenderer;
    }

    public void addCustomizerExtender(PhpModuleCustomizerExtender customizerExtender) {
        if (this.customizerExtenders == null) {
            this.customizerExtenders = new HashSet<PhpModuleCustomizerExtender>();
        }
        this.customizerExtenders.add(customizerExtender);
    }

    public String getLicenseNameValue() {
        if (this.licenseNameValue == null) {
            this.licenseNameChanged = true;
            this.licenseNameValue = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(LICENSE_NAME);
        }
        return this.licenseNameValue;
    }

    public void setLicenseNameValue(String licenseNameValue) {
        this.licenseNameChanged = true;
        this.licenseNameValue = licenseNameValue;
    }

    public String getLicensePathValue() {
        if (this.licensePathValue == null) {
            this.licensePathChanged = true;
            this.licensePathValue = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(LICENSE_PATH);
        }
        return this.licensePathValue;
    }

    public void setLicensePathValue(String licensePathValue) {
        this.licensePathChanged = true;
        this.licensePathValue = licensePathValue;
    }

    public String getChangedLicensePathContent() {
        return this.changedLicensePathContent;
    }

    public void setChangedLicensePathContent(String changedLicensePathContent) {
        this.changedLicensePathContent = changedLicensePathContent;
    }

    public List<String> getTestingProviders() {
        if (this.testingProviders == null) {
            String value = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(TESTING_PROVIDERS);
            this.testingProviders = StringUtils.explode((String)value, (String)TESTING_PROVIDERS_SEPARATOR);
        }
        return this.testingProviders;
    }

    public void setTestingProviders(List<String> testingProviders) {
        this.testingProviders = testingProviders;
    }

    public boolean isAutoconfigured() {
        if (this.autoconfigured == null) {
            this.autoconfigured = Boolean.parseBoolean(ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(AUTOCONFIGURED));
        }
        return this.autoconfigured;
    }

    public void setAutoconfigured(boolean autoconfigured) {
        this.autoconfigured = autoconfigured;
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    PhpProjectProperties.this.saveProperties();
                    PhpProjectProperties.this.saveCustomizerExtenders();
                    ProjectManager.getDefault().saveProject((Project)PhpProjectProperties.this.project);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            Exceptions.printStackTrace((Throwable)((IOException)e.getException()));
        }
    }

    public static void save(final PhpProject project, final Map<String, String> projectProperties, final Map<String, String> privateProperties) {
        assert (!projectProperties.isEmpty() || !privateProperties.isEmpty()) : "Neither project nor private properties to be saved";
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    AntProjectHelper helper = project.getHelper();
                    this.mergeProperties(helper, "nbproject/project.properties", projectProperties);
                    this.mergeProperties(helper, "nbproject/private/private.properties", privateProperties);
                    ProjectManager.getDefault().saveProject((Project)project);
                    return null;
                }

                private void mergeProperties(AntProjectHelper helper, String path, Map<String, String> properties) {
                    if (properties.isEmpty()) {
                        return;
                    }
                    EditableProperties currentProperties = helper.getProperties(path);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        currentProperties.put(entry.getKey(), entry.getValue());
                    }
                    helper.putProperties(path, currentProperties);
                }
            });
        }
        catch (MutexException e) {
            Exceptions.printStackTrace((Throwable)((IOException)e.getException()));
        }
    }

    void saveProperties() throws IOException {
        String propertyName;
        int i;
        AntProjectHelper helper = this.project.getHelper();
        String[] includePath = null;
        if (this.includePathListModel != null) {
            includePath = this.includePathSupport.encodeToStrings(PathUiSupport.getIterator(this.includePathListModel));
        }
        String[] privateIncludePath = null;
        if (this.privateIncludePathListModel != null) {
            privateIncludePath = this.includePathSupport.encodeToStrings(PathUiSupport.getIterator(this.privateIncludePathListModel), false);
        }
        String[] ignorePath = null;
        if (this.ignorePathListModel != null) {
            ignorePath = this.ignorePathSupport.encodeToStrings(PathUiSupport.getIterator(this.ignorePathListModel));
        }
        String[] codeAnalysisExcludes = null;
        if (this.codeAnalysisExcludesListModel != null) {
            codeAnalysisExcludes = this.ignorePathSupport.encodeToStrings(PathUiSupport.getIterator(this.codeAnalysisExcludesListModel));
        }
        String[] testDirs = null;
        if (this.testDirectoriesListModel != null) {
            testDirs = this.testDirectoriesPathSupport.encodeToStrings(PathUiSupport.getIterator(this.testDirectoriesListModel), true, false);
        }
        String[] seleniumTestDirs = null;
        if (this.seleniumTestDirectoriesListModel != null) {
            seleniumTestDirs = this.seleniumTestDirectoriesPathSupport.encodeToStrings(PathUiSupport.getIterator(this.seleniumTestDirectoriesListModel), true, false);
        }
        EditableProperties projectProperties = helper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = helper.getProperties("nbproject/private/private.properties");
        if (this.srcDir != null) {
            projectProperties.setProperty(SRC_DIR, this.srcDir);
        }
        if (this.copySrcFiles != null) {
            privateProperties.setProperty(COPY_SRC_FILES, this.copySrcFiles);
        }
        if (this.copySrcTarget != null) {
            privateProperties.setProperty(COPY_SRC_TARGET, this.copySrcTarget);
        }
        if (this.copySrcOnOpen != null) {
            privateProperties.setProperty(COPY_SRC_ON_OPEN, String.valueOf(this.copySrcOnOpen));
        }
        if (this.encoding != null) {
            projectProperties.setProperty(SOURCE_ENCODING, this.encoding);
        }
        if (this.browserId != null) {
            privateProperties.setProperty(BROWSER_ID, this.browserId);
        }
        if (this.browserReloadOnSave != null) {
            projectProperties.setProperty(BROWSER_RELOAD_ON_SAVE, this.browserReloadOnSave);
        }
        if (this.webRoot != null) {
            projectProperties.setProperty(WEB_ROOT, this.webRoot);
        }
        if (this.phpVersion != null) {
            projectProperties.setProperty(PHP_VERSION, this.phpVersion);
        }
        if (this.shortTags != null) {
            projectProperties.setProperty(SHORT_TAGS, this.shortTags);
        }
        if (this.aspTags != null) {
            projectProperties.setProperty(ASP_TAGS, this.aspTags);
        }
        if (includePath != null) {
            projectProperties.setProperty(INCLUDE_PATH, includePath);
        }
        if (privateIncludePath != null) {
            privateProperties.setProperty(PRIVATE_INCLUDE_PATH, privateIncludePath);
        }
        if (ignorePath != null) {
            projectProperties.setProperty(IGNORE_PATH, ignorePath);
        }
        if (codeAnalysisExcludes != null) {
            projectProperties.setProperty(CODE_ANALYSIS_EXCLUDES, codeAnalysisExcludes);
        }
        if (testDirs != null) {
            for (String property : this.project.getTestRoots().getRootProperties()) {
                projectProperties.remove((Object)property);
            }
            i = 1;
            String[] stringArray = testDirs;
            int n = stringArray.length;
            for (int property = 0; property < n; ++property) {
                String testDir = stringArray[property];
                propertyName = TEST_SRC_DIR;
                if (i > 1) {
                    propertyName = propertyName + i;
                }
                projectProperties.setProperty(propertyName, testDir);
                ++i;
            }
        }
        if (seleniumTestDirs != null) {
            for (String property : this.project.getSeleniumRoots().getRootProperties()) {
                projectProperties.remove((Object)property);
            }
            i = 1;
            for (String seleniumTestDir : seleniumTestDirs) {
                propertyName = SELENIUM_SRC_DIR;
                if (i > 1) {
                    propertyName = propertyName + i;
                }
                projectProperties.setProperty(propertyName, seleniumTestDir);
                ++i;
            }
        }
        if (this.licensePathValue != null) {
            projectProperties.setProperty(LICENSE_PATH, this.licensePathValue);
        } else if (this.licensePathChanged) {
            projectProperties.remove((Object)LICENSE_PATH);
        }
        if (this.licenseNameValue != null) {
            projectProperties.setProperty(LICENSE_NAME, this.licenseNameValue);
        } else if (this.licenseNameChanged) {
            projectProperties.remove((Object)LICENSE_NAME);
        }
        if (this.changedLicensePathContent != null) {
            assert (this.licensePathValue != null);
            String evaluated = ProjectPropertiesSupport.getPropertyEvaluator(this.project).evaluate(this.licensePathValue);
            assert (evaluated != null) : this.licensePathValue;
            File file = this.project.getHelper().resolveFile(evaluated);
            FileObject fo = !file.exists() ? FileUtil.createData((File)file) : FileUtil.toFileObject((File)file);
            try (OutputStream out = fo.getOutputStream();){
                String charsetName = this.encoding != null ? this.encoding : ProjectPropertiesSupport.getEncoding(this.project);
                FileUtil.copy((InputStream)new ByteArrayInputStream(this.changedLicensePathContent.getBytes(charsetName)), (OutputStream)out);
            }
        }
        if (this.testingProviders != null) {
            projectProperties.setProperty(TESTING_PROVIDERS, StringUtils.implode(this.testingProviders, (String)TESTING_PROVIDERS_SEPARATOR));
        }
        if (this.autoconfigured != null) {
            if (this.autoconfigured.booleanValue()) {
                privateProperties.put(AUTOCONFIGURED, Boolean.TRUE.toString());
            } else {
                privateProperties.remove((Object)AUTOCONFIGURED);
            }
        }
        this.storeRunConfigs(projectProperties, privateProperties);
        EditableProperties ep = helper.getProperties(CONFIG_PRIVATE_PROPERTIES_PATH);
        String currentConfig = this.configManager.currentConfiguration().getName();
        if (currentConfig == null) {
            ep.remove((Object)"config");
        } else {
            ep.setProperty("config", currentConfig);
        }
        helper.putProperties(CONFIG_PRIVATE_PROPERTIES_PATH, ep);
        helper.putProperties("nbproject/project.properties", projectProperties);
        helper.putProperties("nbproject/private/private.properties", privateProperties);
        if (this.encoding != null) {
            try {
                FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(this.encoding));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        ProjectSettings.resetLastUpload(this.project);
        ProjectSettings.resetLastDownload(this.project);
        this.logUsage(helper.getProjectDirectory(), ProjectPropertiesSupport.getSourcesDirectory(this.project), this.getActiveRunAsType(), this.getNumOfRunConfigs(), Boolean.valueOf(this.getCopySrcFiles()));
        if (this.testingProviders != null) {
            UsageLogging.logTestConfig(this.project, this.testingProviders);
        }
    }

    void saveCustomizerExtenders() {
        if (this.customizerExtenders != null) {
            final EnumSet<PhpModuleCustomizerExtender.Change> changes = EnumSet.noneOf(PhpModuleCustomizerExtender.Change.class);
            PhpModule phpModule = this.project.getPhpModule();
            for (PhpModuleCustomizerExtender customizerExtender : this.customizerExtenders) {
                EnumSet change = customizerExtender.save(phpModule);
                if (change == null) continue;
                changes.addAll(change);
            }
            if (!changes.isEmpty()) {
                RP.execute(new Runnable(){

                    @Override
                    public void run() {
                        block7: for (PhpModuleCustomizerExtender.Change change : changes) {
                            switch (change) {
                                case SOURCES_CHANGE: {
                                    PhpProjectProperties.this.project.getSourceRoots().refresh();
                                    continue block7;
                                }
                                case TESTS_CHANGE: {
                                    PhpProjectProperties.this.project.getTestRoots().refresh();
                                    continue block7;
                                }
                                case SELENIUM_CHANGE: {
                                    PhpProjectProperties.this.project.getSeleniumRoots().refresh();
                                    continue block7;
                                }
                                case IGNORED_FILES_CHANGE: {
                                    PhpProjectProperties.this.project.fireIgnoredFilesChange();
                                    continue block7;
                                }
                                case FRAMEWORK_CHANGE: {
                                    PhpProjectProperties.this.project.resetFrameworks();
                                    continue block7;
                                }
                            }
                            throw new IllegalStateException("Unknown change: " + change);
                        }
                    }
                });
            }
        }
    }

    @CheckForNull
    public File getResolvedWebRootFolder() {
        File sourceDir = this.resolveFile(this.getSrcDir());
        if (sourceDir == null) {
            return null;
        }
        String wr = this.getWebRoot();
        if (StringUtils.hasText((String)wr)) {
            return PropertyUtils.resolveFile((File)sourceDir, (String)wr);
        }
        return sourceDir;
    }

    @CheckForNull
    private File resolveFile(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return this.project.getHelper().resolveFile(path);
    }

    private String getActiveRunAsType() {
        return this.configManager.currentConfiguration().getValue(RUN_AS);
    }

    private int getNumOfRunConfigs() {
        int n = 0;
        for (String name : this.configManager.configurationNames()) {
            if (!this.configManager.exists(name)) continue;
            ++n;
        }
        return n;
    }

    private void logUsage(FileObject projectDir, FileObject sourceDir, String activeRunAsType, int numOfConfigs, boolean copyFiles) {
        PhpProjectUtils.logUsage(PhpProjectProperties.class, "USG_PROJECT_CONFIG_PHP", Arrays.asList(FileUtil.isParentOf((FileObject)projectDir, (FileObject)sourceDir) ? "EXTRA_SRC_DIR_NO" : "EXTRA_SRC_DIR_YES", activeRunAsType, Integer.toString(numOfConfigs), copyFiles ? "COPY_FILES_YES" : "COPY_FILES_NO"));
    }

    public PhpProject getProject() {
        return this.project;
    }

    Map<String, Map<String, String>> readRunConfigs() {
        Map<String, Map<String, String>> m = ConfigManager.createEmptyConfigs();
        TreeMap<String, String> def = new TreeMap<String, String>();
        EditableProperties privateProperties = this.getProject().getHelper().getProperties("nbproject/private/private.properties");
        EditableProperties projectProperties = this.getProject().getHelper().getProperties("nbproject/project.properties");
        for (String prop : CFG_PROPS) {
            String v = privateProperties.getProperty(prop);
            if (v == null) {
                v = projectProperties.getProperty(prop);
            }
            if (v == null) continue;
            def.put(prop, v);
        }
        m.put(null, def);
        FileObject configs = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (configs != null) {
            for (FileObject kid : configs.getChildren()) {
                if (!kid.hasExt("properties")) continue;
                String path = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid);
                m.put(kid.getName(), new TreeMap(this.getProject().getHelper().getProperties(path)));
            }
        }
        if ((configs = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject kid : configs.getChildren()) {
                Map<String, String> c;
                if (!kid.hasExt("properties") || (c = m.get(kid.getName())) == null) continue;
                String path = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid);
                c.putAll(new HashMap(this.getProject().getHelper().getProperties(path)));
            }
        }
        return m;
    }

    void storeRunConfigs(EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        ConfigManager.Configuration defaultConfiguration = this.configManager.defaultConfiguration();
        for (String prop : CFG_PROPS) {
            EditableProperties ep;
            String value = defaultConfiguration.getValue(prop);
            EditableProperties editableProperties = ep = this.isPrivateProperty(prop) ? privateProperties : projectProperties;
            if (Utilities.compareObjects((Object)value, (Object)ep.getProperty(prop))) continue;
            if (StringUtils.hasText((String)value)) {
                ep.setProperty(prop, value);
                continue;
            }
            ep.remove((Object)prop);
        }
        for (String name : this.configManager.configurationNames()) {
            if (name == null) continue;
            String sharedPath = "nbproject/configs/" + name + ".properties";
            String privatePath = "nbproject/private/configs/" + name + ".properties";
            if (!this.configManager.exists(name)) {
                this.getProject().getHelper().putProperties(sharedPath, null);
                this.getProject().getHelper().putProperties(privatePath, null);
                continue;
            }
            ConfigManager.Configuration configuration = this.configManager.configurationFor(name);
            String displayName = configuration.getValue("$label");
            if (displayName != null) {
                EditableProperties ep = this.getProject().getHelper().getProperties(sharedPath);
                ep.setProperty("$label", displayName);
                this.getProject().getHelper().putProperties(sharedPath, ep);
            }
            for (String prop : CFG_PROPS) {
                String value = configuration.getValue(prop);
                String path = this.isPrivateProperty(prop) ? privatePath : sharedPath;
                EditableProperties ep = this.getProject().getHelper().getProperties(path);
                if (Utilities.compareObjects((Object)value, (Object)ep.getProperty(prop))) continue;
                if (value != null && (value.length() > 0 || StringUtils.hasText((String)defaultConfiguration.getValue(prop)))) {
                    ep.setProperty(prop, value);
                } else {
                    ep.remove((Object)prop);
                }
                this.getProject().getHelper().putProperties(path, ep);
            }
            this.getProject().getHelper().putProperties(sharedPath, this.getProject().getHelper().getProperties(sharedPath));
        }
    }

    private boolean isPrivateProperty(String property) {
        return true;
    }

    public static enum XDebugUrlArguments {
        XDEBUG_SESSION_START,
        XDEBUG_SESSION_STOP,
        XDEBUG_SESSION_STOP_NO_EXEC;

    }

    public static enum DebugUrl {
        DEFAULT_URL,
        ASK_FOR_URL,
        DO_NOT_OPEN_BROWSER;

    }

    public static enum UploadFiles {
        MANUALLY("LBL_UploadFilesManually", "TXT_UploadFilesManually"),
        ON_RUN("LBL_UploadFilesOnRun", "TXT_UploadFilesOnRun"),
        ON_SAVE("LBL_UploadFilesOnSave", "TXT_UploadFilesOnSave");

        private final String label;
        private final String description;

        private UploadFiles(String labelKey, String descriptionKey) {
            this.label = NbBundle.getMessage(PhpProjectProperties.class, (String)labelKey);
            this.description = NbBundle.getMessage(PhpProjectProperties.class, (String)descriptionKey);
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum RunAsType {
        LOCAL(Bundle.RunAsType_local_label()),
        SCRIPT(Bundle.RunAsType_script_label()),
        REMOTE(Bundle.RunAsType_remote_label()),
        INTERNAL(Bundle.RunAsType_internal_label());

        private final String label;

        private RunAsType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

