/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModuleFilter;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class AddModulePanel
extends JPanel {
    private static final String FILTER_DESCRIPTION = AddModulePanel.getMessage("LBL_FilterDescription");
    private static final String ALL_CLUSTERS = AddModulePanel.getMessage("TEXT_SelectAllClusters");
    private static final RequestProcessor RP = new RequestProcessor(AddModulePanel.class.getName(), 2, true);
    private static Rectangle lastSize;
    private CustomizerComponentFactory.DependencyListModel universeModules;
    private Set<ModuleDependency> selectedDeps;
    private RequestProcessor.Task filterTask;
    private AddModuleFilter filterer;
    private URL currectJavadoc;
    private final Object IMPL_LOCK = new Object();
    private final SingleModuleProperties props;
    private Timer timer;
    private JComboBox clusterFilterComboBox;
    private JLabel clusterFilterLabel;
    private JLabel descLabel;
    private JTextPane descValue;
    private JScrollPane descValueSP;
    private JLabel filter;
    JTextField filterValue;
    private JCheckBox matchCaseValue;
    private JLabel moduleLabel;
    JList moduleList;
    private JScrollPane moduleSP;
    private JCheckBox showExclModulesCheckBox;
    private JButton showJavadocButton;
    private JCheckBox showNonAPIModules;

    public static ModuleDependency[] selectDependencies(SingleModuleProperties props) {
        return AddModulePanel.selectDependencies(props, null);
    }

    public static ModuleDependency[] selectDependencies(SingleModuleProperties props, String initialFilterText) {
        final AddModulePanel addPanel = null != initialFilterText ? new AddModulePanel(props, initialFilterText) : new AddModulePanel(props);
        DialogDescriptor descriptor = new DialogDescriptor((Object)addPanel, AddModulePanel.getMessage("CTL_AddModuleDependencyTitle"));
        descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel"));
        descriptor.setClosingOptions(new Object[0]);
        final Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        descriptor.setButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogDescriptor.OK_OPTION.equals(e.getSource()) && addPanel.getSelectedDependencies().length == 0) {
                    return;
                }
                d.setVisible(false);
                d.dispose();
            }
        });
        if (lastSize != null) {
            d.setBounds(lastSize);
        }
        d.setVisible(true);
        lastSize = d.getBounds();
        d.dispose();
        if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            return addPanel.getSelectedDependencies();
        }
        return new ModuleDependency[0];
    }

    public AddModulePanel(SingleModuleProperties props) {
        this(props, FILTER_DESCRIPTION);
    }

    private AddModulePanel(final SingleModuleProperties props, String initialString) {
        this.props = props;
        this.selectedDeps = new HashSet<ModuleDependency>();
        this.initComponents();
        this.initAccessibility();
        this.filterValue.setText(initialString);
        this.fillUpUniverseModules();
        this.fillUpUniverseClusters();
        this.moduleList.setCellRenderer(CustomizerComponentFactory.getDependencyCellRenderer(false));
        this.moduleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddModulePanel.this.showDescription();
                AddModulePanel.this.currectJavadoc = null;
                final ModuleDependency[] deps = AddModulePanel.this.getSelectedDependencies();
                if (deps.length == 1) {
                    final NbPlatform platform = props.getActivePlatform();
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            AddModulePanel.this.currectJavadoc = deps[0].getModuleEntry().getJavadoc(platform);
                            AddModulePanel.this.showJavadocButton.setEnabled(AddModulePanel.this.currectJavadoc != null);
                        }
                    });
                } else {
                    AddModulePanel.this.showJavadocButton.setEnabled(false);
                }
            }
        });
        this.filterValue.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                if (!FILTER_DESCRIPTION.equals(AddModulePanel.this.filterValue.getText())) {
                    AddModulePanel.this.search();
                }
            }
        });
        this.clusterFilterComboBox.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent e) {
                AddModulePanel.this.filterValue.setEnabled(false);
                AddModulePanel.this.moduleList.setEnabled(false);
                AddModulePanel.this.showNonAPIModules.setEnabled(false);
                AddModulePanel.this.matchCaseValue.setEnabled(false);
                AddModulePanel.this.showExclModulesCheckBox.setEnabled(false);
                String lastFilter = AddModulePanel.this.filterValue.getText();
                AddModulePanel.this.filterValue.setText(UIUtil.WAIT_VALUE);
                AddModulePanel.this.moduleList.setModel(UIUtil.createListWaitModel());
                String selectedClusterStr = String.valueOf(AddModulePanel.this.clusterFilterComboBox.getSelectedItem());
                Set<ModuleDependency> universeDeps = AddModulePanel.this.universeModules.getDependencies();
                Object object = AddModulePanel.this.IMPL_LOCK;
                synchronized (object) {
                    AddModulePanel.this.selectedDeps = new HashSet<ModuleDependency>();
                    if (!ALL_CLUSTERS.equals(selectedClusterStr)) {
                        for (ModuleDependency dependencyIter : universeDeps) {
                            if (!selectedClusterStr.equals(dependencyIter.getModuleEntry().getClusterDirectory().getName())) continue;
                            AddModulePanel.this.selectedDeps.add(dependencyIter);
                        }
                    } else {
                        AddModulePanel.this.selectedDeps.addAll(universeDeps);
                    }
                }
                ModuleProperties.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = AddModulePanel.this.IMPL_LOCK;
                                synchronized (object) {
                                    AddModulePanel.this.moduleList.setModel(CustomizerComponentFactory.createSortedDependencyListModel(AddModulePanel.this.selectedDeps));
                                }
                                AddModulePanel.this.moduleList.setEnabled(true);
                                AddModulePanel.this.filterValue.setEnabled(true);
                                AddModulePanel.this.showNonAPIModules.setEnabled(true);
                                boolean enableExclModuleChckBox = props.isHasExcludedModules() && props.isSuiteComponent();
                                AddModulePanel.this.showExclModulesCheckBox.setEnabled(enableExclModuleChckBox);
                                AddModulePanel.this.matchCaseValue.setEnabled(true);
                            }
                        });
                    }
                });
                AddModulePanel.this.filterValue.setText(lastFilter);
                if (!FILTER_DESCRIPTION.equals(lastFilter)) {
                    AddModulePanel.this.search();
                } else {
                    AddModulePanel.this.filterValue.selectAll();
                }
                AddModulePanel.this.filterValue.requestFocusInWindow();
            }
        });
        String[][] listNavCommands = new String[][]{{"selectPreviousRow", "selectPreviousRow"}, {"selectNextRow", "selectNextRow"}, {"selectFirstRow", "selectFirstRow"}, {"selectLastRow", "selectLastRow"}, {"scrollUp", "scrollUp"}, {"scrollDown", "scrollDown"}};
        String[][] areaNavCommands = new String[][]{{"selection-page-up", "page-up"}, {"selection-page-down", "page-down"}, {"selection-up", "caret-up"}, {"selection-down", "caret-down"}};
        AddModulePanel.exchangeCommands(listNavCommands, this.moduleList, this.filterValue);
        AddModulePanel.exchangeCommands(areaNavCommands, this.descValue, this.filterValue);
    }

    private static void exchangeCommands(String[][] commandsToExchange, final JComponent target, JComponent source) {
        InputMap targetBindings = target.getInputMap();
        KeyStroke[] targetBindingKeys = targetBindings.allKeys();
        ActionMap targetActions = target.getActionMap();
        InputMap sourceBindings = source.getInputMap();
        ActionMap sourceActions = source.getActionMap();
        for (int i = 0; i < commandsToExchange.length; ++i) {
            String commandFrom = commandsToExchange[i][0];
            String commandTo = commandsToExchange[i][1];
            final Action orig = targetActions.get(commandTo);
            if (orig == null) continue;
            sourceActions.put(commandTo, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    orig.actionPerformed(new ActionEvent(target, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                }
            });
            for (int j = 0; j < targetBindingKeys.length; ++j) {
                if (!targetBindings.get(targetBindingKeys[j]).equals(commandFrom)) continue;
                sourceBindings.put(targetBindingKeys[j], commandTo);
            }
        }
    }

    private void fillUpUniverseClusters() {
        final boolean nonApiDeps = this.showNonAPIModules.isSelected();
        final boolean exclModules = this.showExclModulesCheckBox.isSelected();
        final Object lastSelectedItem = this.clusterFilterComboBox.getSelectedItem();
        final ArrayList allClustersList = new ArrayList();
        ModuleProperties.RP.post(new Runnable(){

            @Override
            public void run() {
                AddModulePanel.this.selectedDeps = AddModulePanel.this.props.getUniverseDependencies(!exclModules, !nonApiDeps);
                final Set<ModuleDependency> universeDeps = AddModulePanel.this.selectedDeps;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allClustersList.add(ALL_CLUSTERS);
                        for (ModuleDependency dependencyIter : universeDeps) {
                            if (allClustersList.contains(dependencyIter.getModuleEntry().getClusterDirectory().getName())) continue;
                            allClustersList.add(dependencyIter.getModuleEntry().getClusterDirectory().getName());
                        }
                        String[] allClusters = new String[allClustersList.size()];
                        allClustersList.toArray(allClusters);
                        AddModulePanel.this.clusterFilterComboBox.setModel(new DefaultComboBoxModel<String>(allClusters));
                        for (int i = 0; i < AddModulePanel.this.clusterFilterComboBox.getItemCount(); ++i) {
                            if (!AddModulePanel.this.clusterFilterComboBox.getItemAt(i).equals(lastSelectedItem)) continue;
                            AddModulePanel.this.clusterFilterComboBox.setSelectedIndex(i);
                        }
                    }
                });
            }
        });
    }

    private void fillUpUniverseModules() {
        this.filterValue.setEnabled(false);
        this.moduleList.setEnabled(false);
        this.showNonAPIModules.setEnabled(false);
        this.matchCaseValue.setEnabled(false);
        this.showExclModulesCheckBox.setEnabled(false);
        final String lastFilter = this.filterValue.getText();
        this.filterValue.setText(UIUtil.WAIT_VALUE);
        this.moduleList.setModel(UIUtil.createListWaitModel());
        final boolean nonApiDeps = this.showNonAPIModules.isSelected();
        final boolean exclModules = this.showExclModulesCheckBox.isSelected();
        ModuleProperties.RP.post(new Runnable(){

            @Override
            public void run() {
                AddModulePanel.this.props.resetUniverseDependencies();
                final Set<ModuleDependency> universeDeps = AddModulePanel.this.props.getUniverseDependencies(!exclModules, !nonApiDeps);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddModulePanel.this.universeModules = CustomizerComponentFactory.createSortedDependencyListModel(universeDeps);
                        AddModulePanel.this.filterer = null;
                        AddModulePanel.this.moduleList.setModel(AddModulePanel.this.universeModules);
                        AddModulePanel.this.moduleList.setEnabled(true);
                        AddModulePanel.this.filterValue.setEnabled(true);
                        AddModulePanel.this.showNonAPIModules.setEnabled(true);
                        AddModulePanel.this.matchCaseValue.setEnabled(true);
                        boolean enableExclModuleChckBox = AddModulePanel.this.props.isHasExcludedModules() && AddModulePanel.this.props.isSuiteComponent();
                        AddModulePanel.this.showExclModulesCheckBox.setEnabled(enableExclModuleChckBox);
                        AddModulePanel.this.filterValue.setText(lastFilter);
                        if (!FILTER_DESCRIPTION.equals(lastFilter)) {
                            AddModulePanel.this.search();
                        } else {
                            AddModulePanel.this.filterValue.selectAll();
                        }
                        AddModulePanel.this.filterValue.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private void showDescription() {
        StyledDocument doc = this.descValue.getStyledDocument();
        Boolean matchCase = this.matchCaseValue.isSelected();
        try {
            String filterText;
            doc.remove(0, doc.getLength());
            ModuleDependency[] deps = this.getSelectedDependencies();
            if (deps.length != 1) {
                return;
            }
            String longDesc = deps[0].getModuleEntry().getLongDescription();
            if (longDesc != null) {
                doc.insertString(0, longDesc, null);
            }
            if ((filterText = this.filterValue.getText().trim()).length() != 0 && !FILTER_DESCRIPTION.equals(filterText)) {
                doc.insertString(doc.getLength(), "\n\n", null);
                Style bold = doc.addStyle(null, null);
                bold.addAttribute(StyleConstants.Bold, Boolean.TRUE);
                doc.insertString(doc.getLength(), AddModulePanel.getMessage("TEXT_matching_filter_contents"), bold);
                doc.insertString(doc.getLength(), "\n", null);
                if (filterText.length() > 0) {
                    String filterTextLC = matchCase != false ? filterText : filterText.toLowerCase(Locale.US);
                    Style match = doc.addStyle(null, null);
                    match.addAttribute(StyleConstants.Background, UIManager.get("selection.highlight") != null ? UIManager.get("selection.highlight") : new Color(246, 248, 139));
                    boolean isEven = false;
                    Style even = doc.addStyle(null, null);
                    even.addAttribute(StyleConstants.Background, UIManager.get("Panel.background"));
                    if (this.filterer == null) {
                        return;
                    }
                    for (String hit : this.filterer.getMatchesFor(filterText, deps[0])) {
                        int loc = doc.getLength();
                        doc.insertString(loc, hit, isEven ? even : null);
                        int start = (matchCase != false ? hit : hit.toLowerCase(Locale.US)).indexOf(filterTextLC);
                        while (start != -1) {
                            doc.setCharacterAttributes(loc + start, filterTextLC.length(), match, true);
                            start = hit.toLowerCase(Locale.US).indexOf(filterTextLC, start + 1);
                        }
                        doc.insertString(doc.getLength(), "\n", isEven ? even : null);
                        isEven ^= true;
                    }
                } else {
                    Style italics = doc.addStyle(null, null);
                    italics.addAttribute(StyleConstants.Italic, Boolean.TRUE);
                    doc.insertString(doc.getLength(), AddModulePanel.getMessage("TEXT_no_filter_specified"), italics);
                }
            }
            this.descValue.setCaretPosition(0);
        }
        catch (BadLocationException e) {
            Util.err.notify(1, (Throwable)e);
        }
    }

    public ModuleDependency[] getSelectedDependencies() {
        ModuleDependency[] deps;
        if (UIUtil.isWaitModel(this.moduleList.getModel())) {
            deps = new ModuleDependency[]{};
        } else {
            Object[] objects = this.moduleList.getSelectedValues();
            deps = new ModuleDependency[objects.length];
            System.arraycopy(objects, 0, deps, 0, objects.length);
        }
        return deps;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.cancelFilterTask();
    }

    private synchronized void cancelFilterTask() {
        if (this.filterTask != null) {
            this.filterTask.cancel();
            this.filterTask = null;
            this.filterer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search() {
        this.cancelFilterTask();
        final String text = this.filterValue.getText();
        final Boolean matchCase = this.matchCaseValue.isSelected();
        if (text.length() == 0) {
            this.moduleList.setModel(CustomizerComponentFactory.createSortedDependencyListModel(this.selectedDeps));
            this.moduleList.setSelectedIndex(0);
            this.moduleList.ensureIndexIsVisible(0);
        } else {
            final Runnable compute = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set<ModuleDependency> matches;
                    AddModuleFilter _filterer = AddModulePanel.this.filterer;
                    if (_filterer == null) {
                        return;
                    }
                    Object object = AddModulePanel.this.IMPL_LOCK;
                    synchronized (object) {
                        matches = _filterer.getMatches(AddModulePanel.this.selectedDeps, text, matchCase);
                    }
                    object = AddModulePanel.this;
                    synchronized (object) {
                        AddModulePanel.this.filterTask = null;
                    }
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            AddModulePanel.this.timer.stop();
                            if (!text.equals(AddModulePanel.this.filterValue.getText())) {
                                return;
                            }
                            AddModulePanel.this.moduleList.setModel(CustomizerComponentFactory.createDependencyListModel(matches));
                            int index = matches.isEmpty() ? -1 : 0;
                            AddModulePanel.this.moduleList.setSelectedIndex(index);
                            AddModulePanel.this.moduleList.ensureIndexIsVisible(index);
                        }
                    });
                }
            };
            this.restartTimer();
            AddModulePanel addModulePanel = this;
            synchronized (addModulePanel) {
                this.filterTask = RP.post(new Runnable(){

                    @Override
                    public void run() {
                        if (AddModulePanel.this.filterer == null) {
                            AddModulePanel.this.filterer = new AddModuleFilter(AddModulePanel.this.universeModules.getDependencies(), AddModulePanel.this.props.getCodeNameBase());
                        }
                        compute.run();
                    }
                });
            }
        }
    }

    private void restartTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddModulePanel.this.moduleList.setModel(UIUtil.createListWaitModel());
                }
            });
            this.timer.setRepeats(false);
        }
        this.timer.restart();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_AddModuleDependency"));
        this.filterValue.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_LBL_Filter"));
        this.moduleList.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_CTL_ModuleList"));
        this.moduleSP.getVerticalScrollBar().getAccessibleContext().setAccessibleName(AddModulePanel.getMessage("ACS_CTL_ModuleListVerticalScroll"));
        this.moduleSP.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACSD_CTL_ModuleListVerticalScroll"));
        this.moduleSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(AddModulePanel.getMessage("ACS_CTL_ModuleListHorizontalScroll"));
        this.moduleSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACSD_CTL_ModuleListHorizontalScroll"));
        this.showNonAPIModules.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACSD_ShowNonApiModules"));
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(AddModulePanel.class, (String)key);
    }

    private void initComponents() {
        this.moduleLabel = new JLabel();
        this.moduleSP = new JScrollPane();
        this.moduleList = new JList();
        this.descLabel = new JLabel();
        this.filter = new JLabel();
        this.filterValue = new JTextField();
        this.descValueSP = new JScrollPane();
        this.descValue = new JTextPane();
        this.showJavadocButton = new JButton();
        this.showNonAPIModules = new JCheckBox();
        this.matchCaseValue = new JCheckBox();
        this.showExclModulesCheckBox = new JCheckBox();
        this.clusterFilterComboBox = new JComboBox();
        this.clusterFilterLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setPreferredSize(new Dimension(500, 450));
        this.setLayout(new GridBagLayout());
        this.moduleLabel.setLabelFor(this.moduleList);
        Mnemonics.setLocalizedText((JLabel)this.moduleLabel, (String)NbBundle.getMessage(AddModulePanel.class, (String)"LBL_Module"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.moduleLabel, gridBagConstraints);
        this.moduleSP.setPreferredSize(new Dimension(450, 116));
        this.moduleSP.setViewportView(this.moduleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.moduleSP, gridBagConstraints);
        this.descLabel.setLabelFor(this.descValue);
        Mnemonics.setLocalizedText((JLabel)this.descLabel, (String)NbBundle.getMessage(AddModulePanel.class, (String)"LBL_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.descLabel, gridBagConstraints);
        this.filter.setLabelFor(this.filterValue);
        Mnemonics.setLocalizedText((JLabel)this.filter, (String)NbBundle.getMessage(AddModulePanel.class, (String)"LBL_Filter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.add((Component)this.filter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.filterValue, gridBagConstraints);
        this.descValueSP.setPreferredSize(new Dimension(450, 116));
        this.descValue.setEditable(false);
        this.descValue.setPreferredSize(new Dimension(6, 100));
        this.descValueSP.setViewportView(this.descValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.descValueSP, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.showJavadocButton, (String)bundle.getString("CTL_ShowJavadoc"));
        this.showJavadocButton.setEnabled(false);
        this.showJavadocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddModulePanel.this.showJavadoc(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.showJavadocButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showNonAPIModules, (String)NbBundle.getMessage(AddModulePanel.class, (String)"CTL_ShowNonAPIModules"));
        this.showNonAPIModules.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showNonAPIModules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddModulePanel.this.showNonAPIModulesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.showNonAPIModules, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.matchCaseValue, (String)"Match &Case");
        this.matchCaseValue.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.matchCaseValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddModulePanel.this.matchCaseValueActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.add((Component)this.matchCaseValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showExclModulesCheckBox, (String)"Show &Excl. Modules");
        this.showExclModulesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddModulePanel.this.showExclModulesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.add((Component)this.showExclModulesCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.clusterFilterComboBox, gridBagConstraints);
        this.clusterFilterLabel.setLabelFor(this.clusterFilterComboBox);
        Mnemonics.setLocalizedText((JLabel)this.clusterFilterLabel, (String)"C&luster:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.add((Component)this.clusterFilterLabel, gridBagConstraints);
    }

    private void showNonAPIModulesActionPerformed(ActionEvent evt) {
        this.fillUpUniverseClusters();
        this.fillUpUniverseModules();
    }

    private void showJavadoc(ActionEvent evt) {
        HtmlBrowser.URLDisplayer.getDefault().showURL(this.currectJavadoc);
    }

    private void matchCaseValueActionPerformed(ActionEvent evt) {
        this.fillUpUniverseClusters();
        this.fillUpUniverseModules();
    }

    private void showExclModulesCheckBoxActionPerformed(ActionEvent evt) {
        this.fillUpUniverseClusters();
        this.fillUpUniverseModules();
    }
}

