/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class WrongOrderOfArgsHint
extends HintRule {
    private static final String HINT_ID = "Wrong.Order.Of.Args.Hint";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        TokenHierarchy tokenHierarchy = phpParseResult.getSnapshot().getTokenHierarchy();
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc, tokenHierarchy);
        phpParseResult.getProgram().accept(checkVisitor);
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.WrongOrderOfArgsHintDesc();
    }

    public String getDisplayName() {
        return Bundle.WrongOrderOfArgsHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final List<FunctionDeclaration> wrongFunctions = new ArrayList<FunctionDeclaration>();
        private final List<Hint> hints = new ArrayList<Hint>();
        private final BaseDocument doc;
        private final TokenHierarchy<?> tokenHierarchy;

        public CheckVisitor(FileObject fileObject, BaseDocument doc, TokenHierarchy<?> tokenHierarchy) {
            this.fileObject = fileObject;
            this.doc = doc;
            this.tokenHierarchy = tokenHierarchy;
        }

        public List<Hint> getHints() {
            for (FunctionDeclaration wrongFunction : this.wrongFunctions) {
                this.processWrongFunction(wrongFunction);
            }
            return new ArrayList<Hint>(this.hints);
        }

        private void processWrongFunction(FunctionDeclaration node) {
            RearrangeParametersFix hintFix = new RearrangeParametersFix(this.doc, node, this.tokenHierarchy);
            OffsetRange offsetRange = hintFix.getOffsetRange();
            if (WrongOrderOfArgsHint.this.showHint(offsetRange, this.doc)) {
                this.hints.add(new Hint((Rule)WrongOrderOfArgsHint.this, Bundle.WrongOrderOfArgsDesc(), this.fileObject, offsetRange, Collections.singletonList(hintFix), 500));
            }
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            boolean previousParamIsOptional = false;
            for (FormalParameter formalParameter : node.getFormalParameters()) {
                boolean currentParamIsOptional;
                boolean bl = currentParamIsOptional = !formalParameter.isMandatory();
                if (currentParamIsOptional) {
                    previousParamIsOptional = currentParamIsOptional;
                    continue;
                }
                if (!previousParamIsOptional || formalParameter.isVariadic()) continue;
                this.wrongFunctions.add(node);
                break;
            }
        }
    }

    private static class RearrangedFunctionDeclaration
    extends FunctionDeclaration {
        public RearrangedFunctionDeclaration(FunctionDeclaration node) {
            super(node.getStartOffset(), node.getEndOffset(), node.getFunctionName(), node.getFormalParameters(), node.getReturnType(), node.getBody(), node.isReference());
        }

        @Override
        public List<FormalParameter> getFormalParameters() {
            ArrayList<FormalParameter> rearrangedList = new ArrayList<FormalParameter>();
            ArrayList<FormalParameter> parametersWithDefault = new ArrayList<FormalParameter>();
            FormalParameter variadicParam = null;
            for (FormalParameter param : super.getFormalParameters()) {
                if (param.isMandatory()) {
                    rearrangedList.add(param);
                    continue;
                }
                if (param.isVariadic()) {
                    variadicParam = param;
                    continue;
                }
                parametersWithDefault.add(param);
            }
            rearrangedList.addAll(parametersWithDefault);
            if (variadicParam != null) {
                rearrangedList.add(variadicParam);
            }
            return rearrangedList;
        }
    }

    private static class RearrangeParametersFix
    implements HintFix {
        private final FunctionDeclaration node;
        private final BaseDocument doc;
        private final FunctionDeclarationInfo functionDeclarationInfo;
        private final TokenHierarchy<?> tokenHierarchy;

        public RearrangeParametersFix(BaseDocument doc, FunctionDeclaration node, TokenHierarchy<?> tokenHierarchy) {
            this.doc = doc;
            this.node = node;
            this.tokenHierarchy = tokenHierarchy;
            this.functionDeclarationInfo = FunctionDeclarationInfo.create(new RearrangedFunctionDeclaration(node));
        }

        public String getDescription() {
            return Bundle.RearrangeParamsDisp(this.functionDeclarationInfo.getName());
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            List<FormalParameter> originalParameters = this.node.getFormalParameters();
            List<ParameterElement> parameters = this.functionDeclarationInfo.getParameters();
            assert (originalParameters.size() == parameters.size()) : originalParameters.size() + " != " + parameters.size();
            for (int i = 0; i < originalParameters.size(); ++i) {
                FormalParameter originalParameter = originalParameters.get(i);
                OffsetRange originalRange = new OffsetRange(originalParameter.getStartOffset(), originalParameter.getEndOffset());
                edits.replace(originalRange.getStart(), originalRange.getLength(), parameters.get(i).asString(ParameterElement.OutputType.COMPLETE_DECLARATION_WITH_MODIFIER), false, 0);
            }
            edits.apply();
        }

        public OffsetRange getOffsetRange() {
            int start = 0;
            int end = 0;
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(this.tokenHierarchy, this.node.getStartOffset());
            if (ts != null) {
                ts.move(this.node.getStartOffset());
                int braceMatch = 0;
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() != PHPTokenId.PHP_TOKEN) continue;
                    if (TokenUtilities.textEquals((CharSequence)t.text(), (CharSequence)"(")) {
                        if (braceMatch == 0) {
                            start = ts.offset() + 1;
                        }
                        ++braceMatch;
                    } else if (TokenUtilities.textEquals((CharSequence)t.text(), (CharSequence)")")) {
                        --braceMatch;
                    }
                    if (braceMatch != 0) continue;
                    end = ts.offset();
                    ts.moveNext();
                    break;
                }
            }
            return new OffsetRange(start, end);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

