/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class AddOverrideAttributeHint
extends HintRule {
    private static final String HINT_ID = "Add.Override.Attribute";

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.AddOverrideAttributeSuggestion_description();
    }

    public String getDisplayName() {
        return Bundle.AddOverrideAttributeSuggestion_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        BaseDocument document = context.doc;
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && this.hasOverrideAttribute(fileObject)) {
            FileScope fileScope = context.fileScope;
            ElementQuery.Index index = context.getIndex();
            Map<String, Set<String>> types = this.getTypesAndInheritedMethods(index, fileScope);
            CheckVisitor checkVisitor = new CheckVisitor(types, fileScope);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            TokenHierarchy tokenHierarchy = phpParseResult.getSnapshot().getTokenHierarchy();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(tokenHierarchy, 0);
            this.addAddOverrideHints(checkVisitor, hints, document, fileObject, ts);
            this.addRemoveOverrideHints(checkVisitor, hints, document, fileObject, ts);
        }
    }

    private Map<String, Set<String>> getTypesAndInheritedMethods(ElementQuery.Index index, FileScope fileScope) {
        List<TypeScope> declaredTypes = this.getDeclaredTypes(fileScope);
        HashMap<String, Set<String>> typesAndInheritedMethods = new HashMap<String, Set<String>>();
        for (TypeScope typeScope : declaredTypes) {
            if (CancelSupport.getDefault().isCancelled()) {
                Collections.emptyMap();
            }
            Set<String> inheritedMethods = AddOverrideAttributeHint.toNames(this.getInheritedMethods(typeScope, index));
            typesAndInheritedMethods.put(typeScope.getName(), inheritedMethods);
        }
        return typesAndInheritedMethods;
    }

    private List<TypeScope> getDeclaredTypes(FileScope fileScope) {
        ArrayList<TypeScope> declaredTypes = new ArrayList<TypeScope>();
        declaredTypes.addAll(ModelUtils.getDeclaredClasses(fileScope));
        declaredTypes.addAll(ModelUtils.getDeclaredInterfaces(fileScope));
        declaredTypes.addAll(ModelUtils.getDeclaredEnums(fileScope));
        return declaredTypes;
    }

    private void addAddOverrideHints(CheckVisitor checkVisitor, List<Hint> hints, BaseDocument document, FileObject fileObject, TokenSequence<PHPTokenId> ts) {
        for (MethodDeclaration method : checkVisitor.getMissingOverrideAttributeMethods()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Identifier methodName = method.getFunction().getFunctionName();
            AddOverrideFix fix = new AddOverrideFix(document, method, ts);
            hints.add(new Hint((Rule)this, fix.getDescription(), fileObject, new OffsetRange(methodName.getStartOffset(), methodName.getEndOffset()), Collections.singletonList(fix), 500));
        }
    }

    private void addRemoveOverrideHints(CheckVisitor checkVisitor, List<Hint> hints, BaseDocument document, FileObject fileObject, TokenSequence<PHPTokenId> ts) {
        for (InvalidOverrideAttributeMethod invalidOverrideMethod : checkVisitor.getInvalidOverrideAttributeMethods()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            AttributeDeclaration overrideDeclaration = invalidOverrideMethod.getOverrideAttributeDeclaration();
            Expression attributeName = overrideDeclaration.getAttributeName();
            RemoveOverrideFix fix = new RemoveOverrideFix(document, invalidOverrideMethod, ts);
            hints.add(new Hint((Rule)this, fix.getDescription(), fileObject, new OffsetRange(attributeName.getStartOffset(), attributeName.getEndOffset()), Collections.singletonList(fix), 500));
        }
    }

    protected boolean hasOverrideAttribute(FileObject fileObject) {
        PhpVersion phpVersion = CodeUtils.getPhpVersion(fileObject);
        return phpVersion.hasOverrideAttribute();
    }

    private Set<MethodElement> getInheritedMethods(TypeScope typeScope, ElementQuery.Index index) {
        HashSet<MethodElement> inheritedMethods = new HashSet<MethodElement>();
        HashSet<MethodElement> accessibleSuperMethods = new HashSet<MethodElement>();
        this.addAccessibleClassMethods(typeScope, index, accessibleSuperMethods);
        this.addAccessibleInterfaceMethods(typeScope, index, accessibleSuperMethods);
        this.addAccessibleAbstractTraitMethods(typeScope, index, accessibleSuperMethods);
        inheritedMethods.addAll(accessibleSuperMethods);
        return inheritedMethods;
    }

    private void addAccessibleClassMethods(TypeScope typeScope, ElementQuery.Index index, Set<MethodElement> accessibleSuperMethods) {
        Collection<? extends ClassScope> superClasses = this.getSuperClasses(typeScope);
        for (ClassScope classScope : superClasses) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Set<MethodElement> accessibleMethods = index.getAccessibleMethods(classScope, typeScope);
            accessibleSuperMethods.addAll(accessibleMethods);
        }
    }

    private void addAccessibleInterfaceMethods(TypeScope typeScope, ElementQuery.Index index, Set<MethodElement> accessibleSuperMethods) {
        Collection<? extends InterfaceScope> superInterface = typeScope.getSuperInterfaceScopes();
        for (InterfaceScope interfaceScope : superInterface) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            accessibleSuperMethods.addAll(index.getAccessibleMethods(interfaceScope, typeScope));
        }
    }

    private void addAccessibleAbstractTraitMethods(TypeScope typeScope, ElementQuery.Index index, Set<MethodElement> accessibleSuperMethods) {
        Collection<? extends TraitScope> traits = this.getTraits(typeScope);
        for (TraitScope traitScope : traits) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            ElementFilter abstractMethodFilter = new ElementFilter(){

                @Override
                public boolean isAccepted(PhpElement element) {
                    if (element instanceof MethodElement) {
                        MethodElement method = (MethodElement)element;
                        return method.isAbstract();
                    }
                    return false;
                }
            };
            Set<MethodElement> accessibleTraitMethods = index.getAccessibleMethods(traitScope, typeScope);
            accessibleSuperMethods.addAll(abstractMethodFilter.filter(accessibleTraitMethods));
        }
    }

    private Collection<? extends ClassScope> getSuperClasses(TypeScope typeScope) {
        if (typeScope instanceof ClassScope) {
            return ((ClassScope)typeScope).getSuperClasses();
        }
        return Collections.emptyList();
    }

    private Collection<? extends TraitScope> getTraits(TypeScope typeScope) {
        if (typeScope instanceof ClassScope) {
            return ((ClassScope)typeScope).getTraits();
        }
        if (typeScope instanceof TraitScope) {
            return ((TraitScope)typeScope).getTraits();
        }
        if (typeScope instanceof EnumScope) {
            return ((EnumScope)typeScope).getTraits();
        }
        return Collections.emptyList();
    }

    private static Set<String> toNames(Set<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            String name = phpElement.getName();
            if (StringUtils.isEmpty((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)",");
    }

    private static boolean isWhitespace(Token<PHPTokenId> token) {
        return token.id() == PHPTokenId.WHITESPACE;
    }

    private static class CheckVisitor
    extends DefaultVisitor {
        private final Map<String, Set<String>> typesAndInheritedMethods;
        private final Set<MethodDeclaration> missingOverrideAttributeMethods = new HashSet<MethodDeclaration>();
        private final Set<InvalidOverrideAttributeMethod> invalidOverrideAttributeMethods = new HashSet<InvalidOverrideAttributeMethod>();
        private String currentTypeName = null;
        private NamespaceDeclaration currentNamespace = null;
        private final FileScope fileScope;

        public CheckVisitor(Map<String, Set<String>> typesAndInheritedMethods, FileScope fileScope) {
            this.typesAndInheritedMethods = new HashMap<String, Set<String>>(typesAndInheritedMethods);
            this.fileScope = fileScope;
        }

        @Override
        public void visit(NamespaceDeclaration namespace) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.currentNamespace = namespace;
            super.visit(namespace);
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            String originalCurrentTypeName = this.currentTypeName;
            this.currentTypeName = CodeUtils.extractClassName(node);
            super.visit(node);
            this.currentTypeName = originalCurrentTypeName;
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.currentTypeName = node.getName().getName();
            super.visit(node);
        }

        @Override
        public void visit(InterfaceDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.currentTypeName = node.getName().getName();
            super.visit(node);
        }

        @Override
        public void visit(EnumDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.currentTypeName = node.getName().getName();
            super.visit(node);
        }

        @Override
        public void visit(TraitDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.currentTypeName = null;
            super.visit(node);
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            String methodName = node.getFunction().getFunctionName().getName();
            if (this.currentTypeName != null) {
                Set<String> inheritedMethods = this.typesAndInheritedMethods.get(this.currentTypeName);
                if (inheritedMethods == null) {
                    return;
                }
                Pair<Attribute, AttributeDeclaration> overrideAttribute = this.getOverrideAttribute(node);
                boolean hasOverride = overrideAttribute != null;
                boolean isInheritedMethod = inheritedMethods.contains(methodName);
                if (isInheritedMethod && !hasOverride) {
                    this.missingOverrideAttributeMethods.add(node);
                } else if (!isInheritedMethod && hasOverride) {
                    this.invalidOverrideAttributeMethods.add(new InvalidOverrideAttributeMethod(methodName, overrideAttribute));
                }
            }
            super.visit(node);
        }

        @CheckForNull
        private Pair<Attribute, AttributeDeclaration> getOverrideAttribute(MethodDeclaration method) {
            for (Attribute attribute : method.getAttributes()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return null;
                }
                for (AttributeDeclaration attributeDeclaration : attribute.getAttributeDeclarations()) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return null;
                    }
                    Expression attributeNameExpression = attributeDeclaration.getAttributeName();
                    String attributeName = CodeUtils.extractQualifiedName(attributeNameExpression);
                    if (!this.isOverrideAttibute(attributeName, attributeNameExpression.getStartOffset())) continue;
                    return Pair.of((Object)attribute, (Object)attributeDeclaration);
                }
            }
            return null;
        }

        public Set<InvalidOverrideAttributeMethod> getInvalidOverrideAttributeMethods() {
            return Collections.unmodifiableSet(this.invalidOverrideAttributeMethods);
        }

        public Set<MethodDeclaration> getMissingOverrideAttributeMethods() {
            return Collections.unmodifiableSet(this.missingOverrideAttributeMethods);
        }

        private boolean isOverrideAttibute(String attributeName, int offset) {
            if (PredefinedSymbols.Attributes.OVERRIDE.getFqName().equals(attributeName)) {
                return true;
            }
            if (PredefinedSymbols.Attributes.OVERRIDE.getName().equals(attributeName)) {
                Collection<? extends NamespaceScope> declaredNamespaces = this.fileScope.getDeclaredNamespaces();
                if (this.isGlobalNamespace()) {
                    return true;
                }
                NamespaceName name = this.currentNamespace.getName();
                QualifiedName currentNamespaceName = QualifiedName.create(name);
                NamespaceScope namespaceScope = null;
                for (NamespaceScope namespaceScope2 : declaredNamespaces) {
                    QualifiedName namespaceName = namespaceScope2.getNamespaceName();
                    if (!currentNamespaceName.equals(namespaceName)) continue;
                    namespaceScope = namespaceScope2;
                    break;
                }
                if (namespaceScope != null) {
                    QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(PredefinedSymbols.Attributes.OVERRIDE.getName()), offset, namespaceScope);
                    if (PredefinedSymbols.Attributes.OVERRIDE.getFqName().equals(fullyQualifiedName.toString())) {
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isGlobalNamespace() {
            return this.currentNamespace == null || this.currentNamespace.getName() == null;
        }
    }

    private static class AddOverrideFix
    implements HintFix {
        private static final List<PHPTokenId> COMMENT_AND_WS_TOKEN_IDS = Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END);
        private final BaseDocument document;
        private final MethodDeclaration methodDeclaration;
        private final TokenSequence<PHPTokenId> ts;

        public AddOverrideFix(BaseDocument document, MethodDeclaration methodDeclaration, TokenSequence<PHPTokenId> ts) {
            this.document = document;
            this.methodDeclaration = methodDeclaration;
            this.ts = ts;
        }

        public String getDescription() {
            return Bundle.AddOverrideFix_description();
        }

        public void implement() throws Exception {
            CharSequence text;
            int lastIndex;
            EditList edits = new EditList(this.document);
            int offset = this.methodDeclaration.getStartOffset();
            List<Attribute> attributes = this.methodDeclaration.getAttributes();
            this.ts.move(offset);
            CharSequence indent = "";
            if (this.ts.movePrevious() && AddOverrideAttributeHint.isWhitespace((Token<PHPTokenId>)this.ts.token()) && (lastIndex = TokenUtilities.lastIndexOf((CharSequence)(text = this.ts.token().text()), (CharSequence)"\n")) != -1) {
                indent = text.subSequence(lastIndex + 1, text.length());
            }
            if (attributes.isEmpty()) {
                edits.replace(offset, 0, PredefinedSymbols.Attributes.OVERRIDE.asAttributeExpression() + "\n" + indent, false, 0);
            } else {
                Token<? extends PHPTokenId> findNext;
                Attribute lastAttribute = attributes.get(attributes.size() - 1);
                offset = lastAttribute.getEndOffset();
                this.ts.move(offset);
                if (this.ts.moveNext() && (findNext = LexUtilities.findNext(this.ts, COMMENT_AND_WS_TOKEN_IDS)) != null) {
                    offset = this.ts.offset();
                }
                edits.replace(offset, 0, PredefinedSymbols.Attributes.OVERRIDE.asAttributeExpression() + "\n" + indent, false, 0);
            }
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class InvalidOverrideAttributeMethod {
        private final String methodName;
        private final Attribute attribute;
        private final AttributeDeclaration overrideAttributeDeclaration;

        public InvalidOverrideAttributeMethod(String methodName, Pair<Attribute, AttributeDeclaration> attribute) {
            this.methodName = methodName;
            this.attribute = (Attribute)attribute.first();
            this.overrideAttributeDeclaration = (AttributeDeclaration)attribute.second();
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public AttributeDeclaration getOverrideAttributeDeclaration() {
            return this.overrideAttributeDeclaration;
        }
    }

    private static class RemoveOverrideFix
    implements HintFix {
        private final BaseDocument document;
        private final InvalidOverrideAttributeMethod invalidOverrideMethod;
        private final TokenSequence<PHPTokenId> ts;

        public RemoveOverrideFix(BaseDocument document, InvalidOverrideAttributeMethod invalidOverrideMethod, TokenSequence<PHPTokenId> ts) {
            this.document = document;
            this.invalidOverrideMethod = invalidOverrideMethod;
            this.ts = ts;
        }

        public String getDescription() {
            String methodName = this.invalidOverrideMethod.getMethodName();
            return Bundle.RemoveOverrideFix_description(methodName);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.document);
            OffsetRange removalRange = this.getRemovalRange(this.invalidOverrideMethod);
            if (removalRange != OffsetRange.NONE) {
                edits.replace(removalRange.getStart(), removalRange.getLength(), "", false, 0);
                edits.apply();
            }
        }

        private OffsetRange getRemovalRange(InvalidOverrideAttributeMethod invalidAttributedMethod) {
            Attribute attribute = invalidAttributedMethod.getAttribute();
            if (attribute.getAttributeDeclarations().size() == 1) {
                return this.getRemovalRange(attribute);
            }
            AttributeDeclaration overrideDeclaration = invalidAttributedMethod.getOverrideAttributeDeclaration();
            int startOffset = overrideDeclaration.getStartOffset();
            AttributeDeclaration previousDeclaration = null;
            Iterator<AttributeDeclaration> iterator = attribute.getAttributeDeclarations().iterator();
            while (iterator.hasNext()) {
                AttributeDeclaration attributeDeclaration = iterator.next();
                if (attributeDeclaration.getStartOffset() == startOffset) {
                    int endOffset;
                    if (!iterator.hasNext()) {
                        int commentEnd;
                        endOffset = attributeDeclaration.getEndOffset();
                        this.ts.move(startOffset);
                        if (previousDeclaration != null) {
                            startOffset = previousDeclaration.getEndOffset();
                        }
                        if (startOffset != (commentEnd = this.getPreviousCommentEnd(startOffset))) {
                            startOffset = commentEnd;
                            endOffset = this.getCommaEnd(endOffset, attribute);
                        }
                    } else {
                        endOffset = iterator.next().getStartOffset();
                        endOffset = this.getNextCommentStart(overrideDeclaration, endOffset);
                    }
                    return new OffsetRange(startOffset, endOffset);
                }
                previousDeclaration = attributeDeclaration;
            }
            return OffsetRange.NONE;
        }

        private int getNextCommentStart(AttributeDeclaration overrideDeclaration, int endOffset) {
            int end = endOffset;
            this.ts.move(overrideDeclaration.getEndOffset());
            while (this.ts.moveNext() && this.ts.offset() < endOffset) {
                if (AddOverrideAttributeHint.isComma((Token<PHPTokenId>)this.ts.token()) || AddOverrideAttributeHint.isWhitespace((Token<PHPTokenId>)this.ts.token())) continue;
                end = this.ts.offset();
                break;
            }
            return end;
        }

        private int getPreviousCommentEnd(int startOffset) {
            int start = startOffset;
            while (this.ts.movePrevious() && this.ts.offset() >= startOffset) {
                if (AddOverrideAttributeHint.isComma((Token<PHPTokenId>)this.ts.token()) || AddOverrideAttributeHint.isWhitespace((Token<PHPTokenId>)this.ts.token())) continue;
                start = this.ts.offset() + this.ts.token().length();
                if (!TokenUtilities.endsWith((CharSequence)this.ts.token().text(), (CharSequence)"\n")) break;
                --start;
                break;
            }
            return start;
        }

        private int getCommaEnd(int endOffset, Attribute attribute) {
            int end = endOffset;
            this.ts.move(end);
            while (this.ts.moveNext() && this.ts.offset() < attribute.getEndOffset()) {
                if (AddOverrideAttributeHint.isComma((Token<PHPTokenId>)this.ts.token())) {
                    end = this.ts.offset() + this.ts.token().length();
                    break;
                }
                if (AddOverrideAttributeHint.isWhitespace((Token<PHPTokenId>)this.ts.token())) continue;
            }
            return end;
        }

        private OffsetRange getRemovalRange(Attribute attribute) {
            int endOffset = attribute.getEndOffset();
            this.ts.move(endOffset);
            if (this.ts.moveNext() && AddOverrideAttributeHint.isWhitespace((Token<PHPTokenId>)this.ts.token())) {
                endOffset = this.ts.offset() + this.ts.token().text().length();
            }
            return new OffsetRange(attribute.getStartOffset(), endOffset);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

