/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.actions.PopupUtil;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ImportModulePanel
extends JPanel {
    private ParserResult info;
    private DefaultListModel model;
    private final int position;
    public JLabel ctrlLabel;
    public JLabel importPreviewLabel;
    public JLabel jLabel1;
    public JList jList1;
    public JPanel jPanel1;
    public JScrollPane jScrollPane1;
    public JSeparator jSeparator1;

    public ImportModulePanel(List<String> priviledged, List<String> denied, Font font, ParserResult info, int position) {
        this.info = info;
        this.position = position;
        this.createModel(priviledged, denied);
        this.initComponents();
        this.setBackground(this.jList1.getBackground());
        if (this.model.size() > 0) {
            int modelSize;
            this.jList1.setModel(this.model);
            this.setFocusable(false);
            this.setNextFocusableComponent(this.jList1);
            this.jScrollPane1.setBackground(this.jList1.getBackground());
            this.setBackground(this.jList1.getBackground());
            if (font != null) {
                this.jList1.setFont(font);
            }
            if ((modelSize = this.jList1.getModel().getSize()) > 0) {
                this.jList1.setSelectedIndex(0);
            }
            this.jList1.setVisibleRowCount(modelSize > 8 ? 8 : modelSize);
            this.jList1.setCellRenderer(new Renderer(this.jList1));
            this.jList1.grabFocus();
        } else {
            this.remove(this.jScrollPane1);
            JLabel nothingFoundJL = new JLabel(NbBundle.getMessage(ImportModulePanel.class, (String)"NoModsFound"));
            if (font != null) {
                nothingFoundJL.setFont(font);
            }
            nothingFoundJL.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
            nothingFoundJL.setEnabled(false);
            nothingFoundJL.setBackground(this.jList1.getBackground());
            this.add(nothingFoundJL);
        }
        this.setA11Y();
        this.updatePreview(null);
    }

    private void setA11Y() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportClassPanel_ACN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportClassPanel_ACSD"));
        this.jList1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportClassPanel_JList1_ACN"));
        this.jList1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportClassPanel_JList1_ACSD"));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.ctrlLabel = new JLabel();
        this.importPreviewLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setBorder(BorderFactory.createLineBorder(new Color(64, 64, 64)));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
        this.jList1.setSelectionMode(0);
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ImportModulePanel.this.listMouseReleased(evt);
            }
        });
        this.jList1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImportModulePanel.this.updatePreview(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ImportModulePanel.this.listKeyReleased(evt);
                ImportModulePanel.this.updatePreview(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setLabelFor(this.jList1);
        this.jLabel1.setText(NbBundle.getMessage(ImportModulePanel.class, (String)"ImportChoices"));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jLabel1.setOpaque(true);
        this.add((Component)this.jLabel1, "First");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.ctrlLabel.setText(NbBundle.getMessage(ImportModulePanel.class, (String)"LBL_PackageImport"));
        this.importPreviewLabel.setText(" ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ctrlLabel, -1, 390, Short.MAX_VALUE).addComponent(this.importPreviewLabel, -1, 390, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 390, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.ctrlLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importPreviewLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Last");
    }

    private void listMouseReleased(MouseEvent evt) {
        boolean packageImport = (evt.getModifiers() & 8) > 0;
        boolean useFqn = (evt.getModifiers() & 1) > 0;
        this.importModule(this.getSelected(), packageImport, useFqn);
    }

    private void listKeyReleased(KeyEvent evt) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(evt);
        if (ks.getKeyCode() == 10 || ks.getKeyCode() == 32) {
            boolean packageImport = (evt.getModifiers() & 8) > 0;
            boolean useFqn = (evt.getModifiers() & 1) > 0;
            this.importModule(this.getSelected(), packageImport, useFqn);
        }
    }

    private void updatePreview(KeyEvent evt) {
        Object selected = this.jList1.getSelectedValue();
        if (selected != null) {
            String preview = "<html><code><b>" + ((TypeDescription)selected).qualifiedName + "</b></code></html>";
            this.importPreviewLabel.setText(preview);
        }
    }

    public String getSelected() {
        TypeDescription typeDescription = (TypeDescription)this.jList1.getSelectedValue();
        return typeDescription == null ? null : typeDescription.qualifiedName;
    }

    private void createModel(List<String> priviledged, List<String> denied) {
        ArrayList<TypeDescription> l = new ArrayList<TypeDescription>(priviledged.size());
        for (String typeElement : priviledged) {
            l.add(new TypeDescription(typeElement, false));
        }
        for (String typeElement : denied) {
            l.add(new TypeDescription(typeElement, true));
        }
        Collections.sort(l);
        this.model = new DefaultListModel();
        for (TypeDescription td : l) {
            this.model.addElement(td);
        }
    }

    private void importModule(String importCode, boolean importInPreviousLine, boolean useFqn) {
        TokenSequence<PHPTokenId> ts;
        PopupUtil.hidePopup();
        int basePosition = importInPreviousLine ? this.position : -1;
        BaseDocument document = (BaseDocument)this.info.getSnapshot().getSource().getDocument(false);
        if (!importInPreviousLine && (ts = LexUtilities.getPHPTokenSequence((Document)document, this.position)) != null) {
            ts.move(this.position);
            while (ts.movePrevious()) {
                Token token = ts.token();
                if (!((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPENTAG)) continue;
                basePosition = ts.offset();
            }
        }
        if (basePosition != -1) {
            EditList edits = new EditList(document);
            try {
                int rowEnd = importInPreviousLine ? LineDocumentUtils.getLineStart((LineDocument)document, (int)this.position) : LineDocumentUtils.getLineEnd((LineDocument)document, (int)basePosition);
                importCode = importInPreviousLine ? importCode + "\n" : "\n" + importCode;
                edits.replace(rowEnd, 0, importCode, true, 0);
                edits.setFormatAll(true);
                edits.apply();
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static final int DARKER_COLOR_COMPONENT = 5;
        private Color denidedColor = new Color(128, 128, 128);
        private Color fgColor;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;

        public Renderer(JList list) {
            this.setFont(list.getFont());
            this.fgColor = list.getForeground();
            this.bgColor = list.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - 5), Math.abs(this.bgColor.getGreen() - 5), Math.abs(this.bgColor.getBlue() - 5));
            this.bgSelectionColor = list.getSelectionBackground();
            this.fgSelectionColor = list.getSelectionForeground();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            if (isSelected) {
                this.setForeground(this.fgSelectionColor);
                this.setBackground(this.bgSelectionColor);
            } else {
                this.setForeground(this.fgColor);
                this.setBackground(index % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (value instanceof TypeDescription) {
                TypeDescription td = (TypeDescription)value;
                this.setText(td.qualifiedName);
                if (td.isDenied) {
                    this.setForeground(this.denidedColor);
                }
                this.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/editor/resources/interface.png")));
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }

    private static class TypeDescription
    implements Comparable<TypeDescription> {
        private boolean isDenied;
        private final String qualifiedName;

        public TypeDescription(String typeElement, boolean isDenied) {
            this.isDenied = isDenied;
            this.qualifiedName = typeElement;
        }

        public int hashCode() {
            int hash = 7;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeDescription other = (TypeDescription)obj;
            if (this.isDenied != other.isDenied) {
                return false;
            }
            return !(this.qualifiedName == null ? other.qualifiedName != null : !this.qualifiedName.equals(other.qualifiedName));
        }

        @Override
        public int compareTo(TypeDescription o) {
            if (this.isDenied && !o.isDenied) {
                return 1;
            }
            if (!this.isDenied && o.isDenied) {
                return -1;
            }
            return this.qualifiedName.compareTo(o.qualifiedName);
        }
    }
}

