/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

public class ClassLoaderTable {
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.classfile.ClassLoaderTable") != null;
    private static int[] parentLoaderIds;

    public static int getParentLoader(int loader) {
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: getParent loader: " + loader);
        }
        if (loader >= parentLoaderIds.length) {
            return -1;
        }
        return parentLoaderIds[loader];
    }

    public static void addChildAndParent(int[] thisAndParentLoaderData) {
        int ofs = thisAndParentLoaderData[2];
        if (ofs == 0) {
            ClassLoaderTable.addChildAndParent(thisAndParentLoaderData[0], thisAndParentLoaderData[1]);
        } else {
            int loaderId = thisAndParentLoaderData[0];
            for (int i = 0; i < ofs; ++i) {
                ClassLoaderTable.addChildAndParent(loaderId, loaderId + 1);
                ++loaderId;
            }
            ClassLoaderTable.addChildAndParent(loaderId, thisAndParentLoaderData[1]);
        }
    }

    public static void initTable(int[] inParentLoaderIds) {
        int i;
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: init patent loader ids: " + inParentLoaderIds.length);
            for (i = 0; i < inParentLoaderIds.length; ++i) {
                System.err.println("ClassLoaderTable.DEBUG: inParentLoaderIds[" + i + "]=" + inParentLoaderIds[i]);
            }
        }
        parentLoaderIds = inParentLoaderIds;
        for (i = 0; i < parentLoaderIds.length; ++i) {
            if (parentLoaderIds[i] != -1) continue;
            ClassLoaderTable.parentLoaderIds[i] = 0;
        }
    }

    private static void addChildAndParent(int childLoader, int parentLoader) {
        int maxLoader;
        if (DEBUG) {
            System.err.println("ClassLoaderTable.DEBUG: add child and parent: child: " + childLoader + ", parent: " + parentLoader);
        }
        int n = maxLoader = childLoader > parentLoader ? childLoader : parentLoader;
        if (parentLoaderIds.length < maxLoader + 1) {
            int[] oldTable = parentLoaderIds;
            parentLoaderIds = new int[childLoader * 2 + 1];
            System.arraycopy(oldTable, 0, parentLoaderIds, 0, oldTable.length);
        }
        if (parentLoader == -1) {
            parentLoader = 0;
        }
        ClassLoaderTable.parentLoaderIds[childLoader] = parentLoader;
    }
}

