/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.json;

import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javascript2.json.spi.JsonOptionsQueryImplementation;
import org.openide.filesystems.FileObject;

public class GlobalJsonOptionsQueryImpl
implements JsonOptionsQueryImplementation {
    private static final Logger LOG = Logger.getLogger(GlobalJsonOptionsQueryImpl.class.getName());
    private static final String PROP_ALLOW_COMMENTS = "json.comments";
    private static final Pattern FILES;

    @Override
    @CheckForNull
    public JsonOptionsQueryImplementation.Result getOptions(FileObject file) {
        if (FILES != null && FILES.matcher(file.getNameExt()).matches()) {
            return new JsonOptionsResult(true);
        }
        return null;
    }

    static {
        Pattern p = null;
        String propVal = System.getProperty(PROP_ALLOW_COMMENTS);
        if (propVal != null) {
            try {
                p = Pattern.compile(propVal);
            }
            catch (PatternSyntaxException e) {
                LOG.log(Level.WARNING, "Cannot compile: {0}, error: {1}", new Object[]{propVal, e.getMessage()});
            }
        }
        FILES = p;
    }

    private static final class JsonOptionsResult
    implements JsonOptionsQueryImplementation.Result {
        private final boolean commentSupported;

        JsonOptionsResult(boolean commentSupported) {
            this.commentSupported = commentSupported;
        }

        @Override
        @CheckForNull
        public Boolean isCommentSupported() {
            return this.commentSupported;
        }

        @Override
        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        }
    }
}

