/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui.swing;

import java.awt.Dimension;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.MultilineLabelUI;
import org.openide.util.NbBundle;

final class MultilineLabel
extends JLabel {
    private final boolean isPopup;
    private int tallest = Integer.MIN_VALUE;
    private int knownWidth = -1;

    MultilineLabel() {
        this(false);
    }

    MultilineLabel(boolean isPopup) {
        this.isPopup = isPopup;
    }

    boolean isPopup() {
        return this.isPopup;
    }

    @Override
    public void updateUI() {
        this.setUI(new MultilineLabelUI());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (!this.isPopup && !this.isPreferredSizeSet()) {
            if (this.tallest < result.height) {
                this.tallest = result.height;
            }
            result.height = this.tallest;
        }
        return result;
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        if (!this.isPopup && w != this.knownWidth) {
            this.knownWidth = w;
            this.tallest = Integer.MIN_VALUE;
        }
        super.reshape(x, y, w, h);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.isPopup) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!this.isPopup) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    @Override
    public String getToolTipText() {
        String s = this.getText();
        if (s != null && !"".equals(s.trim())) {
            return MultilineLabel.htmlize(s);
        }
        return super.getToolTipText();
    }

    private static String htmlize(String s) {
        StringBuilder res = new StringBuilder("<html>");
        String[] words = s.split(" ");
        boolean newline = false;
        int ct = 0;
        for (String word : words) {
            boolean bl = newline = (ct += word.length()) > 80;
            if (newline) {
                res.append("<br>");
                ct = 0;
            }
            res.append(word);
            res.append(' ');
        }
        return res.toString();
    }

    ValidationUI createUI() {
        return new LblUI(this);
    }

    private static final class LblUI
    implements ValidationUI {
        private final WeakReference<JLabel> label;

        LblUI(JLabel lbl) {
            assert (lbl != null);
            this.label = new WeakReference<JLabel>(lbl);
        }

        @Override
        public void showProblem(Problem problem) {
            JLabel lbl = (JLabel)this.label.get();
            if (lbl != null) {
                if (problem == null) {
                    lbl.setText("   ");
                    lbl.setIcon(null);
                    lbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MultilineLabel.class, (String)"WARNING_LABEL"));
                    lbl.getAccessibleContext().setAccessibleDescription("");
                } else {
                    lbl.setText(problem.getMessage());
                    lbl.setIcon(problem.severity().icon());
                    lbl.setForeground(problem.severity().color());
                    lbl.getAccessibleContext().setAccessibleName(problem.severity().toString());
                    lbl.getAccessibleContext().setAccessibleDescription(problem.severity().describeError(problem.getMessage()));
                }
            }
        }

        @Override
        public void clearProblem() {
            this.showProblem(null);
        }
    }
}

