/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.launch;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.NbSourceProvider;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbLaunchDelegate;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbLaunchWithDebuggingDelegate;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbLaunchWithoutDebuggingDelegate;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbProcessConsole;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class NbLaunchRequestHandler {
    private NbLaunchDelegate activeLaunchHandler;
    private static final Pattern STACKTRACE_PATTERN = Pattern.compile("\\s+at\\s+(([\\w$]+\\.)*[\\w$]+)\\(([\\w-$]+\\.java:\\d+)\\)");

    public CompletableFuture<Void> launch(Map<String, Object> launchArguments, DebugAdapterContext context) {
        boolean isNative = "nativeimage".equals(launchArguments.get("type"));
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        boolean noDebug = (Boolean)launchArguments.getOrDefault("noDebug", Boolean.FALSE);
        Consumer<DebugAdapterContext> terminateHandle = daContext -> this.handleTerminatedEvent((DebugAdapterContext)daContext);
        this.activeLaunchHandler = noDebug ? new NbLaunchWithoutDebuggingDelegate(terminateHandle) : new NbLaunchWithDebuggingDelegate(terminateHandle);
        List modulePaths = launchArguments.getOrDefault("modulePaths", Collections.emptyList());
        List classPaths = launchArguments.getOrDefault("classPaths", Collections.emptyList());
        String filePath = (String)launchArguments.get("file");
        String projectFilePath = (String)launchArguments.get("projectFile");
        String mainFilePath = (String)launchArguments.get("mainClass");
        if (!isNative && (StringUtils.isBlank((CharSequence)mainFilePath) && StringUtils.isBlank((CharSequence)filePath) && StringUtils.isBlank((CharSequence)projectFilePath) || modulePaths.isEmpty() && classPaths.isEmpty())) {
            if (modulePaths.isEmpty() && classPaths.isEmpty()) {
                ErrorUtilities.completeExceptionally(resultFuture, "Failed to launch debuggee VM. Missing modulePaths/classPaths options in launch configuration.", ResponseErrorCode.ServerNotInitialized);
                return resultFuture;
            }
            if (StringUtils.isBlank((CharSequence)mainFilePath) && StringUtils.isBlank((CharSequence)filePath) && StringUtils.isBlank((CharSequence)projectFilePath)) {
                LspServerState state = (LspServerState)Lookup.getDefault().lookup(LspServerState.class);
                if (state == null) {
                    ErrorUtilities.completeExceptionally(resultFuture, "Failed to launch debuggee VM. Missing mainClass or modulePaths/classPaths options in launch configuration.", ResponseErrorCode.ServerNotInitialized);
                    return resultFuture;
                }
                return state.openedProjects().thenCompose(prjs -> {
                    FileObject[] sourceRoots = (FileObject[])Arrays.stream(prjs).flatMap(p -> Arrays.stream(ProjectUtils.getSources((Project)p).getSourceGroups("java"))).map(sg -> sg.getRootFolder()).toArray(FileObject[]::new);
                    ArrayList mainClasses = new ArrayList(SourceUtils.getMainClasses((FileObject[])sourceRoots));
                    CompletableFuture currentResult = new CompletableFuture();
                    Consumer<ElementHandle> handleSelectedMainClass = mainClass -> {
                        HashMap<String, Object> newLaunchArguments = new HashMap<String, Object>(launchArguments);
                        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((FileObject[])sourceRoots));
                        FileObject mainClassFile = SourceUtils.getFile((ElementHandle)mainClass, (ClasspathInfo)cpInfo);
                        if (mainClassFile == null) {
                            ErrorUtilities.completeExceptionally(currentResult, "Cannot find source file for the selected main class.", ResponseErrorCode.ServerNotInitialized);
                        } else {
                            newLaunchArguments.put("mainClass", mainClassFile.toURI().toString());
                            ((CompletableFuture)this.launch(newLaunchArguments, context).thenAccept(res -> currentResult.complete(res))).exceptionally(t -> {
                                currentResult.completeExceptionally((Throwable)t);
                                return null;
                            });
                        }
                    };
                    switch (mainClasses.size()) {
                        case 0: {
                            String message = "Failed to launch debuggee VM. No mainClass provided.";
                            if (SourceUtils.isScanInProgress()) {
                                message = message + " Indexing is in progress, please try again when the indexing is completed.";
                            }
                            ErrorUtilities.completeExceptionally(currentResult, message, ResponseErrorCode.ServerNotInitialized);
                            break;
                        }
                        case 1: {
                            handleSelectedMainClass.accept((ElementHandle)mainClasses.get(0));
                            break;
                        }
                        case 2: {
                            List mainClassItems = mainClasses.stream().map(eh -> new NotifyDescriptor.QuickPick.Item(eh.getQualifiedName(), eh.getQualifiedName())).collect(Collectors.toList());
                            NotifyDescriptor.QuickPick pick = new NotifyDescriptor.QuickPick("Please choose main class", "Choose main class", mainClassItems, false);
                            ((CompletableFuture)DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)pick).thenAccept(acceptedPick -> {
                                for (int i = 0; i < acceptedPick.getItems().size(); ++i) {
                                    NotifyDescriptor.QuickPick.Item item = (NotifyDescriptor.QuickPick.Item)acceptedPick.getItems().get(i);
                                    if (!item.isSelected()) continue;
                                    ElementHandle mainClass = (ElementHandle)mainClasses.get(i);
                                    handleSelectedMainClass.accept(mainClass);
                                    break;
                                }
                            })).exceptionally(t -> {
                                ErrorUtilities.completeExceptionally(currentResult, "Failed to launch debuggee VM. No mainClass provided.", ResponseErrorCode.ServerNotInitialized);
                                return null;
                            });
                        }
                    }
                    return currentResult;
                });
            }
        }
        if (StringUtils.isBlank((CharSequence)((String)launchArguments.get("encoding")))) {
            context.setDebuggeeEncoding(StandardCharsets.UTF_8);
        } else {
            if (!Charset.isSupported((String)launchArguments.get("encoding"))) {
                ErrorUtilities.completeExceptionally(resultFuture, "Failed to launch debuggee VM. 'encoding' options in the launch configuration is not recognized.", ResponseErrorCode.ServerNotInitialized);
                return resultFuture;
            }
            context.setDebuggeeEncoding(Charset.forName((String)launchArguments.get("encoding")));
        }
        if (!isNative) {
            List<String> vmArgList = NbLaunchDelegate.argsToStringList(launchArguments.get("vmArgs"));
            if (vmArgList.isEmpty()) {
                launchArguments.put("vmArgs", String.format("-Dfile.encoding=%s", context.getDebuggeeEncoding().name()));
            } else {
                vmArgList = new ArrayList<String>(vmArgList);
                vmArgList.add(String.format("-Dfile.encoding=%s", context.getDebuggeeEncoding().name()));
                launchArguments.put("vmArgs", vmArgList);
            }
        }
        context.setDebugMode(!noDebug);
        this.activeLaunchHandler.preLaunch(launchArguments, context);
        if (projectFilePath != null) {
            filePath = projectFilePath;
        }
        boolean preferProjActions = true;
        if (filePath == null || mainFilePath != null) {
            preferProjActions = false;
            filePath = mainFilePath;
        }
        FileObject file = null;
        File nativeImageFile = null;
        if (!isNative) {
            file = NbLaunchRequestHandler.getFileObject(filePath);
            if (file == null) {
                ErrorUtilities.completeExceptionally(resultFuture, "Missing file: " + filePath, ResponseErrorCode.ServerNotInitialized);
                return resultFuture;
            }
        } else {
            String nativeImage = (String)launchArguments.get("nativeImagePath");
            if (nativeImage == null) {
                ErrorUtilities.completeExceptionally(resultFuture, "Failed to launch debuggee native image. No native image is specified.", ResponseErrorCode.ServerNotInitialized);
                return resultFuture;
            }
            nativeImageFile = new File(nativeImage);
        }
        if (!isNative && !launchArguments.containsKey("sourcePaths")) {
            ClassPath sourceCP = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
            if (sourceCP != null) {
                FileObject[] roots = sourceCP.getRoots();
                String[] sourcePaths = new String[roots.length];
                for (int i = 0; i < roots.length; ++i) {
                    sourcePaths[i] = roots[i].getPath();
                }
                context.setSourcePaths(sourcePaths);
            }
        } else {
            context.setSourcePaths((String[])launchArguments.get("sourcePaths"));
        }
        String singleMethod = (String)launchArguments.get("methodName");
        boolean testRun = (Boolean)launchArguments.getOrDefault("testRun", Boolean.FALSE);
        ((CompletableFuture)this.activeLaunchHandler.nbLaunch(file, preferProjActions, nativeImageFile, singleMethod, launchArguments, context, !noDebug, testRun, new OutputListener(context)).thenRun(() -> {
            this.activeLaunchHandler.postLaunch(launchArguments, context);
            resultFuture.complete(null);
        })).exceptionally(e -> {
            resultFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return resultFuture;
    }

    private static FileObject getFileObject(String filePath) {
        File ioFile = null;
        if (filePath != null && !(ioFile = new File(filePath)).exists()) {
            try {
                URI uri = new URI(filePath);
                ioFile = Utilities.toFile((URI)uri);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return ioFile != null ? FileUtil.toFileObject(ioFile) : null;
    }

    private static OutputEventArguments convertToOutputEventArguments(String message, String category, DebugAdapterContext context) {
        Matcher matcher = STACKTRACE_PATTERN.matcher(message);
        if (matcher.find()) {
            String methodField = matcher.group(1);
            String locationField = matcher.group(matcher.groupCount());
            String fullyQualifiedName = methodField.substring(0, methodField.lastIndexOf("."));
            String packageName = fullyQualifiedName.lastIndexOf(".") > -1 ? fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf(".")) : "";
            String[] locations = locationField.split(":");
            String sourceName = locations[0];
            int lineNumber = Integer.parseInt(locations[1]);
            String sourcePath = StringUtils.isBlank((CharSequence)packageName) ? sourceName : packageName.replace('.', File.separatorChar) + File.separatorChar + sourceName;
            Source source = null;
            try {
                source = NbSourceProvider.convertDebuggerSourceToClient(fullyQualifiedName, sourceName, sourcePath, context);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            OutputEventArguments args = new OutputEventArguments();
            args.setCategory(category);
            args.setOutput(message);
            args.setSource(source);
            args.setLine(lineNumber);
            return args;
        }
        OutputEventArguments args = new OutputEventArguments();
        args.setCategory(category);
        args.setOutput(message);
        return args;
    }

    protected void handleTerminatedEvent(DebugAdapterContext context) {
        context.getClient().terminated(new TerminatedEventArguments());
    }

    private final class OutputListener
    implements Consumer<NbProcessConsole.ConsoleMessage> {
        private final DebugAdapterContext context;

        OutputListener(DebugAdapterContext context) {
            this.context = context;
        }

        @Override
        public void accept(NbProcessConsole.ConsoleMessage message) {
            if (message != null) {
                OutputEventArguments outputEvent = NbLaunchRequestHandler.convertToOutputEventArguments(message.output, message.category, this.context);
                this.context.getClient().output(outputEvent);
            }
        }
    }
}

