/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.Widget;

public class RoundedBorder3D
implements Border {
    private static final Color SHADOW_COLOR = new Color(208, 208, 208);
    private static final Color SELECTED_BORDER_COLOR = new Color(255, 153, 0);
    private Widget widget;
    private int radius;
    private int insetWidth;
    private int insetHeight;
    private Color drawColor;
    private int depth = 3;

    public RoundedBorder3D(Widget widget, int radius, int depth, int insetWidth, int insetHeight, Color drawColor) {
        this.widget = widget;
        this.radius = radius;
        this.depth = depth;
        this.insetWidth = insetWidth;
        this.insetHeight = insetHeight;
        this.drawColor = drawColor;
    }

    public Insets getInsets() {
        return new Insets(this.insetHeight, this.insetWidth, this.insetHeight + this.depth, this.insetWidth + this.depth);
    }

    public void paint(Graphics2D gr, Rectangle bounds) {
        Paint oldPaint = gr.getPaint();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double((float)bounds.x + 0.5f, (float)bounds.y + 0.5f, bounds.width - this.depth - 1, bounds.height - this.depth - 1, this.radius, this.radius);
        if (this.drawColor != null) {
            RoundRectangle2D.Double outerRect = new RoundRectangle2D.Double((float)(bounds.x + this.depth) + 0.5f, (float)(bounds.y + this.depth) + 0.5f, bounds.width - this.depth - 1, bounds.height - this.depth - 1, this.radius, this.radius);
            Area raisedArea = new Area(outerRect);
            raisedArea.subtract(new Area(rect));
            gr.setPaint(SHADOW_COLOR);
            gr.fill(raisedArea);
            gr.setPaint(this.widget.getState().isSelected() ? SELECTED_BORDER_COLOR : this.drawColor);
            Stroke s = gr.getStroke();
            if (this.widget.getState().isFocused()) {
                gr.setStroke(new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{2.0f, 2.0f}, 0.0f));
            }
            gr.draw(rect);
            gr.setStroke(s);
        }
        gr.setPaint(oldPaint);
    }

    public boolean isOpaque() {
        return true;
    }
}

