/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.rmi.ArrayType;
import com.sun.xml.rpc.processor.modeler.rmi.ClassType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import java.util.Hashtable;

public class RmiType
implements RmiConstants {
    private static final Hashtable typeHash = new Hashtable(231);
    private String typeSig;
    private int typeCode = 0;
    public static final RmiType tVoid = new RmiType(11, "V");
    public static final RmiType tBoolean = new RmiType(0, "Z");
    public static final RmiType tByte = new RmiType(1, "B");
    public static final RmiType tChar = new RmiType(2, "C");
    public static final RmiType tShort = new RmiType(3, "S");
    public static final RmiType tInt = new RmiType(4, "I");
    public static final RmiType tFloat = new RmiType(6, "F");
    public static final RmiType tLong = new RmiType(5, "J");
    public static final RmiType tDouble = new RmiType(7, "D");
    public static final RmiType tObject = RmiType.classType("java.lang.Object");
    public static final RmiType tClassDesc = RmiType.classType("java.lang.Class");
    public static final RmiType tString = RmiType.classType("java.lang.String");

    protected RmiType() {
    }

    protected RmiType(int typeCode, String typeSig) {
        this.typeCode = typeCode;
        this.typeSig = typeSig;
        typeHash.put(typeSig, this);
    }

    public final String getTypeSignature() {
        return this.typeSig;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public RmiType getElementType() {
        throw new UnsupportedOperationException();
    }

    public String getClassName() {
        throw new UnsupportedOperationException();
    }

    public int getArrayDimension() {
        return 0;
    }

    public Class getTypeClass(ClassLoader loader) throws ClassNotFoundException {
        if (this.typeSig.length() == 1) {
            return RmiUtils.getClassForName(this.typeString(false), loader);
        }
        String sig = RmiType.getTypeSigClassName(this.typeSig);
        return Class.forName(sig, true, loader);
    }

    private static String getTypeSigClassName(String typeSig) {
        String sig = typeSig;
        if (sig.charAt(0) == 'L') {
            sig = sig.substring(1, sig.length() - 1).replace('/', '.');
        }
        return sig;
    }

    public static RmiType classType(String className) {
        String sig = new String("L" + className + ";");
        RmiType t = (RmiType)typeHash.get(sig);
        if (t == null) {
            t = new ClassType(sig, className);
        }
        return t;
    }

    public static RmiType arrayType(RmiType elem) {
        String sig = new String("[" + elem.getTypeSignature());
        RmiType t = (RmiType)typeHash.get(sig);
        if (t == null) {
            t = new ArrayType(sig, elem);
        }
        return t;
    }

    public static RmiType getRmiType(Class classObj) {
        String sig = classObj.isArray() ? classObj.getName() : RmiUtils.getTypeSig(classObj.getName());
        return RmiType.getRmiType(sig);
    }

    public static RmiType getRmiType(String sig) {
        RmiType type = (RmiType)typeHash.get(sig);
        if (type != null) {
            return type;
        }
        switch (sig.charAt(0)) {
            case '[': {
                return RmiType.arrayType(RmiType.getRmiType(sig.substring(1)));
            }
            case 'L': {
                return RmiType.classType(sig.substring(1, sig.length() - 1).replace('/', '.'));
            }
        }
        return type;
    }

    public String typeString(boolean abbrev) {
        switch (this.typeCode) {
            case 11: {
                return "void";
            }
            case 0: {
                return "boolean";
            }
            case 1: {
                return "byte";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
        }
        return "unknown";
    }

    public boolean isNillable() {
        return false;
    }

    public String toString() {
        return this.typeString(false);
    }
}

