/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;

public final class FieldInfo {
    public final String name;
    public final int number;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private boolean storeTermVector;
    private boolean omitNorms;
    private final IndexOptions indexOptions;
    private boolean storePayloads;
    private final Map<String, String> attributes;
    private long dvGen;
    private int pointDimensionCount;
    private int pointIndexDimensionCount;
    private int pointNumBytes;
    private final int vectorDimension;
    private final VectorEncoding vectorEncoding;
    private final VectorSimilarityFunction vectorSimilarityFunction;
    private final boolean softDeletesField;
    private final boolean isParentField;

    public FieldInfo(String name, int number, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValues, long dvGen, Map<String, String> attributes, int pointDimensionCount, int pointIndexDimensionCount, int pointNumBytes, int vectorDimension, VectorEncoding vectorEncoding, VectorSimilarityFunction vectorSimilarityFunction, boolean softDeletesField, boolean isParentField) {
        this.name = Objects.requireNonNull(name);
        this.number = number;
        this.docValuesType = Objects.requireNonNull(docValues, "DocValuesType must not be null (field: \"" + name + "\")");
        this.indexOptions = Objects.requireNonNull(indexOptions, "IndexOptions must not be null (field: \"" + name + "\")");
        if (indexOptions != IndexOptions.NONE) {
            this.storeTermVector = storeTermVector;
            this.storePayloads = storePayloads;
            this.omitNorms = omitNorms;
        } else {
            this.storeTermVector = false;
            this.storePayloads = false;
            this.omitNorms = false;
        }
        this.dvGen = dvGen;
        this.attributes = Objects.requireNonNull(attributes);
        this.pointDimensionCount = pointDimensionCount;
        this.pointIndexDimensionCount = pointIndexDimensionCount;
        this.pointNumBytes = pointNumBytes;
        this.vectorDimension = vectorDimension;
        this.vectorEncoding = vectorEncoding;
        this.vectorSimilarityFunction = vectorSimilarityFunction;
        this.softDeletesField = softDeletesField;
        this.isParentField = isParentField;
        this.checkConsistency();
    }

    public void checkConsistency() {
        if (this.indexOptions == null) {
            throw new IllegalArgumentException("IndexOptions must not be null (field: '" + this.name + "')");
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0 && this.storePayloads) {
                throw new IllegalArgumentException("indexed field '" + this.name + "' cannot have payloads without positions");
            }
        } else {
            if (this.storeTermVector) {
                throw new IllegalArgumentException("non-indexed field '" + this.name + "' cannot store term vectors");
            }
            if (this.storePayloads) {
                throw new IllegalArgumentException("non-indexed field '" + this.name + "' cannot store payloads");
            }
            if (this.omitNorms) {
                throw new IllegalArgumentException("non-indexed field '" + this.name + "' cannot omit norms");
            }
        }
        if (this.docValuesType == null) {
            throw new IllegalArgumentException("DocValuesType must not be null (field: '" + this.name + "')");
        }
        if (this.dvGen != -1L && this.docValuesType == DocValuesType.NONE) {
            throw new IllegalArgumentException("field '" + this.name + "' cannot have a docvalues update generation without having docvalues");
        }
        if (this.pointDimensionCount < 0) {
            throw new IllegalArgumentException("pointDimensionCount must be >= 0; got " + this.pointDimensionCount + " (field: '" + this.name + "')");
        }
        if (this.pointIndexDimensionCount < 0) {
            throw new IllegalArgumentException("pointIndexDimensionCount must be >= 0; got " + this.pointIndexDimensionCount + " (field: '" + this.name + "')");
        }
        if (this.pointNumBytes < 0) {
            throw new IllegalArgumentException("pointNumBytes must be >= 0; got " + this.pointNumBytes + " (field: '" + this.name + "')");
        }
        if (this.pointDimensionCount != 0 && this.pointNumBytes == 0) {
            throw new IllegalArgumentException("pointNumBytes must be > 0 when pointDimensionCount=" + this.pointDimensionCount + " (field: '" + this.name + "')");
        }
        if (this.pointIndexDimensionCount != 0 && this.pointDimensionCount == 0) {
            throw new IllegalArgumentException("pointIndexDimensionCount must be 0 when pointDimensionCount=0 (field: '" + this.name + "')");
        }
        if (this.pointNumBytes != 0 && this.pointDimensionCount == 0) {
            throw new IllegalArgumentException("pointDimensionCount must be > 0 when pointNumBytes=" + this.pointNumBytes + " (field: '" + this.name + "')");
        }
        if (this.vectorSimilarityFunction == null) {
            throw new IllegalArgumentException("Vector similarity function must not be null (field: '" + this.name + "')");
        }
        if (this.vectorDimension < 0) {
            throw new IllegalArgumentException("vectorDimension must be >=0; got " + this.vectorDimension + " (field: '" + this.name + "')");
        }
        if (this.softDeletesField && this.isParentField) {
            throw new IllegalArgumentException("field can't be used as soft-deletes field and parent document field (field: '" + this.name + "')");
        }
    }

    void verifySameSchema(FieldInfo o, boolean strictlyConsistent) {
        String fieldName = this.name;
        FieldInfo.verifySameIndexOptions(fieldName, this.indexOptions, o.getIndexOptions(), strictlyConsistent);
        if (this.indexOptions != IndexOptions.NONE) {
            FieldInfo.verifySameOmitNorms(fieldName, this.omitNorms, o.omitNorms, strictlyConsistent);
            FieldInfo.verifySameStoreTermVectors(fieldName, this.storeTermVector, o.storeTermVector, strictlyConsistent);
        }
        FieldInfo.verifySameDocValuesType(fieldName, this.docValuesType, o.docValuesType, strictlyConsistent);
        FieldInfo.verifySamePointsOptions(fieldName, this.pointDimensionCount, this.pointIndexDimensionCount, this.pointNumBytes, o.pointDimensionCount, o.pointIndexDimensionCount, o.pointNumBytes, strictlyConsistent);
        FieldInfo.verifySameVectorOptions(fieldName, this.vectorDimension, this.vectorEncoding, this.vectorSimilarityFunction, o.vectorDimension, o.vectorEncoding, o.vectorSimilarityFunction);
    }

    static void verifySameIndexOptions(String fieldName, IndexOptions indexOptions1, IndexOptions indexOptions2, boolean strictlyConsistent) {
        if (!(strictlyConsistent || indexOptions1 != IndexOptions.NONE && indexOptions2 != IndexOptions.NONE)) {
            return;
        }
        if (indexOptions1 != indexOptions2) {
            throw new IllegalArgumentException("cannot change field \"" + fieldName + "\" from index options=" + indexOptions1 + " to inconsistent index options=" + indexOptions2);
        }
    }

    static void verifySameDocValuesType(String fieldName, DocValuesType docValuesType1, DocValuesType docValuesType2, boolean strictlyConsistent) {
        if (!(strictlyConsistent || docValuesType1 != DocValuesType.NONE && docValuesType2 != DocValuesType.NONE)) {
            return;
        }
        if (docValuesType1 != docValuesType2) {
            throw new IllegalArgumentException("cannot change field \"" + fieldName + "\" from doc values type=" + docValuesType1 + " to inconsistent doc values type=" + docValuesType2);
        }
    }

    static void verifySameStoreTermVectors(String fieldName, boolean storeTermVector1, boolean storeTermVector2, boolean strictlyConsistent) {
        if (strictlyConsistent && storeTermVector1 != storeTermVector2) {
            throw new IllegalArgumentException("cannot change field \"" + fieldName + "\" from storeTermVector=" + storeTermVector1 + " to inconsistent storeTermVector=" + storeTermVector2);
        }
    }

    static void verifySameOmitNorms(String fieldName, boolean omitNorms1, boolean omitNorms2, boolean strictlyConsistent) {
        if (strictlyConsistent && omitNorms1 != omitNorms2) {
            throw new IllegalArgumentException("cannot change field \"" + fieldName + "\" from omitNorms=" + omitNorms1 + " to inconsistent omitNorms=" + omitNorms2);
        }
    }

    static void verifySamePointsOptions(String fieldName, int pointDimensionCount1, int indexDimensionCount1, int numBytes1, int pointDimensionCount2, int indexDimensionCount2, int numBytes2, boolean strictlyConsistent) {
        if (!(strictlyConsistent || pointDimensionCount1 != 0 && pointDimensionCount2 != 0)) {
            return;
        }
        if (pointDimensionCount1 != pointDimensionCount2 || indexDimensionCount1 != indexDimensionCount2 || numBytes1 != numBytes2) {
            throw new IllegalArgumentException("cannot change field \"" + fieldName + "\" from points dimensionCount=" + pointDimensionCount1 + ", indexDimensionCount=" + indexDimensionCount1 + ", numBytes=" + numBytes1 + " to inconsistent dimensionCount=" + pointDimensionCount2 + ", indexDimensionCount=" + indexDimensionCount2 + ", numBytes=" + numBytes2);
        }
    }

    static void verifySameVectorOptions(String fieldName, int vd1, VectorEncoding ve1, VectorSimilarityFunction vsf1, int vd2, VectorEncoding ve2, VectorSimilarityFunction vsf2) {
        if (vd1 != vd2 || vsf1 != vsf2 || ve1 != ve2) {
            throw new IllegalArgumentException("cannot change field \"" + fieldName + "\" from vector dimension=" + vd1 + ", vector encoding=" + ve1 + ", vector similarity function=" + vsf1 + " to inconsistent vector dimension=" + vd2 + ", vector encoding=" + ve2 + ", vector similarity function=" + vsf2);
        }
    }

    FieldInfo handleLegacySupportedUpdates(FieldInfo otherFi) {
        IndexOptions newIndexOptions = this.indexOptions;
        boolean newStoreTermVector = this.storeTermVector;
        boolean newOmitNorms = this.omitNorms;
        boolean newStorePayloads = this.storePayloads;
        DocValuesType newDocValues = this.docValuesType;
        int newPointDimensionCount = this.pointDimensionCount;
        int newPointNumBytes = this.pointNumBytes;
        int newPointIndexDimensionCount = this.pointIndexDimensionCount;
        long newDvGen = this.dvGen;
        boolean fieldInfoChanges = false;
        if (this.indexOptions != otherFi.indexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                newIndexOptions = otherFi.indexOptions;
                fieldInfoChanges = true;
            } else if (otherFi.indexOptions != IndexOptions.NONE) {
                throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from index options=" + this.indexOptions + " to inconsistent index options=" + otherFi.indexOptions);
            }
        }
        if (this.pointDimensionCount != otherFi.pointDimensionCount && otherFi.pointDimensionCount != 0) {
            if (this.pointDimensionCount == 0) {
                fieldInfoChanges = true;
                newPointDimensionCount = otherFi.pointDimensionCount;
            } else {
                throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from points dimensionCount=" + this.pointDimensionCount + " to inconsistent dimensionCount=" + otherFi.pointDimensionCount);
            }
        }
        if (this.pointIndexDimensionCount != otherFi.pointIndexDimensionCount && otherFi.pointIndexDimensionCount != 0) {
            if (this.pointIndexDimensionCount == 0) {
                fieldInfoChanges = true;
                newPointIndexDimensionCount = otherFi.pointIndexDimensionCount;
            } else {
                throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from points indexDimensionCount=" + this.pointIndexDimensionCount + " to inconsistent indexDimensionCount=" + otherFi.pointIndexDimensionCount);
            }
        }
        if (this.pointNumBytes != otherFi.pointNumBytes && otherFi.pointNumBytes != 0) {
            if (this.pointNumBytes == 0) {
                fieldInfoChanges = true;
                newPointNumBytes = otherFi.pointNumBytes;
            } else {
                throw new IllegalArgumentException("cannot change field \"" + this.name + "\" from points numBytes=" + this.pointNumBytes + " to inconsistent numBytes=" + otherFi.pointNumBytes);
            }
        }
        if (newIndexOptions != IndexOptions.NONE) {
            if (this.storeTermVector != otherFi.storeTermVector && !this.storeTermVector) {
                fieldInfoChanges = true;
                newStoreTermVector = true;
            }
            if (this.storePayloads != otherFi.storePayloads && !this.storePayloads && newIndexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
                fieldInfoChanges = true;
                newStorePayloads = true;
            }
            if (otherFi.indexOptions != IndexOptions.NONE && this.omitNorms != otherFi.omitNorms && !this.omitNorms) {
                fieldInfoChanges = true;
                newOmitNorms = true;
            }
        }
        if (otherFi.docValuesType != DocValuesType.NONE && otherFi.docValuesType != this.docValuesType) {
            if (this.docValuesType == DocValuesType.NONE) {
                fieldInfoChanges = true;
                newDocValues = otherFi.docValuesType;
                newDvGen = otherFi.dvGen;
            } else {
                throw new IllegalArgumentException("cannot change DocValues type from " + this.docValuesType + " to " + otherFi.docValuesType + " for field \"" + this.name + "\"");
            }
        }
        if (!fieldInfoChanges) {
            return null;
        }
        return new FieldInfo(this.name, this.number, newStoreTermVector, newOmitNorms, newStorePayloads, newIndexOptions, newDocValues, newDvGen, this.attributes, newPointDimensionCount, newPointIndexDimensionCount, newPointNumBytes, this.vectorDimension, this.vectorEncoding, this.vectorSimilarityFunction, this.softDeletesField, this.isParentField);
    }

    public void setPointDimensions(int dimensionCount, int indexDimensionCount, int numBytes) {
        if (dimensionCount <= 0) {
            throw new IllegalArgumentException("point dimension count must be >= 0; got " + dimensionCount + " for field=\"" + this.name + "\"");
        }
        if (indexDimensionCount > 8) {
            throw new IllegalArgumentException("point index dimension count must be < PointValues.MAX_INDEX_DIMENSIONS (= 8); got " + indexDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (indexDimensionCount > dimensionCount) {
            throw new IllegalArgumentException("point index dimension count must be <= point dimension count (= " + dimensionCount + "); got " + indexDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (numBytes <= 0) {
            throw new IllegalArgumentException("point numBytes must be >= 0; got " + numBytes + " for field=\"" + this.name + "\"");
        }
        if (numBytes > 16) {
            throw new IllegalArgumentException("point numBytes must be <= PointValues.MAX_NUM_BYTES (= 16); got " + numBytes + " for field=\"" + this.name + "\"");
        }
        if (this.pointDimensionCount != 0 && this.pointDimensionCount != dimensionCount) {
            throw new IllegalArgumentException("cannot change point dimension count from " + this.pointDimensionCount + " to " + dimensionCount + " for field=\"" + this.name + "\"");
        }
        if (this.pointIndexDimensionCount != 0 && this.pointIndexDimensionCount != indexDimensionCount) {
            throw new IllegalArgumentException("cannot change point index dimension count from " + this.pointIndexDimensionCount + " to " + indexDimensionCount + " for field=\"" + this.name + "\"");
        }
        if (this.pointNumBytes != 0 && this.pointNumBytes != numBytes) {
            throw new IllegalArgumentException("cannot change point numBytes from " + this.pointNumBytes + " to " + numBytes + " for field=\"" + this.name + "\"");
        }
        this.pointDimensionCount = dimensionCount;
        this.pointIndexDimensionCount = indexDimensionCount;
        this.pointNumBytes = numBytes;
        this.checkConsistency();
    }

    public int getPointDimensionCount() {
        return this.pointDimensionCount;
    }

    public int getPointIndexDimensionCount() {
        return this.pointIndexDimensionCount;
    }

    public int getPointNumBytes() {
        return this.pointNumBytes;
    }

    public int getVectorDimension() {
        return this.vectorDimension;
    }

    public VectorEncoding getVectorEncoding() {
        return this.vectorEncoding;
    }

    public VectorSimilarityFunction getVectorSimilarityFunction() {
        return this.vectorSimilarityFunction;
    }

    public void setDocValuesType(DocValuesType type) {
        if (type == null) {
            throw new NullPointerException("DocValuesType must not be null (field: \"" + this.name + "\")");
        }
        if (this.docValuesType != DocValuesType.NONE && type != DocValuesType.NONE && this.docValuesType != type) {
            throw new IllegalArgumentException("cannot change DocValues type from " + this.docValuesType + " to " + type + " for field \"" + this.name + "\"");
        }
        this.docValuesType = type;
        this.checkConsistency();
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public String getName() {
        return this.name;
    }

    public int getFieldNumber() {
        return this.number;
    }

    public DocValuesType getDocValuesType() {
        return this.docValuesType;
    }

    void setDocValuesGen(long dvGen) {
        this.dvGen = dvGen;
        this.checkConsistency();
    }

    public long getDocValuesGen() {
        return this.dvGen;
    }

    void setStoreTermVectors() {
        this.storeTermVector = true;
        this.checkConsistency();
    }

    void setStorePayloads() {
        if (this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.storePayloads = true;
        }
        this.checkConsistency();
    }

    public boolean omitsNorms() {
        return this.omitNorms;
    }

    public void setOmitsNorms() {
        if (this.indexOptions == IndexOptions.NONE) {
            throw new IllegalStateException("cannot omit norms: this field is not indexed");
        }
        this.omitNorms = true;
        this.checkConsistency();
    }

    public boolean hasNorms() {
        return this.indexOptions != IndexOptions.NONE && !this.omitNorms;
    }

    public boolean hasPayloads() {
        return this.storePayloads;
    }

    public boolean hasVectors() {
        return this.storeTermVector;
    }

    public boolean hasVectorValues() {
        return this.vectorDimension > 0;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String putAttribute(String key, String value) {
        return this.attributes.put(key, value);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public boolean isSoftDeletesField() {
        return this.softDeletesField;
    }

    public boolean isParentField() {
        return this.isParentField;
    }
}

