/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.oauth.AuthorizationType;
import org.netbeans.modules.websvc.saas.model.oauth.DynamicUrlType;
import org.netbeans.modules.websvc.saas.model.oauth.FlowType;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.netbeans.modules.websvc.saas.model.oauth.MethodType;
import org.netbeans.modules.websvc.saas.model.oauth.ParamType;
import org.netbeans.modules.websvc.saas.model.oauth.SignatureMethodType;

public class OAuthHelper {
    private static final String OAUTH_LOGIN_COMMENT = "You need to call this method at the beginning to authorize the application to work with user data.\nThe method obtains the OAuth access token string, that is appended to each API request later.";
    private static final String OAUTH_INIT_COMMENT = "The method sets the OAuth parameters for webResource.\nThe method needs to be called after login() method, or when the webResource path is changed";
    private static final String OAUTH_INIT_WEB_COMMENT = "The method sets the OAuth parameters for webResource.";
    private static final String OAUTH_UNIQUE_COMMENT = "The method increases OAuth nonce and timestamp parameters to make each request unique.\nThe method should be called when repetitive requests are sent to service API provider:\n<pre>\n   client.initOauth();\n   client.getXXX(...);\n   client.makeOAuthRequestUnique();\n   client.getYYY(...);\n   client.makeOAuthRequestUnique();\n   client.getZZZ(...);\n</pre>";

    static ClassTree addOAuthMethods(String projectType, WorkingCopy copy, ClassTree originalClass, Metadata oauthMetadata, String className) {
        ModifiersTree publicStaticModif;
        ArrayList<VariableTree> paramList;
        ExpressionTree accessTokenReturnTree;
        ExpressionTree requestTokenReturnTree;
        MethodTree methodTree;
        ClassTree modifiedClass = originalClass;
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree privateModif = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ModifiersTree publicModif = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        EnumSet<Modifier> modifiersSet = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC);
        ModifiersTree privateStaticModif = maker.Modifiers(modifiersSet);
        modifiersSet.add(Modifier.FINAL);
        ModifiersTree privateStaticFinalModif = maker.Modifiers(modifiersSet);
        IdentifierTree stringType = maker.Identifier((CharSequence)"String");
        FlowType flow = oauthMetadata.getFlow();
        MethodType oauthRequestTokenMethod = flow.getRequestToken();
        MethodType oauthAccessTokenMethod = flow.getAccessToken();
        ExpressionTree uniformInterfaceEx = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        ExpressionTree iOEx = JavaSourceHelper.createTypeTree(copy, "java.io.IOException");
        String oauthBaseUrl = oauthMetadata.getBaseUrl();
        VariableTree fieldTree = maker.Variable(privateStaticFinalModif, (CharSequence)"OAUTH_BASE_URL", (Tree)stringType, (ExpressionTree)maker.Literal((Object)oauthBaseUrl));
        int lastFieldIndex = 3;
        modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
        fieldTree = maker.Variable(privateStaticFinalModif, (CharSequence)"CONSUMER_KEY", (Tree)stringType, (ExpressionTree)maker.Literal((Object)""));
        String comment = "Please, specify the consumer_key string obtained from service API pages";
        maker.addComment((Tree)fieldTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
        modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
        fieldTree = maker.Variable(privateStaticFinalModif, (CharSequence)"CONSUMER_SECRET", (Tree)stringType, (ExpressionTree)maker.Literal((Object)""));
        comment = "Please, specify the consumer_secret string obtained from service API pages";
        maker.addComment((Tree)fieldTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
        modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
        if (OAuthHelper.isCallback(oauthRequestTokenMethod)) {
            fieldTree = maker.Variable(privateStaticFinalModif, (CharSequence)"CALLBACK_PAGE_URL", (Tree)stringType, (ExpressionTree)maker.Literal((Object)""));
            comment = "Please, specify the full URL of your callback page (e.g. http://www.myapplication.org/OAuthCallback)";
            maker.addComment((Tree)fieldTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
            modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
        }
        ExpressionTree fieldTypeTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.oauth.signature.OAuthParameters");
        fieldTree = maker.Variable(privateModif, (CharSequence)"oauth_params", (Tree)fieldTypeTree, null);
        modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
        fieldTypeTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.oauth.signature.OAuthSecrets");
        fieldTree = maker.Variable(privateModif, (CharSequence)"oauth_secrets", (Tree)fieldTypeTree, null);
        modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
        fieldTypeTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.oauth.client.OAuthClientFilter");
        fieldTree = maker.Variable(privateModif, (CharSequence)"oauth_filter", (Tree)fieldTypeTree, null);
        modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
        if ("desktop".equals(projectType)) {
            fieldTree = maker.Variable(privateModif, (CharSequence)"oauth_access_token", (Tree)stringType, null);
            modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
            fieldTree = maker.Variable(privateModif, (CharSequence)"oauth_access_token_secret", (Tree)stringType, null);
            modifiedClass = maker.insertClassMember(modifiedClass, ++lastFieldIndex, (Tree)fieldTree);
        }
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        if ("desktop".equals(projectType)) {
            ArrayList<ExpressionTree> throwList = new ArrayList<ExpressionTree>();
            throwList.add(iOEx);
            throwList.add(uniformInterfaceEx);
            methodTree = maker.Method(publicModif, (CharSequence)"login", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), throwList, OAuthHelper.getLoginBody(oauthMetadata), null);
            comment = OAUTH_LOGIN_COMMENT;
            maker.addComment((Tree)methodTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            requestTokenReturnTree = OAuthHelper.getResponseType(copy, oauthRequestTokenMethod);
            methodTree = maker.Method(privateModif, (CharSequence)"getOAuthRequestToken", (Tree)requestTokenReturnTree, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(uniformInterfaceEx), OAuthHelper.getRequestTokenBody(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            accessTokenReturnTree = OAuthHelper.getResponseType(copy, oauthAccessTokenMethod);
            paramList = new ArrayList<VariableTree>();
            VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)"requestTokenResponse", (Tree)requestTokenReturnTree, null);
            paramList.add(paramTree);
            if (oauthAccessTokenMethod.isVerifier().booleanValue()) {
                paramTree = maker.Variable(paramModifier, (CharSequence)"oauth_verifier", (Tree)stringType, null);
                paramList.add(paramTree);
            }
            methodTree = maker.Method(privateModif, (CharSequence)"getOAuthAccessToken", (Tree)accessTokenReturnTree, Collections.emptyList(), paramList, Collections.singletonList(uniformInterfaceEx), OAuthHelper.getAccessTokenBody(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            methodTree = maker.Method(publicModif, (CharSequence)"initOAuth", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getInitOAuthBody(oauthMetadata), null);
            comment = OAUTH_INIT_COMMENT;
            maker.addComment((Tree)methodTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            if (OAuthHelper.isTimestamp(oauthMetadata) || OAuthHelper.isNonce(oauthMetadata)) {
                methodTree = maker.Method(publicModif, (CharSequence)"makeOAuthRequestUnique", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getBodyForUniqueRequest(oauthMetadata), null);
                comment = OAUTH_UNIQUE_COMMENT;
                maker.addComment((Tree)methodTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
                modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            }
            VariableTree var = maker.Variable(paramModifier, (CharSequence)"requestTokenResponse", (Tree)requestTokenReturnTree, null);
            methodTree = maker.Method(privateModif, (CharSequence)"authorizeConsumer", (Tree)(oauthAccessTokenMethod.isVerifier() != false ? maker.Identifier((CharSequence)"java.lang.String") : maker.Identifier((CharSequence)"void")), Collections.emptyList(), Collections.singletonList(var), Collections.singletonList(iOEx), OAuthHelper.getAuthorizeConsumerBody(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
        } else if ("web".equals(projectType)) {
            modifiersSet = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC);
            publicStaticModif = maker.Modifiers(modifiersSet);
            ExpressionTree requestTokenReturnTree2 = OAuthHelper.getResponseType(copy, oauthRequestTokenMethod);
            ArrayList<VariableTree> paramList2 = new ArrayList<VariableTree>();
            MethodTree methodTree2 = maker.Method(privateStaticModif, (CharSequence)"getOAuthRequestToken", (Tree)requestTokenReturnTree2, Collections.emptyList(), paramList2, Collections.singletonList(uniformInterfaceEx), OAuthHelper.getRequestTokenBodyWeb(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree2);
            ExpressionTree accessTokenReturnTree2 = OAuthHelper.getResponseType(copy, oauthAccessTokenMethod);
            ExpressionTree typeTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpSession");
            VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)"session", (Tree)typeTree, null);
            paramList2.add(paramTree);
            if (oauthAccessTokenMethod.isVerifier().booleanValue()) {
                paramTree = maker.Variable(paramModifier, (CharSequence)"oauth_verifier", (Tree)stringType, null);
                paramList2.add(paramTree);
            }
            methodTree2 = maker.Method(privateStaticModif, (CharSequence)"getOAuthAccessToken", (Tree)accessTokenReturnTree2, Collections.emptyList(), paramList2, Collections.singletonList(uniformInterfaceEx), OAuthHelper.getAccessTokenBodyWeb(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree2);
            paramList2 = new ArrayList();
            typeTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpServletRequest");
            paramTree = maker.Variable(paramModifier, (CharSequence)"request", (Tree)typeTree, null);
            paramList2.add(paramTree);
            typeTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpServletResponse");
            paramTree = maker.Variable(paramModifier, (CharSequence)"response", (Tree)typeTree, null);
            paramList2.add(paramTree);
            methodTree2 = maker.Method(publicModif, (CharSequence)"initOAuth", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), paramList2, Collections.singletonList(iOEx), OAuthHelper.getInitOAuthBodyWeb(oauthMetadata), null);
            comment = OAUTH_INIT_WEB_COMMENT;
            maker.addComment((Tree)methodTree2, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree2);
            if (OAuthHelper.isTimestamp(oauthMetadata) || OAuthHelper.isNonce(oauthMetadata)) {
                methodTree2 = maker.Method(publicModif, (CharSequence)"makeOAuthRequestUnique", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getBodyForUniqueRequest(oauthMetadata), null);
                comment = OAUTH_UNIQUE_COMMENT;
                maker.addComment((Tree)methodTree2, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
                modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree2);
            }
            typeTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpServletRequest");
            paramTree = maker.Variable(paramModifier, (CharSequence)"request", (Tree)typeTree, null);
            methodTree2 = maker.Method(publicStaticModif, (CharSequence)"logout", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.singletonList(paramTree), Collections.emptyList(), OAuthHelper.getLogoutBodyWeb(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree2);
        } else if ("nb-module".equals(projectType)) {
            modifiersSet = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC);
            publicStaticModif = maker.Modifiers(modifiersSet);
            methodTree = maker.Method(publicStaticModif, (CharSequence)"login", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(uniformInterfaceEx), OAuthHelper.getLoginBodyNb(oauthMetadata, className), null);
            comment = OAUTH_LOGIN_COMMENT;
            maker.addComment((Tree)methodTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            methodTree = maker.Method(publicStaticModif, (CharSequence)"logout", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getLogoutBodyNb(oauthMetadata, className), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            requestTokenReturnTree = OAuthHelper.getResponseType(copy, oauthRequestTokenMethod);
            methodTree = maker.Method(privateStaticModif, (CharSequence)"getOAuthRequestToken", (Tree)requestTokenReturnTree, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(uniformInterfaceEx), OAuthHelper.getRequestTokenBodyWeb(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            accessTokenReturnTree = OAuthHelper.getResponseType(copy, oauthRequestTokenMethod);
            paramList = new ArrayList();
            VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)"requestTokenResponse", (Tree)requestTokenReturnTree, null);
            paramList.add(paramTree);
            if (oauthAccessTokenMethod.isVerifier().booleanValue()) {
                paramTree = maker.Variable(paramModifier, (CharSequence)"oauth_verifier", (Tree)stringType, null);
                paramList.add(paramTree);
            }
            methodTree = maker.Method(privateStaticModif, (CharSequence)"getOAuthAccessToken", (Tree)accessTokenReturnTree, Collections.emptyList(), paramList, Collections.singletonList(uniformInterfaceEx), OAuthHelper.getAccessTokenBodyNb(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            methodTree = maker.Method(publicModif, (CharSequence)"initOAuth", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getInitOAuthBodyNb(oauthMetadata), null);
            comment = OAUTH_INIT_COMMENT;
            maker.addComment((Tree)methodTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            if (OAuthHelper.isTimestamp(oauthMetadata) || OAuthHelper.isNonce(oauthMetadata)) {
                methodTree = maker.Method(publicModif, (CharSequence)"makeOAuthRequestUnique", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), OAuthHelper.getBodyForUniqueRequest(oauthMetadata), null);
                comment = OAUTH_UNIQUE_COMMENT;
                maker.addComment((Tree)methodTree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)comment), true);
                modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            }
            paramTree = maker.Variable(paramModifier, (CharSequence)"requestTokenResponse", (Tree)requestTokenReturnTree, null);
            methodTree = maker.Method(privateStaticModif, (CharSequence)"authorizeConsumer", (Tree)maker.Identifier((CharSequence)"java.lang.String"), Collections.emptyList(), Collections.singletonList(paramTree), Collections.emptyList(), OAuthHelper.getAuthorizeConsumerBodyNb(oauthMetadata), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
        }
        if (OAuthHelper.needXPath(oauthRequestTokenMethod)) {
            String format = oauthRequestTokenMethod.getResponseStyle();
            ArrayList<VariableTree> paramList3 = new ArrayList<VariableTree>();
            VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)"response", (Tree)stringType, null);
            paramList3.add(paramTree);
            String paramName = "JSON".equals(format) ? "jsonPath" : "xPath";
            paramTree = maker.Variable(paramModifier, (CharSequence)paramName, (Tree)stringType, null);
            paramList3.add(paramTree);
            MethodTree methodTree3 = maker.Method(privateStaticModif, (CharSequence)("JSON".equals(format) ? "jsonSearch" : "xPathSearch"), (Tree)stringType, Collections.emptyList(), paramList3, Collections.emptyList(), OAuthHelper.getBodyForSearchMethod("JSON".equals(format) ? "JSON" : "XML"), null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree3);
        }
        return modifiedClass;
    }

    private static String getSignatureMethod(Metadata oauthMetadata, MethodType oauthMethod) {
        SignatureMethodType sigMethod;
        String signatureMethod = null;
        signatureMethod = oauthMethod == null ? oauthMetadata.getSignatureMethod().value() : ((sigMethod = oauthMethod.getSignatureMethod()) == null ? oauthMetadata.getSignatureMethod().value() : sigMethod.value());
        return "com.sun.jersey.oauth.signature." + signatureMethod + ".NAME";
    }

    private static String getVersion(Metadata oauthMetadata) {
        String version = oauthMetadata.getVersion();
        return version == null ? "1.0" : version;
    }

    private static String getVersion(MethodType oauthMethod) {
        String version = oauthMethod.getVersion();
        return version == null ? "1.0" : version;
    }

    private static boolean isNonce(Metadata oauthMetadata) {
        Boolean nounce = oauthMetadata.isNonce();
        return !Boolean.FALSE.equals(nounce);
    }

    private static boolean isNonce(MethodType oauthMethod) {
        Boolean nounce = oauthMethod.isNonce();
        return !Boolean.FALSE.equals(nounce);
    }

    private static boolean isTimestamp(Metadata oauthMetadata) {
        Boolean timestamp = oauthMetadata.isTimestamp();
        return !Boolean.FALSE.equals(timestamp);
    }

    private static boolean isTimestamp(MethodType oauthMethod) {
        Boolean timestamp = oauthMethod.isTimestamp();
        return !Boolean.FALSE.equals(timestamp);
    }

    private static boolean isCallback(MethodType oauthMethod) {
        Boolean callback = oauthMethod.isCallback();
        return Boolean.TRUE.equals(callback);
    }

    private static boolean isVerifier(MethodType oauthMethod) {
        Boolean verifier = oauthMethod.isVerifier();
        return Boolean.TRUE.equals(verifier);
    }

    private static String getRequestTokenBody(Metadata oauthMetadata) {
        MethodType oauthMethod = oauthMetadata.getFlow().getRequestToken();
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        String webResourceMethod = OAuthHelper.getWebResourceMethod(oauthMethod);
        bodyBuf.append("WebResource resource = client.resource(OAUTH_BASE_URL)." + webResourceMethod);
        bodyBuf.append("oauth_params = new OAuthParameters().consumerKey(CONSUMER_KEY)");
        bodyBuf.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(oauthMetadata, oauthMethod) + ")");
        bodyBuf.append(".version(\"" + OAuthHelper.getVersion(oauthMethod) + "\")");
        if (OAuthHelper.isNonce(oauthMethod)) {
            bodyBuf.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(oauthMethod)) {
            bodyBuf.append(".timestamp()");
        }
        if (OAuthHelper.isCallback(oauthMethod)) {
            bodyBuf.append(".callback(CALLBACK_PAGE_URL)");
        }
        bodyBuf.append(";");
        bodyBuf.append("oauth_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET);");
        bodyBuf.append("oauth_filter = new OAuthClientFilter(client.getProviders(), oauth_params, oauth_secrets);");
        bodyBuf.append("resource.addFilter(oauth_filter);");
        bodyBuf.append("return resource.get(" + OAuthHelper.getResponseClass(oauthMethod.getResponseStyle(), true) + ");");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getAccessTokenBody(Metadata oauthMetadata) {
        MethodType requestTokenMethod = oauthMetadata.getFlow().getRequestToken();
        MethodType accessTokenMethod = oauthMetadata.getFlow().getAccessToken();
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        String webResourceMethod = OAuthHelper.getWebResourceMethod(accessTokenMethod);
        bodyBuf.append("WebResource resource = client.resource(OAUTH_BASE_URL)." + webResourceMethod);
        bodyBuf.append("oauth_params.token(" + OAuthHelper.getParamFromResponse(oauthMetadata, requestTokenMethod.getResponseStyle(), "requestTokenResponse", "oauth_token") + ")");
        bodyBuf.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(oauthMetadata, accessTokenMethod) + ")");
        bodyBuf.append(".version(\"" + OAuthHelper.getVersion(accessTokenMethod) + "\")");
        if (OAuthHelper.isNonce(accessTokenMethod)) {
            bodyBuf.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(accessTokenMethod)) {
            bodyBuf.append(".timestamp()");
        }
        if (OAuthHelper.isCallback(requestTokenMethod)) {
            bodyBuf.append(".callback(null)");
        }
        if (OAuthHelper.isVerifier(accessTokenMethod)) {
            bodyBuf.append(".verifier(oauth_verifier)");
        }
        bodyBuf.append(";");
        bodyBuf.append("oauth_secrets.tokenSecret(" + OAuthHelper.getParamFromResponse(oauthMetadata, requestTokenMethod.getResponseStyle(), "requestTokenResponse", "oauth_token_secret") + ");");
        bodyBuf.append("resource.addFilter(oauth_filter);");
        bodyBuf.append("return resource.get(" + OAuthHelper.getResponseClass(accessTokenMethod.getResponseStyle(), true) + ");");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getInitOAuthBody(Metadata oauthMetadata) {
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("oauth_params = new OAuthParameters().consumerKey(CONSUMER_KEY).token(oauth_access_token)");
        bodyBuf.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(oauthMetadata, null) + ")");
        bodyBuf.append(".version(\"" + OAuthHelper.getVersion(oauthMetadata) + "\")");
        if (OAuthHelper.isNonce(oauthMetadata)) {
            bodyBuf.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(oauthMetadata)) {
            bodyBuf.append(".timestamp()");
        }
        bodyBuf.append(";");
        bodyBuf.append("oauth_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret(oauth_access_token_secret);");
        bodyBuf.append("oauth_filter = new OAuthClientFilter(client.getProviders(), oauth_params, oauth_secrets);");
        bodyBuf.append("webResource.addFilter(oauth_filter);");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getAuthorizeConsumerBody(Metadata oauthMetadata) {
        MethodType accessTokenMethod = oauthMetadata.getFlow().getAccessToken();
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("try {");
        bodyBuf.append("java.awt.Desktop.getDesktop().browse(new java.net.URI(" + OAuthHelper.getAuthorizationUrl(oauthMetadata) + "));");
        bodyBuf.append("} catch (java.net.URISyntaxException ex) {");
        bodyBuf.append("ex.printStackTrace();");
        bodyBuf.append("}");
        if (accessTokenMethod.isVerifier().booleanValue()) {
            bodyBuf.append("java.io.BufferedReader br = null;");
            bodyBuf.append("String oauth_verifier = null;");
            bodyBuf.append("try {");
            bodyBuf.append("br = new java.io.BufferedReader(new java.io.InputStreamReader(System.in));");
            bodyBuf.append("System.out.print(\"Type oauth_verifier string (taken from callback page url):\");");
            bodyBuf.append("oauth_verifier=br.readLine();");
            bodyBuf.append("} finally { br.close(); }");
            bodyBuf.append("return oauth_verifier;");
        } else {
            bodyBuf.append("System.out.print(\"After you authorize the application press <Enter>:\");System.in.read();");
        }
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getLoginBody(Metadata oauthMetadata) {
        MethodType requestTokenMethod = oauthMetadata.getFlow().getRequestToken();
        MethodType accessTokenMethod = oauthMetadata.getFlow().getAccessToken();
        String verifierPrefix = accessTokenMethod.isVerifier() != false ? "String oauth_verifier = " : "";
        String verifierPostfix = accessTokenMethod.isVerifier() != false ? ", oauth_verifier" : "";
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append(OAuthHelper.getResponseClass(requestTokenMethod.getResponseStyle(), false) + " requestTokenResponse = getOAuthRequestToken();");
        bodyBuf.append(verifierPrefix + "authorizeConsumer(requestTokenResponse);");
        bodyBuf.append(OAuthHelper.getResponseClass(accessTokenMethod.getResponseStyle(), false) + " accessTokenResponse = getOAuthAccessToken(requestTokenResponse" + verifierPostfix + ");");
        bodyBuf.append("oauth_access_token_secret = " + OAuthHelper.getParamFromResponse(oauthMetadata, accessTokenMethod.getResponseStyle(), "accessTokenResponse", "oauth_token_secret") + ";");
        bodyBuf.append("oauth_access_token  = " + OAuthHelper.getParamFromResponse(oauthMetadata, accessTokenMethod.getResponseStyle(), "accessTokenResponse", "oauth_token") + ";");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getWebResourceMethod(MethodType method) {
        String requestStyle = method.getRequestStyle();
        String webResourceMethod = null;
        if ("PATH".equals(requestStyle)) {
            webResourceMethod = "path(\"" + method.getMethodName() + "\")";
        } else if ("HEADER".equals(requestStyle)) {
            String paramName = method.getRequestParam();
            if (paramName == null) {
                paramName = "method";
            }
            webResourceMethod = "header(\"" + paramName + "\",\"" + method.getMethodName() + "\")";
        } else {
            String paramName = method.getRequestParam();
            if (paramName == null) {
                paramName = "method";
            }
            webResourceMethod = "queryParam(\"" + paramName + "\",\"" + method.getMethodName() + "\")";
        }
        return webResourceMethod;
    }

    private static String getResponseClass(String responseStyle, boolean extension) {
        String responseClass = "String";
        if ("FORM".equals(responseStyle)) {
            responseClass = "Form";
        }
        return extension ? responseClass + ".class" : responseClass;
    }

    private static String getAuthorizationUrl(Metadata oauthMetadata) {
        AuthorizationType auth = oauthMetadata.getFlow().getAuthorization();
        if (auth.getFixedUrl() != null) {
            StringBuffer buf = new StringBuffer(auth.getFixedUrl().getUrl());
            List params = auth.getParam();
            if (params.size() > 0) {
                buf.append("?");
            }
            int i = 0;
            for (ParamType p : auth.getParam()) {
                if (i++ > 0) {
                    buf.append("+\"&");
                }
                String paramName = p.getParamName();
                String oauthName = p.getOauthName();
                if (paramName == null) {
                    paramName = oauthName;
                }
                String paramValue = OAuthHelper.getParamFromResponse(oauthMetadata, oauthMetadata.getFlow().getRequestToken().getResponseStyle(), "requestTokenResponse", oauthName);
                buf.append(paramName + "=\"+" + paramValue);
            }
            return "\"" + buf.toString() + (params.size() == 0 ? "\"" : "");
        }
        DynamicUrlType dynamicUrl = auth.getDynamicUrl();
        return OAuthHelper.getParamFromResponse(oauthMetadata, oauthMetadata.getFlow().getRequestToken().getResponseStyle(), "requestTokenResponse", dynamicUrl.getAuthParamName());
    }

    private static String getParamFromResponse(Metadata oauthMetadata, String responseStyle, String responseFieldName, String oauthName) {
        String xPath;
        if ("FORM".equals(responseStyle)) {
            return responseFieldName + ".getFirst(\"" + oauthName + "\")";
        }
        if ("XML".equals(responseStyle)) {
            String xPath2 = OAuthHelper.getXPathForParam(oauthMetadata, oauthName);
            if (xPath2 != null) {
                return "xPathSearch(" + responseFieldName + ",\"" + xPath2 + "\")";
            }
        } else if ("JSON".equals(responseStyle) && (xPath = OAuthHelper.getXPathForParam(oauthMetadata, oauthName)) != null) {
            return "jsonSearch(" + responseFieldName + ",\"" + xPath + "\")";
        }
        return "";
    }

    private static ExpressionTree getResponseType(WorkingCopy copy, MethodType method) {
        String responseStyle = method.getResponseStyle();
        if ("FORM".equals(responseStyle)) {
            return JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.representation.Form");
        }
        return copy.getTreeMaker().Identifier((CharSequence)"java.lang.String");
    }

    private static String getRequestTokenBodyWeb(Metadata oauthMetadata) {
        MethodType oauthMethod = oauthMetadata.getFlow().getRequestToken();
        String webResourceMethod = OAuthHelper.getWebResourceMethod(oauthMethod);
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("Client reqTokenClient = new Client();");
        bodyBuf.append("WebResource resource = reqTokenClient.resource(OAUTH_BASE_URL)." + webResourceMethod);
        bodyBuf.append("OAuthParameters o_params = new OAuthParameters().consumerKey(CONSUMER_KEY)");
        bodyBuf.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(oauthMetadata, oauthMethod) + ")");
        bodyBuf.append(".version(\"" + OAuthHelper.getVersion(oauthMethod) + "\")");
        if (OAuthHelper.isNonce(oauthMethod)) {
            bodyBuf.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(oauthMethod)) {
            bodyBuf.append(".timestamp()");
        }
        if (OAuthHelper.isCallback(oauthMethod)) {
            bodyBuf.append(".callback(CALLBACK_PAGE_URL)");
        }
        bodyBuf.append(";");
        bodyBuf.append("OAuthSecrets o_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET);");
        bodyBuf.append("OAuthClientFilter o_filter = new OAuthClientFilter(reqTokenClient.getProviders(), o_params, o_secrets);");
        bodyBuf.append("resource.addFilter(o_filter);");
        bodyBuf.append("return resource.get(" + OAuthHelper.getResponseClass(oauthMethod.getResponseStyle(), true) + ");");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getAccessTokenBodyWeb(Metadata oauthMetadata) {
        MethodType accessTokenMethod = oauthMetadata.getFlow().getAccessToken();
        String webResourceMethod = OAuthHelper.getWebResourceMethod(accessTokenMethod);
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("Client accessTokenClient = new Client();");
        bodyBuf.append("WebResource resource = accessTokenClient.resource(OAUTH_BASE_URL)." + webResourceMethod);
        bodyBuf.append("OAuthParameters o_params = new OAuthParameters().consumerKey(CONSUMER_KEY)");
        bodyBuf.append(".token((String)session.getAttribute(\"oauth_token\"))");
        bodyBuf.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(oauthMetadata, accessTokenMethod) + ")");
        bodyBuf.append(".version(\"" + OAuthHelper.getVersion(accessTokenMethod) + "\")");
        if (OAuthHelper.isNonce(accessTokenMethod)) {
            bodyBuf.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(accessTokenMethod)) {
            bodyBuf.append(".timestamp()");
        }
        if (OAuthHelper.isVerifier(accessTokenMethod)) {
            bodyBuf.append(".verifier(oauth_verifier)");
        }
        bodyBuf.append(";");
        bodyBuf.append("OAuthSecrets o_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret((String)session.getAttribute(\"oauth_token_secret\"));");
        bodyBuf.append("OAuthClientFilter o_filter = new OAuthClientFilter(accessTokenClient.getProviders(), o_params, o_secrets);");
        bodyBuf.append("resource.addFilter(o_filter);");
        bodyBuf.append("return resource.get(" + OAuthHelper.getResponseClass(accessTokenMethod.getResponseStyle(), true) + ");");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getAccessTokenBodyNb(Metadata oauthMetadata) {
        MethodType requestTokenMethod = oauthMetadata.getFlow().getRequestToken();
        MethodType accessTokenMethod = oauthMetadata.getFlow().getAccessToken();
        String webResourceMethod = OAuthHelper.getWebResourceMethod(accessTokenMethod);
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("Client accessTokenClient = new Client();");
        bodyBuf.append("WebResource resource = accessTokenClient.resource(OAUTH_BASE_URL)." + webResourceMethod);
        bodyBuf.append("OAuthParameters o_params = new OAuthParameters().consumerKey(CONSUMER_KEY)");
        bodyBuf.append(".token(" + OAuthHelper.getParamFromResponse(oauthMetadata, requestTokenMethod.getResponseStyle(), "requestTokenResponse", "oauth_token") + ")");
        bodyBuf.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(oauthMetadata, accessTokenMethod) + ")");
        bodyBuf.append(".version(\"" + OAuthHelper.getVersion(accessTokenMethod) + "\")");
        if (OAuthHelper.isNonce(accessTokenMethod)) {
            bodyBuf.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(accessTokenMethod)) {
            bodyBuf.append(".timestamp()");
        }
        if (OAuthHelper.isVerifier(accessTokenMethod)) {
            bodyBuf.append(".verifier(oauth_verifier)");
        }
        bodyBuf.append(";");
        bodyBuf.append("OAuthSecrets o_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret(" + OAuthHelper.getParamFromResponse(oauthMetadata, requestTokenMethod.getResponseStyle(), "requestTokenResponse", "oauth_token_secret") + ");");
        bodyBuf.append("OAuthClientFilter o_filter = new OAuthClientFilter(accessTokenClient.getProviders(), o_params, o_secrets);");
        bodyBuf.append("resource.addFilter(o_filter);");
        bodyBuf.append("return resource.get(" + OAuthHelper.getResponseClass(accessTokenMethod.getResponseStyle(), true) + ");");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getInitOAuthBodyWeb(Metadata oauthMetadata) {
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("HttpSession session = request.getSession();");
        bodyBuf.append("if ((String)session.getAttribute(\"oauth_token\") == null) {");
        bodyBuf.append("    response.sendRedirect(request.getContextPath() + \"/OAuthLogin\");");
        bodyBuf.append("} else {");
        bodyBuf.append("oauth_params = new OAuthParameters().consumerKey(CONSUMER_KEY).token((String)session.getAttribute(\"oauth_token\"))");
        bodyBuf.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(oauthMetadata, null) + ")");
        bodyBuf.append(".version(\"" + OAuthHelper.getVersion(oauthMetadata) + "\")");
        if (OAuthHelper.isNonce(oauthMetadata)) {
            bodyBuf.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(oauthMetadata)) {
            bodyBuf.append(".timestamp()");
        }
        bodyBuf.append(";");
        bodyBuf.append("oauth_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret((String)session.getAttribute(\"oauth_token_secret\"));");
        bodyBuf.append("oauth_filter = new OAuthClientFilter(client.getProviders(), oauth_params, oauth_secrets);");
        bodyBuf.append("webResource.addFilter(oauth_filter);");
        bodyBuf.append("}");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getInitOAuthBodyNb(Metadata oauthMetadata) {
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("java.util.prefs.Preferences prefs = org.openide.util.NbPreferences.forModule(this.getClass());");
        bodyBuf.append("String oauth_token = prefs.get(\"oauth_token\", null);");
        bodyBuf.append("String oauth_token_secret = prefs.get(\"oauth_token_secret\", null);");
        bodyBuf.append("if (oauth_token == null || oauth_token_secret == null) {");
        bodyBuf.append("    org.openide.DialogDisplayer.getDefault().notify(new org.openide.NotifyDescriptor.Message(\"You have to call the login() method first to authorize the application to access user data.\"));");
        bodyBuf.append("} else {");
        bodyBuf.append("oauth_params = new OAuthParameters().consumerKey(CONSUMER_KEY).token(oauth_token)");
        bodyBuf.append(".signatureMethod(" + OAuthHelper.getSignatureMethod(oauthMetadata, null) + ")");
        bodyBuf.append(".version(\"" + OAuthHelper.getVersion(oauthMetadata) + "\")");
        if (OAuthHelper.isNonce(oauthMetadata)) {
            bodyBuf.append(".nonce()");
        }
        if (OAuthHelper.isTimestamp(oauthMetadata)) {
            bodyBuf.append(".timestamp()");
        }
        bodyBuf.append(";");
        bodyBuf.append("oauth_secrets = new OAuthSecrets().consumerSecret(CONSUMER_SECRET).tokenSecret(oauth_token_secret);");
        bodyBuf.append("oauth_filter = new OAuthClientFilter(client.getProviders(), oauth_params, oauth_secrets);");
        bodyBuf.append("webResource.addFilter(oauth_filter);");
        bodyBuf.append("}");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getBodyForUniqueRequest(Metadata oauthMetadata) {
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("if (oauth_params != null) {");
        if (OAuthHelper.isNonce(oauthMetadata)) {
            bodyBuf.append("oauth_params.nonce()");
            if (OAuthHelper.isTimestamp(oauthMetadata)) {
                bodyBuf.append(".timestamp();");
            }
        } else if (OAuthHelper.isTimestamp(oauthMetadata)) {
            bodyBuf.append("oauth_params.timestamp();");
        }
        bodyBuf.append("}");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getLoginBodyNb(Metadata oauthMetadata, String className) {
        MethodType requestTokenMethod = oauthMetadata.getFlow().getRequestToken();
        MethodType accessTokenMethod = oauthMetadata.getFlow().getAccessToken();
        String verifierPrefix = accessTokenMethod.isVerifier() != false ? "String oauth_verifier = " : "";
        String verifierPostfix = accessTokenMethod.isVerifier() != false ? ", oauth_verifier" : "";
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append(OAuthHelper.getResponseClass(requestTokenMethod.getResponseStyle(), false) + " requestTokenResponse = getOAuthRequestToken();");
        bodyBuf.append(verifierPrefix + "authorizeConsumer(requestTokenResponse);");
        bodyBuf.append(OAuthHelper.getResponseClass(accessTokenMethod.getResponseStyle(), false) + " accessTokenResponse = getOAuthAccessToken(requestTokenResponse" + verifierPostfix + ");");
        bodyBuf.append("java.util.prefs.Preferences prefs = org.openide.util.NbPreferences.forModule(" + className + ".class);");
        bodyBuf.append("prefs.put(\"oauth_token\", " + OAuthHelper.getParamFromResponse(oauthMetadata, accessTokenMethod.getResponseStyle(), "accessTokenResponse", "oauth_token") + ");");
        bodyBuf.append("prefs.put(\"oauth_token_secret\", " + OAuthHelper.getParamFromResponse(oauthMetadata, accessTokenMethod.getResponseStyle(), "accessTokenResponse", "oauth_token_secret") + ");");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getLogoutBodyWeb(Metadata oauthMetadata) {
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("HttpSession session = request.getSession();");
        bodyBuf.append("session.removeAttribute(\"oauth_token\");");
        bodyBuf.append("session.removeAttribute(\"oauth_token_secret\");");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getLogoutBodyNb(Metadata oauthMetadata, String className) {
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append("java.util.prefs.Preferences prefs = org.openide.util.NbPreferences.forModule(" + className + ".class);");
        bodyBuf.append("prefs.remove(\"oauth_token\");");
        bodyBuf.append("prefs.remove(\"oauth_token_secret\");");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    private static String getAuthorizeConsumerBodyNb(Metadata oauthMetadata) {
        String dialogPanel = Wadl2JavaHelper.getMethodBody("Templates/SaaSServices/OAuthAuthorizationPanelNb.java");
        StringBuffer bodyBuf = new StringBuffer();
        bodyBuf.append("{");
        bodyBuf.append(dialogPanel);
        bodyBuf.append("String oauth_verifier = null;");
        bodyBuf.append("String loginUrl = " + OAuthHelper.getAuthorizationUrl(oauthMetadata) + ";");
        bodyBuf.append("DialogPanel dialogPanel = new DialogPanel(loginUrl);");
        bodyBuf.append("org.openide.DialogDescriptor dd = new org.openide.DialogDescriptor(dialogPanel, \"OAuth Authentication Dialog\");");
        bodyBuf.append("org.openide.DialogDisplayer.getDefault().notify(dd);");
        bodyBuf.append("if (dd.getValue() == org.openide.DialogDescriptor.OK_OPTION) {");
        bodyBuf.append("    oauth_verifier = dialogPanel.getVerifier();");
        bodyBuf.append("}");
        bodyBuf.append("return oauth_verifier;");
        bodyBuf.append("}");
        return bodyBuf.toString();
    }

    static ClassTree addOAuthServlets(WorkingCopy copy, ClassTree originalClass, Metadata oauthMetadata, String clientClassName, boolean annotateServlet) {
        ClassTree modifiedClass = originalClass;
        TreeMaker maker = copy.getTreeMaker();
        TypeElement servletAn = copy.getElements().getTypeElement("javax.servlet.annotation.WebServlet");
        EnumSet<Modifier> classModifs = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC);
        ModifiersTree classModifiers = maker.Modifiers(classModifs);
        String className = "OAuthLoginServlet";
        if (annotateServlet && servletAn != null) {
            ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
            attrs.add(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"name"), (ExpressionTree)maker.Literal((Object)className)));
            attrs.add(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"urlPatterns"), (ExpressionTree)maker.Literal((Object)"/OAuthLogin")));
            AnnotationTree servletAnnotation = maker.Annotation((Tree)maker.QualIdent((Element)servletAn), attrs);
            classModifiers = maker.addModifiersAnnotation(classModifiers, servletAnnotation);
        }
        ExpressionTree extendsTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpServlet");
        ClassTree innerClass = maker.Class(classModifiers, (CharSequence)className, Collections.emptyList(), (Tree)extendsTree, Collections.emptyList(), Collections.emptyList());
        ModifiersTree methodModifiers = maker.Modifiers(Collections.singleton(Modifier.PROTECTED));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        ExpressionTree typeTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpServletRequest");
        VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)"request", (Tree)typeTree, null);
        paramList.add(paramTree);
        typeTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpServletResponse");
        paramTree = maker.Variable(paramModifier, (CharSequence)"response", (Tree)typeTree, null);
        paramList.add(paramTree);
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        ExpressionTree servletEx = JavaSourceHelper.createTypeTree(copy, "javax.servlet.ServletException");
        ExpressionTree ioEx = JavaSourceHelper.createTypeTree(copy, "java.io.IOException");
        throwsList.add(servletEx);
        throwsList.add(ioEx);
        MethodTree methodTree = maker.Method(methodModifiers, (CharSequence)"doGet", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), paramList, throwsList, OAuthHelper.getOAuthLoginBody(oauthMetadata), null);
        ClassTree modifiedInnerClass = maker.addClassMember(innerClass, (Tree)methodTree);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)modifiedInnerClass);
        classModifiers = maker.Modifiers(classModifs);
        className = "OAuthCallbackServlet";
        if (annotateServlet && servletAn != null) {
            ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
            attrs.add(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"name"), (ExpressionTree)maker.Literal((Object)className)));
            attrs.add(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"urlPatterns"), (ExpressionTree)maker.Literal((Object)"/OAuthCallback")));
            AnnotationTree servletAnnotation = maker.Annotation((Tree)maker.QualIdent((Element)servletAn), attrs);
            classModifiers = maker.addModifiersAnnotation(classModifiers, servletAnnotation);
        }
        innerClass = maker.Class(classModifiers, (CharSequence)className, Collections.emptyList(), (Tree)extendsTree, Collections.emptyList(), Collections.emptyList());
        methodTree = maker.Method(methodModifiers, (CharSequence)"doGet", (Tree)maker.Identifier((CharSequence)"void"), Collections.emptyList(), paramList, throwsList, OAuthHelper.getOAuthCallbackBody(oauthMetadata, clientClassName), null);
        modifiedInnerClass = maker.addClassMember(innerClass, (Tree)methodTree);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)modifiedInnerClass);
        return modifiedClass;
    }

    private static String getOAuthLoginBody(Metadata oauthMetadata) {
        String responseStyle = oauthMetadata.getFlow().getRequestToken().getResponseStyle();
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append("response.setContentType(\"text/html;charset=UTF-8\");");
        buf.append("java.io.PrintWriter out = response.getWriter();");
        buf.append("try {");
        buf.append(OAuthHelper.getResponseClass(responseStyle, false) + " requestTokenResponse = null;");
        buf.append("UniformInterfaceException uiEx = null;");
        buf.append("try {");
        buf.append("    requestTokenResponse = getOAuthRequestToken();");
        buf.append("    javax.servlet.http.HttpSession session = request.getSession(true);");
        buf.append("    session.setAttribute(\"oauth_token\", " + OAuthHelper.getParamFromResponse(oauthMetadata, responseStyle, "requestTokenResponse", "oauth_token") + ");");
        buf.append("    session.setAttribute(\"oauth_token_secret\", " + OAuthHelper.getParamFromResponse(oauthMetadata, responseStyle, "requestTokenResponse", "oauth_token_secret") + ");");
        buf.append("} catch (UniformInterfaceException ex) ");
        buf.append("    uiEx = ex;");
        buf.append("}");
        buf.append("out.println(\"<html>\");");
        buf.append("out.println(\"<head>\");");
        buf.append("out.println(\"<title>OAuth Login Servlet</title>\");");
        buf.append("out.println(\"</head>\");");
        buf.append("out.println(\"<body>\");");
        buf.append("out.println(\"<h1>OAuth Login Servlet at \" + request.getContextPath() + \"</h1>\");");
        buf.append("if (uiEx == null) {");
        buf.append("out.println(\"<a href='\"+" + OAuthHelper.getAuthorizationUrl(oauthMetadata) + "+\"'>");
        buf.append("Click at this link to authorize the application to access your data</a>\");");
        buf.append("} else {");
        buf.append("out.println(\"Problem to get request token: \"+uiEx.getResponse()+\": \"+uiEx.getResponse().getEntity(String.class));");
        buf.append("}");
        buf.append("out.println(\"</body>\");");
        buf.append("out.println(\"</html>\");");
        buf.append("} finally {");
        buf.append("    out.close();");
        buf.append("}");
        buf.append("}");
        return buf.toString();
    }

    private static String getOAuthCallbackBody(Metadata oauthMetadata, String clientClassName) {
        String responseStyle = oauthMetadata.getFlow().getAccessToken().getResponseStyle();
        boolean isVerifier = OAuthHelper.isVerifier(oauthMetadata.getFlow().getAccessToken());
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append("response.setContentType(\"text/html;charset=UTF-8\");");
        buf.append("java.io.PrintWriter out = response.getWriter();");
        buf.append("try {");
        if (isVerifier) {
            buf.append("String oauth_verifier = request.getParameter(\"oauth_verifier\");");
        }
        buf.append(OAuthHelper.getResponseClass(responseStyle, false) + " accessTokenResponse = null;");
        buf.append("UniformInterfaceException uiEx = null;");
        buf.append("try {");
        buf.append("    javax.servlet.http.HttpSession session = request.getSession(true);");
        buf.append("    accessTokenResponse = getOAuthAccessToken(session" + (isVerifier ? ", oauth_verifier" : "") + ");");
        buf.append("    session.setAttribute(\"oauth_token\", " + OAuthHelper.getParamFromResponse(oauthMetadata, responseStyle, "accessTokenResponse", "oauth_token") + ");");
        buf.append("    session.setAttribute(\"oauth_token_secret\", " + OAuthHelper.getParamFromResponse(oauthMetadata, responseStyle, "accessTokenResponse", "oauth_token_secret") + ");");
        buf.append("} catch (UniformInterfaceException ex) {");
        buf.append("    uiEx = ex;");
        buf.append("}");
        buf.append("out.println(\"<html>\");");
        buf.append("out.println(\"<head>\");");
        buf.append("out.println(\"<title>OAuth Callback Servlet</title>\");");
        buf.append("out.println(\"</head>\");");
        buf.append("out.println(\"<body>\");");
        buf.append("out.println(\"<h1>OAuth Callback Servlet at \" + request.getContextPath() + \"</h1>\");");
        buf.append("if (uiEx == null) {");
        buf.append("    out.println(\"Now, you have successfully authorized this application to access your data.<br><br>\");");
        buf.append("    out.println(\"Usage: <p><pre>\");");
        buf.append("    out.println(\"   " + clientClassName + " client = new " + clientClassName + "(...);\");");
        buf.append("    out.println(\"   client.initOAuth(httpServletRequest, httpServletResponse);\");");
        buf.append("    out.println(\"   // call any method\");");
        buf.append("    out.println(\"   client.close();\");");
        buf.append("    out.println(\"</pre></p>\");");
        buf.append("} else {");
        buf.append("    out.println(\"Problem to get access token: \"+uiEx.getResponse()+\": \"+uiEx.getResponse().getEntity(String.class));");
        buf.append("}");
        buf.append("out.println(\"</body>\");");
        buf.append("out.println(\"</html>\");");
        buf.append("} finally {");
        buf.append("    out.close();");
        buf.append("}");
        buf.append("}");
        return buf.toString();
    }

    private static boolean needXPath(MethodType method) {
        return !"FORM".equals(method.getResponseStyle());
    }

    private static String getXPathForParam(Metadata oauthMetadata, String oathParamName) {
        for (ParamType p : oauthMetadata.getParam()) {
            if (!oathParamName.equals(p.getOauthName())) continue;
            return p.getXpath();
        }
        return null;
    }

    private static String getBodyForSearchMethod(String format) {
        return Wadl2JavaHelper.getMethodBody("Templates/SaaSServices/OAuthSearch" + format + ".method");
    }
}

