/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.model.CaseElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TraitedScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.ClassConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.LazyBuild;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TraitScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassInstanceCreationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.util.Union2;

class ClassScopeImpl
extends TypeScopeImpl
implements ClassScope,
VariableNameFactory {
    private final Collection<QualifiedName> possibleFQSuperClassNames;
    private final Collection<QualifiedName> mixinClassNames = new LinkedHashSet<QualifiedName>();
    private final Collection<QualifiedName> usedTraits = new HashSet<QualifiedName>();
    private final Set<? super TypeScope> superRecursionDetection = new HashSet<TypeScope>();
    private final Set<? super TypeScope> subRecursionDetection = new HashSet<TypeScope>();
    private final Union2<String, List<ClassScopeImpl>> superClass;
    private final boolean isAttributeClass;

    @Override
    void addElement(ModelElementImpl element) {
        assert (element instanceof TypeScope || element instanceof VariableName || element instanceof MethodScope || element instanceof FieldElement || element instanceof CaseElement || element instanceof ClassConstantElement) : element.getPhpElementKind();
        if (element instanceof TypeScope) {
            Scope inScope = this.getInScope();
            if (inScope instanceof ScopeImpl) {
                ((ScopeImpl)inScope).addElement(element);
            }
        } else {
            super.addElement(element);
        }
    }

    ClassScopeImpl(Scope inScope, ClassDeclarationInfo nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, isDeprecated);
        Expression superId = nodeInfo.getSuperClass();
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(inScope);
        this.isAttributeClass = this.isAttributeClass(nodeInfo, namespaceScope);
        if (superId != null) {
            QualifiedName superClassName = QualifiedName.create(superId);
            this.possibleFQSuperClassNames = namespaceScope == null ? Collections.emptyList() : VariousUtils.getPossibleFQN(superClassName, nodeInfo.getSuperClass().getStartOffset(), namespaceScope);
            this.superClass = superClassName != null ? Union2.createFirst((Object)superClassName.toString()) : Union2.createFirst(null);
        } else {
            this.possibleFQSuperClassNames = Collections.emptyList();
            this.superClass = Union2.createFirst(null);
        }
        for (QualifiedName usedTrait : nodeInfo.getUsedTraits()) {
            if (usedTrait.getName().isEmpty()) continue;
            this.usedTraits.add(VariousUtils.getFullyQualifiedName(usedTrait, ((ClassDeclaration)nodeInfo.getOriginalNode()).getStartOffset(), inScope));
        }
    }

    ClassScopeImpl(Scope inScope, ClassInstanceCreationInfo nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, isDeprecated);
        Expression superId = nodeInfo.getSuperClass();
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(inScope);
        this.isAttributeClass = false;
        if (superId != null) {
            QualifiedName superClassName = QualifiedName.create(superId);
            this.possibleFQSuperClassNames = namespaceScope == null ? Collections.emptyList() : VariousUtils.getPossibleFQN(superClassName, nodeInfo.getSuperClass().getStartOffset(), namespaceScope);
            this.superClass = superClassName != null ? Union2.createFirst((Object)superClassName.toString()) : Union2.createFirst(null);
        } else {
            this.possibleFQSuperClassNames = Collections.emptyList();
            this.superClass = Union2.createFirst(null);
        }
        for (QualifiedName usedTrait : nodeInfo.getUsedTraits()) {
            QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(usedTrait, ((ClassInstanceCreation)nodeInfo.getOriginalNode()).getStartOffset(), inScope);
            if (fullyQualifiedName.getName().isEmpty()) continue;
            this.usedTraits.add(fullyQualifiedName);
        }
    }

    ClassScopeImpl(IndexScope inScope, ClassElement indexedClass) {
        super((Scope)inScope, indexedClass);
        QualifiedName superClassName = indexedClass.getSuperClassName();
        this.superClass = Union2.createFirst((Object)(superClassName != null ? superClassName.toString() : null));
        this.possibleFQSuperClassNames = indexedClass.getPossibleFQSuperClassNames();
        this.usedTraits.addAll(indexedClass.getUsedTraits());
        this.mixinClassNames.addAll(indexedClass.getFQMixinClassNames());
        this.isAttributeClass = indexedClass.isAttribute();
    }

    private boolean isAttributeClass(ClassDeclarationInfo nodeInfo, NamespaceScope namespaceScope) {
        int offset;
        String className = nodeInfo.getName();
        if (this.isPredefinedAttribute(className, offset = ((ClassDeclaration)nodeInfo.getOriginalNode()).getStartOffset(), namespaceScope)) {
            return true;
        }
        for (Attribute attribute : nodeInfo.getAttributes()) {
            for (AttributeDeclaration attributeDeclaration : attribute.getAttributeDeclarations()) {
                Expression attributeNameExpression = attributeDeclaration.getAttributeName();
                String attributeName = CodeUtils.extractQualifiedName(attributeNameExpression);
                if (!this.isAttributeAttribute(attributeName, attributeNameExpression.getStartOffset(), namespaceScope)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAttributeAttribute(String attributeName, int offset, NamespaceScope namespaceScope) {
        if (PredefinedSymbols.Attributes.ATTRIBUTE.getFqName().equals(attributeName)) {
            return true;
        }
        return PredefinedSymbols.Attributes.ATTRIBUTE.getName().equals(attributeName) && this.isPredefinedAttribute(attributeName, offset, namespaceScope);
    }

    private boolean isPredefinedAttribute(String attributeName, int offset, NamespaceScope namespaceScope) {
        QualifiedName fullyQualifiedName;
        if (PredefinedSymbols.ATTRIBUTE_FQ_NAMES.contains(attributeName)) {
            return true;
        }
        return PredefinedSymbols.ATTRIBUTE_NAMES.contains(attributeName) && namespaceScope != null && PredefinedSymbols.ATTRIBUTE_FQ_NAMES.contains((fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(attributeName), offset, namespaceScope)).toString());
    }

    @Override
    public Collection<QualifiedName> getPossibleFQSuperClassNames() {
        return Collections.unmodifiableCollection(this.possibleFQSuperClassNames);
    }

    synchronized void addFQMixinClassNames(Collection<QualifiedName> names) {
        this.mixinClassNames.addAll(names);
    }

    @Override
    public synchronized Collection<QualifiedName> getFQMixinClassNames() {
        return Collections.unmodifiableCollection(this.mixinClassNames);
    }

    @Override
    @NonNull
    public Collection<? extends ClassScope> getSuperClasses() {
        List retval = null;
        if (this.superClass.hasSecond() && this.superClass.second() != null) {
            return (Collection)this.superClass.second();
        }
        assert (this.superClass.hasFirst());
        String superClasName = (String)this.superClass.first();
        if (this.possibleFQSuperClassNames != null && !this.possibleFQSuperClassNames.isEmpty()) {
            retval = new ArrayList();
            for (QualifiedName qualifiedName : this.possibleFQSuperClassNames) {
                retval.addAll(IndexScopeImpl.getClasses(qualifiedName, this));
            }
        }
        if (retval == null && superClasName != null) {
            return IndexScopeImpl.getClasses(QualifiedName.create(superClasName), this);
        }
        return retval != null ? retval : Collections.emptyList();
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
                this.printAsSuperTypes(retval);
                break;
            }
            case SuperTypes: {
                this.printAsSuperTypes(retval);
                break;
            }
            default: {
                assert (false) : as;
                break;
            }
        }
        return retval.toString();
    }

    private void printAsSuperTypes(StringBuilder sb) {
        Set<QualifiedName> superIfaces;
        QualifiedName superClassName = this.getSuperClassName();
        if (superClassName != null) {
            sb.append(" extends  ");
            sb.append(superClassName.getName());
        }
        if (!(superIfaces = this.getSuperInterfaces()).isEmpty()) {
            sb.append(" implements ");
        }
        StringBuilder ifacesBuffer = new StringBuilder();
        for (QualifiedName qualifiedName : superIfaces) {
            if (ifacesBuffer.length() > 0) {
                ifacesBuffer.append(", ");
            }
            ifacesBuffer.append(qualifiedName.getName());
        }
        sb.append((CharSequence)ifacesBuffer);
    }

    @Override
    public Collection<? extends FieldElement> getDeclaredFields() {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScopeImpl = ModelUtils.getIndexScope(this);
            return indexScopeImpl.findFields((ClassScope)this, new int[0]);
        }
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.FIELD);
            }
        });
    }

    @Override
    public Collection<? extends FieldElement> getFields() {
        HashSet<FieldElement> allFields = new HashSet<FieldElement>();
        allFields.addAll(this.getDeclaredFields());
        allFields.addAll(this.getInheritedFields());
        return allFields;
    }

    @Override
    public Collection<? extends MethodScope> getInheritedMethods() {
        TypeElement type;
        HashSet<MethodScopeImpl> allMethods = new HashSet<MethodScopeImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        HashSet<? extends ClassScope> superClasses = new HashSet<ClassScope>(this.getSuperClasses());
        for (ClassScope classScope : superClasses) {
            Set<MethodElement> indexedFunctions = ElementFilter.forPrivateModifiers(false).filter(index.getAllMethods(classScope));
            for (MethodElement methodElement : indexedFunctions) {
                MethodElement indexedFunction = methodElement;
                TypeElement type2 = indexedFunction.getType();
                if (type2.isInterface()) {
                    allMethods.add(new MethodScopeImpl((Scope)new InterfaceScopeImpl(indexScope, (InterfaceElement)type2), indexedFunction));
                    continue;
                }
                if (type2.isTrait()) {
                    allMethods.add(new MethodScopeImpl((Scope)new TraitScopeImpl((Scope)indexScope, (TraitElement)type2), indexedFunction));
                    continue;
                }
                allMethods.add(new MethodScopeImpl((Scope)new ClassScopeImpl(indexScope, (ClassElement)type2), indexedFunction));
            }
        }
        HashSet interfaceScopes = new HashSet(this.getSuperInterfaceScopes());
        for (InterfaceScope iface : interfaceScopes) {
            Set<MethodElement> set = ElementFilter.forPrivateModifiers(false).filter(index.getAllMethods(iface));
            for (MethodElement classMember : set) {
                MethodElement indexedFunction = classMember;
                type = indexedFunction.getType();
                if (type.isInterface()) {
                    allMethods.add(new MethodScopeImpl((Scope)new InterfaceScopeImpl(indexScope, (InterfaceElement)type), indexedFunction));
                    continue;
                }
                allMethods.add(new MethodScopeImpl((Scope)new ClassScopeImpl(indexScope, (ClassElement)type), indexedFunction));
            }
        }
        HashSet<? extends TraitScope> hashSet = new HashSet<TraitScope>(this.getTraits());
        for (TraitScope traitScope : hashSet) {
            Set<MethodElement> set = index.getAllMethods(traitScope);
            for (MethodElement methodElement : set) {
                type = methodElement.getType();
                if (type.isTrait()) {
                    allMethods.add(new MethodScopeImpl((Scope)new TraitScopeImpl((Scope)indexScope, (TraitElement)type), methodElement));
                    continue;
                }
                allMethods.add(new MethodScopeImpl((Scope)new ClassScopeImpl(indexScope, (ClassElement)type), methodElement));
            }
        }
        return allMethods;
    }

    @Override
    public Collection<? extends FieldElement> getInheritedFields() {
        Set<org.netbeans.modules.php.editor.api.elements.FieldElement> indexedFields;
        HashSet<FieldElementImpl> allFields = new HashSet<FieldElementImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        ElementFilter filterForPrivate = ElementFilter.forPrivateModifiers(false);
        HashSet<? extends ClassScope> superClasses = new HashSet<ClassScope>(this.getSuperClasses());
        for (ClassScope classScope : superClasses) {
            indexedFields = filterForPrivate.filter(index.getAlllFields(classScope));
            for (org.netbeans.modules.php.editor.api.elements.FieldElement field : indexedFields) {
                allFields.add(new FieldElementImpl(classScope, field));
            }
        }
        for (TraitScope traitScope : new HashSet<TraitScope>(this.getTraits())) {
            indexedFields = index.getAlllFields(traitScope);
            for (org.netbeans.modules.php.editor.api.elements.FieldElement field : indexedFields) {
                allFields.add(new FieldElementImpl(traitScope, field));
            }
        }
        Set<TypeMemberElement> mixinTypeMembers = index.getAccessibleMixinTypeMembers(this, this);
        for (TypeMemberElement mixinTypeMember : mixinTypeMembers) {
            if (!(mixinTypeMember instanceof org.netbeans.modules.php.editor.api.elements.FieldElement)) continue;
            allFields.add(new FieldElementImpl(this, (org.netbeans.modules.php.editor.api.elements.FieldElement)mixinTypeMember));
        }
        return allFields;
    }

    @Override
    public final Collection<? extends ClassConstantElement> getInheritedConstants() {
        HashSet<ClassConstantElementImpl> allConstants = new HashSet<ClassConstantElementImpl>();
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        ElementQuery.Index index = indexScope.getIndex();
        ElementFilter filterForPrivate = ElementFilter.forPrivateModifiers(false);
        HashSet<? extends ClassScope> superClasses = new HashSet<ClassScope>(this.getSuperClasses());
        for (ClassScope classScope : superClasses) {
            Set<TypeConstantElement> indexedConstants = filterForPrivate.filter(index.getAllTypeConstants(classScope));
            Iterator<TypeConstantElement> iterator = indexedConstants.iterator();
            while (iterator.hasNext()) {
                TypeConstantElement typeConstantElement;
                TypeConstantElement constant = typeConstantElement = iterator.next();
                TypeElement type = constant.getType();
                TraitedScope inScope = classScope;
                if (type instanceof TraitElement) {
                    inScope = new TraitScopeImpl((Scope)indexScope, (TraitElement)type);
                }
                allConstants.add(new ClassConstantElementImpl((Scope)((Object)inScope), constant));
            }
        }
        HashSet interfaceScopes = new HashSet();
        interfaceScopes.addAll(this.getSuperInterfaceScopes());
        for (InterfaceScope iface : interfaceScopes) {
            Set<TypeConstantElement> set = filterForPrivate.filter(index.getInheritedTypeConstants(iface));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TypeConstantElement classMember2;
                TypeConstantElement constant = classMember2 = (TypeConstantElement)iterator.next();
                allConstants.add(new ClassConstantElementImpl(iface, constant));
            }
        }
        HashSet<? extends TraitScope> hashSet = new HashSet<TraitScope>(this.getTraits());
        for (TraitScope traitScope : hashSet) {
            Set<TypeConstantElement> set = index.getAllTypeConstants(traitScope);
            for (TypeConstantElement constant : set) {
                allConstants.add(new ClassConstantElementImpl(traitScope, constant));
            }
        }
        return allConstants;
    }

    @Override
    public Collection<? extends MethodScope> getMethods() {
        HashSet<MethodScope> allMethods = new HashSet<MethodScope>();
        allMethods.addAll(this.getDeclaredMethods());
        allMethods.addAll(this.getInheritedMethods());
        return allMethods;
    }

    @Override
    public String getNormalizedName() {
        return super.getNormalizedName() + (this.getSuperClassName() != null ? this.getSuperClassName() : "");
    }

    @Override
    @CheckForNull
    public QualifiedName getSuperClassName() {
        if (this.superClass != null) {
            ClassScope cls;
            List retval;
            List list = retval = this.superClass.hasSecond() ? (List)this.superClass.second() : null;
            if (retval == null) {
                assert (this.superClass.hasFirst());
                String superClasName = (String)this.superClass.first();
                if (superClasName != null) {
                    return QualifiedName.create(superClasName);
                }
            } else if (!retval.isEmpty() && (cls = (ClassScope)ModelUtils.getFirst(retval)) != null) {
                return QualifiedName.create(cls.getName());
            }
        }
        return null;
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
        String namespaceName;
        String name;
        indexDocument.addPair("clz", this.getIndexSignature(), true, true);
        if (this.isAttributeClass) {
            indexDocument.addPair("attribute.clz", this.getIndexSignature(), true, true);
        }
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName superClassName = this.getSuperClassName();
        if (superClassName != null) {
            String name2 = superClassName.getName();
            String namespaceName2 = VariousUtils.getFullyQualifiedName(superClassName, this.getOffset(), namespaceScope).getNamespaceName();
            indexDocument.addPair("superclz", String.format("%s;%s;%s", name2.toLowerCase(), name2, namespaceName2), true, true);
        }
        Set<QualifiedName> superInterfaces = this.getSuperInterfaces();
        for (QualifiedName qualifiedName : superInterfaces) {
            name = qualifiedName.getName();
            namespaceName = VariousUtils.getFullyQualifiedName(qualifiedName, this.getOffset(), namespaceScope).getNamespaceName();
            indexDocument.addPair("superiface", String.format("%s;%s;%s", name.toLowerCase(), name, namespaceName), true, true);
        }
        for (QualifiedName qualifiedName : this.getUsedTraits()) {
            name = qualifiedName.getName();
            namespaceName = VariousUtils.getFullyQualifiedName(qualifiedName, this.getOffset(), namespaceScope).getNamespaceName();
            indexDocument.addPair("usedtrait", String.format("%s;%s;%s", name.toLowerCase(), name, namespaceName), true, true);
        }
        indexDocument.addPair("top", this.getName().toLowerCase(), true, true);
        for (MethodScope methodScope : this.getDeclaredMethods()) {
            LazyBuild lazyMethod;
            if (methodScope instanceof LazyBuild && !(lazyMethod = (LazyBuild)((Object)methodScope)).isScanned()) {
                lazyMethod.scan();
            }
            if (StringUtils.isEmpty((String)methodScope.getName())) continue;
            methodScope.addSelfToIndex(indexDocument);
        }
        for (FieldElement fieldElement : this.getDeclaredFields()) {
            fieldElement.addSelfToIndex(indexDocument);
        }
        for (ClassConstantElement classConstantElement : this.getDeclaredConstants()) {
            classConstantElement.addSelfToIndex(indexDocument);
        }
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase(Locale.ROOT)).append(';');
        sb.append(this.getName()).append(';');
        sb.append(this.getOffset()).append(';');
        QualifiedName superClassName = this.getSuperClassName();
        if (superClassName != null) {
            sb.append(superClassName.toString());
            sb.append("|");
            boolean first = true;
            for (QualifiedName qualifiedName : this.possibleFQSuperClassNames) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = true;
                }
                assert (!qualifiedName.getName().isEmpty());
                sb.append(qualifiedName.toString());
            }
        }
        sb.append(';');
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope != null ? namespaceScope.getQualifiedName() : QualifiedName.create("");
        sb.append(qualifiedName.toString()).append(';');
        Collection superInterfaceNames = this.getSuperInterfaceNames();
        StringBuilder ifaceSb = new StringBuilder();
        for (String iface : superInterfaceNames) {
            if (ifaceSb.length() > 0) {
                ifaceSb.append(",");
            }
            ifaceSb.append(iface);
        }
        sb.append((CharSequence)ifaceSb);
        if (ifaceSb.length() > 0) {
            sb.append("|");
            StringBuilder fqIfaceSb = new StringBuilder();
            Collection<QualifiedName> fQSuperInterfaceNames = this.getFQSuperInterfaceNames();
            for (QualifiedName fQSuperInterfaceName : fQSuperInterfaceNames) {
                if (fqIfaceSb.length() > 0) {
                    fqIfaceSb.append(",");
                }
                fqIfaceSb.append(fQSuperInterfaceName.toString());
            }
            sb.append((CharSequence)fqIfaceSb);
        }
        sb.append(';');
        sb.append(this.getPhpModifiers().toFlags()).append(';');
        if (!this.usedTraits.isEmpty()) {
            StringBuilder traitSb = new StringBuilder();
            for (QualifiedName usedTrait : this.usedTraits) {
                if (traitSb.length() > 0) {
                    traitSb.append(",");
                }
                assert (!usedTrait.getName().isEmpty());
                traitSb.append(usedTrait.toString());
            }
            sb.append((CharSequence)traitSb);
        }
        sb.append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        StringBuilder mixinSb = new StringBuilder();
        for (QualifiedName mixinClassName : this.mixinClassNames) {
            if (mixinSb.length() > 0) {
                mixinSb.append(",");
            }
            assert (!mixinClassName.getName().isEmpty());
            mixinSb.append(mixinClassName.toString());
        }
        sb.append((CharSequence)mixinSb);
        sb.append(';');
        sb.append(this.isAttributeClass ? 1 : 0);
        sb.append(';');
        return sb.toString();
    }

    @Override
    public Collection<? extends MethodScope> getDeclaredConstructors() {
        return ModelUtils.filter(this.getDeclaredMethods(), new ModelUtils.ElementFilter<MethodScope>(){

            @Override
            public boolean isAccepted(MethodScope methodScope) {
                return methodScope.isConstructor();
            }
        });
    }

    @Override
    public String getDefaultConstructorIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(';');
        sb.append(this.getName()).append(';');
        sb.append(this.getOffset()).append(';');
        sb.append(';');
        sb.append(';');
        sb.append(1).append(';');
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        assert (namespaceScope != null);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        sb.append(';');
        return sb.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof ClassElement) {
            ClassElement indexedClass = (ClassElement)this.indexedElement;
            return indexedClass.getNamespaceName();
        }
        return super.getNamespaceName();
    }

    @Override
    public Collection<? extends String> getSuperClassNames() {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.superClass != null) {
            String supeClsName;
            String string = supeClsName = this.superClass.hasFirst() ? (String)this.superClass.first() : null;
            if (supeClsName != null) {
                return Collections.singletonList(supeClsName);
            }
            List supeClasses = Collections.emptyList();
            if (this.superClass.hasSecond()) {
                supeClasses = (List)this.superClass.second();
            }
            for (ClassScopeImpl cls : supeClasses) {
                retval.add(cls.getName());
            }
        }
        return retval;
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                LazyBuild scope;
                if (element instanceof MethodScope && ((MethodScope)element).isInitiator() && element instanceof LazyBuild && !(scope = (LazyBuild)((Object)element)).isScanned()) {
                    scope.scan();
                }
                return element.getPhpElementKind().equals((Object)PhpElementKind.VARIABLE);
            }
        });
    }

    @Override
    public VariableNameImpl createElement(Variable node) {
        VariableNameImpl retval = new VariableNameImpl((Scope)this, node, false);
        this.addElement(retval);
        return retval;
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    @Override
    public boolean isReadonly() {
        return this.getPhpModifiers().isReadonly();
    }

    @Override
    public boolean isAnonymous() {
        return CodeUtils.isSyntheticTypeName(this.getName());
    }

    @Override
    public boolean isAttribute() {
        return this.isAttributeClass;
    }

    @Override
    public Collection<QualifiedName> getUsedTraits() {
        return Collections.unmodifiableCollection(this.usedTraits);
    }

    @Override
    public Collection<? extends TraitScope> getTraits() {
        ArrayList<? extends TraitScope> result = new ArrayList<TraitScope>();
        for (QualifiedName qualifiedName : this.getUsedTraits()) {
            result.addAll(IndexScopeImpl.getTraits(qualifiedName, this));
        }
        return result;
    }

    @Override
    public boolean isSuperTypeOf(TypeScope subType) {
        boolean result = false;
        if (this.superRecursionDetection.add(subType)) {
            if (subType.isClass()) {
                ClassScope classScope;
                assert (subType instanceof ClassScope);
                Iterator<? extends ClassScope> iterator = ((ClassScope)subType).getSuperClasses().iterator();
                while (iterator.hasNext() && !(result = (classScope = iterator.next()).equals(this) ? true : this.isSuperTypeOf(classScope))) {
                }
            } else {
                result = subType.isTrait() ? false : super.isSuperTypeOf(subType);
            }
        }
        return result;
    }

    @Override
    public boolean isSubTypeOf(TypeScope superType) {
        boolean result;
        block4: {
            ClassScope classScope;
            block6: {
                TraitScope traitScope;
                ClassScope classScope2;
                block5: {
                    ClassScope classScope3;
                    result = false;
                    if (!this.subRecursionDetection.add(superType)) break block4;
                    if (!superType.isClass()) break block5;
                    Iterator<? extends ClassScope> iterator = this.getSuperClasses().iterator();
                    while (iterator.hasNext() && !(result = (classScope3 = iterator.next()).equals(superType) ? true : classScope3.isSubTypeOf(superType))) {
                    }
                    break block4;
                }
                if (!superType.isTrait()) break block6;
                Iterator<TraitedScope> iterator = this.getSuperClasses().iterator();
                while (iterator.hasNext() && !(result = (classScope2 = iterator.next()).isSubTypeOf(superType))) {
                }
                iterator = this.getTraits().iterator();
                while (iterator.hasNext() && !(result = (traitScope = (TraitScope)iterator.next()).equals(superType) ? true : traitScope.isSubTypeOf(superType))) {
                }
                break block4;
            }
            result = super.isSubTypeOf(superType);
            if (result) break block4;
            Iterator<? extends ClassScope> iterator = this.getSuperClasses().iterator();
            while (iterator.hasNext() && !(result = (classScope = iterator.next()).isSubTypeOf(superType))) {
            }
        }
        return result;
    }

    @Override
    public String toString() {
        Collection<? extends TraitScope> traits;
        Collection implementedInterfaces;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        Collection<? extends ClassScope> extendedClasses = this.getSuperClasses();
        ClassScope extClass = ModelUtils.getFirst(extendedClasses);
        if (extClass != null) {
            sb.append(" extends ").append(extClass.getName());
        }
        if (!(implementedInterfaces = this.getSuperInterfaceScopes()).isEmpty()) {
            sb.append(" implements ");
            for (InterfaceScope interfaceScope : implementedInterfaces) {
                sb.append(interfaceScope.getName()).append(" ");
            }
        }
        if (!(traits = this.getTraits()).isEmpty()) {
            sb.append(" uses ");
            for (TraitScope traitScope : traits) {
                sb.append(traitScope.getName()).append(" ");
            }
        }
        return sb.toString();
    }
}

