/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementFilter;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.el.JsfVariableContext;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.api.TagFeature;
import org.netbeans.modules.web.jsfapi.spi.TagFeatureProvider;

public class JsfVariablesModel {
    static boolean inTest = false;
    private static final Logger LOG = Logger.getLogger(JsfVariablesModel.class.getName());
    private static final String VARIABLE_NAME = "var";
    private static final String VALUE_NAME = "value";
    private static WeakReference<JsfVariablesModel> lastModelCache;
    private HtmlParserResult result;
    private SortedSet<JsfVariableContext> contextsList = new TreeSet<JsfVariableContext>();
    private Snapshot topLevelSnapshot;

    public static JsfVariablesModel getModel(HtmlParserResult result, Snapshot topLevelSnapshot) {
        JsfVariablesModel cachedModel;
        if (lastModelCache != null && (cachedModel = (JsfVariablesModel)lastModelCache.get()) != null && cachedModel.result == result) {
            return cachedModel;
        }
        JsfVariablesModel model = new JsfVariablesModel(result, topLevelSnapshot);
        lastModelCache = new WeakReference<JsfVariablesModel>(model);
        return model;
    }

    private JsfVariablesModel(HtmlParserResult result, Snapshot topLevelSnapshot) {
        this.result = result;
        this.topLevelSnapshot = topLevelSnapshot;
        this.initModel();
    }

    private void initModel() {
        JsfSupportImpl sup = JsfSupportImpl.findFor(this.result.getSnapshot().getSource());
        if (sup == null) {
            return;
        }
        Set<String> faceletsLibsNamespaces = sup.getLibraries().keySet();
        Set declaredNamespaces = this.result.getNamespaces().keySet();
        for (String namespace : declaredNamespaces) {
            if (!inTest && !faceletsLibsNamespaces.contains(namespace)) continue;
            Node root = this.result.root(namespace);
            final Library library = sup.getLibrary(namespace);
            List matches = ElementUtils.getChildrenRecursivelly((Element)root, (ElementFilter)new ElementFilter(){

                public boolean accepts(Element node) {
                    OpenTag openTag;
                    String tagName;
                    LibraryComponent component;
                    if (node.type() == ElementType.OPEN_TAG && (component = library.getComponent(tagName = (openTag = (OpenTag)node).unqualifiedName().toString())) != null) {
                        Collection tagFeatures = TagFeatureProvider.Query.getFeatures((Tag)component.getTag(), (Library)library, TagFeature.IterableTagPattern.class);
                        for (TagFeature.IterableTagPattern iterableTagPattern : tagFeatures) {
                            if (iterableTagPattern.getVariable() == null || iterableTagPattern.getItems() == null) continue;
                            Attribute itemsAttribute = openTag.getAttribute(iterableTagPattern.getItems().getName());
                            Attribute variableAttribute = openTag.getAttribute(iterableTagPattern.getVariable().getName());
                            CharSequence itemsValue = itemsAttribute == null ? null : itemsAttribute.unquotedValue();
                            CharSequence variableValue = variableAttribute == null ? null : variableAttribute.unquotedValue();
                            return itemsValue != null && itemsValue.length() > 0 && variableValue != null && variableValue.length() > 0;
                        }
                    }
                    return false;
                }
            }, (boolean)false);
            for (Element node : matches) {
                OpenTag openTag = (OpenTag)node;
                String tagName = openTag.unqualifiedName().toString();
                LibraryComponent component = library.getComponent(tagName);
                if (component == null) continue;
                Collection tagFeatures = TagFeatureProvider.Query.getFeatures((Tag)component.getTag(), (Library)library, TagFeature.IterableTagPattern.class);
                for (TagFeature.IterableTagPattern iterableTagPattern : tagFeatures) {
                    if (iterableTagPattern.getVariable() == null || iterableTagPattern.getItems() == null) continue;
                    String variableAttributeName = iterableTagPattern.getVariable().getName();
                    String itemsAttributeName = iterableTagPattern.getItems().getName();
                    Attribute itemsAttribute = openTag.getAttribute(itemsAttributeName);
                    int doc_from = this.result.getSnapshot().getOriginalOffset(itemsAttribute.valueOffset());
                    int doc_to = this.result.getSnapshot().getOriginalOffset(itemsAttribute.valueOffset() + itemsAttribute.value().length());
                    if (doc_from == -1 || doc_to == -1) continue;
                    CharSequence topLeveLSnapshotText = this.topLevelSnapshot.getText();
                    if (doc_to > topLeveLSnapshotText.length()) {
                        LOG.log(Level.INFO, "It happened in Facelet''s doc_from={0}, doc_to={1}, text={2}", new Object[]{doc_from, doc_to, topLeveLSnapshotText});
                        LOG.log(Level.WARNING, "Error in the JsfVariablesModel initialization, please report it.");
                        continue;
                    }
                    String documentValueContent = this.topLevelSnapshot.getText().subSequence(doc_from, doc_to).toString();
                    JsfVariableContext context = new JsfVariableContext(openTag.from(), openTag.semanticEnd(), openTag.getAttribute(variableAttributeName).unquotedValue().toString(), this.unquotedValue(documentValueContent));
                    this.contextsList.add(context);
                }
            }
        }
    }

    private String unquotedValue(String value) {
        return this.isValueQuoted(value) ? value.substring(1, value.length() - 1) : value;
    }

    private boolean isValueQuoted(String value) {
        if (value.length() < 2) {
            return false;
        }
        return !(value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"');
    }

    public SortedSet<JsfVariableContext> getContexts() {
        return this.contextsList;
    }

    public JsfVariableContext getContainingContext(int offset) {
        JsfVariableContext match = null;
        for (JsfVariableContext c : this.getContexts()) {
            if (c.getFrom() <= offset && c.getTo() > offset) {
                match = c;
            }
            if (match == null || c.getTo() >= offset) continue;
            break;
        }
        return match;
    }

    public JsfVariableContext getPrecedingContext(int offset) {
        JsfVariableContext c;
        JsfVariableContext match = null;
        Iterator iterator = this.getContexts().iterator();
        while (iterator.hasNext() && (c = (JsfVariableContext)iterator.next()).getFrom() < offset) {
            match = c;
        }
        return match;
    }

    List<JsfVariableContext> getAncestors(JsfVariableContext context, boolean includeItself) {
        SortedSet<JsfVariableContext> head = this.getContexts().headSet(context);
        JsfVariableContext[] head_array = head.toArray(new JsfVariableContext[0]);
        ArrayList<JsfVariableContext> ancestors = new ArrayList<JsfVariableContext>();
        for (int i = head_array.length - 1; i >= 0; --i) {
            JsfVariableContext c = head_array[i];
            if (c.getTo() <= context.getTo()) continue;
            ancestors.add(c);
        }
        if (includeItself) {
            ancestors.add(0, context);
        }
        return ancestors;
    }

    List<JsfVariableContext> getPredecessors(JsfVariableContext context, boolean includeItself) {
        SortedSet<JsfVariableContext> head = this.getContexts().headSet(context);
        ArrayList<JsfVariableContext> pre = new ArrayList<JsfVariableContext>();
        for (JsfVariableContext c : head) {
            pre.add(0, c);
        }
        if (includeItself) {
            pre.add(0, context);
        }
        return pre;
    }

    String resolveVariable(JsfVariableContext context, boolean nestingAware) {
        List<JsfVariableContext> ancestors;
        Expression expr = Expression.parse(context.getVariableValue());
        String resolved = expr.getPostfix() != null ? expr.getPostfix() : "";
        List<JsfVariableContext> list = ancestors = nestingAware ? this.getAncestors(context, false) : this.getPredecessors(context, false);
        if (ancestors.isEmpty()) {
            return expr.getCleanExpression();
        }
        ArrayList<JsfVariableContext> matching = new ArrayList<JsfVariableContext>();
        for (JsfVariableContext c : ancestors) {
            if (!c.getVariableName().equals(expr.getBase())) continue;
            expr = Expression.parse(c.getVariableValue());
            matching.add(c);
        }
        if (matching.isEmpty()) {
            return expr.getCleanExpression();
        }
        Iterator itr = matching.iterator();
        while (itr.hasNext()) {
            JsfVariableContext c;
            c = (JsfVariableContext)itr.next();
            expr = Expression.parse(c.getVariableValue());
            if (itr.hasNext()) {
                resolved = expr.getPostfix() + "." + resolved;
                continue;
            }
            resolved = expr.getCleanExpression() + "." + resolved;
        }
        return resolved;
    }

    public String resolveExpression(String expression, int offset, boolean nestingAware) {
        JsfVariableContext leaf;
        Expression parsedExpression = Expression.parse(expression);
        JsfVariableContext jsfVariableContext = leaf = nestingAware ? this.getContainingContext(offset) : this.getPrecedingContext(offset);
        if (leaf == null) {
            return null;
        }
        List<JsfVariableContext> ancestors = nestingAware ? this.getAncestors(leaf, true) : this.getPredecessors(leaf, true);
        JsfVariableContext match = null;
        for (JsfVariableContext c : ancestors) {
            if (!c.getVariableName().equals(parsedExpression.getBase())) continue;
            match = c;
            break;
        }
        if (match == null) {
            return null;
        }
        return this.resolveVariable(match, nestingAware) + (parsedExpression.getPostfix() != null ? "." + parsedExpression.getPostfix() : "");
    }

    public List<JsfVariableContext> getAllAvailableVariables(int offset, boolean nestingAware) {
        JsfVariableContext leaf;
        ArrayList<JsfVariableContext> vars = new ArrayList<JsfVariableContext>();
        JsfVariableContext jsfVariableContext = leaf = nestingAware ? this.getContainingContext(offset) : this.getPrecedingContext(offset);
        if (leaf == null) {
            return vars;
        }
        List<JsfVariableContext> ancestors = nestingAware ? this.getAncestors(leaf, true) : this.getPredecessors(leaf, true);
        for (JsfVariableContext c : ancestors) {
            c.setResolvedType(this.resolveVariable(c, nestingAware));
            vars.add(c);
        }
        return vars;
    }

    static class Expression {
        private String base;
        private String postfix;
        private String expression;

        public static Expression parse(String expression) {
            return new Expression(expression);
        }

        private Expression(String expression) {
            if (expression.length() >= 2 && (expression.charAt(0) == '#' || expression.charAt(0) == '$') && expression.charAt(1) == '{') {
                expression = expression.substring(2);
            }
            if (expression.length() >= 1 && expression.charAt(expression.length() - 1) == '}') {
                expression = expression.substring(0, expression.length() - 1);
            }
            this.expression = expression;
            int dotIndex = expression.indexOf(46);
            this.base = dotIndex == -1 ? expression : expression.substring(0, dotIndex);
            this.postfix = dotIndex == -1 ? null : expression.substring(dotIndex + 1);
        }

        public String getCleanExpression() {
            return this.expression;
        }

        public String getBase() {
            return this.base;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public String toString() {
            return super.toString() + " (base=" + this.base + ", postfix=" + this.postfix;
        }
    }
}

