/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class FileSearchOptions {
    private static final String CASE_SENSITIVE = "caseSensitive";
    private static final String SHOW_HIDDEN_FILES = "showHiddenFiles";
    private static final String PREFER_MAIN_PROJECT = "preferMainProject";
    private static final String SEARCH_BY_FOLDERS = "searchByFolders";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static Preferences node;

    public static boolean getCaseSensitive() {
        return FileSearchOptions.getNode().getBoolean(CASE_SENSITIVE, false);
    }

    public static void setCaseSensitive(boolean caseSensitive) {
        FileSearchOptions.getNode().putBoolean(CASE_SENSITIVE, caseSensitive);
    }

    public static boolean getShowHiddenFiles() {
        return FileSearchOptions.getNode().getBoolean(SHOW_HIDDEN_FILES, false);
    }

    public static void setShowHiddenFiles(boolean showHiddenFiles) {
        FileSearchOptions.getNode().putBoolean(SHOW_HIDDEN_FILES, showHiddenFiles);
    }

    public static boolean getPreferMainProject() {
        return FileSearchOptions.getNode().getBoolean(PREFER_MAIN_PROJECT, true);
    }

    public static void setPreferMainProject(boolean preferMainProject) {
        FileSearchOptions.getNode().putBoolean(PREFER_MAIN_PROJECT, preferMainProject);
    }

    public static void setSearchByFolders(boolean preferMainProject) {
        FileSearchOptions.getNode().putBoolean(SEARCH_BY_FOLDERS, preferMainProject);
    }

    public static boolean getSearchByFolders() {
        return FileSearchOptions.getNode().getBoolean(SEARCH_BY_FOLDERS, false);
    }

    public static int getHeight() {
        return FileSearchOptions.getNode().getInt(HEIGHT, 460);
    }

    public static void setHeight(int height) {
        FileSearchOptions.getNode().putInt(HEIGHT, height);
    }

    public static int getWidth() {
        return FileSearchOptions.getNode().getInt(WIDTH, 740);
    }

    public static void setWidth(int width) {
        FileSearchOptions.getNode().putInt(WIDTH, width);
    }

    static void flush() {
        try {
            FileSearchOptions.getNode().flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static synchronized Preferences getNode() {
        if (node == null) {
            node = NbPreferences.forModule(FileSearchOptions.class);
        }
        return node;
    }
}

