/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.expression;

import java.beans.Introspector;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.micronaut.expression.EvaluationContext;

public abstract class ExpressionTree {
    private final Kind kind;
    protected Element element;
    protected TypeMirror typeMirror;

    private ExpressionTree(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Element getElement(EvaluationContext ctx) {
        if (this.typeMirror == null && this.element == null) {
            this.resolve(ctx);
        }
        return this.element;
    }

    public TypeMirror getTypeMirror(EvaluationContext ctx) {
        if (this.typeMirror == null && this.element == null) {
            this.resolve(ctx);
        }
        return this.typeMirror;
    }

    public abstract int getStartPosition();

    public abstract int getEndPosition();

    public abstract <R, D> R accept(Scanner<R, D> var1, D var2);

    protected void resolve(EvaluationContext ctx) {
        this.typeMirror = ctx.getTypes().getNoType(TypeKind.NONE);
    }

    private static TypeMirror unbox(EvaluationContext ctx, TypeMirror tm) {
        try {
            return ctx.getTypes().unboxedType(tm);
        }
        catch (IllegalArgumentException e) {
            return tm;
        }
    }

    public static String getPropertyName(ExecutableElement ee) {
        TypeKind ret;
        if (ee.getParameters().isEmpty() && ee.getModifiers().contains((Object)Modifier.PUBLIC) && !ee.getModifiers().contains((Object)Modifier.STATIC) && (ret = ee.getReturnType().getKind()) != TypeKind.VOID) {
            String name = ee.getSimpleName().toString();
            if (ret == TypeKind.BOOLEAN && name.startsWith("is")) {
                return name.length() > 2 ? Introspector.decapitalize(name.substring(2)) : null;
            }
            if (name.startsWith("get")) {
                return name.length() > 3 ? Introspector.decapitalize(name.substring(3)) : null;
            }
        }
        return null;
    }

    public static class Scanner<R, P> {
        private Path path;

        public Path getCurrentPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R scan(Path path, P p) {
            this.path = path;
            try {
                Object r = path.getLeaf().accept(this, p);
                return r;
            }
            finally {
                this.path = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R scan(ExpressionTree tree, P p) {
            if (tree == null) {
                return null;
            }
            Path prev = this.path;
            this.path = new Path(this.path, tree);
            try {
                Object r = tree.accept(this, p);
                return r;
            }
            finally {
                this.path = prev;
            }
        }

        private R scanAndReduce(ExpressionTree node, P p, R r) {
            return this.reduce(this.scan(node, p), r);
        }

        public R scan(Iterable<? extends ExpressionTree> nodes, P p) {
            R r = null;
            if (nodes != null) {
                boolean first = true;
                for (ExpressionTree expressionTree : nodes) {
                    r = (R)(first ? this.scan(expressionTree, p) : this.scanAndReduce(expressionTree, p, r));
                    first = false;
                }
            }
            return r;
        }

        private R scanAndReduce(Iterable<? extends ExpressionTree> nodes, P p, R r) {
            return this.reduce(this.scan(nodes, p), r);
        }

        public R reduce(R r1, R r2) {
            return r1;
        }

        public R visitLiteral(Literal node, P p) {
            return null;
        }

        public R visitUnaryExpression(UnaryExpression node, P p) {
            return this.scan(node.getExpression(), p);
        }

        public R visitBinaryExpression(BinaryExpression node, P p) {
            R r = this.scan(node.getLeftOperand(), p);
            r = this.scanAndReduce(node.getRightOperand(), p, r);
            return r;
        }

        public R visitInstanceOf(InstanceOf node, P p) {
            R r = this.scan(node.getExpression(), p);
            r = this.scanAndReduce(node.getType(), p, r);
            return r;
        }

        public R visitTernaryExpression(TernaryExpression node, P p) {
            R r = this.scan(node.getCondition(), p);
            r = this.scanAndReduce(node.getTrueExpression(), p, r);
            r = this.scanAndReduce(node.getFalseExpression(), p, r);
            return r;
        }

        public R visitParenthesizedExpression(ParenthesizedExpression node, P p) {
            return this.scan(node.getExpression(), p);
        }

        public R visitTypeReference(TypeReference node, P p) {
            return null;
        }

        public R visitThisAccess(ThisAccess node, P p) {
            return null;
        }

        public R visitMethodCall(MethodCall node, P p) {
            R r = this.scan(node.getCallee(), p);
            r = this.scanAndReduce(node.getArguments(), p, r);
            return r;
        }

        public R visitPropertyAccess(PropertyAccess node, P p) {
            return this.scan(node.getCallee(), p);
        }

        public R visitArrayAccess(ArrayAccess node, P p) {
            R r = this.scan(node.getCallee(), p);
            r = this.scanAndReduce(node.getIndex(), p, r);
            return r;
        }

        public R visitBeanContextAccess(BeanContextAccess node, P p) {
            return this.scan(node.getTypeReference(), p);
        }

        public R visitEnvironmentAccess(EnvironmentAccess node, P p) {
            return this.scan(node.getPropertyName(), p);
        }

        public R visitErroneous(Erroneous node, P p) {
            return this.scan(node.getErrorTrees(), p);
        }
    }

    public static final class Path {
        private final ExpressionTree leaf;
        private final Path parent;

        public Path(ExpressionTree root) {
            this(null, root);
        }

        public Path(Path parent, ExpressionTree leaf) {
            this.parent = parent;
            this.leaf = leaf;
        }

        public ExpressionTree getLeaf() {
            return this.leaf;
        }

        public Path getParentPath() {
            return this.parent;
        }

        public static Path get(ExpressionTree root, ExpressionTree target) {
            if (root == null || target == null) {
                return null;
            }
            Path path = new Path(root);
            class PathFinder
            extends Scanner<Path, ExpressionTree> {
                private Path result;

                PathFinder() {
                }

                @Override
                public Path scan(Path path, ExpressionTree target) {
                    super.scan(path, target);
                    return this.result;
                }

                @Override
                public Path scan(ExpressionTree tree, ExpressionTree target) {
                    if (this.result == null) {
                        if (tree == target) {
                            this.result = new Path(this.getCurrentPath(), target);
                        } else {
                            super.scan(tree, target);
                        }
                    }
                    return this.result;
                }

                @Override
                public Path scan(Iterable<? extends ExpressionTree> nodes, ExpressionTree target) {
                    if (nodes != null && this.result == null) {
                        for (ExpressionTree expressionTree : nodes) {
                            this.scan(expressionTree, target);
                            if (this.result == null) continue;
                            break;
                        }
                    }
                    return this.result;
                }
            }
            return path.getLeaf() == target ? path : new PathFinder().scan(path, target);
        }

        public static Path get(ExpressionTree root, int offset) {
            if (root == null) {
                return null;
            }
            Path path = new Path(root);
            class PathFinder
            extends Scanner<Path, Void> {
                private Path result;
                final /* synthetic */ int val$offset;

                PathFinder(int n) {
                    this.val$offset = n;
                }

                @Override
                public Path scan(Path path, Void p) {
                    super.scan(path, p);
                    if (this.result == null && path.getLeaf().getStartPosition() < this.val$offset && this.val$offset <= path.getLeaf().getEndPosition()) {
                        this.result = path;
                    }
                    return this.result;
                }

                @Override
                public Path scan(ExpressionTree tree, Void p) {
                    if (tree != null && tree.getStartPosition() < this.val$offset && this.val$offset <= tree.getEndPosition()) {
                        super.scan(tree, p);
                        if (this.result == null) {
                            this.result = new Path(this.getCurrentPath(), tree);
                        }
                    }
                    return this.result;
                }

                @Override
                public Path scan(Iterable<? extends ExpressionTree> nodes, Void p) {
                    if (nodes != null && this.result == null) {
                        for (ExpressionTree expressionTree : nodes) {
                            this.scan(expressionTree, p);
                            if (this.result == null) continue;
                            break;
                        }
                    }
                    return this.result;
                }
            }
            return new PathFinder(offset).scan(path, null);
        }
    }

    public static enum Kind {
        NULL_LITERAL,
        BOOLEAN_LITERAL,
        STRING_LITERAL,
        INT_LITERAL,
        LONG_LITERAL,
        FLOAT_LITERAL,
        DOUBLE_LITERAL,
        UNARY_PLUS,
        UNARY_MINUS,
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        REMAINDER,
        POWER,
        EQUAL_TO,
        NOT_EQUAL_TO,
        GREATER_THAN,
        LESS_THAN,
        GREATER_THAN_EQUAL,
        LESS_THAN_EQUAL,
        MATCHES,
        AND,
        OR,
        NOT,
        EMPTY,
        ELVIS,
        TERNARY,
        PARENTHESIZED,
        TYPE_REFERENCE,
        INSTANCE_OF,
        THIS_ACCESS,
        METHOD_CALL,
        PROPERTY_ACCESS,
        ARRAY_ACCESS,
        BEAN_CONTEXT_ACCESS,
        ENVIRONMENT_ACCESS,
        ERRONEOUS;

    }

    public static final class Erroneous
    extends ExpressionTree {
        private final List<? extends ExpressionTree> errors;
        private final int start;
        private final int end;

        public Erroneous(List<? extends ExpressionTree> errors, int start, int end) {
            super(Kind.ERRONEOUS);
            this.errors = errors;
            this.start = start;
            this.end = end;
        }

        public List<? extends ExpressionTree> getErrorTrees() {
            return this.errors;
        }

        @Override
        public int getStartPosition() {
            int pos = this.start;
            for (ExpressionTree expressionTree : this.errors) {
                if (expressionTree.getStartPosition() >= pos) continue;
                pos = expressionTree.getStartPosition();
            }
            return pos;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitErroneous(this, data);
        }
    }

    public static final class EnvironmentAccess
    extends ExpressionTree {
        private final ExpressionTree propertyName;
        private final int start;
        private final int end;

        public EnvironmentAccess(ExpressionTree propertyName, int start, int end) {
            super(Kind.ENVIRONMENT_ACCESS);
            this.propertyName = propertyName;
            this.start = start;
            this.end = end;
        }

        public ExpressionTree getPropertyName() {
            return this.propertyName;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitEnvironmentAccess(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            this.typeMirror = ctx.getElements().getTypeElement("java.lang.String").asType();
        }
    }

    public static final class BeanContextAccess
    extends ExpressionTree {
        private final TypeReference typeReference;
        private final int start;
        private final int end;

        public BeanContextAccess(TypeReference typeReference, int start, int end) {
            super(Kind.BEAN_CONTEXT_ACCESS);
            this.typeReference = typeReference;
            this.start = start;
            this.end = end;
        }

        public TypeReference getTypeReference() {
            return this.typeReference;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitBeanContextAccess(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            this.typeMirror = this.typeReference.getTypeMirror(ctx);
        }
    }

    public static final class ArrayAccess
    extends ExpressionTree {
        private final ExpressionTree callee;
        private final ExpressionTree index;
        private final int end;

        public ArrayAccess(ExpressionTree callee, ExpressionTree index, int end) {
            super(Kind.ARRAY_ACCESS);
            this.callee = callee;
            this.index = index;
            this.end = end;
        }

        public ExpressionTree getCallee() {
            return this.callee;
        }

        public ExpressionTree getIndex() {
            return this.index;
        }

        @Override
        public int getStartPosition() {
            return this.callee.getStartPosition();
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitArrayAccess(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            TypeMirror calleeTM = this.callee.getTypeMirror(ctx);
            this.typeMirror = calleeTM.getKind() == TypeKind.ARRAY ? ((ArrayType)calleeTM).getComponentType() : ctx.getTypes().getNoType(TypeKind.NONE);
        }
    }

    public static final class PropertyAccess
    extends ExpressionTree {
        private final ExpressionTree callee;
        private final String identifier;
        private final int start;
        private final int end;

        public PropertyAccess(ExpressionTree callee, String identifier, int end) {
            super(Kind.PROPERTY_ACCESS);
            this.callee = callee;
            this.identifier = identifier;
            this.start = callee.getStartPosition();
            this.end = end;
        }

        public PropertyAccess(String identifier, int start, int end) {
            super(Kind.PROPERTY_ACCESS);
            this.callee = null;
            this.identifier = identifier;
            this.start = start;
            this.end = end;
        }

        public ExpressionTree getCallee() {
            return this.callee;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitPropertyAccess(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            List<ExecutableElement> methods = null;
            DeclaredType dt = null;
            if (this.callee == null) {
                methods = ctx.getContextMethods();
            } else {
                TypeMirror calleeTM = this.callee.getTypeMirror(ctx);
                if (calleeTM.getKind() == TypeKind.DECLARED) {
                    dt = (DeclaredType)calleeTM;
                    methods = ElementFilter.methodsIn(((TypeElement)dt.asElement()).getEnclosedElements());
                }
            }
            if (methods != null && !methods.isEmpty()) {
                for (ExecutableElement ee : methods) {
                    TypeMirror enclType = dt != null ? dt : ee.getEnclosingElement().asType();
                    if (enclType.getKind() != TypeKind.DECLARED || !this.identifier.equals(PropertyAccess.getPropertyName(ee)) || !ctx.getTrees().isAccessible(ctx.getScope(), ee, (DeclaredType)enclType)) continue;
                    ExecutableType et = (ExecutableType)ctx.getTypes().asMemberOf((DeclaredType)enclType, ee);
                    this.element = ee;
                    this.typeMirror = et.getReturnType();
                    return;
                }
            }
            this.typeMirror = ctx.getTypes().getNoType(TypeKind.NONE);
        }
    }

    public static final class MethodCall
    extends ExpressionTree {
        private final ExpressionTree callee;
        private final String identifier;
        private final List<? extends ExpressionTree> arguments;
        private final int start;
        private final int end;

        public MethodCall(ExpressionTree callee, String identifier, List<? extends ExpressionTree> arguments, int end) {
            super(Kind.METHOD_CALL);
            this.callee = callee;
            this.identifier = identifier;
            this.arguments = arguments;
            this.start = callee.getStartPosition();
            this.end = end;
        }

        public MethodCall(String identifier, List<? extends ExpressionTree> arguments, int start, int end) {
            super(Kind.METHOD_CALL);
            this.callee = null;
            this.identifier = identifier;
            this.arguments = arguments;
            this.start = start;
            this.end = end;
        }

        public ExpressionTree getCallee() {
            return this.callee;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public List<? extends ExpressionTree> getArguments() {
            return this.arguments;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitMethodCall(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            List<ExecutableElement> methods = null;
            DeclaredType dt = null;
            if (this.callee == null) {
                methods = ctx.getContextMethods();
            } else {
                TypeMirror calleeTM = this.callee.getTypeMirror(ctx);
                if (calleeTM.getKind() == TypeKind.DECLARED) {
                    dt = (DeclaredType)calleeTM;
                    methods = ElementFilter.methodsIn(((TypeElement)dt.asElement()).getEnclosedElements());
                }
            }
            if (methods != null && !methods.isEmpty()) {
                List argTypes = this.arguments.stream().map(arg -> arg.getTypeMirror(ctx)).collect(Collectors.toList());
                for (ExecutableElement ee : methods) {
                    TypeMirror enclType = dt != null ? dt : ee.getEnclosingElement().asType();
                    if (enclType.getKind() != TypeKind.DECLARED || !this.identifier.contentEquals(ee.getSimpleName()) || !ctx.getTrees().isAccessible(ctx.getScope(), ee, (DeclaredType)enclType)) continue;
                    ExecutableType et = (ExecutableType)ctx.getTypes().asMemberOf((DeclaredType)enclType, ee);
                    List<? extends TypeMirror> paramTypes = et.getParameterTypes();
                    if ((!ee.isVarArgs() || argTypes.size() < paramTypes.size()) && argTypes.size() != paramTypes.size()) continue;
                    boolean match = true;
                    Iterator<? extends TypeMirror> paramsIt = paramTypes.iterator();
                    TypeMirror param = paramsIt.hasNext() ? paramsIt.next() : null;
                    Iterator argsIt = argTypes.iterator();
                    while (match && argsIt.hasNext()) {
                        TypeMirror arg2 = (TypeMirror)argsIt.next();
                        if (!ctx.getTypes().isAssignable(arg2, param)) {
                            match = false;
                        }
                        if (!paramsIt.hasNext()) continue;
                        param = paramsIt.next();
                    }
                    if (!match) continue;
                    this.element = ee;
                    this.typeMirror = et.getReturnType();
                    return;
                }
            }
            this.typeMirror = ctx.getTypes().getNoType(TypeKind.NONE);
        }
    }

    public static final class ThisAccess
    extends ExpressionTree {
        private final int start;
        private final int end;

        public ThisAccess(int start, int end) {
            super(Kind.THIS_ACCESS);
            this.start = start;
            this.end = end;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitThisAccess(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            TypeElement te = ctx.getScope().getEnclosingClass();
            this.typeMirror = te != null ? te.asType() : ctx.getTypes().getNoType(TypeKind.NONE);
        }
    }

    public static final class TypeReference
    extends ExpressionTree {
        private final String typeName;
        private final int typeStart;
        private final int start;
        private final int end;

        public TypeReference(String typeName, int typeStart, int start, int end) {
            super(Kind.TYPE_REFERENCE);
            this.typeName = typeName;
            this.typeStart = typeStart;
            this.start = start;
            this.end = end;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getTypeStartPosition() {
            return this.typeStart;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitTypeReference(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            this.element = ctx.getElements().getTypeElement(this.typeName);
            if (this.element == null) {
                this.element = ctx.getElements().getTypeElement("java.lang." + this.typeName);
            }
            this.typeMirror = this.element != null ? this.element.asType() : ctx.getTypes().getNoType(TypeKind.NONE);
        }
    }

    public static final class ParenthesizedExpression
    extends ExpressionTree {
        private final ExpressionTree expression;
        private final int start;
        private final int end;

        public ParenthesizedExpression(Kind kind, ExpressionTree expression, int start, int end) {
            super(kind);
            this.expression = expression;
            this.start = start;
            this.end = end;
        }

        public ExpressionTree getExpression() {
            return this.expression;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitParenthesizedExpression(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            this.typeMirror = this.expression.getTypeMirror(ctx);
        }
    }

    public static final class TernaryExpression
    extends ExpressionTree {
        private final ExpressionTree condition;
        private final ExpressionTree trueExpression;
        private final ExpressionTree falseExpression;

        public TernaryExpression(ExpressionTree condition, ExpressionTree trueExpression, ExpressionTree falseExpression) {
            super(Kind.TERNARY);
            this.condition = condition;
            this.trueExpression = trueExpression;
            this.falseExpression = falseExpression;
        }

        public ExpressionTree getCondition() {
            return this.condition;
        }

        public ExpressionTree getTrueExpression() {
            return this.trueExpression;
        }

        public ExpressionTree getFalseExpression() {
            return this.falseExpression;
        }

        @Override
        public int getStartPosition() {
            return this.condition.getStartPosition();
        }

        @Override
        public int getEndPosition() {
            return this.falseExpression.getEndPosition();
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitTernaryExpression(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            TypeMirror trueTM = ExpressionTree.unbox(ctx, this.trueExpression.getTypeMirror(ctx));
            TypeMirror falseTM = ExpressionTree.unbox(ctx, this.falseExpression.getTypeMirror(ctx));
            this.typeMirror = trueTM.getKind() == TypeKind.DOUBLE || falseTM.getKind() == TypeKind.DOUBLE ? ctx.getTypes().getPrimitiveType(TypeKind.DOUBLE) : (trueTM.getKind() == TypeKind.FLOAT || falseTM.getKind() == TypeKind.FLOAT ? ctx.getTypes().getPrimitiveType(TypeKind.FLOAT) : (trueTM.getKind() == TypeKind.LONG || falseTM.getKind() == TypeKind.LONG ? ctx.getTypes().getPrimitiveType(TypeKind.LONG) : (trueTM.getKind() == TypeKind.INT || falseTM.getKind() == TypeKind.INT ? ctx.getTypes().getPrimitiveType(TypeKind.INT) : trueTM)));
        }
    }

    public static final class InstanceOf
    extends ExpressionTree {
        private final ExpressionTree expression;
        private final TypeReference type;

        public InstanceOf(ExpressionTree expression, TypeReference type) {
            super(Kind.INSTANCE_OF);
            this.expression = expression;
            this.type = type;
        }

        public ExpressionTree getExpression() {
            return this.expression;
        }

        public TypeReference getType() {
            return this.type;
        }

        @Override
        public int getStartPosition() {
            return this.expression.getStartPosition();
        }

        @Override
        public int getEndPosition() {
            return this.type.getEndPosition();
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitInstanceOf(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.BOOLEAN);
        }
    }

    public static final class BinaryExpression
    extends ExpressionTree {
        private final ExpressionTree left;
        private final ExpressionTree right;

        public BinaryExpression(Kind kind, ExpressionTree left, ExpressionTree right) {
            super(kind);
            this.left = left;
            this.right = right;
        }

        public ExpressionTree getLeftOperand() {
            return this.left;
        }

        public ExpressionTree getRightOperand() {
            return this.right;
        }

        @Override
        public int getStartPosition() {
            return this.left.getStartPosition();
        }

        @Override
        public int getEndPosition() {
            return this.right.getEndPosition();
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitBinaryExpression(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            TypeMirror leftTM = ExpressionTree.unbox(ctx, this.left.getTypeMirror(ctx));
            TypeMirror rightTM = ExpressionTree.unbox(ctx, this.right.getTypeMirror(ctx));
            switch (this.getKind()) {
                case EQUAL_TO: 
                case NOT_EQUAL_TO: 
                case GREATER_THAN: 
                case LESS_THAN: 
                case GREATER_THAN_EQUAL: 
                case LESS_THAN_EQUAL: 
                case MATCHES: 
                case AND: 
                case OR: 
                case ELVIS: {
                    this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.BOOLEAN);
                    break;
                }
                case PLUS: {
                    if (leftTM.getKind() == TypeKind.DECLARED && "java.lang.String".contentEquals(((TypeElement)((DeclaredType)leftTM).asElement()).getQualifiedName())) {
                        this.typeMirror = leftTM;
                        break;
                    }
                }
                case MINUS: 
                case MULTIPLY: 
                case DIVIDE: 
                case REMAINDER: 
                case POWER: {
                    if (leftTM.getKind() == TypeKind.DOUBLE || rightTM.getKind() == TypeKind.DOUBLE) {
                        this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.DOUBLE);
                        break;
                    }
                    if (leftTM.getKind() == TypeKind.FLOAT || rightTM.getKind() == TypeKind.FLOAT) {
                        this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.FLOAT);
                        break;
                    }
                    if (leftTM.getKind() == TypeKind.LONG || rightTM.getKind() == TypeKind.LONG) {
                        this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.LONG);
                        break;
                    }
                    this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.INT);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)this.getKind())));
                }
            }
        }
    }

    public static final class UnaryExpression
    extends ExpressionTree {
        private final ExpressionTree expression;
        private final int start;

        public UnaryExpression(Kind kind, ExpressionTree expression, int start) {
            super(kind);
            this.expression = expression;
            this.start = start;
        }

        public ExpressionTree getExpression() {
            return this.expression;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.expression.getEndPosition();
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitUnaryExpression(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            TypeMirror tm = ExpressionTree.unbox(ctx, this.expression.getTypeMirror(ctx));
            block0 : switch (this.getKind()) {
                case NOT: 
                case EMPTY: {
                    this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.BOOLEAN);
                    break;
                }
                case PLUS: 
                case MINUS: {
                    switch (tm.getKind()) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            this.typeMirror = tm;
                            break block0;
                        }
                    }
                    this.typeMirror = ctx.getTypes().getNoType(TypeKind.INT);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)this.getKind())));
                }
            }
        }
    }

    public static final class Literal
    extends ExpressionTree {
        private final Object value;
        private final int start;
        private final int end;

        Literal(Kind kind, Object value, int start, int end) {
            super(kind);
            this.value = value;
            this.start = start;
            this.end = end;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public int getStartPosition() {
            return this.start;
        }

        @Override
        public int getEndPosition() {
            return this.end;
        }

        @Override
        public <R, D> R accept(Scanner<R, D> scanner, D data) {
            return scanner.visitLiteral(this, data);
        }

        @Override
        protected void resolve(EvaluationContext ctx) {
            switch (this.getKind()) {
                case NULL_LITERAL: {
                    this.typeMirror = ctx.getTypes().getNullType();
                    break;
                }
                case BOOLEAN_LITERAL: {
                    this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.BOOLEAN);
                    break;
                }
                case STRING_LITERAL: {
                    this.typeMirror = ctx.getElements().getTypeElement("java.lang.String").asType();
                    break;
                }
                case INT_LITERAL: {
                    this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.INT);
                    break;
                }
                case LONG_LITERAL: {
                    this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.LONG);
                    break;
                }
                case FLOAT_LITERAL: {
                    this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.FLOAT);
                    break;
                }
                case DOUBLE_LITERAL: {
                    this.typeMirror = ctx.getTypes().getPrimitiveType(TypeKind.DOUBLE);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)this.getKind())));
                }
            }
        }
    }
}

