/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.xml.bind.JAXBException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.GuardedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.client.ClientGenerationStrategy;
import org.netbeans.modules.websvc.rest.client.HttpParams;
import org.netbeans.modules.websvc.rest.client.JaxRsGenerationStrategy;
import org.netbeans.modules.websvc.rest.client.JerseyGenerationStrategy;
import org.netbeans.modules.websvc.rest.client.OAuthHelper;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.SecurityParams;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.SubResourceLocator;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.Authenticator;
import org.netbeans.modules.websvc.saas.model.jaxb.Params;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.jaxb.ServletDescriptor;
import org.netbeans.modules.websvc.saas.model.jaxb.Sign;
import org.netbeans.modules.websvc.saas.model.jaxb.TemplateType;
import org.netbeans.modules.websvc.saas.model.jaxb.UseTemplates;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClientJavaSourceHelper {
    public static void generateJerseyClient(Node resourceNode, FileObject targetFo, String className) {
        ClientJavaSourceHelper.generateJerseyClient(resourceNode, targetFo, className, new Security(false, Security.Authentication.NONE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateJerseyClient(Node resourceNode, FileObject targetFo, String className, Security security) {
        block24: {
            Project project = FileOwnerQuery.getOwner((FileObject)targetFo);
            ClassPath cp = ClassPath.getClassPath((FileObject)targetFo, (String)"classpath/compile");
            boolean jersey1Available = cp != null && cp.findResource("com/sun/jersey/api/client/WebResource.class") != null;
            boolean jersey2Available = cp != null && cp.findResource("org/glassfish/jersey/spi/Contract.class") != null;
            boolean jaxRs1Available = cp != null && cp.findResource("javax/ws/rs/core/Application.class") != null;
            boolean jaxRs2Available = cp != null && cp.findResource("javax/ws/rs/client/Client.class") != null;
            boolean jakartaRsClientAvailable = cp != null && cp.findResource("jakarta/ws/rs/client/Client.class") != null;
            JaxRsStackSupport support = JaxRsStackSupport.getInstance((Project)project);
            boolean jersey1AvailableOnServer = support != null && support.isBundled("com.sun.jersey.api.client.WebResource");
            boolean jersey2AvailableOnServer = support != null && support.isBundled("org.glassfish.jersey.spi.Contract");
            ClientGenerationStrategy strategy = null;
            if (jersey2Available || jersey2AvailableOnServer) {
                strategy = new JaxRsGenerationStrategy(jakartaRsClientAvailable);
            } else if (jersey1Available || jersey1AvailableOnServer) {
                strategy = new JerseyGenerationStrategy();
            }
            if (project != null && strategy == null) {
                if (jaxRs2Available || jakartaRsClientAvailable) {
                    strategy = new JaxRsGenerationStrategy(jakartaRsClientAvailable);
                } else if (jaxRs1Available) {
                    strategy = new JaxRsGenerationStrategy(jakartaRsClientAvailable);
                }
            }
            if (strategy == null) {
                strategy = new JaxRsGenerationStrategy(jakartaRsClientAvailable);
            }
            ProgressHandle handle = null;
            if (support == null) {
                support = JaxRsStackSupport.getDefault();
            }
            boolean requiresJersey = strategy.requiresJersey(resourceNode, security);
            try {
                RestSupport restSupport;
                handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_creatingRESTClient"));
                handle.start();
                if (!(jaxRs2Available || jaxRs1Available || jakartaRsClientAvailable)) {
                    support.addJsr311Api(project);
                    support.extendsJerseyProjectClasspath(project);
                }
                if (requiresJersey && !jersey1Available && !jersey2Available) {
                    support.extendsJerseyProjectClasspath(project);
                }
                String targetProjectType = null;
                targetProjectType = project != null ? Wadl2JavaHelper.getProjectType(project) : "desktop";
                if (targetProjectType == "web" && (jersey2Available || jersey2AvailableOnServer)) {
                    targetProjectType = "web-ee7";
                }
                security.setProjectType(targetProjectType);
                RestServiceDescription restServiceDesc = (RestServiceDescription)resourceNode.getLookup().lookup(RestServiceDescription.class);
                if (restServiceDesc != null) {
                    String uriTemplate = restServiceDesc.getUriTemplate();
                    if (uriTemplate != null) {
                        String baseURL;
                        PathFormat pf = null;
                        if (uriTemplate.length() == 0) {
                            ResourcePath rootResourcePath = ClientJavaSourceHelper.getResourcePath(resourceNode, restServiceDesc.getClassName(), "");
                            uriTemplate = rootResourcePath.getPath();
                            pf = rootResourcePath.getPathFormat();
                        } else {
                            pf = ClientGenerationStrategy.getPathFormat(uriTemplate);
                        }
                        Project prj = (Project)resourceNode.getLookup().lookup(Project.class);
                        String string = baseURL = prj == null ? "" : ClientJavaSourceHelper.getBaseURL(prj);
                        if (baseURL.endsWith("/")) {
                            baseURL = baseURL.substring(0, baseURL.length() - 1);
                        }
                        ClientJavaSourceHelper.addJerseyClient(JavaSource.forFileObject((FileObject)targetFo), className, baseURL, restServiceDesc, null, pf, security, strategy);
                    }
                    break block24;
                }
                WadlSaasResource saasResource = (WadlSaasResource)resourceNode.getLookup().lookup(WadlSaasResource.class);
                if (saasResource == null) break block24;
                ClientJavaSourceHelper.addSecurityMetadata(security, saasResource);
                if ("web".equals(security.getProjectType()) && (Security.Authentication.SESSION_KEY == security.getAuthentication() || Security.Authentication.OAUTH == security.getAuthentication()) && (restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class)) != null) {
                    security.setDeploymentDescriptor(RestUtils.getDeploymentDescriptor(project));
                }
                String baseUrl = saasResource.getSaas().getBaseURL();
                ResourcePath resourcePath = ClientJavaSourceHelper.getResourcePath(saasResource);
                PathFormat pf = resourcePath.getPathFormat();
                ClientJavaSourceHelper.addJerseyClient(JavaSource.forFileObject((FileObject)targetFo), className, baseUrl, null, saasResource, pf, security, strategy);
                try {
                    Wadl2JavaHelper.generateJaxb(targetFo, saasResource.getSaas());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (!(!"nb-module".equals(targetProjectType) || Security.Authentication.OAUTH != security.getAuthentication() && Security.Authentication.SESSION_KEY != security.getAuthentication() || cp != null && cp.findResource("org/openide/DialogDisplayer.class.class") != null && cp.findResource("org/openide/util/NbPreferences.class.class") != null && cp.findResource("org/openide/awt/HtmlBrowser.class") != null)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_MissingOpenideModules"), 2));
                }
            }
            finally {
                handle.finish();
            }
        }
    }

    private static void addJerseyClient(final JavaSource source, final String className, final String resourceUri, final RestServiceDescription restServiceDesc, final WadlSaasResource saasResource, final PathFormat pf, final Security security, final ClientGenerationStrategy strategy) {
        try {
            AbstractTask<WorkingCopy> task = new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy copy) throws IOException {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    ClassTree tree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                    ClassTree modifiedTree = null;
                    modifiedTree = className == null ? ClientJavaSourceHelper.modifyJerseyClientClass(copy, tree, resourceUri, restServiceDesc, saasResource, pf, security, strategy) : ClientJavaSourceHelper.addJerseyClientClass(copy, tree, className, resourceUri, restServiceDesc, saasResource, pf, security, strategy);
                    copy.rewrite((Tree)tree, (Tree)modifiedTree);
                }
            };
            ModificationResult result = source.runModificationTask((Task)task);
            if (SourceUtils.isScanInProgress()) {
                source.runWhenScanFinished((Task)new Task<CompilationController>((Task)task){
                    final /* synthetic */ Task val$task;
                    {
                        this.val$task = task;
                    }

                    public void run(CompilationController controller) throws Exception {
                        source.runModificationTask(this.val$task).commit();
                    }
                }, true);
            } else {
                result.commit();
            }
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof GuardedException) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"ERR_CannotApplyGuarded"), 0));
                Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.FINE, null, ex);
            }
            Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    private static ClassTree modifyJerseyClientClass(WorkingCopy copy, ClassTree classTree, String resourceURI, RestServiceDescription restServiceDesc, WadlSaasResource saasResource, PathFormat pf, Security security, ClientGenerationStrategy strategy) {
        return ClientJavaSourceHelper.generateClassArtifacts(copy, classTree, resourceURI, restServiceDesc, saasResource, pf, security, null, strategy);
    }

    private static ClassTree addJerseyClientClass(WorkingCopy copy, ClassTree classTree, String className, String resourceURI, RestServiceDescription restServiceDesc, WadlSaasResource saasResource, PathFormat pf, Security security, ClientGenerationStrategy strategy) {
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree modifs = maker.Modifiers(Collections.singleton(Modifier.STATIC));
        ClassTree innerClass = maker.Class(modifs, (CharSequence)className, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList());
        ClassTree modifiedInnerClass = ClientJavaSourceHelper.generateClassArtifacts(copy, innerClass, resourceURI, restServiceDesc, saasResource, pf, security, classTree.getSimpleName().toString(), strategy);
        return maker.addClassMember(classTree, (Tree)modifiedInnerClass);
    }

    private static ClassTree generateClassArtifacts(WorkingCopy copy, ClassTree classTree, String resourceURI, RestServiceDescription restServiceDesc, WadlSaasResource saasResource, PathFormat pf, Security security, String outerClassName, ClientGenerationStrategy strategy) {
        String className;
        String packageName;
        FileObject ddFo;
        boolean isSubresource;
        TreeMaker maker = copy.getTreeMaker();
        ClassTree modifiedClass = strategy.generateFields(maker, copy, classTree, resourceURI, security);
        MethodTree ctor = strategy.generateConstructor(maker, copy, modifiedClass, pf, security);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)ctor);
        if (Security.Authentication.BASIC == security.getAuthentication() && pf.getArguments().length == 0) {
            ctor = strategy.generateConstructorAuthBasic(maker);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)ctor);
        }
        boolean bl = isSubresource = pf.getArguments().length > 0;
        if (isSubresource) {
            MethodTree subresource = strategy.generateSubresourceMethod(maker, copy, modifiedClass, pf);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)subresource);
        }
        if (restServiceDesc != null) {
            List annotatedMethods = restServiceDesc.getMethods();
            for (RestMethodDescription methodDesc : annotatedMethods) {
                if (!(methodDesc instanceof HttpMethod)) continue;
                List<MethodTree> httpMethods = strategy.generateHttpMethods(copy, (HttpMethod)methodDesc);
                for (MethodTree httpMethod : httpMethods) {
                    modifiedClass = maker.addClassMember(modifiedClass, (Tree)httpMethod);
                }
            }
        } else if (saasResource != null) {
            modifiedClass = ClientJavaSourceHelper.generateSaasClientMethods(copy, modifiedClass, saasResource, security, strategy);
        }
        MethodTree close = strategy.generateClose(maker, copy);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)close);
        if (Security.Authentication.BASIC == security.getAuthentication()) {
            ArrayList<VariableTree> authParams = new ArrayList<VariableTree>();
            IdentifierTree argTypeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree argFieldTree = maker.Variable(fieldModifier, (CharSequence)"username", (Tree)argTypeTree, null);
            authParams.add(argFieldTree);
            argFieldTree = maker.Variable(fieldModifier, (CharSequence)"password", (Tree)argTypeTree, null);
            authParams.add(argFieldTree);
            MethodTree authMethod = strategy.generateBasicAuth(maker, copy, authParams);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)authMethod);
        } else if (saasResource != null && Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            final SecurityParams securityParams = security.getSecurityParams();
            if (securityParams != null) {
                modifiedClass = Wadl2JavaHelper.addSessionAuthMethods(copy, modifiedClass, securityParams);
                if ("web".equals(security.getProjectType())) {
                    ddFo = security.getDeploymentDescriptor();
                    if (ddFo != null) {
                        packageName = copy.getCompilationUnit().getPackageName().toString();
                        className = (outerClassName == null ? "" : outerClassName + "$") + classTree.getSimpleName().toString();
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ClientJavaSourceHelper.addWebXmlArtifacts(ddFo, securityParams, className, packageName);
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot add servlet/servlet mapping to web.xml", ex);
                                }
                            }
                        }, 1000);
                    }
                    modifiedClass = Wadl2JavaHelper.addSessionAuthServlets(copy, modifiedClass, securityParams, ddFo == null);
                }
            }
        } else if (saasResource != null) {
            try {
                Metadata oauthMetadata = saasResource.getSaas().getOauthMetadata();
                if (oauthMetadata != null) {
                    modifiedClass = strategy.generateOAuthMethods(security.getProjectType(), copy, modifiedClass, oauthMetadata);
                    if ("web".equals(security.getProjectType())) {
                        ddFo = security.getDeploymentDescriptor();
                        if (ddFo != null) {
                            packageName = copy.getCompilationUnit().getPackageName().toString();
                            className = (outerClassName == null ? "" : outerClassName + "$") + classTree.getSimpleName().toString();
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        ClientJavaSourceHelper.addWebXmlOAuthArtifacts(ddFo, className, packageName);
                                    }
                                    catch (IOException ex) {
                                        Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot add servlet/servlet mapping to web.xml", ex);
                                    }
                                }
                            }, 1000);
                        }
                        modifiedClass = OAuthHelper.addOAuthServlets(copy, modifiedClass, oauthMetadata, classTree.getSimpleName().toString(), ddFo == null);
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot get metadata for oauth", ex);
            }
            catch (JAXBException ex) {
                Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot get metadata for oauth", ex);
            }
        }
        if (security.isSSL()) {
            modifiedClass = ClientJavaSourceHelper.generateSslConfigMethods(maker, copy, modifiedClass);
        }
        return modifiedClass;
    }

    private static ClassTree generateSaasClientMethods(WorkingCopy copy, ClassTree classTree, WadlSaasResource saasResource, Security security, ClientGenerationStrategy strategy) {
        MethodTree methodTree;
        List saasMethods = saasResource.getMethods();
        ClassTree modifiedInnerClass = classTree;
        TreeMaker maker = copy.getTreeMaker();
        boolean hasMultipleParamsInList = false;
        boolean hasOptionalQueryParams = false;
        boolean hasFormParams = false;
        HttpParams globalParams = new HttpParams(saasResource);
        for (WadlSaasMethod saasMethod : saasMethods) {
            HttpParams httpParams = new HttpParams(saasMethod);
            httpParams.mergeQueryandHeaderParams(globalParams);
            if (httpParams.hasMultipleParamsInList()) {
                hasMultipleParamsInList = true;
            }
            if (httpParams.hasOptionalQueryParams() && httpParams.hasRequiredQueryParams() || httpParams.hasDefaultQueryParams()) {
                hasOptionalQueryParams = true;
            }
            if (httpParams.hasFormParams()) {
                hasFormParams = true;
            }
            List<MethodTree> httpMethods = strategy.generateHttpMethods(copy, saasMethod, httpParams, security);
            for (MethodTree httpMethod : httpMethods) {
                modifiedInnerClass = maker.addClassMember(modifiedInnerClass, (Tree)httpMethod);
            }
        }
        if (hasMultipleParamsInList || hasFormParams) {
            methodTree = strategy.generateFormMethod(maker, copy);
            modifiedInnerClass = maker.addClassMember(modifiedInnerClass, (Tree)methodTree);
        }
        if (hasOptionalQueryParams) {
            methodTree = strategy.generateOptionalFormMethod(maker, copy);
            modifiedInnerClass = maker.addClassMember(modifiedInnerClass, (Tree)methodTree);
        }
        return modifiedInnerClass;
    }

    private static ClassTree generateSslConfigMethods(TreeMaker maker, WorkingCopy copy, ClassTree classTree) {
        ModifiersTree privateModifier = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        String body = "{   return new HostnameVerifier() {       @Override       public boolean verify(String hostname, javax.net.ssl.SSLSession sslSession) {           return true;       }   }}";
        MethodTree methodTree = maker.Method(privateModifier, (CharSequence)"getHostnameVerifier", (Tree)JavaSourceHelper.createTypeTree(copy, "javax.net.ssl.HostnameVerifier"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
        ClassTree modifiedClass = maker.addClassMember(classTree, (Tree)methodTree);
        body = "{   // for alternative implementation checkout org.glassfish.jersey.SslConfigurator\n   javax.net.ssl.TrustManager x509 = new javax.net.ssl.X509TrustManager() {       @Override       public void checkClientTrusted(java.security.cert.X509Certificate[] arg0, String arg1) throws java.security.cert.CertificateException {           return;       }       @Override       public void checkServerTrusted(java.security.cert.X509Certificate[] arg0, String arg1) throws java.security.cert.CertificateException {           return;       }       @Override       public java.security.cert.X509Certificate[] getAcceptedIssuers() {           return null;       }   };   SSLContext ctx = null;   try {       ctx = SSLContext.getInstance(\"SSL\");       ctx.init(null, new javax.net.ssl.TrustManager[] {x509}, null);   } catch (java.security.GeneralSecurityException ex) {}   return ctx;}";
        methodTree = maker.Method(privateModifier, (CharSequence)"getSSLContext", (Tree)JavaSourceHelper.createTypeTree(copy, "javax.net.ssl.SSLContext"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
        return maker.addClassMember(modifiedClass, (Tree)methodTree);
    }

    private static ResourcePath getResourcePath(WadlSaasResource saasResource) {
        String path = ClientGenerationStrategy.normalizePath(saasResource.getResource().getPath());
        for (WadlSaasResource parent = saasResource.getParent(); parent != null; parent = parent.getParent()) {
            String pathToken = ClientGenerationStrategy.normalizePath(parent.getResource().getPath());
            if (pathToken.length() <= 0) continue;
            path = pathToken + "/" + path;
        }
        return new ResourcePath(ClientGenerationStrategy.getPathFormat(path), path);
    }

    private static ResourcePath getResourcePath(Node resourceNode, String resourceClass, String uriTemplate) {
        String resourceUri = ClientGenerationStrategy.normalizePath(uriTemplate);
        Node projectNode = resourceNode.getParentNode();
        if (projectNode != null) {
            for (Node sibling : projectNode.getChildren().getNodes()) {
                RestServiceDescription desc;
                if (resourceNode == sibling || (desc = (RestServiceDescription)sibling.getLookup().lookup(RestServiceDescription.class)) == null) continue;
                for (RestMethodDescription m : desc.getMethods()) {
                    SubResourceLocator resourceLocator;
                    if (!(m instanceof SubResourceLocator) || !resourceClass.equals((resourceLocator = (SubResourceLocator)m).getReturnType())) continue;
                    String resourceLocatorUri = ClientGenerationStrategy.normalizePath(resourceLocator.getUriTemplate());
                    String parentResourceUri = desc.getUriTemplate();
                    if (parentResourceUri.length() > 0) {
                        String subresourceUri = null;
                        subresourceUri = resourceLocatorUri.length() > 0 ? (resourceUri.length() > 0 ? resourceLocatorUri + "/" + resourceUri : resourceLocatorUri) : resourceUri;
                        PathFormat pf = ClientGenerationStrategy.getPathFormat(ClientGenerationStrategy.normalizePath(parentResourceUri) + "/" + subresourceUri);
                        return new ResourcePath(pf, parentResourceUri);
                    }
                    return ClientJavaSourceHelper.getResourcePath(sibling, desc.getClassName(), resourceLocatorUri + "/" + uriTemplate);
                }
            }
        }
        return new ResourcePath(ClientGenerationStrategy.getPathFormat(uriTemplate), uriTemplate);
    }

    public static String getBaseURL(Project project) {
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = provider.getServerInstanceID();
        if (serverInstanceID == null) {
            Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
            return "";
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
        String portNumber = "8080";
        String hostName = "localhost";
        try {
            ServerInstance.Descriptor instanceDescriptor = serverInstance.getDescriptor();
            if (instanceDescriptor != null) {
                int port = instanceDescriptor.getHttpPort();
                portNumber = port == 0 ? "8080" : String.valueOf(port);
                String hstName = instanceDescriptor.getHostname();
                if (hstName != null) {
                    hostName = hstName;
                }
            }
        }
        catch (InstanceRemovedException ex) {
            Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Removed ServerInstance", ex);
        }
        String contextRoot = null;
        J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
        if (J2eeModule.Type.WAR.equals(moduleType)) {
            J2eeModuleProvider.ConfigSupport configSupport = provider.getConfigSupport();
            try {
                contextRoot = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            if (contextRoot != null && contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
        }
        String applicationPath = "webresources";
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            applicationPath = restSupport.getApplicationPath();
        }
        return "http://" + hostName + ":" + portNumber + "/" + (contextRoot != null && !contextRoot.equals("") ? contextRoot : "") + "/" + applicationPath;
    }

    private static void addSecurityMetadata(Security security, WadlSaasResource saasResource) {
        SaasMetadata.Authentication auth;
        SaasMetadata saasMetadata = saasResource.getSaas().getSaasMetadata();
        if (saasMetadata != null && (auth = saasMetadata.getAuthentication()) != null && auth.getSessionKey().size() > 0) {
            SecurityParams securityParams = new SecurityParams();
            SaasMetadata.Authentication.SessionKey sessionKey = (SaasMetadata.Authentication.SessionKey)auth.getSessionKey().get(0);
            if (sessionKey != null) {
                UseTemplates useTemplates;
                Authenticator authenticator;
                Params secParams;
                securityParams.setSignature(sessionKey.getSigId());
                Sign sign = sessionKey.getSign();
                if (sign != null && (secParams = sign.getParams()) != null) {
                    ArrayList<String> params = new ArrayList<String>();
                    for (Params.Param secParam : secParams.getParam()) {
                        params.add(secParam.getName());
                    }
                    securityParams.setParams(params);
                }
                if ((authenticator = sessionKey.getAuthenticator()) != null && (useTemplates = authenticator.getUseTemplates()) != null) {
                    TemplateType tt;
                    if ("nb-module".equals(security.getProjectType())) {
                        tt = useTemplates.getNbModule();
                        if (tt != null) {
                            securityParams.setFieldDescriptors(tt.getFieldDescriptor());
                            securityParams.setMethodDescriptors(tt.getMethodDescriptor());
                            securityParams.setServletDescriptors(tt.getServletDescriptor());
                        }
                    } else if ("web-ee7".equals(security.getProjectType())) {
                        tt = useTemplates.getWebEe7();
                        if (tt == null) {
                            tt = useTemplates.getWeb();
                        }
                        if (tt != null) {
                            securityParams.setFieldDescriptors(tt.getFieldDescriptor());
                            securityParams.setMethodDescriptors(tt.getMethodDescriptor());
                            securityParams.setServletDescriptors(tt.getServletDescriptor());
                        }
                    } else if ("web".equals(security.getProjectType())) {
                        tt = useTemplates.getWeb();
                        if (tt != null) {
                            securityParams.setFieldDescriptors(tt.getFieldDescriptor());
                            securityParams.setMethodDescriptors(tt.getMethodDescriptor());
                            securityParams.setServletDescriptors(tt.getServletDescriptor());
                        }
                    } else {
                        tt = useTemplates.getDesktop();
                        if (tt != null) {
                            securityParams.setFieldDescriptors(tt.getFieldDescriptor());
                            securityParams.setMethodDescriptors(tt.getMethodDescriptor());
                            securityParams.setServletDescriptors(tt.getServletDescriptor());
                        }
                    }
                }
            }
            security.setSecurityParams(securityParams);
        }
    }

    private static void addWebXmlArtifacts(FileObject ddFo, SecurityParams securityParams, String parentClassName, String packageName) throws IOException {
        WebApp webApp = DDProvider.getDefault().getDDRoot(ddFo);
        if (webApp != null) {
            for (ServletDescriptor servletDesc : securityParams.getServletDescriptors()) {
                String servletName = parentClassName + "$" + servletDesc.getClassName();
                String className = packageName + "." + servletName;
                String urlPattern = servletDesc.getServletMapping();
                try {
                    Servlet servlet = (Servlet)webApp.createBean("Servlet");
                    servlet.setServletName(servletName);
                    servlet.setServletClass(className);
                    ServletMapping25 servletMapping = (ServletMapping25)webApp.createBean("ServletMapping");
                    servletMapping.setServletName(servletName);
                    servletMapping.addUrlPattern(urlPattern);
                    webApp.addServlet(servlet);
                    webApp.addServletMapping((ServletMapping)servletMapping);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            webApp.write(ddFo);
        }
    }

    private static void addWebXmlOAuthArtifacts(FileObject ddFo, String parentClassName, String packageName) throws IOException {
        String[] servletNames = new String[]{"OAuthLoginServlet", "OAuthCallbackServlet"};
        String[] urlPatterns = new String[]{"/OAuthLogin", "/OAuthCallback"};
        WebApp webApp = DDProvider.getDefault().getDDRoot(ddFo);
        if (webApp != null) {
            for (int i = 0; i < servletNames.length; ++i) {
                String servletName = parentClassName + "$" + servletNames[i];
                String className = packageName + "." + servletName;
                try {
                    Servlet servlet = (Servlet)webApp.createBean("Servlet");
                    servlet.setServletName(servletName);
                    servlet.setServletClass(className);
                    ServletMapping25 servletMapping = (ServletMapping25)webApp.createBean("ServletMapping");
                    servletMapping.setServletName(servletName);
                    servletMapping.addUrlPattern(urlPatterns[i]);
                    webApp.addServlet(servlet);
                    webApp.addServletMapping((ServletMapping)servletMapping);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            webApp.write(ddFo);
        }
    }

    static enum HttpMimeType {
        XML("application/xml", "javax.ws.rs.core.MediaType.APPLICATION_XML"),
        JSON("application/json", "javax.ws.rs.core.MediaType.APPLICATION_JSON"),
        TEXT("text/plain", "javax.ws.rs.core.MediaType.TEXT_PLAIN"),
        HTML("text/html", "javax.ws.rs.core.MediaType.TEXT_HTML"),
        TEXT_XML("text/xml", "javax.ws.rs.core.MediaType.TEXT_XML"),
        FORM("application/x-www-form-urlencoded", "javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED");

        private String mimeType;
        private String mediaType;

        private HttpMimeType(String mimeType, String mediaType) {
            this.mimeType = mimeType;
            this.mediaType = mediaType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getMediaType() {
            return this.mediaType;
        }
    }

    static class ResourcePath {
        private PathFormat pathFormat;
        private String path;

        public ResourcePath() {
        }

        public ResourcePath(PathFormat pathFormat, String path) {
            this.pathFormat = pathFormat;
            this.path = path;
        }

        public PathFormat getPathFormat() {
            return this.pathFormat;
        }

        public void setPathFormat(PathFormat pathFormat) {
            this.pathFormat = pathFormat;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    static class PathFormat {
        private static final String ARG = "arg";
        private String pattern;
        private String[] arguments;
        private Set<String> javaIds = new HashSet<String>();

        PathFormat() {
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setArguments(String[] arguments) {
            this.arguments = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                this.arguments[i] = this.getJavaIdentifier(arguments[i]);
            }
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        private String getJavaIdentifier(String arg) {
            if (arg.length() == 0) {
                return this.getUniqueArgument(ARG);
            }
            char first = arg.charAt(0);
            if (Character.isJavaIdentifierStart(first)) {
                int index = -1;
                for (int i = 1; i < arg.length(); ++i) {
                    if (Character.isJavaIdentifierPart(arg.charAt(i))) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    return this.getUniqueArgument(arg);
                }
                String start = arg.substring(0, index);
                String end = "";
                if (index < arg.length() - 1) {
                    end = arg.substring(index + 1);
                }
                if (end.length() > 0) {
                    end = Character.toUpperCase(end.charAt(0)) + end.substring(1);
                }
                return this.getUniqueArgument(start + end);
            }
            return this.getJavaIdentifier(arg.substring(1));
        }

        private String getUniqueArgument(String base) {
            String result = base;
            int count = 1;
            while (this.javaIds.contains(result)) {
                result = base + count;
                ++count;
            }
            this.javaIds.add(result);
            return result;
        }
    }
}

