/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.netbeans.modules.docker.ChunkedOutputStream;
import org.netbeans.modules.docker.IgnoreFileFilter;
import org.netbeans.modules.docker.api.DockerInstance;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class FolderUploader {
    private static final Logger LOGGER = Logger.getLogger(FolderUploader.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(FolderUploader.class);
    private final DockerInstance instance;
    private final OutputStream os;

    public FolderUploader(DockerInstance instance, OutputStream os) {
        this.instance = instance;
        this.os = os;
    }

    public Future<Void> upload(final FileObject folder, final IgnoreFileFilter filter, final Listener listener) {
        return RP.submit((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws IOException, ArchiveException {
                ChunkedOutputStream cos = new ChunkedOutputStream(new BufferedOutputStream(FolderUploader.this.os));
                try {
                    GZIPOutputStream gzos = new GZIPOutputStream(cos);
                    try {
                        TarArchiveOutputStream aos = new TarArchiveOutputStream((OutputStream)gzos);
                        aos.setLongFileMode(3);
                        try {
                            FileObject context = folder;
                            Enumeration e = context.getChildren(true);
                            while (e.hasMoreElements()) {
                                String path;
                                FileObject child = (FileObject)e.nextElement();
                                if (child.isFolder() || !filter.accept(path = FileUtil.getRelativePath((FileObject)context, (FileObject)child))) continue;
                                listener.onUpload(path);
                                LOGGER.log(Level.FINE, "Uploading {0}", path);
                                TarArchiveEntry entry = new TarArchiveEntry((File)new FileObjectAdapter(child), path);
                                aos.putArchiveEntry(entry);
                                try (BufferedInputStream is = new BufferedInputStream(child.getInputStream());){
                                    FileUtil.copy((InputStream)is, (OutputStream)aos);
                                }
                                aos.closeArchiveEntry();
                            }
                        }
                        finally {
                            aos.finish();
                            aos.flush();
                        }
                    }
                    finally {
                        gzos.finish();
                        gzos.flush();
                    }
                }
                finally {
                    cos.finish();
                    cos.flush();
                }
                return null;
            }
        });
    }

    private static final class FileObjectAdapter
    extends File {
        private final FileObject fo;

        public FileObjectAdapter(FileObject fo) {
            super(fo.getPath());
            this.fo = fo;
        }

        @Override
        public boolean isDirectory() {
            return this.fo.isFolder();
        }

        @Override
        public long lastModified() {
            return this.fo.lastModified().getTime();
        }

        @Override
        public long length() {
            return this.fo.getSize();
        }
    }

    public static interface Listener {
        public void onUpload(String var1);
    }
}

