/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.layout;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.layout.Layout;
import org.primefaces.component.layout.LayoutUnit;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class LayoutRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Layout layout = (Layout)component;
        String clientId = layout.getClientId(context);
        this.encodeScript(context, layout);
        if (layout.isElementLayout()) {
            writer.startElement("div", (UIComponent)layout);
            writer.writeAttribute("id", (Object)clientId, "id");
            if (layout.getStyle() != null) {
                writer.writeAttribute("style", (Object)layout.getStyle(), "style");
            }
            if (layout.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)layout.getStyleClass(), "styleClass");
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Layout layout = (Layout)component;
        if (layout.isElementLayout()) {
            writer.endElement("div");
        }
    }

    protected void encodeScript(FacesContext context, Layout layout) throws IOException {
        String clientId = layout.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Layout", layout.resolveWidgetVar(), clientId, "layout").attr("full", layout.isFullPage(), false).attr("useStateCookie", layout.isStateful(), false);
        if (layout.isNested()) {
            wb.attr("parent", layout.getParent().getClientId(context));
        }
        wb.callback("onToggle", "function(e)", layout.getOnToggle()).callback("onClose", "function(e)", layout.getOnClose()).callback("onResize", "function(e)", layout.getOnResize());
        this.encodeUnits(context, layout, wb);
        this.encodeClientBehaviors(context, layout);
        wb.finish();
    }

    protected void encodeUnits(FacesContext context, Layout layout, WidgetBuilder wb) throws IOException {
        for (UIComponent child : layout.getChildren()) {
            if (!child.isRendered() || !(child instanceof LayoutUnit)) continue;
            LayoutUnit unit = (LayoutUnit)child;
            wb.append(",").append(unit.getPosition()).append(":{").append("paneSelector:'").append(ComponentUtils.escapeJQueryId(unit.getClientId(context))).append("'").attr("size", unit.getSize()).attr("resizable", unit.isResizable()).attr("closable", unit.isCollapsible()).attr("minSize", unit.getMinSize(), 50).attr("maxSize", unit.getMaxSize(), 0);
            if (unit.isCollapsible()) {
                wb.attr("spacing_open", unit.getGutter()).attr("spacing_closed", unit.getCollapseSize());
            }
            wb.attr("initHidden", !unit.isVisible(), false).attr("initClosed", unit.isCollapsed(), false).attr("fxName", unit.getEffect(), null).attr("fxSpeed", unit.getEffectSpeed(), null).attr("resizerTip", layout.getResizeTitle(), null).attr("togglerTip_closed", layout.getExpandTitle(), null);
            wb.append("}");
        }
    }
}

