/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.debug.clientImpl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import org.apache.bsf.debug.clientImpl.ClientStubTable;
import org.apache.bsf.debug.meta.DebugManagerStub;
import org.apache.bsf.debug.meta.DebuggerDispatcher;
import org.apache.bsf.debug.meta.JsCallbacksDispatcher;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.debug.util.Dispatcher;
import org.apache.bsf.debug.util.ResultCell;
import org.apache.bsf.debug.util.SocketConnection;

public class ClientConnection
extends SocketConnection
implements Runnable {
    int CommandIdGenerator = 1;
    Socket fSocket;
    Thread fThread;
    private static final int SOCKET_TIMEOUT = 100;
    Dispatcher[] m_dispatchers;
    DebugManagerStub m_debugManager;

    public ClientConnection(String string, int n) throws IOException {
        int n2 = -1;
        this.fStubs = new ClientStubTable(this);
        this.m_dispatchers = new Dispatcher[2];
        this.m_dispatchers[0] = new DebuggerDispatcher(this);
        this.m_dispatchers[1] = new JsCallbacksDispatcher(this);
        this.fSocket = new Socket(string, n);
        this.fInputStream = this.fSocket.getInputStream();
        this.fDataInputStream = new DataInputStream(this.fInputStream);
        this.fOutputStream = this.fSocket.getOutputStream();
        this.fDataOutputStream = new DataOutputStream(this.fOutputStream);
        this.fDataOutputStream.writeInt(1);
        this.fDataOutputStream.writeInt(0);
        n2 = this.fDataInputStream.readInt();
        if (n2 == 0) {
            this.fSocket.close();
            this.fSocket = null;
            throw new ProtocolException("Protocol version mismatch.");
        }
        this.fThread = new Thread((Runnable)this, "Socket Listener");
        this.fThread.start();
        this.m_debugManager = new DebugManagerStub(this);
    }

    public DebugManagerStub getDebugManager() {
        return this.m_debugManager;
    }

    public void run() {
        this.listen();
    }

    protected void dispatchInvocation(ResultCell resultCell) throws Exception {
        switch (resultCell.classId) {
            case 108: {
                this.m_dispatchers[0].dispatch(resultCell);
                break;
            }
            case 109: {
                this.m_dispatchers[1].dispatch(resultCell);
                break;
            }
            default: {
                throw new Error("Can't parse the invocation!");
            }
        }
    }

    public void breakConnection() {
        try {
            this.m_debugManager.sendQuitNotice();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopListening();
        try {
            this.fSocket.setSoLinger(false, 0);
            this.fSocket.shutdownInput();
            this.fSocket.close();
            this.fSocket = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void wireExceptionNotify(Exception exception) {
        DebugLog.stdoutPrintln("Disconnected", 1);
        this.m_debugManager.disconnectNotify(exception);
        super.wireExceptionNotify(exception);
    }
}

