/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;

public class ParagraphBlock
extends Block {
    private static final Pattern confluenceBlockStart = Pattern.compile("\\{(code|info|tip|warning|panel|note|toc|noformat)(?:(:[^\\}]*))?\\}");
    private int blockLineCount = 0;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        ++this.blockLineCount;
        ConfluenceLanguage markupLanguage = (ConfluenceLanguage)this.getMarkupLanguage();
        if (ParagraphBlock.paragraphBreakingBlockMatches((MarkupLanguage)markupLanguage, line, offset)) {
            this.setClosed(true);
            return 0;
        }
        Matcher blockStartMatcher = confluenceBlockStart.matcher(line);
        if (offset > 0) {
            blockStartMatcher.region(offset, line.length());
        }
        if (blockStartMatcher.find()) {
            int end = blockStartMatcher.start();
            if (end > offset) {
                markupLanguage.emitMarkupLine(this.getParser(), this.state, offset, line.substring(offset, end), 0);
            }
            this.setClosed(true);
            return end;
        }
        if (this.blockLineCount > 1) {
            this.builder.lineBreak();
        }
        markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    static boolean paragraphBreakingBlockMatches(MarkupLanguage language, String line, int offset) {
        ConfluenceLanguage markupLanguage = (ConfluenceLanguage)language;
        for (Block block : markupLanguage.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            return true;
        }
        return false;
    }
}

