/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api.config;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.eecommon.api.config.AppClientVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.ApplicationVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.EjbJarVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.ServletVersion;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class J2eeModuleHelper {
    public static final String WEB_INF = "WEB-INF";
    public static final String GF_WEB_XML_V1 = "WEB-INF" + File.separatorChar + "sun-web.xml";
    public static final String GF_WEB_XML_V2 = "WEB-INF" + File.separatorChar + "glassfish-web.xml";
    private static final Map<Object, J2eeModuleHelper> helperMap;
    private static final Map<Object, J2eeModuleHelper> gfhelperMap;
    private final Object moduleType;
    private final String standardDDName;
    private final String webserviceDDName;
    private final String primarySunDDName;
    private final String secondarySunDDName;

    public static boolean isGlassFishWeb(J2eeModule module) {
        File webXml = module.getDeploymentConfigurationFile(GF_WEB_XML_V2);
        return webXml.canRead();
    }

    public static final J2eeModuleHelper getSunDDModuleHelper(Object type) {
        return helperMap.get(type);
    }

    public static final J2eeModuleHelper getGlassfishDDModuleHelper(Object type) {
        return gfhelperMap.get(type);
    }

    public static final J2eeModuleHelper getWsModuleHelper(String primarySunDDName) {
        return new WebServerDDHelper(primarySunDDName);
    }

    private J2eeModuleHelper(Object type, String stdDD, String wsDD, String sunDD, String cmpDD) {
        this.moduleType = type;
        this.standardDDName = stdDD;
        this.webserviceDDName = wsDD;
        this.primarySunDDName = sunDD;
        this.secondarySunDDName = cmpDD;
    }

    public Object getJ2eeModule() {
        return this.moduleType;
    }

    public String getStandardDDName() {
        return this.standardDDName;
    }

    public String getWebserviceDDName() {
        return this.webserviceDDName;
    }

    public String getPrimarySunDDName() {
        return this.primarySunDDName;
    }

    public String getSecondarySunDDName() {
        return this.secondarySunDDName;
    }

    public File getPrimarySunDDFile(J2eeModule module) {
        return this.primarySunDDName != null ? module.getDeploymentConfigurationFile(this.primarySunDDName) : null;
    }

    public File getSecondarySunDDFile(J2eeModule module) {
        return this.secondarySunDDName != null ? module.getDeploymentConfigurationFile(this.secondarySunDDName) : null;
    }

    public RootInterface getStandardRootDD(J2eeModule module) {
        File ddFile;
        RootInterface stdRootDD = null;
        if (this.standardDDName != null && (ddFile = module.getDeploymentConfigurationFile(this.standardDDName)).exists()) {
            FileUtil.normalizeFile((File)ddFile);
            FileObject ddFO = FileUtil.toFileObject((File)ddFile);
            try {
                stdRootDD = this.getStandardRootDD(ddFO);
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish-eecommon").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return stdRootDD;
    }

    public Webservices getWebServicesRootDD(J2eeModule module) {
        File ddFile;
        Webservices wsRootDD = null;
        if (this.webserviceDDName != null && (ddFile = module.getDeploymentConfigurationFile(this.webserviceDDName)).exists()) {
            FileObject ddFO = FileUtil.toFileObject((File)ddFile);
            try {
                wsRootDD = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(ddFO);
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish-eecommon").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return wsRootDD;
    }

    protected abstract RootInterface getStandardRootDD(FileObject var1) throws IOException;

    protected abstract ASDDVersion getMinASVersion(String var1, ASDDVersion var2);

    static {
        HashMap<J2eeModule.Type, J2eeModuleHelper> map = new HashMap<J2eeModule.Type, J2eeModuleHelper>();
        map.put(J2eeModule.Type.WAR, new WebDDHelper());
        map.put(J2eeModule.Type.EJB, new EjbDDHelper());
        map.put(J2eeModule.Type.EAR, new EarDDHelper());
        map.put(J2eeModule.Type.CAR, new ClientDDHelper());
        helperMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(J2eeModule.Type.WAR, new WebDDHelper(GF_WEB_XML_V2, null));
        map.put(J2eeModule.Type.EJB, new EjbDDHelper("META-INF/glassfish-ejb-jar.xml", "META-INF/glassfish-cmp-mappings.xml"));
        map.put(J2eeModule.Type.EAR, new EarDDHelper("META-INF/glassfish-application.xml", null));
        map.put(J2eeModule.Type.CAR, new ClientDDHelper("META-INF/glassfish-application-client.xml", null));
        gfhelperMap = Collections.unmodifiableMap(map);
    }

    public static class ClientDDHelper
    extends J2eeModuleHelper {
        private ClientDDHelper() {
            this("META-INF/sun-application-client.xml", null);
        }

        private ClientDDHelper(String dd1, String dd2) {
            super(J2eeModule.CLIENT, "application-client.xml", null, dd1, dd2);
        }

        @Override
        protected RootInterface getStandardRootDD(FileObject ddFO) throws IOException {
            return DDProvider.getDefault().getDDRoot(ddFO);
        }

        @Override
        protected ASDDVersion getMinASVersion(String j2eeModuleVersion, ASDDVersion defaultVersion) {
            ASDDVersion result = defaultVersion;
            AppClientVersion appClientVersion = AppClientVersion.getAppClientVersion(j2eeModuleVersion);
            if (AppClientVersion.APP_CLIENT_1_4.equals(appClientVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (AppClientVersion.APP_CLIENT_5_0.equals(appClientVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            } else if (AppClientVersion.APP_CLIENT_6_0.equals(appClientVersion)) {
                result = ASDDVersion.SUN_APPSERVER_10_0;
            } else if (AppClientVersion.APP_CLIENT_7_0.equals(appClientVersion)) {
                result = ASDDVersion.GLASSFISH_4_1;
            } else if (AppClientVersion.APP_CLIENT_8_0.equals(appClientVersion)) {
                result = ASDDVersion.GLASSFISH_5_1;
            } else if (AppClientVersion.APP_CLIENT_9_0.equals(appClientVersion)) {
                result = ASDDVersion.GLASSFISH_6;
            } else if (AppClientVersion.APP_CLIENT_10_0.equals(appClientVersion)) {
                result = ASDDVersion.GLASSFISH_7;
            }
            return result;
        }
    }

    public static class EarDDHelper
    extends J2eeModuleHelper {
        private EarDDHelper() {
            this("META-INF/sun-application.xml", null);
        }

        private EarDDHelper(String dd1, String dd2) {
            super(J2eeModule.EAR, "application.xml", null, dd1, dd2);
        }

        @Override
        protected RootInterface getStandardRootDD(FileObject ddFO) throws IOException {
            return org.netbeans.modules.j2ee.dd.api.application.DDProvider.getDefault().getDDRoot(ddFO);
        }

        @Override
        protected ASDDVersion getMinASVersion(String j2eeModuleVersion, ASDDVersion defaultVersion) {
            ASDDVersion result = defaultVersion;
            ApplicationVersion applicationVersion = ApplicationVersion.getApplicationVersion(j2eeModuleVersion);
            if (ApplicationVersion.APPLICATION_1_4.equals(applicationVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (ApplicationVersion.APPLICATION_5_0.equals(applicationVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            } else if (ApplicationVersion.APPLICATION_6_0.equals(applicationVersion)) {
                result = ASDDVersion.SUN_APPSERVER_10_0;
            } else if (ApplicationVersion.APPLICATION_7_0.equals(applicationVersion)) {
                result = ASDDVersion.GLASSFISH_4_1;
            } else if (ApplicationVersion.APPLICATION_8_0.equals(applicationVersion)) {
                result = ASDDVersion.GLASSFISH_5_1;
            } else if (ApplicationVersion.APPLICATION_9_0.equals(applicationVersion)) {
                result = ASDDVersion.GLASSFISH_6;
            } else if (ApplicationVersion.APPLICATION_10_0.equals(applicationVersion)) {
                result = ASDDVersion.GLASSFISH_7;
            }
            return result;
        }
    }

    public static class EjbDDHelper
    extends J2eeModuleHelper {
        private EjbDDHelper() {
            this("META-INF/sun-ejb-jar.xml", "META-INF/sun-cmp-mappings.xml");
        }

        private EjbDDHelper(String dd1, String dd2) {
            super(J2eeModule.EJB, "ejb-jar.xml", "webservices.xml", dd1, dd2);
        }

        @Override
        protected RootInterface getStandardRootDD(FileObject ddFO) throws IOException {
            return org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getDDRoot(ddFO);
        }

        @Override
        protected ASDDVersion getMinASVersion(String j2eeModuleVersion, ASDDVersion defaultVersion) {
            ASDDVersion result = defaultVersion;
            EjbJarVersion ejbJarVersion = EjbJarVersion.getEjbJarVersion(j2eeModuleVersion);
            if (EjbJarVersion.EJBJAR_2_1.equals(ejbJarVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (EjbJarVersion.EJBJAR_3_0.equals(ejbJarVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            } else if (EjbJarVersion.EJBJAR_3_1.equals(ejbJarVersion)) {
                result = ASDDVersion.SUN_APPSERVER_10_0;
            } else if (EjbJarVersion.EJBJAR_3_2.equals(ejbJarVersion)) {
                result = ASDDVersion.GLASSFISH_4_1;
            } else if (EjbJarVersion.EJBJAR_3_2_6.equals(ejbJarVersion)) {
                result = ASDDVersion.GLASSFISH_5_1;
            } else if (EjbJarVersion.EJBJAR_4_0.equals(ejbJarVersion)) {
                result = ASDDVersion.GLASSFISH_7;
            }
            return result;
        }
    }

    public static class WebServerDDHelper
    extends J2eeModuleHelper {
        private WebServerDDHelper(String primarySunDDName) {
            super(J2eeModule.WAR, "WEB-INF/web.xml", "WEB-INF/webservices.xml", primarySunDDName, null);
        }

        @Override
        protected RootInterface getStandardRootDD(FileObject ddFO) throws IOException {
            return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(ddFO);
        }

        @Override
        protected ASDDVersion getMinASVersion(String j2eeModuleVersion, ASDDVersion defaultVersion) {
            ASDDVersion result = defaultVersion;
            ServletVersion servletVersion = ServletVersion.getServletVersion(j2eeModuleVersion);
            if (ServletVersion.SERVLET_2_4.equals(servletVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (ServletVersion.SERVLET_2_5.equals(servletVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            } else if (ServletVersion.SERVLET_3_0.equals(servletVersion)) {
                result = ASDDVersion.SUN_APPSERVER_10_0;
            } else if (ServletVersion.SERVLET_4_0.equals(servletVersion)) {
                result = ASDDVersion.GLASSFISH_5_1;
            } else if (ServletVersion.SERVLET_5_0.equals(servletVersion)) {
                result = ASDDVersion.GLASSFISH_6;
            } else if (ServletVersion.SERVLET_6_0.equals(servletVersion)) {
                result = ASDDVersion.GLASSFISH_7;
            }
            return result;
        }
    }

    public static class WebDDHelper
    extends J2eeModuleHelper {
        private WebDDHelper() {
            this(GF_WEB_XML_V2, null);
        }

        private WebDDHelper(String dd1, String dd2) {
            super(J2eeModule.WAR, "WEB-INF/web.xml", "WEB-INF/webservices.xml", dd1, dd2);
        }

        @Override
        protected RootInterface getStandardRootDD(FileObject ddFO) throws IOException {
            return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(ddFO);
        }

        @Override
        protected ASDDVersion getMinASVersion(String j2eeModuleVersion, ASDDVersion defaultVersion) {
            ASDDVersion result = defaultVersion;
            ServletVersion servletVersion = ServletVersion.getServletVersion(j2eeModuleVersion);
            if (ServletVersion.SERVLET_2_4.equals(servletVersion)) {
                result = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (ServletVersion.SERVLET_2_5.equals(servletVersion)) {
                result = ASDDVersion.SUN_APPSERVER_9_0;
            } else if (ServletVersion.SERVLET_3_0.equals(servletVersion)) {
                result = ASDDVersion.SUN_APPSERVER_10_0;
            } else if (ServletVersion.SERVLET_4_0.equals(servletVersion)) {
                result = ASDDVersion.GLASSFISH_5_1;
            }
            return result;
        }
    }
}

