/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAutonomousDatabaseBackupRequest
extends BmcRequest<Void> {
    private String autonomousDatabaseBackupId;
    private String opcRequestId;

    public String getAutonomousDatabaseBackupId() {
        return this.autonomousDatabaseBackupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().autonomousDatabaseBackupId(this.autonomousDatabaseBackupId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousDatabaseBackupId=").append(String.valueOf(this.autonomousDatabaseBackupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAutonomousDatabaseBackupRequest)) {
            return false;
        }
        GetAutonomousDatabaseBackupRequest other = (GetAutonomousDatabaseBackupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousDatabaseBackupId, other.autonomousDatabaseBackupId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousDatabaseBackupId == null ? 43 : this.autonomousDatabaseBackupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAutonomousDatabaseBackupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousDatabaseBackupId = null;
        private String opcRequestId = null;

        public Builder autonomousDatabaseBackupId(String autonomousDatabaseBackupId) {
            this.autonomousDatabaseBackupId = autonomousDatabaseBackupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAutonomousDatabaseBackupRequest o) {
            this.autonomousDatabaseBackupId(o.getAutonomousDatabaseBackupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAutonomousDatabaseBackupRequest build() {
            GetAutonomousDatabaseBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAutonomousDatabaseBackupRequest buildWithoutInvocationCallback() {
            GetAutonomousDatabaseBackupRequest request = new GetAutonomousDatabaseBackupRequest();
            request.autonomousDatabaseBackupId = this.autonomousDatabaseBackupId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

