/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.project;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.TextAction;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.j2seproject.api.J2SECategoryExtensionProvider;
import org.netbeans.modules.jshell.project.Bundle;
import org.netbeans.modules.jshell.project.RunOptionsModel;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JShellOptions2
extends JPanel
implements ItemListener {
    private final Project project;
    private J2SECategoryExtensionProvider.ConfigChangeListener listener;
    private ChangeListener changeListener;
    private Map<String, String> changedOptions = new HashMap<String, String>();
    private List<JComponent> hideControls = new ArrayList<JComponent>();
    private ElementHandle<TypeElement> targetClass;
    private String oldText;
    private ClasspathInfo cpi;
    private String message;
    private boolean disableUpdates = false;
    private JButton btnBrowseClass;
    private ButtonGroup buttonGroup1;
    private JCheckBox cSwingExecutor;
    private JComboBox cbMember;
    private JCheckBox checkEnable;
    private JLabel lblLoaderSelect;
    private JLabel lblMember;
    private JLabel lblSource;
    private JComboBox loaderSelect;
    private JPanel optsPanel;
    private JTextField source;

    public JShellOptions2(Project project) {
        this.project = project;
        this.initComponents();
        DefaultComboBoxModel<RunOptionsModel.LoaderPolicy> mdl = new DefaultComboBoxModel<RunOptionsModel.LoaderPolicy>();
        mdl.addElement(RunOptionsModel.LoaderPolicy.SYSTEM);
        mdl.addElement(RunOptionsModel.LoaderPolicy.CLASS);
        mdl.addElement(RunOptionsModel.LoaderPolicy.EVAL);
        this.loaderSelect.setModel(mdl);
        this.loaderSelect.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                RunOptionsModel.LoaderPolicy pol = (RunOptionsModel.LoaderPolicy)((Object)value);
                if (pol == null) {
                    pol = RunOptionsModel.LoaderPolicy.SYSTEM;
                }
                this.setText(NbBundle.getMessage(JShellOptions2.class, (String)("JShellOptions.loader." + pol.name().toLowerCase())));
                return this;
            }
        });
        this.source.addActionListener(this::classNameChanged);
        this.source.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getComponent() == JShellOptions2.this.source) {
                    JShellOptions2.this.classNameChanged(null);
                }
            }
        });
        this.loaderSelect.addItemListener(this);
        this.cbMember.setRenderer(new MemberRenderer());
        this.source.getActionMap().put("type-browse", new BrowseAction());
        this.source.getInputMap().put(KeyStroke.getKeyStroke(32, 128), "type-browse");
        this.enableDisable();
    }

    public Project getProject() {
        return this.project;
    }

    private void classNameChanged(ActionEvent ac) {
        final String s = this.source.getText().trim();
        if (s.equals(this.oldText)) {
            return;
        }
        if (this.loaderSelect.getSelectedItem() == RunOptionsModel.LoaderPolicy.SYSTEM) {
            return;
        }
        try {
            class UT
            extends UserTask
            implements ClasspathInfo.Provider {
                UT() {
                }

                public ClasspathInfo getClasspathInfo() {
                    return JShellOptions2.this.getClasspathInfo();
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationInfo cc = CompilationInfo.get((Parser.Result)resultIterator.getParserResult());
                    TypeElement tel = cc.getElements().getTypeElement(s);
                    if (tel != null) {
                        JShellOptions2.this.targetClass = ElementHandle.create((Element)tel);
                        return;
                    }
                    JShellOptions2.this.targetClass = null;
                }
            }
            ParserManager.parse((String)"text/x-java", (UserTask)new UT());
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.message = null;
        if (this.targetClass == null) {
            this.message = Bundle.ERR_ClassNameInvalid();
        } else {
            this.changedOptions.put("jshell.classloader.from.class", s);
        }
        this.updateMembers();
        this.oldText = s;
        if (this.disableUpdates) {
            return;
        }
        this.storeChanges();
    }

    public boolean isPanelValid() {
        return this.message == null;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public Map<String, String> getChangedOptions() {
        return this.changedOptions;
    }

    public void setConfigChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public void setConfigChangeListener(J2SECategoryExtensionProvider.ConfigChangeListener l) {
        this.listener = l;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.checkEnable = new JCheckBox();
        this.optsPanel = new JPanel();
        this.lblLoaderSelect = new JLabel();
        this.loaderSelect = new JComboBox();
        this.lblSource = new JLabel();
        this.source = new JTextField();
        this.lblMember = new JLabel();
        this.btnBrowseClass = new JButton();
        this.cbMember = new JComboBox();
        this.cSwingExecutor = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.checkEnable, (String)NbBundle.getMessage(JShellOptions2.class, (String)"JShellOptions2.checkEnable.text"));
        this.checkEnable.setBorder(null);
        this.checkEnable.setLabel(NbBundle.getMessage(JShellOptions2.class, (String)"CHECK_EnableJShell"));
        this.checkEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JShellOptions2.this.checkEnableActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblLoaderSelect, (String)NbBundle.getMessage(JShellOptions2.class, (String)"JShellOptions2.lblLoaderSelect.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblSource, (String)NbBundle.getMessage(JShellOptions2.class, (String)"JShellOptions2.lblSource.text"));
        this.lblSource.setEnabled(false);
        this.source.setText(NbBundle.getMessage(JShellOptions2.class, (String)"JShellOptions2.source.text"));
        this.source.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.lblMember, (String)NbBundle.getMessage(JShellOptions2.class, (String)"JShellOptions2.lblMember.text"));
        this.lblMember.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btnBrowseClass, (String)NbBundle.getMessage(JShellOptions2.class, (String)"JShellOptions2.btnBrowseClass.text"));
        this.btnBrowseClass.setEnabled(false);
        this.btnBrowseClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JShellOptions2.this.btnBrowseClassActionPerformed(evt);
            }
        });
        this.cbMember.setEnabled(false);
        this.cbMember.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JShellOptions2.this.cbMemberActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cSwingExecutor, (String)NbBundle.getMessage(JShellOptions2.class, (String)"JShellOptions2.cSwingExecutor.text"));
        this.cSwingExecutor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JShellOptions2.this.cSwingExecutorActionPerformed(evt);
            }
        });
        GroupLayout optsPanelLayout = new GroupLayout(this.optsPanel);
        this.optsPanel.setLayout(optsPanelLayout);
        optsPanelLayout.setHorizontalGroup(optsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optsPanelLayout.createSequentialGroup().addGroup(optsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optsPanelLayout.createSequentialGroup().addComponent(this.lblLoaderSelect).addGap(4, 4, 4).addComponent(this.loaderSelect, -2, 120, -2).addGap(18, 18, 18).addGroup(optsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblSource, -1, -1, Short.MAX_VALUE).addComponent(this.lblMember, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbMember, -2, 219, -2).addGroup(GroupLayout.Alignment.TRAILING, optsPanelLayout.createSequentialGroup().addComponent(this.source, -2, 218, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseClass)))).addComponent(this.cSwingExecutor)).addContainerGap(-1, Short.MAX_VALUE)));
        optsPanelLayout.setVerticalGroup(optsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optsPanelLayout.createSequentialGroup().addGroup(optsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLoaderSelect).addComponent(this.loaderSelect, -2, -1, -2).addComponent(this.source, -2, -1, -2).addComponent(this.lblSource).addComponent(this.btnBrowseClass)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(optsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMember).addComponent(this.cbMember, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cSwingExecutor).addGap(27, 27, 27)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkEnable).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.optsPanel, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkEnable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void checkEnableActionPerformed(ActionEvent evt) {
        boolean enable = this.checkEnable.isSelected();
        this.enableDisable();
        if (!this.disableUpdates) {
            if (enable) {
                this.changedOptions.put("jshell.run.enable", Boolean.TRUE.toString());
            } else {
                this.changedOptions.put("jshell.run.enable", null);
            }
            this.storeChanges();
        }
    }

    public ClasspathInfo getClasspathInfo() {
        if (this.cpi != null) {
            return this.cpi;
        }
        FileObject fileObject = this.project.getProjectDirectory();
        SourceGroup[] grp = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        ArrayList<FileObject> roots = new ArrayList<FileObject>(grp.length);
        for (SourceGroup sg : grp) {
            roots.add(sg.getRootFolder());
        }
        this.cpi = ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot"), (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()])));
        return this.cpi;
    }

    private void btnBrowseClassActionPerformed(ActionEvent evt) {
        String current;
        final ClasspathInfo cpi = this.getClasspathInfo();
        ElementHandle handle = TypeElementFinder.find((ClasspathInfo)cpi, (String)(current = this.source.getText()), (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                searchScopes.retainAll(Arrays.asList(ClassIndex.SearchScope.SOURCE));
                return cpi.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
            }

            public boolean accept(ElementHandle<TypeElement> typeHandle) {
                return true;
            }
        });
        if (handle == null) {
            return;
        }
        this.targetClass = handle;
        this.source.setText(handle.getQualifiedName());
        this.classNameChanged(null);
    }

    private void cbMemberActionPerformed(ActionEvent evt) {
        Object o = this.cbMember.getSelectedItem();
        if (o != null && !this.disableUpdates) {
            MemberDescription md = (MemberDescription)o;
            if (md.kind == ElementKind.METHOD) {
                this.changedOptions.put("jshell.classloader.from.field", null);
                this.changedOptions.put("jshell.classloader.from.method", md.name);
            } else {
                this.changedOptions.put("jshell.classloader.from.method", null);
                this.changedOptions.put("jshell.classloader.from.field", md.name);
            }
            this.message = null;
            this.storeChanges();
        }
    }

    private void cSwingExecutorActionPerformed(ActionEvent evt) {
        if (this.disableUpdates) {
            return;
        }
        if (this.cSwingExecutor.isSelected()) {
            this.changedOptions.put("jshell.executor", "org.netbeans.lib.jshell.agent.SwingExecutor");
        } else {
            this.changedOptions.put("jshell.executor", null);
        }
        this.storeChanges();
    }

    private void updateMembers() {
        if (this.loaderSelect.getSelectedItem() != RunOptionsModel.LoaderPolicy.EVAL) {
            this.cbMember.getEditor().setItem(null);
            this.cbMember.setEnabled(false);
            return;
        }
        MemberDescription old = (MemberDescription)this.cbMember.getSelectedItem();
        final ArrayList descs = new ArrayList();
        if (this.targetClass != null) {
            try {
                ParserManager.parse((String)"text/x-java", (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationInfo cc = CompilationInfo.get((Parser.Result)resultIterator.getParserResult());
                        TypeElement clazz = (TypeElement)JShellOptions2.this.targetClass.resolve(cc);
                        if (clazz == null) {
                            return;
                        }
                        for (Element element : clazz.getEnclosedElements()) {
                            ElementKind k = element.getKind();
                            if (k != ElementKind.FIELD && (k != ElementKind.METHOD || !((ExecutableElement)element).getParameters().isEmpty()) || clazz.getKind().isClass() && !element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                            String n = element.getSimpleName().toString();
                            String typeString = cc.getTypeUtilities().getTypeName(element.asType(), new TypeUtilities.TypeNameOptions[0]).toString();
                            descs.add(new MemberDescription(k, n, element.getModifiers(), typeString));
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (descs.isEmpty()) {
                this.message = Bundle.ERR_NoSuitableMembers();
            }
        }
        DefaultComboBoxModel<MemberDescription> mdl = new DefaultComboBoxModel<MemberDescription>(descs.toArray(new MemberDescription[descs.size()]));
        this.cbMember.setModel(mdl);
        this.cbMember.setSelectedItem(old);
        if (this.cbMember.getItemCount() == 0) {
            this.cbMember.setEnabled(false);
            return;
        }
        this.cbMember.setEnabled(true);
        if (this.cbMember.getSelectedItem() == null || !this.cbMember.getSelectedItem().equals(old)) {
            this.cbMember.setSelectedIndex(0);
            if (!this.disableUpdates) {
                this.cbMemberActionPerformed(null);
            }
        }
    }

    private void storeChanges() {
        if (this.listener != null) {
            this.listener.propertiesChanged(this.changedOptions);
        }
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void readOptions(Map<String, String> opts) {
        RunOptionsModel.LoaderPolicy pol;
        this.disableUpdates = true;
        boolean enabled = Boolean.parseBoolean(opts.getOrDefault("jshell.run.enable", Boolean.FALSE.toString()));
        this.checkEnable.setSelected(enabled);
        String polString = opts.getOrDefault("jshell.run.classloader", RunOptionsModel.LoaderPolicy.SYSTEM.name()).toUpperCase();
        try {
            pol = RunOptionsModel.LoaderPolicy.valueOf(polString);
        }
        catch (IllegalArgumentException ex) {
            pol = RunOptionsModel.LoaderPolicy.SYSTEM;
        }
        String cn = opts.get("jshell.classloader.from.class");
        String f = opts.get("jshell.classloader.from.field");
        String m = opts.get("jshell.classloader.from.method");
        if (cn == null) {
            pol = RunOptionsModel.LoaderPolicy.SYSTEM;
        } else if (f == null && m == null) {
            pol = RunOptionsModel.LoaderPolicy.CLASS;
        }
        this.message = null;
        this.setPolicy(pol);
        this.setClassName(cn);
        this.setMethodOrFieldName(cn, f, m);
        this.cSwingExecutor.setSelected("org.netbeans.lib.jshell.agent.SwingExecutor".equals(opts.get("jshell.executor")));
        this.disableUpdates = false;
        this.enableDisable();
    }

    private void enableDisable() {
        this.optsPanel.setVisible(this.checkEnable.isSelected());
        if (this.checkEnable.isSelected()) {
            Object o = this.loaderSelect.getSelectedItem();
            boolean b = o != null && o != RunOptionsModel.LoaderPolicy.SYSTEM;
            this.source.setEnabled(b);
            this.lblSource.setEnabled(b);
            this.btnBrowseClass.setEnabled(b);
            this.lblMember.setEnabled(o == RunOptionsModel.LoaderPolicy.EVAL);
            this.cbMember.setEnabled(o == RunOptionsModel.LoaderPolicy.EVAL);
        }
        this.invalidate();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableDisable();
        if (this.disableUpdates) {
            return;
        }
        Object o = this.loaderSelect.getSelectedItem();
        if (o == null) {
            o = RunOptionsModel.LoaderPolicy.SYSTEM;
        }
        RunOptionsModel.LoaderPolicy pol = (RunOptionsModel.LoaderPolicy)((Object)o);
        this.changedOptions.put("jshell.run.classloader", o.toString().toLowerCase());
        switch ((RunOptionsModel.LoaderPolicy)((Object)o)) {
            case SYSTEM: {
                this.changedOptions.remove("jshell.classloader.from.class");
            }
            case CLASS: {
                this.changedOptions.remove("jshell.classloader.from.field");
                this.changedOptions.remove("jshell.classloader.from.method");
            }
        }
        this.oldText = null;
        this.classNameChanged(null);
        this.storeChanges();
    }

    public void setPolicy(RunOptionsModel.LoaderPolicy policy) {
        this.disableUpdates = true;
        this.loaderSelect.setSelectedItem((Object)policy);
        this.disableUpdates = false;
    }

    public void setClassName(String name) {
        this.disableUpdates = true;
        this.source.setText(name);
        this.oldText = null;
        this.classNameChanged(null);
        this.disableUpdates = false;
    }

    public void setMethodOrFieldName(String clazz, String method, String field) {
        this.disableUpdates = true;
        this.updateMembers();
        for (int i = 0; i < this.cbMember.getItemCount(); ++i) {
            Object o = this.cbMember.getItemAt(i);
            MemberDescription desc = (MemberDescription)o;
            if (method != null) {
                if (desc.kind != ElementKind.METHOD || !desc.name.equals(method)) continue;
                this.cbMember.setSelectedIndex(i);
                break;
            }
            if (field == null || desc.kind != ElementKind.FIELD || !desc.name.equals(method)) continue;
            this.cbMember.setSelectedIndex(i);
            break;
        }
        this.disableUpdates = false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.disableUpdates = true;
        this.checkEnable.setSelected(enabled);
        this.disableUpdates = true;
    }

    private static class MemberDescription {
        private ElementKind kind;
        private Set<Modifier> modifiers;
        private String name;
        private String typeString;

        public MemberDescription(ElementKind kind, String name, Set<Modifier> modifiers, String typeString) {
            this.kind = kind;
            this.name = name;
            this.typeString = typeString;
            this.modifiers = modifiers;
        }

        public int hashCode() {
            int hash = 3;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MemberDescription other = (MemberDescription)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return this.kind == other.kind;
        }
    }

    private static class MemberRenderer
    extends DefaultListCellRenderer {
        private MemberRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            MemberDescription md = (MemberDescription)value;
            if (md == null) {
                return l;
            }
            l.setIcon(ElementIcons.getElementIcon((ElementKind)md.kind, md.modifiers));
            Object n = md.name;
            if (md.kind == ElementKind.METHOD) {
                n = (String)n + "()";
            }
            l.setText(md.name);
            return l;
        }
    }

    public class BrowseAction
    extends TextAction {
        public BrowseAction() {
            super("type-browse");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JShellOptions2.this.btnBrowseClassActionPerformed(e);
        }
    }
}

