/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class SQLCompletionItem
implements CompletionItem {
    private static final String CATALOG_COLOR = SQLCompletionItem.getHtmlColor(81, 95, 197);
    private static final String SCHEMA_COLOR = SQLCompletionItem.getHtmlColor(0, 102, 102);
    private static final String TABLE_COLOR = SQLCompletionItem.getHtmlColor(204, 120, 0);
    private static final String VIEW_COLOR = SQLCompletionItem.getHtmlColor(187, 120, 0);
    private static final String COLUMN_COLOR = SQLCompletionItem.getHtmlColor(7, 7, 171);
    private static final String KEYWORD_COLOR = SQLCompletionItem.getHtmlColor(0, 81, 128);
    private static final String COLOR_END = "</font>";
    private static final String BOLD = "<b>";
    private static final String BOLD_END = "</b>";
    private static final ImageIcon CATALOG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/catalog.png", (boolean)false);
    private static final ImageIcon SCHEMA_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/schema.png", (boolean)false);
    private static final ImageIcon TABLE_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/table.png", (boolean)false);
    private static final ImageIcon VIEW_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/view.gif", (boolean)false);
    private static final ImageIcon ALIAS_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/alias.png", (boolean)false);
    private static final ImageIcon COLUMN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/column.png", (boolean)false);
    private static final ImageIcon KEYWORD_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/editor/completion/resources/keyword.png", (boolean)false);
    private final SubstitutionHandler substHandler;
    private final String substText;
    private final int substOffset;

    public static SQLCompletionItem catalog(String catalogName, String substText, int substOffset, SubstitutionHandler substHandler) {
        return new Catalog(catalogName, substText, substOffset, substHandler);
    }

    public static SQLCompletionItem schema(String schemaName, String substText, int substOffset, SubstitutionHandler substHandler) {
        return new Schema(schemaName, substText, substOffset, substHandler);
    }

    public static SQLCompletionItem table(String tableName, String substText, int substOffset, SubstitutionHandler substHandler) {
        return new Table(tableName, substText, substOffset, substHandler);
    }

    public static SQLCompletionItem view(String viewName, String substText, int substOffset, SubstitutionHandler substHandler) {
        return new View(viewName, substText, substOffset, substHandler);
    }

    public static SQLCompletionItem alias(String alias, QualIdent tableName, String substText, int substOffset, SubstitutionHandler substHandler) {
        return new Alias(alias, tableName, substText, substOffset, substHandler);
    }

    public static SQLCompletionItem column(boolean view, QualIdent tupleName, String columnName, String dataType, String substText, int substOffset, SubstitutionHandler substHandler) {
        return new Column(view, tupleName, columnName, dataType, substText, substOffset, substHandler);
    }

    public static SQLCompletionItem keyword(String keyword, int substOffset, SubstitutionHandler substHandler) {
        return new Keyword(keyword, substOffset, substHandler);
    }

    protected SQLCompletionItem(String substText, int substOffset, SubstitutionHandler substHandler) {
        this.substText = substText;
        this.substOffset = substOffset;
        this.substHandler = substHandler;
    }

    public void defaultAction(JTextComponent component) {
        Completion.get().hideDocumentation();
        Completion.get().hideCompletion();
        this.substHandler.substituteText(component, this.substOffset, this.substText);
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        int width = CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
        return width += 20;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getImageIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return null;
    }

    public CharSequence getInsertPrefix() {
        return this.substText;
    }

    protected abstract ImageIcon getImageIcon();

    protected abstract String getLeftHtmlText();

    protected abstract String getRightHtmlText();

    private void substituteText(JTextComponent component, int offset, int len) {
    }

    private static String getHtmlColor(int r, int g, int b) {
        Color c = LFCustoms.shiftColor((Color)new Color(r, g, b));
        return "<font color=#" + LFCustoms.getHexString((int)c.getRed()) + LFCustoms.getHexString((int)c.getGreen()) + LFCustoms.getHexString((int)c.getBlue()) + ">";
    }

    private static class Keyword
    extends SQLCompletionItem {
        private final String keyword;
        private String leftText;

        public Keyword(String keyword, int substOffset, SubstitutionHandler substHandler) {
            super(keyword, substOffset, substHandler);
            this.keyword = keyword;
        }

        @Override
        protected ImageIcon getImageIcon() {
            return KEYWORD_ICON;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(KEYWORD_COLOR);
                sb.append(SQLCompletionItem.BOLD);
                sb.append(this.keyword);
                sb.append(SQLCompletionItem.BOLD_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        public CharSequence getSortText() {
            return this.keyword;
        }

        @Override
        public int getSortPriority() {
            return 50;
        }

        @Override
        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return "Keyword " + this.keyword;
        }
    }

    private static class Column
    extends SQLCompletionItem {
        private final boolean view;
        private final QualIdent tableName;
        private final String columnName;
        private String leftText;
        private String rightText;
        private final String dataType;

        public Column(boolean view, QualIdent tableName, String columnName, String dataType, String substText, int substOffset, SubstitutionHandler substHandler) {
            super(substText, substOffset, substHandler);
            this.view = view;
            this.tableName = tableName;
            this.columnName = columnName;
            this.dataType = dataType;
        }

        protected String getColumnName() {
            return this.columnName;
        }

        @Override
        protected ImageIcon getImageIcon() {
            return COLUMN_ICON;
        }

        @Override
        public CharSequence getSortText() {
            return this.columnName;
        }

        @Override
        public int getSortPriority() {
            return 100;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(COLUMN_COLOR);
                sb.append(SQLCompletionItem.BOLD);
                sb.append(this.columnName);
                sb.append(SQLCompletionItem.BOLD_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(TABLE_COLOR);
                sb.append(this.tableName.toString());
                sb.append(SQLCompletionItem.COLOR_END);
                this.rightText = MessageFormat.format(NbBundle.getMessage(SQLCompletionItem.class, (String)(this.view ? "MSG_View" : "MSG_Table")), sb.toString());
                sb.setLength(0);
                if (this.dataType != null && !this.dataType.trim().isEmpty()) {
                    sb.append(" (");
                    sb.append(this.dataType.trim());
                    sb.append(")");
                    this.rightText = this.rightText + sb.toString();
                }
            }
            return this.rightText;
        }

        public String toString() {
            return MessageFormat.format("Column {0} in {1} {2}", this.columnName, this.view ? "view" : "table", this.tableName);
        }
    }

    private static final class Alias
    extends SQLCompletionItem {
        private final String alias;
        private final QualIdent tableName;
        private String rightText;

        public Alias(String alias, QualIdent tableName, String substText, int substOffset, SubstitutionHandler substHandler) {
            super(substText, substOffset, substHandler);
            this.alias = alias;
            this.tableName = tableName;
        }

        @Override
        protected ImageIcon getImageIcon() {
            return ALIAS_ICON;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.alias;
        }

        @Override
        public CharSequence getSortText() {
            return this.alias;
        }

        @Override
        public int getSortPriority() {
            return 300;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(TABLE_COLOR);
                sb.append(this.tableName.toString());
                sb.append(SQLCompletionItem.COLOR_END);
                this.rightText = MessageFormat.format(NbBundle.getMessage(SQLCompletionItem.class, (String)"MSG_Alias"), sb.toString());
            }
            return this.rightText;
        }

        public String toString() {
            return MessageFormat.format("Alias {0} to {1}", this.alias, this.tableName);
        }
    }

    private static final class View
    extends SQLCompletionItem {
        private final String viewName;
        private String leftText;

        public View(String viewName, String substText, int substOffset, SubstitutionHandler substHandler) {
            super(substText, substOffset, substHandler);
            this.viewName = viewName;
        }

        @Override
        protected ImageIcon getImageIcon() {
            return VIEW_ICON;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(VIEW_COLOR);
                sb.append(this.viewName);
                sb.append(SQLCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        public CharSequence getSortText() {
            return this.viewName;
        }

        @Override
        public int getSortPriority() {
            return 300;
        }

        @Override
        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("View {0}", this.viewName);
        }
    }

    private static final class Table
    extends SQLCompletionItem {
        private final String tableName;
        private String leftText;

        public Table(String tableName, String substText, int substOffset, SubstitutionHandler substHandler) {
            super(substText, substOffset, substHandler);
            this.tableName = tableName;
        }

        @Override
        protected ImageIcon getImageIcon() {
            return TABLE_ICON;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(TABLE_COLOR);
                sb.append(this.tableName);
                sb.append(SQLCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        public CharSequence getSortText() {
            return this.tableName;
        }

        @Override
        public int getSortPriority() {
            return 200;
        }

        @Override
        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Table {0}", this.tableName);
        }
    }

    private static final class Schema
    extends SQLCompletionItem {
        private final String schemaName;
        private String leftText;

        public Schema(String schemaName, String substText, int substOffset, SubstitutionHandler substHandler) {
            super(substText, substOffset, substHandler);
            this.schemaName = schemaName;
        }

        @Override
        protected ImageIcon getImageIcon() {
            return SCHEMA_ICON;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(SCHEMA_COLOR);
                sb.append(this.schemaName);
                sb.append(SQLCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        public CharSequence getSortText() {
            return this.schemaName;
        }

        @Override
        public int getSortPriority() {
            return 400;
        }

        @Override
        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Schema {0}", this.schemaName);
        }
    }

    private static final class Catalog
    extends SQLCompletionItem {
        private final String catalogName;
        private String leftText;

        public Catalog(String catalogName, String substText, int substOffset, SubstitutionHandler substHandler) {
            super(substText, substOffset, substHandler);
            this.catalogName = catalogName;
        }

        @Override
        protected ImageIcon getImageIcon() {
            return CATALOG_ICON;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(CATALOG_COLOR);
                sb.append(this.catalogName);
                sb.append(SQLCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        public CharSequence getSortText() {
            return this.catalogName;
        }

        @Override
        public int getSortPriority() {
            return 500;
        }

        @Override
        protected String getRightHtmlText() {
            return null;
        }

        public String toString() {
            return MessageFormat.format("Catalog {0}", this.catalogName);
        }
    }
}

