/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.mx.project.Compliance;
import org.netbeans.modules.java.mx.project.CoreSuite;
import org.netbeans.modules.java.mx.project.Jdks;
import org.netbeans.modules.java.mx.project.SuiteProject;
import org.netbeans.modules.java.mx.project.suitepy.MxDistribution;
import org.netbeans.modules.java.mx.project.suitepy.MxImports;
import org.netbeans.modules.java.mx.project.suitepy.MxLibrary;
import org.netbeans.modules.java.mx.project.suitepy.MxProject;
import org.netbeans.modules.java.mx.project.suitepy.MxSuite;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FlaggedClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation2;
import org.netbeans.spi.java.queries.MultipleRootsUnitTestForSourceQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

final class SuiteSources
implements Sources,
BinaryForSourceQueryImplementation2<Group>,
SourceForBinaryQueryImplementation2,
SourceLevelQueryImplementation2,
SubprojectProvider,
MultipleRootsUnitTestForSourceQueryImplementation {
    private static final Logger LOG = Logger.getLogger(SuiteSources.class.getName());
    private static final SuiteSources CORE;
    private final MxSuite suite;
    private final List<Group> groups;
    private final List<Library> libraries;
    private final List<Dist> distributions;
    private final FileObject dir;
    private Map<String, Dep> transitiveDeps;
    private final SuiteProject prj;
    private final Map<String, SuiteSources> imported;
    private final Jdks jdks;

    SuiteSources(SuiteProject owner, Jdks jdks, FileObject dir, MxSuite suite) {
        HashMap<String, Dep> fillDeps = new HashMap<String, Dep>();
        this.prj = owner;
        this.jdks = jdks;
        this.dir = dir;
        this.groups = this.findGroups(fillDeps, suite, dir);
        this.libraries = this.findLibraries(fillDeps, suite);
        this.imported = SuiteSources.findImportedSuites(dir, suite, fillDeps);
        this.distributions = this.findDistributions(suite, this.libraries, this.groups, fillDeps);
        this.suite = suite;
        this.transitiveDeps = fillDeps;
    }

    public String toString() {
        return "MxSources[" + (this.dir == null ? "mx" : this.dir.toURI()) + "]";
    }

    private List<Group> findGroups(Map<String, Dep> fillDeps, MxSuite s, FileObject dir) {
        ArrayList<Group> arr = new ArrayList<Group>();
        for (Map.Entry<String, MxProject> entry : s.projects().entrySet()) {
            MxProject mxPrj;
            String name = entry.getKey();
            FileObject prjDir = SuiteSources.findPrjDir(dir, name, mxPrj = entry.getValue());
            if (prjDir == null) {
                fillDeps.put(name, new Group(name, mxPrj, null, null, null, name, name));
                continue;
            }
            String prevName = null;
            Group firstGroup = null;
            String binPrefix = "mxbuild/";
            for (String rel : mxPrj.sourceDirs()) {
                FileObject srcDir = prjDir.getFileObject(rel);
                FileObject binDir = SuiteSources.getSubDir(dir, binPrefix + name + "/bin");
                FileObject srcGenDir = SuiteSources.getSubDir(dir, binPrefix + name + "/src_gen");
                if (srcDir == null || binDir == null) continue;
                String prgName = name + "-" + rel;
                String displayName = prevName == null ? name : name + "[" + rel + "]";
                Group g = new Group(name, mxPrj, srcDir, srcGenDir, binDir, prgName, displayName);
                arr.add(g);
                if (firstGroup == null) {
                    firstGroup = g;
                }
                prevName = displayName;
            }
            if (firstGroup == null) continue;
            fillDeps.put(name, firstGroup);
        }
        return arr;
    }

    private static FileObject getSubDir(FileObject dir, String relPath) {
        FileObject subDir = dir.getFileObject(relPath);
        if (subDir == null) {
            try {
                subDir = FileUtil.createFolder((FileObject)dir, (String)relPath);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return subDir;
    }

    private List<Library> findLibraries(Map<String, Dep> fillDeps, MxSuite suite) {
        Library library;
        HashMap<String, MxLibrary> allLibraries = new HashMap<String, MxLibrary>();
        SuiteSources.registerLibs(allLibraries, null, suite.libraries());
        ArrayList<Library> arr = new ArrayList<Library>();
        for (Map.Entry entry : allLibraries.entrySet()) {
            library = new Library((String)entry.getKey(), (MxLibrary)entry.getValue());
            arr.add(library);
            fillDeps.put(library.getName(), library);
        }
        for (Map.Entry<Object, Object> entry : suite.jdklibraries().entrySet()) {
            library = new JdkLibrary((String)entry.getKey(), (MxLibrary)entry.getValue());
            arr.add(library);
            fillDeps.put(((JdkLibrary)library).getName(), library);
        }
        return arr;
    }

    private static Map<String, SuiteSources> findImportedSuites(FileObject dir, MxSuite s, Map<String, Dep> fillDeps) {
        if (dir == null) {
            return Collections.emptyMap();
        }
        CORE.registerDeps("mx", fillDeps);
        MxImports imports = s.imports();
        if (imports != null) {
            LinkedHashMap<String, SuiteSources> imported = new LinkedHashMap<String, SuiteSources>();
            for (MxImports.Suite imp : imports.suites()) {
                SuiteSources impSources = SuiteSources.findSuiteSources(dir, imp);
                String suiteName = imp.name();
                if (impSources == null) {
                    LOG.log(Level.INFO, "cannot find imported suite: {0}", suiteName);
                    continue;
                }
                imported.put(suiteName, impSources);
                impSources.registerDeps(suiteName, fillDeps);
            }
            return imported;
        }
        return Collections.emptyMap();
    }

    private List<Dist> findDistributions(MxSuite s, List<Library> libraries, List<Group> groups, Map<String, Dep> fillDeps) {
        ArrayList<Dist> dists = new ArrayList<Dist>();
        for (Map.Entry<String, MxDistribution> entry : s.distributions().entrySet()) {
            Dist d = new Dist(entry.getKey(), entry.getValue());
            dists.add(d);
            fillDeps.put(d.getName(), d);
        }
        return dists;
    }

    final synchronized void ensureTransitiveDependenciesAreComputed() {
        Map<String, Dep> collectedDeps = this.transitiveDeps;
        if (collectedDeps == null) {
            return;
        }
        this.transitiveDeps = null;
        for (Library l : this.libraries) {
            this.transitiveDeps(l, collectedDeps);
        }
        for (Group g : this.groups) {
            this.transitiveDeps(g, collectedDeps);
        }
        for (Dist d : this.distributions) {
            this.transitiveDeps(d, collectedDeps);
        }
        for (Group g : this.groups) {
            g.computeClassPath(collectedDeps);
        }
        for (Dist d : this.distributions) {
            d.computeSourceRoots(collectedDeps);
        }
    }

    private static SuiteSources findSuiteSources(FileObject dir, MxImports.Suite imp) throws IllegalArgumentException {
        SuiteSources sources = SuiteSources.findSuiteSources(dir.getParent(), imp.name());
        if (sources != null) {
            return sources;
        }
        if (imp.subdir()) {
            for (FileObject subDir : dir.getParent().getChildren()) {
                sources = SuiteSources.findSuiteSources(subDir, imp.name());
                if (sources == null) continue;
                return sources;
            }
            for (FileObject subDir : dir.getParent().getParent().getChildren()) {
                sources = SuiteSources.findSuiteSources(subDir, imp.name());
                if (sources == null) continue;
                return sources;
            }
        }
        return null;
    }

    private static SuiteSources findSuiteSources(FileObject root, String name) throws IllegalArgumentException {
        FileObject impDir = root.getFileObject(name);
        if (impDir != null) {
            try {
                Project impPrj = ProjectManager.getDefault().findProject(impDir);
                return impPrj == null ? null : (SuiteSources)impPrj.getLookup().lookup(SuiteSources.class);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public SourceGroup[] getSourceGroups(String string) {
        return this.groups();
    }

    Group[] groups() {
        return this.groups.toArray(new Group[0]);
    }

    Group findGroup(FileObject fo) {
        for (Group g : this.groups) {
            if (!g.contains(fo)) continue;
            return g;
        }
        return null;
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    private static FileObject findPrjDir(FileObject dir, String prjName, MxProject prj) {
        if (dir == null) {
            return null;
        }
        if (prj.dir() != null) {
            return dir.getFileObject(prj.dir());
        }
        if (prj.subDir() != null && (dir = dir.getFileObject(prj.subDir())) == null) {
            return null;
        }
        return dir.getFileObject(prjName);
    }

    private Collection<Dep> transitiveDeps(Dep current, Map<String, Dep> fill) {
        current.owner().ensureTransitiveDependenciesAreComputed();
        Collection<Dep> currentAllDeps = current.allDeps();
        if (currentAllDeps == Collections.emptySet()) {
            throw new IllegalStateException("Cyclic dep on " + current.getName());
        }
        if (currentAllDeps != null) {
            return currentAllDeps;
        }
        current.setAllDeps(Collections.emptySet());
        TreeSet<Dep> computing = new TreeSet<Dep>();
        computing.add(current);
        for (String depName : current.depNames()) {
            int colon;
            Dep dep = fill.get(depName);
            if (dep == null && (dep = fill.get(depName.substring((colon = depName.lastIndexOf(58)) + 1))) == null) {
                LOG.log(Level.INFO, "dep not found: {0}", depName);
                continue;
            }
            Collection<Dep> allDeps = this.transitiveDeps(dep, fill);
            computing.addAll(allDeps);
        }
        current.setAllDeps(computing);
        return computing;
    }

    private static void registerLibs(Map<String, MxLibrary> collect, String prefix, Map<String, MxLibrary> libraries) {
        for (Map.Entry<String, MxLibrary> entry : libraries.entrySet()) {
            String key = entry.getKey();
            MxLibrary lib = entry.getValue();
            if (prefix == null) {
                collect.put(key, lib);
                continue;
            }
            collect.put(prefix + ":" + key, lib);
        }
    }

    private void registerDeps(String prefix, Map<String, Dep> fillDeps) {
        for (Library library : this.libraries) {
            fillDeps.put(prefix + ":" + library.getName(), library);
        }
        for (Dist dist : this.distributions) {
            fillDeps.put(prefix + ":" + dist.getName(), dist);
        }
        for (Map.Entry entry : this.imported.entrySet()) {
            ((SuiteSources)entry.getValue()).registerDeps((String)entry.getKey(), fillDeps);
        }
    }

    public Group findBinaryRoots2(URL url) {
        FileObject srcFo = URLMapper.findFileObject((URL)url);
        for (Group group : this.groups) {
            if (!group.contains(srcFo)) continue;
            return group;
        }
        return null;
    }

    public URL[] computeRoots(Group group) {
        if (group.binDir != null) {
            return new URL[]{group.binDir.toURL()};
        }
        return new URL[0];
    }

    public boolean computePreferBinaries(Group result) {
        return true;
    }

    public void computeChangeListener(Group result, boolean bln, ChangeListener cl) {
    }

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL url) {
        this.ensureTransitiveDependenciesAreComputed();
        for (Dist dist : this.distributions) {
            if (!dist.isRootJar(url)) continue;
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            for (Group d : dist.getContributingGroups()) {
                roots.add(d.srcDir);
                roots.add(d.srcGenDir);
            }
            return new ImmutableResult(roots.toArray(new FileObject[roots.size()]));
        }
        for (Group group : this.groups) {
            if (group.binDir == null || !group.binDir.toURL().equals(url)) continue;
            return new ImmutableResult(group.srcDir, group.srcGenDir);
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL url) {
        return this.findSourceRoots2(url);
    }

    public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject fo) {
        final Group g = this.findGroup(fo);
        if (g == null) {
            return null;
        }
        return new SourceLevelQueryImplementation2.Result2(){

            public SourceLevelQuery.Profile getProfile() {
                return SourceLevelQuery.Profile.DEFAULT;
            }

            public String getSourceLevel() {
                return g.getCompliance().getSourceLevel();
            }

            public void addChangeListener(ChangeListener cl) {
            }

            public void removeChangeListener(ChangeListener cl) {
            }
        };
    }

    public Set<? extends Project> getSubprojects() {
        HashSet<SuiteProject> prjs = new HashSet<SuiteProject>();
        for (SuiteSources imp : this.imported.values()) {
            prjs.add(imp.prj);
        }
        return prjs;
    }

    public URL[] findUnitTests(FileObject fo) {
        return new URL[0];
    }

    public URL[] findSources(FileObject fo) {
        URL[] uRLArray;
        Group g = this.findGroup(fo);
        if (g == null) {
            uRLArray = new URL[]{};
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = g.getRootFolder().toURL();
        }
        return uRLArray;
    }

    static {
        MxSuite coreSuite = CoreSuite.CORE_5_279_0;
        CORE = new SuiteSources(null, null, null, coreSuite);
    }

    private static class ImmutableResult
    implements SourceForBinaryQueryImplementation2.Result {
        private final FileObject[] roots;

        ImmutableResult(FileObject ... candidates) {
            this(Arrays.asList(candidates));
        }

        ImmutableResult(Iterable<FileObject> all) {
            int cnt = 0;
            Iterator<FileObject> it = all.iterator();
            while (it.hasNext()) {
                if (it.next() == null) continue;
                ++cnt;
            }
            it = all.iterator();
            this.roots = new FileObject[cnt];
            int at = 0;
            while (at < cnt) {
                FileObject c = it.next();
                if (c == null) continue;
                this.roots[at++] = c;
            }
        }

        public boolean preferSources() {
            return true;
        }

        public FileObject[] getRoots() {
            return this.roots;
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }
    }

    private class JdkLibrary
    extends Library {
        JdkLibrary(String libName, MxLibrary lib) {
            super(libName, lib);
        }

        @Override
        File getJar(boolean dumpIfMissing) {
            File first = null;
            for (File jdk : SuiteSources.this.jdks.jdks()) {
                File jdkPath;
                File jre = new File(jdk, "jre");
                File jrePath = new File(jre, this.lib.path().replace('/', File.separatorChar));
                if (jrePath.exists()) {
                    return jrePath;
                }
                if (first == null) {
                    first = jrePath;
                }
                if (!(jdkPath = new File(jdk, this.lib.path().replace('/', File.separatorChar))).exists()) continue;
                return jdkPath;
            }
            if (dumpIfMissing) {
                for (File jdk : SuiteSources.this.jdks.jdks()) {
                    File libPath = new File(jdk, this.lib.path().replace('/', File.separatorChar));
                    if (!libPath.exists()) {
                        LOG.log(Level.WARNING, "{0} does not exist", libPath);
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(libPath).append(" exists:\n");
                    String[] kids = libPath.list();
                    if (kids != null) {
                        for (String n : kids) {
                            sb.append("  ").append(n).append("\n");
                        }
                    }
                    LOG.log(Level.INFO, sb.toString());
                    break;
                }
            }
            return first;
        }

        @Override
        public String getName() {
            return this.libName;
        }

        @Override
        public Collection<String> depNames() {
            return this.lib.dependencies();
        }

        @Override
        public Collection<Dep> allDeps() {
            return this.allDeps;
        }

        @Override
        public void setAllDeps(Collection<Dep> set) {
            this.allDeps = set;
        }

        @Override
        public List<? extends PathResourceImplementation> getResources() {
            File jar = this.getJar(this.isInitialized());
            this.updateExists(jar.exists());
            try {
                PathResourceImplementation res = ClassPathSupport.createResource((URL)new URI("jar:" + Utilities.toURI((File)jar).toURL() + "!/").toURL());
                return Collections.singletonList(res);
            }
            catch (MalformedURLException | URISyntaxException ex) {
                return Collections.emptyList();
            }
        }

        @Override
        public SuiteSources owner() {
            return SuiteSources.this;
        }
    }

    private class Library
    extends SharedSupport
    implements FlaggedClassPathImplementation,
    Dep {
        final MxLibrary lib;
        final String libName;
        Collection<Dep> allDeps;

        Library(String libName, MxLibrary lib) {
            this.libName = libName;
            this.lib = this.getOSSLibrary(lib);
        }

        final MxLibrary getOSSLibrary(MxLibrary lib) {
            if (lib.sha1() == null && !lib.os_arch().isEmpty()) {
                Map<String, MxLibrary.Arch> os_dep_libs = lib.os_arch();
                String os = System.getProperty("os.name").toLowerCase();
                for (Map.Entry<String, MxLibrary.Arch> entry : os_dep_libs.entrySet()) {
                    if (!os.contains(entry.getKey())) continue;
                    return entry.getValue().amd64();
                }
            }
            return lib;
        }

        File getJar(boolean dumpIfMissing) {
            FileObject relativePath;
            String cache = System.getenv("MX_CACHE_DIR");
            File mxCache = cache != null ? new File(cache) : new File(new File(new File(System.getProperty("user.home")), ".mx"), "cache");
            int prefix = this.libName.indexOf(58);
            String simpleName = this.libName.substring(prefix + 1);
            File simpleJar = null;
            if (this.lib.path() != null && !this.lib.path().isEmpty() && (relativePath = SuiteSources.this.dir.getFileObject(this.lib.path())) != null) {
                simpleJar = FileUtil.toFile((FileObject)relativePath);
            }
            if (simpleJar == null) {
                simpleJar = new File(mxCache, simpleName + "_" + this.lib.sha1() + ".jar");
            }
            if (simpleJar.exists()) {
                return simpleJar;
            }
            File dir = new File(mxCache, simpleName + "_" + this.lib.sha1());
            File jar = new File(dir, simpleName.replace('_', '-').toLowerCase(Locale.ENGLISH) + ".jar");
            if (dumpIfMissing && !jar.exists()) {
                File f = jar;
                while (true) {
                    if (f.exists()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(f).append(" exists:\n");
                        String[] kids = f.list();
                        if (kids != null) {
                            for (String n : kids) {
                                sb.append("  ").append(n).append("\n");
                            }
                        }
                        LOG.log(Level.INFO, sb.toString());
                        break;
                    }
                    LOG.log(Level.WARNING, "{0} does not exist", f);
                    f = f.getParentFile();
                }
            }
            return jar;
        }

        @Override
        public String getName() {
            return this.libName;
        }

        @Override
        public Collection<String> depNames() {
            return this.lib.dependencies();
        }

        @Override
        public Collection<Dep> allDeps() {
            return this.allDeps;
        }

        @Override
        public void setAllDeps(Collection<Dep> set) {
            this.allDeps = set;
        }

        public List<? extends PathResourceImplementation> getResources() {
            File jar = this.getJar(!this.isInitialized());
            this.updateExists(jar.exists());
            try {
                PathResourceImplementation res = ClassPathSupport.createResource((URL)new URI("jar:" + Utilities.toURI((File)jar).toURL() + "!/").toURL());
                return Collections.singletonList(res);
            }
            catch (MalformedURLException | URISyntaxException ex) {
                return Collections.emptyList();
            }
        }

        @Override
        public SuiteSources owner() {
            return SuiteSources.this;
        }
    }

    final class Group
    implements SourceGroup,
    Dep,
    AnnotationProcessingQuery.Result,
    Compliance.Provider {
        private final String mxName;
        private final MxProject mxPrj;
        private final FileObject srcDir;
        private final FileObject srcGenDir;
        private final FileObject binDir;
        private final String name;
        private final String displayName;
        private final Compliance compliance;
        private ClassPath sourceCP;
        private ClassPath cp;
        private ClassPath processorPath;
        private Collection<Dep> allDeps;
        private ClassPath bootCP;
        private Object platformOrThis;

        Group(String mxName, MxProject mxPrj, FileObject srcDir, FileObject srcGenDir, FileObject binDir, String name, String displayName) {
            this.mxName = mxName;
            this.mxPrj = mxPrj;
            this.srcDir = srcDir;
            this.srcGenDir = srcGenDir;
            this.binDir = binDir;
            this.name = name;
            this.displayName = displayName;
            this.compliance = Compliance.parse(mxPrj.javaCompliance());
        }

        public FileObject getRootFolder() {
            return this.srcDir;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            return null;
        }

        @Override
        public Compliance getCompliance() {
            return this.compliance;
        }

        public boolean contains(FileObject file) {
            return file == this.srcDir || file == this.srcGenDir || FileUtil.isParentOf((FileObject)this.srcDir, (FileObject)file) || this.srcGenDir != null && FileUtil.isParentOf((FileObject)this.srcGenDir, (FileObject)file);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public String toString() {
            return "SuiteSources.Group[name=" + this.name + ",rootFolder=" + this.srcDir + "]";
        }

        ClassPath getSourceCP() {
            SuiteSources.this.ensureTransitiveDependenciesAreComputed();
            return this.sourceCP;
        }

        ClassPath getCP() {
            SuiteSources.this.ensureTransitiveDependenciesAreComputed();
            return this.cp;
        }

        @Override
        public Collection<String> depNames() {
            ArrayList<String> both = new ArrayList<String>();
            both.addAll(this.mxPrj.dependencies());
            both.addAll(this.mxPrj.generatedDependencies());
            return both;
        }

        @Override
        public void setAllDeps(Collection<Dep> set) {
            this.allDeps = set;
        }

        @Override
        public Collection<Dep> allDeps() {
            return this.allDeps;
        }

        private void computeClassPath(Map<String, Dep> transDeps) {
            for (Dep d : transDeps.values()) {
                d.owner().ensureTransitiveDependenciesAreComputed();
            }
            ArrayList<Group> arr = new ArrayList<Group>();
            ArrayList<ClassPathImplementation> libs = new ArrayList<ClassPathImplementation>();
            this.processTransDep(transDeps.get(this.mxName), arr, libs);
            this.cp = this.composeClassPath(arr, libs);
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            if (this.srcDir != null) {
                roots.add(this.srcDir);
            }
            if (this.srcGenDir != null) {
                roots.add(this.srcGenDir);
            }
            this.sourceCP = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
            if (this.mxPrj.annotationProcessors().isEmpty()) {
                this.processorPath = null;
            } else {
                ArrayList<Group> groups = new ArrayList<Group>();
                ArrayList<ClassPathImplementation> jars = new ArrayList<ClassPathImplementation>();
                for (String dep : this.mxPrj.annotationProcessors()) {
                    this.processTransDep(transDeps.get(dep), groups, jars);
                }
                this.processorPath = this.composeClassPath(groups, jars);
            }
        }

        private void processTransDep(Dep dep, List<Group> addGroups, List<ClassPathImplementation> addJars) {
            if (dep != null) {
                dep.owner().ensureTransitiveDependenciesAreComputed();
                for (Dep d : dep.allDeps()) {
                    if (d == this) continue;
                    d.owner().ensureTransitiveDependenciesAreComputed();
                    if (d instanceof Group) {
                        addGroups.add((Group)d);
                        continue;
                    }
                    if (!(d instanceof ClassPathImplementation)) continue;
                    addJars.add((ClassPathImplementation)d);
                }
            }
        }

        private ClassPath composeClassPath(List<Group> arr, List<ClassPathImplementation> libs) {
            LinkedHashSet<FileObject> roots = new LinkedHashSet<FileObject>();
            int depsCount = arr.size();
            for (int i = 0; i < depsCount; ++i) {
                Group g = arr.get(i);
                if (g.binDir == null) continue;
                roots.add(g.binDir);
            }
            ClassPath prjCp = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[0]));
            if (!libs.isEmpty()) {
                prjCp = libs.size() == 1 ? ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{prjCp, ClassPathFactory.createClassPath((ClassPathImplementation)libs.get(0))}) : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{prjCp, ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupport.createProxyClassPathImplementation((ClassPathImplementation[])libs.toArray(new ClassPathImplementation[0])))});
            }
            return prjCp;
        }

        ClassPath getProcessorCP() {
            SuiteSources.this.ensureTransitiveDependenciesAreComputed();
            return this.processorPath;
        }

        public Set<? extends AnnotationProcessingQuery.Trigger> annotationProcessingEnabled() {
            return EnumSet.of(AnnotationProcessingQuery.Trigger.ON_SCAN, AnnotationProcessingQuery.Trigger.IN_EDITOR);
        }

        public Iterable<? extends String> annotationProcessorsToRun() {
            return null;
        }

        public URL sourceOutputDirectory() {
            return this.srcGenDir == null ? null : this.srcGenDir.toURL();
        }

        public Map<? extends String, ? extends String> processorOptions() {
            return Collections.emptyMap();
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public SuiteSources owner() {
            return SuiteSources.this;
        }

        ClassPath getBootCP() {
            if (this.bootCP == null) {
                JavaPlatform platform = this.getJavaPlatform();
                if (platform == null) {
                    platform = JavaPlatform.getDefault();
                }
                List entries = platform.getBootstrapLibraries().entries();
                ArrayList<URL> roots = new ArrayList<URL>();
                for (ClassPath.Entry entry : entries) {
                    URL root = entry.getURL();
                    if (root.getPath().contains("/graal-sdk.jar") || root.getPath().contains("/graaljs-scriptengine.jar") || root.getPath().contains("/graal-sdk.src.zip")) continue;
                    roots.add(entry.getURL());
                }
                this.bootCP = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[0]));
            }
            return this.bootCP;
        }

        final JavaPlatform getJavaPlatform() {
            if (this.platformOrThis == null) {
                JavaPlatform p = SuiteSources.this.jdks.find(this.compliance);
                this.platformOrThis = p == null ? this : p;
            }
            return this.platformOrThis instanceof JavaPlatform ? (JavaPlatform)this.platformOrThis : null;
        }
    }

    final class Dist
    extends SharedSupport
    implements Dep,
    FlaggedClassPathImplementation {
        final String name;
        final MxDistribution dist;
        Collection<Dep> allDeps;
        private Collection<Group> groups;

        public Dist(String name, MxDistribution dist) {
            this.name = name;
            this.dist = dist;
        }

        @Override
        public Collection<String> depNames() {
            TreeSet<String> deps = new TreeSet<String>();
            deps.addAll(this.dist.distDependencies());
            deps.addAll(this.dist.exclude());
            return deps;
        }

        @Override
        public Collection<Dep> allDeps() {
            return this.allDeps;
        }

        @Override
        public void setAllDeps(Collection<Dep> set) {
            this.allDeps = set;
        }

        @Override
        public String getName() {
            return this.name;
        }

        private FileObject getJar() {
            if (SuiteSources.this.dir == null) {
                return null;
            }
            FileObject dists = this.mxBuildDists();
            List<FileObject> candidates = this.findCandidates(dists);
            if (candidates.isEmpty()) {
                return dists.getFileObject(this.name.toLowerCase().replace("_", "-") + ".jar", false);
            }
            return candidates.get(0);
        }

        private FileObject mxBuildDists() {
            FileObject dists = SuiteSources.getSubDir(SuiteSources.this.dir, "mxbuild/dists");
            return dists;
        }

        boolean isRootJar(URL url) {
            try {
                if (url == null) {
                    return false;
                }
                URI uri = url.toURI();
                for (FileObject fo : this.findCandidates(this.mxBuildDists())) {
                    if (!uri.equals(this.toJarURL(fo).toURI())) continue;
                    return true;
                }
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
            return false;
        }

        private List<FileObject> findCandidates(FileObject dists) {
            ArrayList<FileObject> candidates = new ArrayList<FileObject>();
            List dist = Arrays.stream(dists.getChildren()).filter(fo -> fo.isFolder() && fo.getName().startsWith("jdk")).collect(Collectors.toList());
            dist.sort((fo1, fo2) -> fo2.getName().compareTo(fo1.getName()));
            for (FileObject jdkDir : dist) {
                FileObject jar = jdkDir.getFileObject(this.name.toLowerCase().replace("_", "-") + ".jar");
                if (jar == null) continue;
                candidates.add(jar);
            }
            return candidates;
        }

        public List<? extends PathResourceImplementation> getResources() {
            SuiteSources.this.ensureTransitiveDependenciesAreComputed();
            FileObject jar = this.getJar();
            this.updateExists(jar != null && jar.isData());
            if (jar != null) {
                try {
                    PathResourceImplementation res = ClassPathSupport.createResource((URL)this.getJarRoot());
                    return Collections.singletonList(res);
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
            return Collections.emptyList();
        }

        private URL getJarRoot() throws MalformedURLException, URISyntaxException {
            return this.toJarURL(this.getJar());
        }

        private URL toJarURL(FileObject jar) throws MalformedURLException, URISyntaxException {
            if (jar != null) {
                return new URI("jar:" + jar.toURL() + "!/").toURL();
            }
            return null;
        }

        @Override
        public SuiteSources owner() {
            return SuiteSources.this;
        }

        private void computeSourceRoots(Map<String, Dep> collectedDeps) {
            if (this.groups != null) {
                return;
            }
            LinkedHashSet<Group> contributingGroups = new LinkedHashSet<Group>();
            for (String d : this.dist.dependencies()) {
                Dep dep = collectedDeps.get(d);
                if (dep == null || dep.allDeps() == null) continue;
                for (Dep d2 : dep.allDeps()) {
                    if (!(d2 instanceof Group)) continue;
                    contributingGroups.add((Group)d2);
                }
            }
            for (String d : this.dist.distDependencies()) {
                Dep anyDep = collectedDeps.get(d);
                if (!(anyDep instanceof Dist)) continue;
                Dist dep = (Dist)anyDep;
                dep.computeSourceRoots(collectedDeps);
                contributingGroups.removeAll(dep.getContributingGroups());
            }
            this.groups = contributingGroups;
        }

        public Collection<Group> getContributingGroups() {
            return this.groups;
        }

        public String toString() {
            return "Dist[name=" + this.name + "]";
        }
    }

    abstract class SharedSupport {
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);
        private Boolean exists;

        SharedSupport() {
        }

        public final Set<ClassPath.Flag> getFlags() {
            return Boolean.TRUE.equals(this.exists) ? Collections.emptySet() : Collections.singleton(ClassPath.Flag.INCOMPLETE);
        }

        public void addPropertyChangeListener(PropertyChangeListener pl) {
            this.support.addPropertyChangeListener(pl);
        }

        public void removePropertyChangeListener(PropertyChangeListener pl) {
            this.support.removePropertyChangeListener(pl);
        }

        final boolean isInitialized() {
            return this.exists != null;
        }

        final void updateExists(boolean existsNow) {
            if (this.exists == null) {
                this.exists = existsNow;
            } else if (this.exists != existsNow) {
                this.exists = existsNow;
                this.support.firePropertyChange("flags", this.exists == false, this.exists);
            }
        }
    }

    static interface Dep
    extends Comparable<Dep> {
        public String getName();

        public Collection<String> depNames();

        public Collection<Dep> allDeps();

        public void setAllDeps(Collection<Dep> var1);

        @Override
        default public int compareTo(Dep o) {
            return this.getName().compareTo(o.getName());
        }

        public SuiteSources owner();
    }
}

