/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.php.dbgp.breakpoints.ExceptionBreakpoint;
import org.netbeans.modules.php.dbgp.ui.Bundle;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class DbgpExceptionBreakpointPanel
extends JPanel
implements Controller {
    private static final long serialVersionUID = 4967178020173186468L;
    private final JEditorPane classNameEditorPane;
    private final JScrollPane classNameScrollPane;
    private JPanel classNameEditorPanel;
    private JLabel exceptionLabel;

    public DbgpExceptionBreakpointPanel() {
        this.initComponents();
        Pair<JScrollPane, JEditorPane> codeCompletionEditor = this.createCodeCompletionEditor();
        this.classNameScrollPane = (JScrollPane)codeCompletionEditor.first();
        this.classNameEditorPane = (JEditorPane)codeCompletionEditor.second();
        this.classNameEditorPane.getAccessibleContext().setAccessibleName("exception class name input field");
        this.classNameEditorPane.getAccessibleContext().setAccessibleDescription("field for input of the exception class name for the exception breakpoint");
        this.exceptionLabel.setLabelFor(this.classNameScrollPane);
    }

    public boolean cancel() {
        return true;
    }

    public boolean ok() {
        String exceptionName = this.classNameEditorPane.getText();
        if (exceptionName == null || exceptionName.trim().length() == 0) {
            String msg = Bundle.DbgpExceptionBreakpointPanel_EmptyExceptionName();
            NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
            return false;
        }
        ExceptionBreakpoint breakpoint = new ExceptionBreakpoint(exceptionName);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        return true;
    }

    private Pair<JScrollPane, JEditorPane> createCodeCompletionEditor() {
        JComponent[] editorComponents = Utilities.createSingleLineEditor((String)"text/x-php-nbdebug-class-exception");
        JScrollPane scrollPane = (JScrollPane)editorComponents[0];
        JEditorPane editorPane = (JEditorPane)editorComponents[1];
        this.initClassNameEditorPanel(scrollPane);
        editorPane.setText("");
        scrollPane.setToolTipText("");
        editorPane.setToolTipText("");
        return Pair.of((Object)scrollPane, (Object)editorPane);
    }

    private void initClassNameEditorPanel(JScrollPane scrollPane) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.classNameEditorPanel.add((Component)scrollPane, gridBagConstraints);
    }

    private void initComponents() {
        this.classNameEditorPanel = new JPanel();
        this.exceptionLabel = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DbgpExceptionBreakpointPanel.class, (String)"LBL_Settings")));
        this.classNameEditorPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.exceptionLabel, (String)NbBundle.getMessage(DbgpExceptionBreakpointPanel.class, (String)"LBL_ExceptionName"));
        this.exceptionLabel.setVerticalAlignment(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.classNameEditorPanel.add((Component)this.exceptionLabel, gridBagConstraints);
        this.exceptionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpExceptionBreakpointPanel.class, (String)"DbgpExceptionBreakpointPanel.exceptionLabel.AccessibleContext.accessibleName"));
        this.exceptionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DbgpExceptionBreakpointPanel.class, (String)"DbgpExceptionBreakpointPanel.exceptionLabel.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.classNameEditorPanel, -1, 361, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNameEditorPanel, -2, 36, -2));
        this.classNameEditorPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpExceptionBreakpointPanel.class, (String)"A11_SettingsName"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DbgpExceptionBreakpointPanel.class, (String)"A11_SettingsName"));
    }
}

