/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.hints.pom.MavenResult;
import org.netbeans.modules.maven.hints.pom.MavenSelectionHintsTask;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public class MavenFileHintsTask
extends ParserResultTask<MavenResult> {
    public void run(MavenResult result, SchedulerEvent event) {
        FileObject fo = result.getPomFile();
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (fo == null || p == null || p.getProjectDirectory() != fo.getParent()) {
            return;
        }
        List<ErrorDescription> errors = PomModelUtils.findHints(result.getProjectModel(), p);
        HintsController.setErrors((FileObject)fo, (String)"pom", errors);
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public static class F
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Arrays.asList(new ParserResultTask[]{new MavenFileHintsTask(), new MavenSelectionHintsTask()});
        }
    }
}

