/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbform.palette;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.nbform.palette.AddToPaletteWizard;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

class ChooseJARWizardPanel
implements WizardDescriptor.Panel<AddToPaletteWizard> {
    private JFileChooser fileChooser;
    private static String lastDirectoryUsed;
    private AddToPaletteWizard wizard;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    ChooseJARWizardPanel() {
    }

    public Component getComponent() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(lastDirectoryUsed);
            this.fileChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.fileChooser.setName(PaletteUtils.getBundleString((String)"CTL_SelectJAR_Caption"));
            this.fileChooser.putClientProperty("WizardPanel_contentSelectedIndex", 0);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.setControlButtonsAreShown(false);
            this.fileChooser.setMultiSelectionEnabled(true);
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar");
                }

                @Override
                public String getDescription() {
                    return PaletteUtils.getBundleString((String)"CTL_JarArchivesMask");
                }
            });
            this.fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if ("ApproveSelection".equals(ev.getActionCommand())) {
                        ChooseJARWizardPanel.this.wizard.stepToNext();
                    } else if ("CancelSelection".equals(ev.getActionCommand())) {
                        ChooseJARWizardPanel.this.fileChooser.getTopLevelAncestor().setVisible(false);
                    }
                }
            });
            this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    if ("SelectedFilesChangedProperty".equals(ev.getPropertyName())) {
                        ChooseJARWizardPanel.this.cs.fireChange();
                    }
                }
            });
            this.fileChooser.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString((String)"CTL_SelectJAR_Step"));
        }
        return this.fileChooser;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        if (this.fileChooser != null && this.fileChooser.getSelectedFiles().length > 0) {
            lastDirectoryUsed = this.fileChooser.getCurrentDirectory().getAbsolutePath();
            return true;
        }
        return false;
    }

    public void readSettings(AddToPaletteWizard settings) {
        this.wizard = settings;
    }

    public void storeSettings(AddToPaletteWizard settings) {
        if (this.fileChooser != null) {
            ArrayList<ClassSourceResolver.JarEntry> entries = new ArrayList<ClassSourceResolver.JarEntry>();
            for (File jar : this.fileChooser.getSelectedFiles()) {
                entries.add(new ClassSourceResolver.JarEntry(jar));
            }
            settings.setJARFiles(entries);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }
}

