/**
 * The ElementTraversal interface is a set of read-only attributes which allow an author to easily navigate between elements in a document. In conforming implementations of Element Traversal, all objects that implement Element must also implement the ElementTraversal interface. Four of the attributes, firstElementChild, lastElementChild, previousElementSibling, and nextElementSibling, each provide a live reference to another element with the defined relationship to the current element, if the related element exists. The fifth attribute, childElementCount, exposes the number of child elements of an element, for preprocessing before navigation. A conforming User Agent must implement all five attributes. A User Agent may implement similar interfaces in other specifications, but such implementation is not required for conformance to this specification, if the User Agent is designed for a minimal code footprint. <p> This interface must be implemented on all Elements, regardless of their namespace. EntityReference nodes are not visible to the Element Traversal mechanism; if the tree-walker encounters an EntityReference node, it descends into it without informing the caller, and processes any children as if they had been present at the place where the entity node was found. Navigation must be irrespective of namespace, e.g. if an element in the HTML namespace is followed by element in the SVG namespace, the nextElementSibling attribute on the HTML element will return the SVG element.
 */
var ElementTraversal = {
}
/**
 * Accessing this attribute of an element must return a reference to the first child node of that element which is of nodeType 1, as an Element object. If the element on which this attribute is accessed does not have any child nodes, or if none of those child nodes are element nodes, then this attribute must return null.
 * @returns {Element} 
 */
ElementTraversal.prototype.firstElementChild = new Element();

/**
 * Accessing this attribute of an element must return a reference to the sibling node of that element which most immediately follows that element in document order, and which is of nodeType 1, as an Element object. If the element on which this attribute is accessed does not have any following sibling nodes, or if none of those following sibling nodes are element nodes, then this attribute must return null.
 * @returns {Element} 
 */
ElementTraversal.prototype.nextElementSibling = new Element();

/**
 * Accessing this attribute of an element must return the current number of child nodes of that element which are of nodeType 1. An implementation may store this number, or it may calculate it upon accessing this attribute, but the number must always represent the number of child element nodes at the time the attribute is accessed. Only immediate child nodes must be counted, e.g. elements which are child nodes of one of the child nodes of the element on which the attribute is accessed are not included in this count. If the element on which this attribute is accessed does not have any child nodes, or if none of those child nodes are element nodes, then this attribute must return 0.
 * @returns {Number} 
 */
ElementTraversal.prototype.childElementCount = new Number();

/**
 * Accessing this attribute of an element must return a reference to the sibling node of that element which most immediately precedes that element in document order, and which is of nodeType 1, as an Element object. If the element on which this attribute is accessed does not have any preceding sibling nodes, or if none of those preceding sibling nodes are element nodes, then this attribute must return null.
 * @returns {Element} 
 */
ElementTraversal.prototype.previousElementSibling = new Element();

/**
 * Accessing this attribute of an element must return a reference to the last child node of that element which is of nodeType 1, as an Element object. If the element on which this attribute is accessed does not have any child nodes, or if none of those child nodes are element nodes, then this attribute must return null.
 * @returns {Element} 
 */
ElementTraversal.prototype.lastElementChild = new Element();

/**
 * Represents the ElementTraversal prototype object.
 * @syntax ElementTraversal.prototype
 * @static
 */
ElementTraversal.prototype;

