/**
 * The CSSRuleList interface provides the abstraction of an ordered collection of CSS rules.The items in the CSSRuleList are accessible via an integral index, starting from 0.
 */
var CSSRuleList = {
}
/**
 * Used to retrieve a CSS rule by ordinal index. The order in this collection represents the order of the rules in the CSS style sheet. If index is greater than or equal to the number of rules in the list, this returns null.
 * @syntax cSSRuleList.item(index)
 * @param {Number} index Index into the collection
 * @returns {CSSRule} The style rule at the index position in the CSSRuleList, or null if that is not a valid index.
 */
CSSRuleList.prototype.item = function(index) {};

/**
 * The number of CSSRules in the list. The range of valid child rule indices is 0 to length-1 inclusive.
 * @syntax cSSRuleList.length
 * @returns {Number} 
 */
CSSRuleList.prototype.length = new Number();

/**
 * Represents the CSSRuleList prototype object.
 * @syntax CSSRuleList.prototype
 * @static
 */
CSSRuleList.prototype;

