/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.netbeans.modules.websvc.saas.codegen.ui.SoapClientEditorDrop;
import org.netbeans.modules.websvc.saas.codegen.ui.SoapServiceClientEditorDrop;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.ConsumerFlavorProvider;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.ExTransferable;

public class SoapClientFlavorProvider
implements ConsumerFlavorProvider {
    public Transferable addDataFlavors(Transferable transferable) {
        try {
            Object data;
            if (transferable.isDataFlavorSupported(ConsumerFlavorProvider.WSDL_METHOD_FLAVOR)) {
                Object data2 = transferable.getTransferData(ConsumerFlavorProvider.WSDL_METHOD_FLAVOR);
                if (data2 instanceof WsdlSaasMethod) {
                    WsdlSaasMethod method = (WsdlSaasMethod)data2;
                    ExTransferable t = ExTransferable.create((Transferable)transferable);
                    SoapClientEditorDrop editorDrop = new SoapClientEditorDrop(method);
                    ActiveEditorDropTransferable s = new ActiveEditorDropTransferable(editorDrop);
                    t.put((ExTransferable.Single)s);
                    return t;
                }
            } else if (transferable.isDataFlavorSupported(ConsumerFlavorProvider.WSDL_SERVICE_FLAVOR) && (data = transferable.getTransferData(ConsumerFlavorProvider.WSDL_SERVICE_FLAVOR)) instanceof WsdlSaas) {
                WsdlSaas saas = (WsdlSaas)data;
                URL url = this.getWsdlLocationURL(saas);
                if (url == null) {
                    return transferable;
                }
                ExTransferable t = ExTransferable.create((Transferable)transferable);
                SoapServiceClientEditorDrop editorDrop = new SoapServiceClientEditorDrop(saas);
                ServiceActiveEditorDropTransferable s = new ServiceActiveEditorDropTransferable(editorDrop);
                t.put((ExTransferable.Single)s);
                return t;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return transferable;
    }

    private URL getWsdlLocationURL(WsdlSaas saas) {
        URL url = null;
        String wsdlURL = saas.getWsdlData().getWsdlFile();
        if (wsdlURL == null) {
            return null;
        }
        try {
            url = new URL(wsdlURL);
        }
        catch (MalformedURLException ex) {
            File f = new File(wsdlURL);
            try {
                url = BaseUtilities.normalizeURI((URI)f.getCanonicalFile().toURI()).toURL();
            }
            catch (IOException exc) {
                Exceptions.printStackTrace((Throwable)exc);
            }
        }
        return url;
    }

    private static class ServiceActiveEditorDropTransferable
    extends ExTransferable.Single {
        private SoapServiceClientEditorDrop drop;

        ServiceActiveEditorDropTransferable(SoapServiceClientEditorDrop drop) {
            super(SoapServiceClientEditorDrop.FLAVOR);
            this.drop = drop;
        }

        public Object getData() {
            return this.drop;
        }
    }

    private static class ActiveEditorDropTransferable
    extends ExTransferable.Single {
        private SoapClientEditorDrop drop;

        ActiveEditorDropTransferable(SoapClientEditorDrop drop) {
            super(SoapClientEditorDrop.FLAVOR);
            this.drop = drop;
        }

        public Object getData() {
            return this.drop;
        }
    }
}

