/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import com.oracle.truffle.js.runtime.JSContextOptionsOptionDescriptors;
import com.oracle.truffle.js.runtime.JSParserOptions;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;

public final class JSContextOptions {
    public static final String JS_OPTION_PREFIX = "js.";
    @CompilerDirectives.CompilationFinal
    private JSParserOptions parserOptions;
    @CompilerDirectives.CompilationFinal
    private OptionValues optionValues;
    public static final String ECMASCRIPT_VERSION_NAME = "js.ecmascript-version";
    @Option(name="js.ecmascript-version", category=OptionCategory.USER, stability=OptionStability.STABLE, help="ECMAScript Version.")
    public static final OptionKey<Integer> ECMASCRIPT_VERSION = new OptionKey((Object)11, new OptionType("ecmascript-version", (Function)new Function<String, Integer>(){

        @Override
        public Integer apply(String t) {
            try {
                int version = Integer.parseInt(t);
                int minYearVersion = 2015;
                int maxYearVersion = 2021;
                if (minYearVersion <= version && version <= maxYearVersion) {
                    version -= 2009;
                }
                if (version < 5 || version > 12) {
                    throw new IllegalArgumentException("Supported values are 5 to 12 or " + minYearVersion + " to " + maxYearVersion + ".");
                }
                return version;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }));
    @CompilerDirectives.CompilationFinal
    private int ecmascriptVersion;
    public static final String ANNEX_B_NAME = "js.annex-b";
    @Option(name="js.annex-b", category=OptionCategory.USER, help="Enable ECMAScript Annex B features.")
    public static final OptionKey<Boolean> ANNEX_B = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean annexB;
    public static final String SYNTAX_EXTENSIONS_NAME = "js.syntax-extensions";
    @Option(name="js.syntax-extensions", category=OptionCategory.USER, help="Enable Nashorn syntax extensions.")
    public static final OptionKey<Boolean> SYNTAX_EXTENSIONS = new OptionKey((Object)false);
    public static final String SCRIPTING_NAME = "js.scripting";
    @Option(name="js.scripting", category=OptionCategory.USER, help="Enable scripting features (Nashorn compatibility option).")
    public static final OptionKey<Boolean> SCRIPTING = new OptionKey((Object)false);
    public static final String SHEBANG_NAME = "js.shebang";
    @Option(name="js.shebang", category=OptionCategory.USER, help="Allow parsing files starting with #!.")
    public static final OptionKey<Boolean> SHEBANG = new OptionKey((Object)false);
    public static final String STRICT_NAME = "js.strict";
    @Option(name="js.strict", category=OptionCategory.USER, stability=OptionStability.STABLE, help="Enforce strict mode.")
    public static final OptionKey<Boolean> STRICT = new OptionKey((Object)false);
    public static final String CONST_AS_VAR_NAME = "js.const-as-var";
    @Option(name="js.const-as-var", category=OptionCategory.EXPERT, help="Parse const declarations as a var (legacy compatibility option).")
    public static final OptionKey<Boolean> CONST_AS_VAR = new OptionKey((Object)false);
    public static final String FUNCTION_STATEMENT_ERROR_NAME = "js.function-statement-error";
    @Option(name="js.function-statement-error", category=OptionCategory.EXPERT, help="Treat hoistable function statements in blocks as an error (in ES5 mode).")
    public static final OptionKey<Boolean> FUNCTION_STATEMENT_ERROR = new OptionKey((Object)false);
    public static final String INTL_402_NAME = "js.intl-402";
    @Option(name="js.intl-402", category=OptionCategory.USER, stability=OptionStability.STABLE, help="Enable ECMAScript Internationalization API.")
    public static final OptionKey<Boolean> INTL_402 = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean intl402;
    public static final String REGEXP_MATCH_INDICES_NAME = "js.regexp-match-indices";
    @Option(name="js.regexp-match-indices", category=OptionCategory.USER, help="Enable RegExp Match Indices property.")
    public static final OptionKey<Boolean> REGEXP_MATCH_INDICES = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexpMatchIndices;
    public static final String REGEXP_STATIC_RESULT_NAME = "js.regexp-static-result";
    @Option(name="js.regexp-static-result", category=OptionCategory.USER, help="Provide last RegExp match in RegExp global var, e.g. RegExp.$1.")
    public static final OptionKey<Boolean> REGEXP_STATIC_RESULT = new OptionKey((Object)true);
    private final CyclicAssumption regexpStaticResultCyclicAssumption = new CyclicAssumption("The js.regexp-static-result option is stable.");
    @CompilerDirectives.CompilationFinal
    private Assumption regexpStaticResultCurrentAssumption = this.regexpStaticResultCyclicAssumption.getAssumption();
    @CompilerDirectives.CompilationFinal
    private boolean regexpStaticResult;
    public static final String ARRAY_SORT_INHERITED_NAME = "js.array-sort-inherited";
    @Option(name="js.array-sort-inherited", category=OptionCategory.USER, help="Sort inherited keys in Array.protoype.sort.")
    public static final OptionKey<Boolean> ARRAY_SORT_INHERITED = new OptionKey((Object)true);
    private final CyclicAssumption arraySortInheritedCyclicAssumption = new CyclicAssumption("The js.array-sort-inherited option is stable.");
    @CompilerDirectives.CompilationFinal
    private Assumption arraySortInheritedCurrentAssumption = this.arraySortInheritedCyclicAssumption.getAssumption();
    @CompilerDirectives.CompilationFinal
    private boolean arraySortInherited;
    public static final String SHARED_ARRAY_BUFFER_NAME = "js.shared-array-buffer";
    @Option(name="js.shared-array-buffer", category=OptionCategory.USER, help="Enable ES2017 SharedArrayBuffer.")
    public static final OptionKey<Boolean> SHARED_ARRAY_BUFFER = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean sharedArrayBuffer;
    public static final String ATOMICS_NAME = "js.atomics";
    @Option(name="js.atomics", category=OptionCategory.USER, help="Enable ES2017 Atomics.")
    public static final OptionKey<Boolean> ATOMICS = new OptionKey((Object)true);
    public static final String V8_COMPATIBILITY_MODE_NAME = "js.v8-compat";
    @Option(name="js.v8-compat", category=OptionCategory.USER, help="Provide compatibility with the Google V8 engine.")
    public static final OptionKey<Boolean> V8_COMPATIBILITY_MODE = new OptionKey((Object)false);
    private final CyclicAssumption v8CompatibilityModeCyclicAssumption = new CyclicAssumption("The js.v8-compat option is stable.");
    @CompilerDirectives.CompilationFinal
    private Assumption v8CompatibilityModeCurrentAssumption = this.v8CompatibilityModeCyclicAssumption.getAssumption();
    @CompilerDirectives.CompilationFinal
    private boolean v8CompatibilityMode;
    public static final String V8_REALM_BUILTIN_NAME = "js.v8-realm-builtin";
    @Option(name="js.v8-realm-builtin", category=OptionCategory.INTERNAL, help="Provide Realm builtin compatible with V8's d8 shell.")
    public static final OptionKey<Boolean> V8_REALM_BUILTIN = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean v8RealmBuiltin;
    public static final String V8_LEGACY_CONST_NAME = "js.v8-legacy-const";
    @Option(name="js.v8-legacy-const", category=OptionCategory.INTERNAL, help="Emulate v8 behavior when trying to mutate const variables in non-strict mode.")
    public static final OptionKey<Boolean> V8_LEGACY_CONST = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean v8LegacyConst;
    public static final String NASHORN_COMPATIBILITY_MODE_NAME = "js.nashorn-compat";
    @Option(name="js.nashorn-compat", category=OptionCategory.USER, help="Provide compatibility with the OpenJDK Nashorn engine. Do not use with untrusted code.")
    public static final OptionKey<Boolean> NASHORN_COMPATIBILITY_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean nashornCompatibilityMode;
    public static final String STACK_TRACE_LIMIT_NAME = "js.stack-trace-limit";
    @Option(name="js.stack-trace-limit", category=OptionCategory.USER, help="Number of stack frames to capture.")
    public static final OptionKey<Integer> STACK_TRACE_LIMIT = new OptionKey((Object)10);
    @CompilerDirectives.CompilationFinal
    private int stackTraceLimit;
    public static final String DEBUG_BUILTIN_NAME = "js.debug-builtin";
    @Option(name="js.debug-builtin", category=OptionCategory.INTERNAL, help="Provide a non-API Debug builtin. Behaviour will likely change. Don't depend on this in production code.")
    public static final OptionKey<Boolean> DEBUG_BUILTIN = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean debug;
    public static final String DIRECT_BYTE_BUFFER_NAME = "js.direct-byte-buffer";
    @Option(name="js.direct-byte-buffer", category=OptionCategory.USER, help="Use direct (off-heap) byte buffer for typed arrays.")
    public static final OptionKey<Boolean> DIRECT_BYTE_BUFFER = new OptionKey((Object)false);
    private final CyclicAssumption directByteBufferCyclicAssumption = new CyclicAssumption("The js.direct-byte-buffer option is stable.");
    @CompilerDirectives.CompilationFinal
    private Assumption directByteBufferCurrentAssumption = this.directByteBufferCyclicAssumption.getAssumption();
    @CompilerDirectives.CompilationFinal
    private boolean directByteBuffer;
    public static final String PARSE_ONLY_NAME = "js.parse-only";
    @Option(name="js.parse-only", category=OptionCategory.INTERNAL, help="Only parse source code, do not run it.")
    public static final OptionKey<Boolean> PARSE_ONLY = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean parseOnly;
    public static final String TIME_ZONE_NAME = "js.timezone";
    @Option(name="js.timezone", category=OptionCategory.USER, help="Set custom time zone ID.")
    public static final OptionKey<String> TIME_ZONE = new OptionKey((Object)"", new OptionType("ZoneId", (Function)new Function<String, String>(){

        @Override
        public String apply(String tz) {
            try {
                return ZoneId.of(tz, ZoneId.SHORT_IDS).getId();
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }));
    public static final String TIMER_RESOLUTION_NAME = "js.timer-resolution";
    @Option(name="js.timer-resolution", category=OptionCategory.USER, help="Resolution of timers (performance.now() and Date built-ins) in nanoseconds. Fuzzy time is used when set to 0.")
    public static final OptionKey<Long> TIMER_RESOLUTION = new OptionKey((Object)1000000L);
    private final CyclicAssumption timerResolutionCyclicAssumption = new CyclicAssumption("The js.timer-resolution option is stable.");
    @CompilerDirectives.CompilationFinal
    private Assumption timerResolutionCurrentAssumption = this.timerResolutionCyclicAssumption.getAssumption();
    @CompilerDirectives.CompilationFinal
    private long timerResolution;
    public static final String AGENT_CAN_BLOCK_NAME = "js.agent-can-block";
    @Option(name="js.agent-can-block", category=OptionCategory.INTERNAL, help="Determines whether agents can block or not.")
    public static final OptionKey<Boolean> AGENT_CAN_BLOCK = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean agentCanBlock;
    public static final String JAVA_PACKAGE_GLOBALS_NAME = "js.java-package-globals";
    @Option(name="js.java-package-globals", category=OptionCategory.USER, help="Provide Java package globals: Packages, java, javafx, javax, com, org, edu.")
    public static final OptionKey<Boolean> JAVA_PACKAGE_GLOBALS = new OptionKey((Object)true);
    public static final String GLOBAL_PROPERTY_NAME = "js.global-property";
    @Option(name="js.global-property", category=OptionCategory.USER, help="Provide 'global' global property.")
    public static final OptionKey<Boolean> GLOBAL_PROPERTY = new OptionKey((Object)false);
    public static final String GLOBAL_ARGUMENTS_NAME = "js.global-arguments";
    @Option(name="js.global-arguments", category=OptionCategory.USER, help="Provide 'arguments' global property.")
    public static final OptionKey<Boolean> GLOBAL_ARGUMENTS = new OptionKey((Object)true);
    public static final String CONSOLE_NAME = "js.console";
    @Option(name="js.console", category=OptionCategory.USER, help="Provide 'console' global property.")
    public static final OptionKey<Boolean> CONSOLE = new OptionKey((Object)true);
    public static final String PERFORMANCE_NAME = "js.performance";
    @Option(name="js.performance", category=OptionCategory.USER, help="Provide 'performance' global property.")
    public static final OptionKey<Boolean> PERFORMANCE = new OptionKey((Object)false);
    public static final String SHELL_NAME = "js.shell";
    @Option(name="js.shell", category=OptionCategory.USER, help="Provide global functions for js shell.")
    public static final OptionKey<Boolean> SHELL = new OptionKey((Object)false);
    public static final String PRINT_NAME = "js.print";
    @Option(name="js.print", category=OptionCategory.USER, help="Provide 'print' global function.")
    public static final OptionKey<Boolean> PRINT = new OptionKey((Object)true);
    public static final String LOAD_NAME = "js.load";
    @Option(name="js.load", category=OptionCategory.USER, help="Provide 'load' global function.")
    public static final OptionKey<Boolean> LOAD = new OptionKey((Object)true);
    public static final String LOAD_FROM_URL_NAME = "js.load-from-url";
    @Option(name="js.load-from-url", category=OptionCategory.USER, help="Allow 'load' to access URLs. Do not use with untrusted code.")
    public static final OptionKey<Boolean> LOAD_FROM_URL = new OptionKey((Object)false);
    public static final String LOAD_FROM_CLASSPATH_NAME = "js.load-from-classpath";
    @Option(name="js.load-from-classpath", category=OptionCategory.USER, help="Allow 'load' to access 'classpath:' URLs. Do not use with untrusted code.")
    public static final OptionKey<Boolean> LOAD_FROM_CLASSPATH = new OptionKey((Object)false);
    public static final String COMMONJS_REQUIRE_NAME = "js.commonjs-require";
    @Option(name="js.commonjs-require", category=OptionCategory.USER, help="Enable CommonJS require emulation.")
    public static final OptionKey<Boolean> COMMONJS_REQUIRE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean commonJSRequire;
    public static final String COMMONJS_REQUIRE_CWD_NAME = "js.commonjs-require-cwd";
    @Option(name="js.commonjs-require-cwd", category=OptionCategory.USER, help="CommonJS default current working directory.")
    public static final OptionKey<String> COMMONJS_REQUIRE_CWD = new OptionKey((Object)"");
    public static final String COMMONJS_CORE_MODULES_REPLACEMENTS_NAME = "js.commonjs-core-modules-replacements";
    @Option(name="js.commonjs-core-modules-replacements", category=OptionCategory.USER, help="Npm packages used to replace global Node.js builtins. Syntax: name1:module1,name2:module2,...")
    public static final OptionKey<Map<String, String>> COMMONJS_CORE_MODULES_REPLACEMENTS = new OptionKey(Collections.emptyMap(), new OptionType("commonjs-require-globals", (Function)new Function<String, Map<String, String>>(){

        @Override
        public Map<String, String> apply(String value) {
            String[] options;
            HashMap<String, String> map = new HashMap<String, String>();
            if ("".equals(value)) {
                return map;
            }
            for (String s : options = value.split(",")) {
                String[] builtin = s.split(":");
                if (builtin.length != 2) {
                    throw new IllegalArgumentException("Unexpected builtin arguments: " + s);
                }
                String key = builtin[0];
                String val = builtin[1];
                map.put(key, val);
            }
            return map;
        }
    }));
    public static final String COMMONJS_REQUIRE_GLOBAL_PROPERTIES_NAME = "js.commonjs-global-properties";
    @Option(name="js.commonjs-global-properties", category=OptionCategory.USER, help="Npm package used to populate Node.js global object.")
    public static final OptionKey<String> COMMONJS_REQUIRE_GLOBAL_PROPERTIES = new OptionKey((Object)"");
    public static final String GRAAL_BUILTIN_NAME = "js.graal-builtin";
    @Option(name="js.graal-builtin", category=OptionCategory.USER, help="Provide 'Graal' global property.")
    public static final OptionKey<Boolean> GRAAL_BUILTIN = new OptionKey((Object)true);
    public static final String POLYGLOT_BUILTIN_NAME = "js.polyglot-builtin";
    @Option(name="js.polyglot-builtin", category=OptionCategory.USER, help="Provide 'Polyglot' global property.", deprecated=true)
    public static final OptionKey<Boolean> POLYGLOT_BUILTIN = new OptionKey((Object)true);
    public static final String POLYGLOT_EVALFILE_NAME = "js.polyglot-evalfile";
    @Option(name="js.polyglot-evalfile", category=OptionCategory.USER, help="Provide 'Polyglot.evalFile' function.")
    public static final OptionKey<Boolean> POLYGLOT_EVALFILE = new OptionKey((Object)true);
    public static final String AWAIT_OPTIMIZATION_NAME = "js.await-optimization";
    @Option(name="js.await-optimization", category=OptionCategory.INTERNAL, help="Use PromiseResolve for Await.")
    public static final OptionKey<Boolean> AWAIT_OPTIMIZATION = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean awaitOptimization;
    public static final String DISABLE_EVAL_NAME = "js.disable-eval";
    @Option(name="js.disable-eval", category=OptionCategory.EXPERT, help="User code is not allowed to parse code via e.g. eval().")
    public static final OptionKey<Boolean> DISABLE_EVAL = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean disableEval;
    public static final String DISABLE_WITH_NAME = "js.disable-with";
    @Option(name="js.disable-with", category=OptionCategory.EXPERT, help="User code is not allowed to use the 'with' statement.")
    public static final OptionKey<Boolean> DISABLE_WITH = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean disableWith;
    public static final String BIGINT_NAME = "js.bigint";
    @Option(name="js.bigint", category=OptionCategory.USER, help="Provide an implementation of the BigInt proposal.")
    public static final OptionKey<Boolean> BIGINT = new OptionKey((Object)true);
    public static final String CLASS_FIELDS_NAME = "js.class-fields";
    @Option(name="js.class-fields", category=OptionCategory.USER, help="Enable the class public and private fields proposal.")
    public static final OptionKey<Boolean> CLASS_FIELDS = new OptionKey((Object)false);
    public static final int CLASS_FIELDS_ES_VERSION = 12;
    public static final String REGEX_DUMP_AUTOMATA_NAME = "js.regex.dump-automata";
    @Option(name="js.regex.dump-automata", category=OptionCategory.INTERNAL, help="Produce ASTs and automata in JSON, DOT (GraphViz) and LaTeX formats.")
    public static final OptionKey<Boolean> REGEX_DUMP_AUTOMATA = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexDumpAutomata;
    public static final String REGEX_STEP_EXECUTION_NAME = "js.regex.step-execution";
    @Option(name="js.regex.step-execution", category=OptionCategory.INTERNAL, help="Trace the execution of automata in JSON files.")
    public static final OptionKey<Boolean> REGEX_STEP_EXECUTION = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexStepExecution;
    public static final String REGEX_ALWAYS_EAGER_NAME = "js.regex.always-eager";
    @Option(name="js.regex.always-eager", category=OptionCategory.INTERNAL, help="Always match capture groups eagerly.")
    public static final OptionKey<Boolean> REGEX_ALWAYS_EAGER = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexAlwaysEager;
    public static final String SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT_NAME = "js.script-engine-global-scope-import";
    @Option(name="js.script-engine-global-scope-import", deprecated=true, stability=OptionStability.STABLE, category=OptionCategory.INTERNAL, help="Enable ScriptEngine-specific global scope import function.")
    public static final OptionKey<Boolean> SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean scriptEngineGlobalScopeImport;
    public static final String FOREIGN_OBJECT_PROTOTYPE_NAME = "js.foreign-object-prototype";
    @Option(name="js.foreign-object-prototype", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Non-JS objects have prototype (Object/Function/Array.prototype) set.")
    public static final OptionKey<Boolean> FOREIGN_OBJECT_PROTOTYPE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean hasForeignObjectPrototype;
    public static final String EXPERIMENTAL_FOREIGN_OBJECT_PROTOTYPE_NAME = "js.experimental-foreign-object-prototype";
    @Option(name="js.experimental-foreign-object-prototype", category=OptionCategory.EXPERT, deprecated=true, help="Non-JS objects have prototype (Object/Function/Array.prototype) set; deprecated old name.")
    protected static final OptionKey<Boolean> EXPERIMENTAL_FOREIGN_OBJECT_PROTOTYPE = new OptionKey((Object)false);
    public static final String FUNCTION_ARGUMENTS_LIMIT_NAME = "js.function-arguments-limit";
    @Option(name="js.function-arguments-limit", category=OptionCategory.EXPERT, help="Maximum number of arguments for functions.")
    public static final OptionKey<Long> FUNCTION_ARGUMENTS_LIMIT = new OptionKey((Object)65535L);
    @CompilerDirectives.CompilationFinal
    private long functionArgumentsLimit;
    public static final String TEST262_MODE_NAME = "js.test262-mode";
    @Option(name="js.test262-mode", category=OptionCategory.INTERNAL, help="Expose global property $262 needed to run the Test262 harness.")
    public static final OptionKey<Boolean> TEST262_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean test262Mode;
    public static final String TESTV8_MODE_NAME = "js.testV8-mode";
    @Option(name="js.testV8-mode", category=OptionCategory.INTERNAL, help="Expose internals needed to run the TestV8 harness.")
    public static final OptionKey<Boolean> TESTV8_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean testV8Mode;
    public static final String VALIDATE_REGEXP_LITERALS_NAME = "js.validate-regexp-literals";
    @Option(name="js.validate-regexp-literals", category=OptionCategory.INTERNAL, help="Validate regexp literals at parse time.")
    public static final OptionKey<Boolean> VALIDATE_REGEXP_LITERALS = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean validateRegExpLiterals;
    public static final String LOCALE_NAME = "js.locale";
    @Option(name="js.locale", category=OptionCategory.EXPERT, help="Use a specific default locale for locale-sensitive operations.")
    public static final OptionKey<String> LOCALE = new OptionKey((Object)"");
    public static final String FUNCTION_CONSTRUCTOR_CACHE_SIZE_NAME = "js.function-constructor-cache-size";
    @Option(name="js.function-constructor-cache-size", category=OptionCategory.EXPERT, help="Maximum size of the parsing cache used by the Function constructor to avoid re-parsing known sources.")
    public static final OptionKey<Integer> FUNCTION_CONSTRUCTOR_CACHE_SIZE = new OptionKey((Object)32);
    @CompilerDirectives.CompilationFinal
    private int functionConstructorCacheSize;
    public static final String STRING_LENGTH_LIMIT_NAME = "js.string-length-limit";
    @Option(name="js.string-length-limit", category=OptionCategory.EXPERT, help="Maximum string length.")
    public static final OptionKey<Integer> STRING_LENGTH_LIMIT = new OptionKey((Object)1073741799);
    @CompilerDirectives.CompilationFinal
    private int stringLengthLimit;
    public static final String BIND_MEMBER_FUNCTIONS_NAME = "js.bind-member-functions";
    @Option(name="js.bind-member-functions", category=OptionCategory.EXPERT, help="Bind functions returned by Value.getMember to the receiver object.")
    public static final OptionKey<Boolean> BIND_MEMBER_FUNCTIONS = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean bindMemberFunctions;
    public static final String REGEX_REGRESSION_TEST_MODE_NAME = "js.regex-regression-test-mode";
    @Option(name="js.regex-regression-test-mode", category=OptionCategory.INTERNAL, help="Test mode for TRegex.")
    public static final OptionKey<Boolean> REGEX_REGRESSION_TEST_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexRegressionTestMode;
    public static final String INTEROP_COMPLETE_PROMISES_NAME = "js.interop-complete-promises";
    @Option(name="js.interop-complete-promises", category=OptionCategory.EXPERT, help="Resolve promises when crossing a polyglot language boundary.")
    public static final OptionKey<Boolean> INTEROP_COMPLETE_PROMISES = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean interopCompletePromises;
    public static final String DEBUG_PROPERTY_NAME_NAME = "js.debug-property-name";
    @Option(name="js.debug-property-name", category=OptionCategory.EXPERT, help="The name used for the Graal.js debug builtin.")
    public static final OptionKey<String> DEBUG_PROPERTY_NAME = new OptionKey((Object)"Debug");
    public static final String PROFILE_TIME_NAME = "js.profile-time";
    @Option(name="js.profile-time", category=OptionCategory.INTERNAL, help="Enable time profiling.")
    public static final OptionKey<Boolean> PROFILE_TIME = new OptionKey((Object)false);
    public static final String PROFILE_TIME_PRINT_CUMULATIVE_NAME = "js.profile-time-print-cumulative";
    @Option(name="js.profile-time-print-cumulative", category=OptionCategory.INTERNAL, help="Print cumulative time when time profiling is enabled.")
    public static final OptionKey<Boolean> PROFILE_TIME_PRINT_CUMULATIVE = new OptionKey((Object)false);
    public static final String TEST_CLONE_UNINITIALIZED_NAME = "js.test-clone-uninitialized";
    @Option(name="js.test-clone-uninitialized", category=OptionCategory.INTERNAL, help="Test uninitialized cloning.")
    public static final OptionKey<Boolean> TEST_CLONE_UNINITIALIZED = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean testCloneUninitialized;
    public static final String LAZY_TRANSLATION_NAME = "js.lazy-translation";
    @Option(name="js.lazy-translation", category=OptionCategory.INTERNAL, help="Translate function bodies lazily.")
    public static final OptionKey<Boolean> LAZY_TRANSLATION = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean lazyTranslation;
    public static final String MAX_TYPED_ARRAY_LENGTH_NAME = "js.max-typed-array-length";
    @Option(name="js.max-typed-array-length", category=OptionCategory.EXPERT, help="Maximum allowed length for TypedArrays.")
    public static final OptionKey<Integer> MAX_TYPED_ARRAY_LENGTH = new OptionKey((Object)0x3FFFFFFF);
    @CompilerDirectives.CompilationFinal
    private int maxTypedArrayLength;
    public static final String MAX_APPLY_ARGUMENT_LENGTH_NAME = "js.max-apply-argument-length";
    @Option(name="js.max-apply-argument-length", category=OptionCategory.EXPERT, help="Maximum allowed number of arguments allowed in an apply function.")
    public static final OptionKey<Integer> MAX_APPLY_ARGUMENT_LENGTH = new OptionKey((Object)10000000);
    @CompilerDirectives.CompilationFinal
    private int maxApplyArgumentLength;
    public static final String MAX_PROTOTYPE_CHAIN_LENGTH_NAME = "js.max-prototype-chain-length";
    @Option(name="js.max-prototype-chain-length", category=OptionCategory.EXPERT, help="Maximum allowed length of a prototype chain.")
    public static final OptionKey<Integer> MAX_PROTOTYPE_CHAIN_LENGTH = new OptionKey((Object)32766);
    @CompilerDirectives.CompilationFinal
    private int maxPrototypeChainLength;
    public static final String ASYNC_STACK_TRACES_NAME = "js.async-stack-traces";
    @Option(name="js.async-stack-traces", category=OptionCategory.EXPERT, help="Include async function frames in stack traces.")
    public static final OptionKey<Boolean> ASYNC_STACK_TRACES = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean asyncStackTraces;
    public static final String PROPERTY_CACHE_LIMIT_NAME = "js.property-cache-limit";
    @Option(name="js.property-cache-limit", category=OptionCategory.INTERNAL, help="Maximum allowed size of a property cache.")
    public static final OptionKey<Integer> PROPERTY_CACHE_LIMIT = new OptionKey((Object)5);
    @CompilerDirectives.CompilationFinal
    private int propertyCacheLimit;
    public static final String FUNCTION_CACHE_LIMIT_NAME = "js.function-cache-limit";
    @Option(name="js.function-cache-limit", category=OptionCategory.INTERNAL, help="Maximum allowed size of a function cache.")
    public static final OptionKey<Integer> FUNCTION_CACHE_LIMIT = new OptionKey((Object)4);
    @CompilerDirectives.CompilationFinal
    private int functionCacheLimit;

    JSContextOptions(JSParserOptions parserOptions, OptionValues optionValues) {
        this.parserOptions = parserOptions;
        this.optionValues = optionValues;
        this.setOptionValues(optionValues);
    }

    public static JSContextOptions fromOptionValues(OptionValues optionValues) {
        return new JSContextOptions(new JSParserOptions(), optionValues);
    }

    public JSParserOptions getParserOptions() {
        return this.parserOptions;
    }

    public void setParserOptions(JSParserOptions parserOptions) {
        CompilerAsserts.neverPartOfCompilation();
        this.parserOptions = parserOptions;
    }

    public void setOptionValues(OptionValues newOptions) {
        CompilerAsserts.neverPartOfCompilation();
        this.optionValues = newOptions;
        this.cacheOptions();
        this.parserOptions = this.parserOptions.putOptions(newOptions);
    }

    private void cacheOptions() {
        this.ecmascriptVersion = this.readIntegerOption(ECMASCRIPT_VERSION);
        this.annexB = this.readBooleanOption(ANNEX_B);
        this.intl402 = this.readBooleanOption(INTL_402);
        this.regexpStaticResult = this.patchBooleanOption(REGEXP_STATIC_RESULT, REGEXP_STATIC_RESULT_NAME, this.regexpStaticResult, msg -> {
            this.regexpStaticResultCyclicAssumption.invalidate(msg);
            this.regexpStaticResultCurrentAssumption = this.regexpStaticResultCyclicAssumption.getAssumption();
        });
        this.regexpMatchIndices = REGEXP_MATCH_INDICES.hasBeenSet(this.optionValues) ? this.readBooleanOption(REGEXP_MATCH_INDICES) : this.getEcmaScriptVersion() >= 12;
        this.arraySortInherited = this.patchBooleanOption(ARRAY_SORT_INHERITED, ARRAY_SORT_INHERITED_NAME, this.arraySortInherited, msg -> {
            this.arraySortInheritedCyclicAssumption.invalidate(msg);
            this.arraySortInheritedCurrentAssumption = this.arraySortInheritedCyclicAssumption.getAssumption();
        });
        this.sharedArrayBuffer = this.readBooleanOption(SHARED_ARRAY_BUFFER);
        this.v8CompatibilityMode = this.patchBooleanOption(V8_COMPATIBILITY_MODE, V8_COMPATIBILITY_MODE_NAME, this.v8CompatibilityMode, msg -> {
            this.v8CompatibilityModeCyclicAssumption.invalidate(msg);
            this.v8CompatibilityModeCurrentAssumption = this.v8CompatibilityModeCyclicAssumption.getAssumption();
        });
        this.v8RealmBuiltin = this.readBooleanOption(V8_REALM_BUILTIN);
        this.v8LegacyConst = this.readBooleanOption(V8_LEGACY_CONST);
        this.nashornCompatibilityMode = this.readBooleanOption(NASHORN_COMPATIBILITY_MODE);
        this.directByteBuffer = this.patchBooleanOption(DIRECT_BYTE_BUFFER, DIRECT_BYTE_BUFFER_NAME, this.directByteBuffer, msg -> {
            this.directByteBufferCyclicAssumption.invalidate(msg);
            this.directByteBufferCurrentAssumption = this.directByteBufferCyclicAssumption.getAssumption();
        });
        this.parseOnly = this.readBooleanOption(PARSE_ONLY);
        this.debug = this.readBooleanOption(DEBUG_BUILTIN);
        this.timerResolution = this.patchLongOption(TIMER_RESOLUTION, TIMER_RESOLUTION_NAME, this.timerResolution, msg -> {
            this.timerResolutionCyclicAssumption.invalidate(msg);
            this.timerResolutionCurrentAssumption = this.timerResolutionCyclicAssumption.getAssumption();
        });
        this.agentCanBlock = this.readBooleanOption(AGENT_CAN_BLOCK);
        this.awaitOptimization = this.readBooleanOption(AWAIT_OPTIMIZATION);
        this.disableEval = this.readBooleanOption(DISABLE_EVAL);
        this.disableWith = this.readBooleanOption(DISABLE_WITH);
        this.regexDumpAutomata = this.readBooleanOption(REGEX_DUMP_AUTOMATA);
        this.regexStepExecution = this.readBooleanOption(REGEX_STEP_EXECUTION);
        this.regexAlwaysEager = this.readBooleanOption(REGEX_ALWAYS_EAGER);
        this.scriptEngineGlobalScopeImport = this.readBooleanOption(SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT);
        this.hasForeignObjectPrototype = this.readBooleanOption(FOREIGN_OBJECT_PROTOTYPE) || this.readBooleanOption(EXPERIMENTAL_FOREIGN_OBJECT_PROTOTYPE);
        this.functionArgumentsLimit = this.readLongOption(FUNCTION_ARGUMENTS_LIMIT);
        this.test262Mode = this.readBooleanOption(TEST262_MODE);
        this.testV8Mode = this.readBooleanOption(TESTV8_MODE);
        this.validateRegExpLiterals = this.readBooleanOption(VALIDATE_REGEXP_LITERALS);
        this.functionConstructorCacheSize = this.readIntegerOption(FUNCTION_CONSTRUCTOR_CACHE_SIZE);
        this.stringLengthLimit = this.readIntegerOption(STRING_LENGTH_LIMIT);
        this.bindMemberFunctions = this.readBooleanOption(BIND_MEMBER_FUNCTIONS);
        this.commonJSRequire = this.readBooleanOption(COMMONJS_REQUIRE);
        this.regexRegressionTestMode = this.readBooleanOption(REGEX_REGRESSION_TEST_MODE);
        this.interopCompletePromises = this.readBooleanOption(INTEROP_COMPLETE_PROMISES);
        this.testCloneUninitialized = this.readBooleanOption(TEST_CLONE_UNINITIALIZED);
        this.lazyTranslation = this.readBooleanOption(LAZY_TRANSLATION);
        this.stackTraceLimit = this.readIntegerOption(STACK_TRACE_LIMIT);
        this.maxTypedArrayLength = this.readIntegerOption(MAX_TYPED_ARRAY_LENGTH);
        this.maxApplyArgumentLength = this.readIntegerOption(MAX_APPLY_ARGUMENT_LENGTH);
        this.maxPrototypeChainLength = this.readIntegerOption(MAX_PROTOTYPE_CHAIN_LENGTH);
        this.asyncStackTraces = this.readBooleanOption(ASYNC_STACK_TRACES);
        this.propertyCacheLimit = this.readIntegerOption(PROPERTY_CACHE_LIMIT);
        this.functionCacheLimit = this.readIntegerOption(FUNCTION_CACHE_LIMIT);
    }

    private boolean patchBooleanOption(OptionKey<Boolean> key, String name, boolean oldValue, Consumer<String> invalidate) {
        boolean newValue = this.readBooleanOption(key);
        if (oldValue != newValue) {
            invalidate.accept(String.format("Option %s was changed from %b to %b.", name, oldValue, newValue));
        }
        return newValue;
    }

    private boolean readBooleanOption(OptionKey<Boolean> key) {
        return (Boolean)key.getValue(this.optionValues);
    }

    private int readIntegerOption(OptionKey<Integer> key) {
        return (Integer)key.getValue(this.optionValues);
    }

    private long patchLongOption(OptionKey<Long> key, String name, long oldValue, Consumer<String> invalidate) {
        long newValue = this.readLongOption(key);
        if (oldValue != newValue) {
            invalidate.accept(String.format("Option %s was changed from %d to %d.", name, oldValue, newValue));
        }
        return newValue;
    }

    private long readLongOption(OptionKey<Long> key) {
        return (Long)key.getValue(this.optionValues);
    }

    public static String helpWithDefault(String helpMessage, OptionKey<? extends Object> key) {
        return helpMessage + " (default:" + key.getDefaultValue() + ")";
    }

    public static OptionDescriptor newOptionDescriptor(OptionKey<?> key, String name, OptionCategory category, OptionStability stability, String help) {
        return OptionDescriptor.newBuilder(key, (String)name).category(category).help(JSContextOptions.helpWithDefault(help, key)).stability(stability).build();
    }

    public static void describeOptions(List<OptionDescriptor> options) {
        Iterator<OptionDescriptor> iterator = new JSContextOptionsOptionDescriptors().iterator();
        while (iterator.hasNext()) {
            OptionDescriptor desc = iterator.next();
            options.add(JSContextOptions.newOptionDescriptor(desc.getKey(), desc.getName(), desc.getCategory(), desc.getStability(), desc.getHelp()));
        }
    }

    public <T> boolean optionWillChange(OptionKey<T> option, OptionValues newOptionValues) {
        return !option.getValue(this.optionValues).equals(option.getValue(newOptionValues));
    }

    public int getEcmaScriptVersion() {
        return this.ecmascriptVersion;
    }

    public boolean isAnnexB() {
        return this.annexB;
    }

    public boolean isIntl402() {
        CompilerAsserts.neverPartOfCompilation((String)"Patchable option intl-402 should never be accessed in compiled code.");
        return this.intl402;
    }

    public boolean isRegexpMatchIndices() {
        return this.regexpMatchIndices;
    }

    public boolean isRegexpStaticResult() {
        try {
            this.regexpStaticResultCurrentAssumption.check();
        }
        catch (InvalidAssumptionException invalidAssumptionException) {
            // empty catch block
        }
        return this.regexpStaticResult;
    }

    public boolean isArraySortInherited() {
        try {
            this.arraySortInheritedCurrentAssumption.check();
        }
        catch (InvalidAssumptionException invalidAssumptionException) {
            // empty catch block
        }
        return this.arraySortInherited;
    }

    public boolean isSharedArrayBuffer() {
        if (this.getEcmaScriptVersion() < 8) {
            return false;
        }
        return this.sharedArrayBuffer;
    }

    public boolean isAtomics() {
        if (this.getEcmaScriptVersion() < 8) {
            return false;
        }
        return (Boolean)ATOMICS.getValue(this.optionValues);
    }

    public boolean isV8CompatibilityMode() {
        try {
            this.v8CompatibilityModeCurrentAssumption.check();
        }
        catch (InvalidAssumptionException invalidAssumptionException) {
            // empty catch block
        }
        return this.v8CompatibilityMode;
    }

    public boolean isNashornCompatibilityMode() {
        return this.nashornCompatibilityMode;
    }

    public boolean isDebugBuiltin() {
        return this.debug;
    }

    public boolean isDirectByteBuffer() {
        try {
            this.directByteBufferCurrentAssumption.check();
        }
        catch (InvalidAssumptionException invalidAssumptionException) {
            // empty catch block
        }
        return this.directByteBuffer;
    }

    public boolean isParseOnly() {
        return this.parseOnly;
    }

    public long getTimerResolution() {
        try {
            this.timerResolutionCurrentAssumption.check();
        }
        catch (InvalidAssumptionException invalidAssumptionException) {
            // empty catch block
        }
        return this.timerResolution;
    }

    public boolean isV8RealmBuiltin() {
        return this.v8RealmBuiltin;
    }

    public boolean isV8LegacyConst() {
        return this.v8LegacyConst;
    }

    public boolean canAgentBlock() {
        return this.agentCanBlock;
    }

    public boolean isAwaitOptimization() {
        return this.awaitOptimization;
    }

    public boolean isDisableEval() {
        return this.disableEval;
    }

    public boolean isDisableWith() {
        return this.disableWith;
    }

    public boolean isRegexDumpAutomata() {
        return this.regexDumpAutomata;
    }

    public boolean isRegexStepExecution() {
        return this.regexStepExecution;
    }

    public boolean isRegexAlwaysEager() {
        return this.regexAlwaysEager;
    }

    public boolean isScriptEngineGlobalScopeImport() {
        return this.scriptEngineGlobalScopeImport;
    }

    public boolean hasForeignObjectPrototype() {
        return this.hasForeignObjectPrototype;
    }

    public boolean isGlobalProperty() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option global-property was assumed not to be accessed in compiled code.");
        return (Boolean)GLOBAL_PROPERTY.getValue(this.optionValues);
    }

    public boolean isGlobalArguments() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option js.global-arguments was assumed not to be accessed in compiled code.");
        return (Boolean)GLOBAL_ARGUMENTS.getValue(this.optionValues);
    }

    public boolean isConsole() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option console was assumed not to be accessed in compiled code.");
        return (Boolean)CONSOLE.getValue(this.optionValues) != false || !CONSOLE.hasBeenSet(this.optionValues) && this.isShell();
    }

    public boolean isPrint() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option print was assumed not to be accessed in compiled code.");
        return (Boolean)PRINT.getValue(this.optionValues) != false || !PRINT.hasBeenSet(this.optionValues) && (this.isShell() || this.isNashornCompatibilityMode());
    }

    public boolean isLoad() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option load was assumed not to be accessed in compiled code.");
        return (Boolean)LOAD.getValue(this.optionValues) != false || !LOAD.hasBeenSet(this.optionValues) && (this.isShell() || this.isNashornCompatibilityMode());
    }

    public boolean isCommonJSRequire() {
        return this.commonJSRequire;
    }

    public Map<String, String> getCommonJSRequireBuiltins() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option load was assumed not to be accessed in compiled code.");
        return (Map)COMMONJS_CORE_MODULES_REPLACEMENTS.getValue(this.optionValues);
    }

    public String getCommonJSRequireGlobals() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option load was assumed not to be accessed in compiled code.");
        return (String)COMMONJS_REQUIRE_GLOBAL_PROPERTIES.getValue(this.optionValues);
    }

    public String getRequireCwd() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option load was assumed not to be accessed in compiled code.");
        return (String)COMMONJS_REQUIRE_CWD.getValue(this.optionValues);
    }

    public boolean isPerformance() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option performance was assumed not to be accessed in compiled code.");
        return (Boolean)PERFORMANCE.getValue(this.optionValues) != false || !PERFORMANCE.hasBeenSet(this.optionValues) && this.isShell();
    }

    public boolean isShell() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option shell was assumed not to be accessed in compiled code.");
        return (Boolean)SHELL.getValue(this.optionValues);
    }

    public boolean isGraalBuiltin() {
        return (Boolean)GRAAL_BUILTIN.getValue(this.optionValues);
    }

    public boolean isPolyglotBuiltin() {
        return (Boolean)POLYGLOT_BUILTIN.getValue(this.optionValues);
    }

    public boolean isPolyglotEvalFile() {
        return (Boolean)POLYGLOT_EVALFILE.getValue(this.optionValues);
    }

    public boolean isLoadFromURL() {
        return (Boolean)LOAD_FROM_URL.getValue(this.optionValues);
    }

    public boolean isLoadFromClasspath() {
        return (Boolean)LOAD_FROM_CLASSPATH.getValue(this.optionValues);
    }

    public boolean isBigInt() {
        if (this.getEcmaScriptVersion() < 10) {
            return false;
        }
        return (Boolean)BIGINT.getValue(this.optionValues);
    }

    public long getFunctionArgumentsLimit() {
        return this.functionArgumentsLimit;
    }

    public boolean isTest262Mode() {
        return this.test262Mode;
    }

    public boolean isTestV8Mode() {
        return this.testV8Mode;
    }

    public boolean isValidateRegExpLiterals() {
        return this.validateRegExpLiterals;
    }

    public String getLocale() {
        return (String)LOCALE.getValue(this.optionValues);
    }

    public int getFunctionConstructorCacheSize() {
        return this.functionConstructorCacheSize;
    }

    public int getStringLengthLimit() {
        return this.stringLengthLimit;
    }

    public boolean bindMemberFunctions() {
        return this.bindMemberFunctions;
    }

    public boolean isRegexRegressionTestMode() {
        return this.regexRegressionTestMode;
    }

    public boolean interopCompletePromises() {
        return this.interopCompletePromises;
    }

    public String getDebugPropertyName() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option debug-property-name was assumed not to be accessed in compiled code.");
        return (String)DEBUG_PROPERTY_NAME.getValue(this.optionValues);
    }

    public boolean isProfileTime() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option profile-time was assumed not to be accessed in compiled code.");
        return (Boolean)PROFILE_TIME.getValue(this.optionValues);
    }

    public boolean isTestCloneUninitialized() {
        return this.testCloneUninitialized;
    }

    public boolean isLazyTranslation() {
        return this.lazyTranslation;
    }

    public boolean isProfileTimePrintCumulative() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option profile-time-print-cumulative was assumed not to be accessed in compiled code.");
        return (Boolean)PROFILE_TIME_PRINT_CUMULATIVE.getValue(this.optionValues);
    }

    public int getStackTraceLimit() {
        return this.stackTraceLimit;
    }

    public int getMaxTypedArrayLength() {
        return this.maxTypedArrayLength;
    }

    public int getMaxApplyArgumentLength() {
        return this.maxApplyArgumentLength;
    }

    public int getMaxPrototypeChainLength() {
        return this.maxPrototypeChainLength;
    }

    public int getPropertyCacheLimit() {
        return this.propertyCacheLimit;
    }

    public int getFunctionCacheLimit() {
        return this.functionCacheLimit;
    }

    public boolean isAsyncStackTraces() {
        return this.asyncStackTraces;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + Objects.hashCode(this.parserOptions);
        hash = 53 * hash + this.ecmascriptVersion;
        hash = 53 * hash + (this.annexB ? 1 : 0);
        hash = 53 * hash + (this.intl402 ? 1 : 0);
        hash = 53 * hash + (this.regexpMatchIndices ? 1 : 0);
        hash = 53 * hash + (this.regexpStaticResult ? 1 : 0);
        hash = 53 * hash + (this.arraySortInherited ? 1 : 0);
        hash = 53 * hash + (this.sharedArrayBuffer ? 1 : 0);
        hash = 53 * hash + (this.v8CompatibilityMode ? 1 : 0);
        hash = 53 * hash + (this.v8RealmBuiltin ? 1 : 0);
        hash = 53 * hash + (this.v8LegacyConst ? 1 : 0);
        hash = 53 * hash + (this.nashornCompatibilityMode ? 1 : 0);
        hash = 53 * hash + (this.debug ? 1 : 0);
        hash = 53 * hash + (this.directByteBuffer ? 1 : 0);
        hash = 53 * hash + (this.parseOnly ? 1 : 0);
        hash = 53 * hash + (int)this.timerResolution;
        hash = 53 * hash + (this.agentCanBlock ? 1 : 0);
        hash = 53 * hash + (this.awaitOptimization ? 1 : 0);
        hash = 53 * hash + (this.disableEval ? 1 : 0);
        hash = 53 * hash + (this.disableWith ? 1 : 0);
        hash = 53 * hash + (this.regexDumpAutomata ? 1 : 0);
        hash = 53 * hash + (this.regexStepExecution ? 1 : 0);
        hash = 53 * hash + (this.regexAlwaysEager ? 1 : 0);
        hash = 53 * hash + (this.scriptEngineGlobalScopeImport ? 1 : 0);
        hash = 53 * hash + (this.hasForeignObjectPrototype ? 1 : 0);
        hash = 53 * hash + (int)this.functionArgumentsLimit;
        hash = 53 * hash + (this.test262Mode ? 1 : 0);
        hash = 53 * hash + (this.testV8Mode ? 1 : 0);
        hash = 53 * hash + (this.validateRegExpLiterals ? 1 : 0);
        hash = 53 * hash + this.functionConstructorCacheSize;
        hash = 53 * hash + this.stringLengthLimit;
        hash = 53 * hash + (this.bindMemberFunctions ? 1 : 0);
        hash = 53 * hash + (this.commonJSRequire ? 1 : 0);
        hash = 53 * hash + (this.regexRegressionTestMode ? 1 : 0);
        hash = 53 * hash + (this.interopCompletePromises ? 1 : 0);
        hash = 53 * hash + (this.testCloneUninitialized ? 1 : 0);
        hash = 53 * hash + (this.lazyTranslation ? 1 : 0);
        hash = 53 * hash + this.stackTraceLimit;
        hash = 53 * hash + (this.asyncStackTraces ? 1 : 0);
        hash = 53 * hash + this.maxTypedArrayLength;
        hash = 53 * hash + this.maxApplyArgumentLength;
        hash = 53 * hash + this.maxPrototypeChainLength;
        hash = 53 * hash + this.propertyCacheLimit;
        hash = 53 * hash + this.functionCacheLimit;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSContextOptions other = (JSContextOptions)obj;
        if (this.ecmascriptVersion != other.ecmascriptVersion) {
            return false;
        }
        if (this.annexB != other.annexB) {
            return false;
        }
        if (this.intl402 != other.intl402) {
            return false;
        }
        if (this.regexpMatchIndices != other.regexpMatchIndices) {
            return false;
        }
        if (this.regexpStaticResult != other.regexpStaticResult) {
            return false;
        }
        if (this.arraySortInherited != other.arraySortInherited) {
            return false;
        }
        if (this.sharedArrayBuffer != other.sharedArrayBuffer) {
            return false;
        }
        if (this.v8CompatibilityMode != other.v8CompatibilityMode) {
            return false;
        }
        if (this.v8RealmBuiltin != other.v8RealmBuiltin) {
            return false;
        }
        if (this.v8LegacyConst != other.v8LegacyConst) {
            return false;
        }
        if (this.nashornCompatibilityMode != other.nashornCompatibilityMode) {
            return false;
        }
        if (this.debug != other.debug) {
            return false;
        }
        if (this.directByteBuffer != other.directByteBuffer) {
            return false;
        }
        if (this.parseOnly != other.parseOnly) {
            return false;
        }
        if (this.timerResolution != other.timerResolution) {
            return false;
        }
        if (this.agentCanBlock != other.agentCanBlock) {
            return false;
        }
        if (this.awaitOptimization != other.awaitOptimization) {
            return false;
        }
        if (this.disableEval != other.disableEval) {
            return false;
        }
        if (this.disableWith != other.disableWith) {
            return false;
        }
        if (this.regexDumpAutomata != other.regexDumpAutomata) {
            return false;
        }
        if (this.regexStepExecution != other.regexStepExecution) {
            return false;
        }
        if (this.regexAlwaysEager != other.regexAlwaysEager) {
            return false;
        }
        if (this.scriptEngineGlobalScopeImport != other.scriptEngineGlobalScopeImport) {
            return false;
        }
        if (this.hasForeignObjectPrototype != other.hasForeignObjectPrototype) {
            return false;
        }
        if (this.functionArgumentsLimit != other.functionArgumentsLimit) {
            return false;
        }
        if (this.test262Mode != other.test262Mode) {
            return false;
        }
        if (this.testV8Mode != other.testV8Mode) {
            return false;
        }
        if (this.validateRegExpLiterals != other.validateRegExpLiterals) {
            return false;
        }
        if (this.functionConstructorCacheSize != other.functionConstructorCacheSize) {
            return false;
        }
        if (this.stringLengthLimit != other.stringLengthLimit) {
            return false;
        }
        if (this.bindMemberFunctions != other.bindMemberFunctions) {
            return false;
        }
        if (this.commonJSRequire != other.commonJSRequire) {
            return false;
        }
        if (this.regexRegressionTestMode != other.regexRegressionTestMode) {
            return false;
        }
        if (this.interopCompletePromises != other.interopCompletePromises) {
            return false;
        }
        if (this.testCloneUninitialized != other.testCloneUninitialized) {
            return false;
        }
        if (this.lazyTranslation != other.lazyTranslation) {
            return false;
        }
        if (this.stackTraceLimit != other.stackTraceLimit) {
            return false;
        }
        if (this.asyncStackTraces != other.asyncStackTraces) {
            return false;
        }
        if (this.maxTypedArrayLength != other.maxTypedArrayLength) {
            return false;
        }
        if (this.maxApplyArgumentLength != other.maxApplyArgumentLength) {
            return false;
        }
        if (this.maxPrototypeChainLength != other.maxPrototypeChainLength) {
            return false;
        }
        if (this.propertyCacheLimit != other.propertyCacheLimit) {
            return false;
        }
        if (this.functionCacheLimit != other.functionCacheLimit) {
            return false;
        }
        return Objects.equals(this.parserOptions, other.parserOptions);
    }
}

