/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JavaScriptNode.class)
final class JavaScriptNodeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private JavaScriptNodeGen() {
    }

    static {
        LibraryExport.register(JavaScriptNode.class, (LibraryExport[])new LibraryExport[]{new NodeLibraryExports()});
    }

    @GeneratedBy(value=JavaScriptNode.class)
    private static final class NodeLibraryExports
    extends LibraryExport<NodeLibrary> {
        private NodeLibraryExports() {
            super(NodeLibrary.class, JavaScriptNode.class, false);
        }

        protected NodeLibrary createUncached(Object receiver) {
            assert (receiver instanceof JavaScriptNode);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NodeLibrary createCached(Object receiver) {
            assert (receiver instanceof JavaScriptNode);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JavaScriptNode.class)
        private static final class Uncached
        extends NodeLibrary {
            private final Class<? extends JavaScriptNode> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((Object)((Object)((JavaScriptNode)((Object)receiver)))).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_ && Uncached.accepts_(receiver);
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasScope(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode)((Object)receiver)).hasScope(frame);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getScope(Object arg0Value_, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JavaScriptNode arg0Value = (JavaScriptNode)((Object)arg0Value_);
                return arg0Value.getScope(arg1Value, arg2Value, JavaScriptNode.findBlockScopeNode(arg0Value));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasReceiverMember(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode)((Object)receiver)).hasReceiverMember(frame);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getReceiverMember(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode)((Object)receiver)).getReceiverMember(frame);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasRootInstance(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode)((Object)receiver)).hasRootInstance(frame);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getRootInstance(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode)((Object)receiver)).getRootInstance(frame);
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                JavaScriptNode arg0Value = (JavaScriptNode)((Object)arg0Value_);
                return arg0Value.accepts(arg0Value);
            }
        }

        @GeneratedBy(value=JavaScriptNode.class)
        private static final class Cached
        extends NodeLibrary {
            private final Class<? extends JavaScriptNode> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @CompilerDirectives.CompilationFinal
            private JavaScriptNode acceptsNode__cachedNode_;
            @CompilerDirectives.CompilationFinal
            private Node getScopeNode__block_;

            Cached(Object originalReceiver) {
                JavaScriptNode receiver;
                this.acceptsNode__cachedNode_ = receiver = (JavaScriptNode)((Object)originalReceiver);
                this.receiverClass_ = ((Object)((Object)receiver)).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_ && this.accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                JavaScriptNode arg0Value = (JavaScriptNode)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                return arg0Value.accepts(this.acceptsNode__cachedNode_);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public boolean hasScope(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                return ((JavaScriptNode)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).hasScope(frame);
            }

            public Object getScope(Object arg0Value_, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                JavaScriptNode arg0Value = (JavaScriptNode)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                int state = this.state_;
                if (state != 0) {
                    return arg0Value.getScope(arg1Value, arg2Value, this.getScopeNode__block_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getScopeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getScopeNode_AndSpecialize(JavaScriptNode arg0Value, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.getScopeNode__block_ = JavaScriptNode.findBlockScopeNode(arg0Value);
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.getScope(arg1Value, arg2Value, this.getScopeNode__block_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasReceiverMember(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                return ((JavaScriptNode)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).hasReceiverMember(frame);
            }

            public Object getReceiverMember(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                return ((JavaScriptNode)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).getReceiverMember(frame);
            }

            public boolean hasRootInstance(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                return ((JavaScriptNode)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).hasRootInstance(frame);
            }

            public Object getRootInstance(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                return ((JavaScriptNode)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).getRootInstance(frame);
            }
        }
    }
}

