/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.commit.Bundle;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.ui.commit.CommitPanel;
import org.netbeans.modules.mercurial.ui.commit.CommitTable;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.diff.SaveBeforeCommitConfirmation;
import org.netbeans.modules.versioning.hooks.HgHook;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommitAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";
    static final String KEY_CANCELED_MESSAGE = "commit";
    private static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/resources/icons/commit.png";
    private static final String ERROR_COLOR;
    private static final String INFO_COLOR;

    public CommitAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(context) && ctxFiles != null && !ctxFiles.isEmpty();
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Commit";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        File root = HgUtils.getRootFile(context);
        if (root == null) {
            OutputLogger logger = Mercurial.getInstance().getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_INFO"));
            logger.output("");
            logger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        String contentTitle = Utils.getContextDisplayName((VCSContext)context);
        CommitAction.commit(contentTitle, context);
    }

    public static void commit(final String contentTitle, final VCSContext ctx) {
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                File root = HgUtils.getRootFile(ctx);
                if (root == null) {
                    Mercurial.LOG.log(Level.FINE, "CommitAction.commit: null owner for {0}", ctx.getRootFiles());
                    return;
                }
                if (HgUtils.isRebasing(root)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_CommitAction_interruptedRebase_error(root.getName()), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommitAction.commit(contentTitle, ctx, null);
                    }
                });
            }
        });
    }

    private static void commit(String contentTitle, VCSContext ctx, final String branchName) {
        boolean closingBranch;
        File repository = HgUtils.getRootFile(ctx);
        boolean bl = closingBranch = branchName != null;
        if (repository == null) {
            return;
        }
        final CommitPanel panel = new CommitPanel();
        final Collection hooks = VCSHooks.getInstance().getHooks(HgHook.class);
        panel.setHooks(hooks, new HgHookContext(ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]), null, new HgHookContext.LogEntry[0]));
        final CommitTable data = new CommitTable(panel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        panel.setCommitTable(data);
        data.setCommitPanel(panel);
        panel.cbAllFiles.setVisible(closingBranch);
        final AtomicBoolean afterMerge = new AtomicBoolean(false);
        if (closingBranch) {
            panel.cbAllFiles.setSelected(false);
            panel.cbAllFiles.doClick();
            panel.cbAllFiles.setEnabled(false);
        }
        final JButton commitButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)commitButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        if (closingBranch) {
            commitButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_CloseBranch"));
            commitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_CloseBranch"));
        } else {
            commitButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Commit"));
            commitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Commit"));
        }
        final JButton cancelButton = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Cancel"));
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)contentTitle), true, new Object[]{commitButton, cancelButton}, (Object)commitButton, 0, new HelpCtx(CommitAction.class), null);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dd.setClosingOptions(new Object[]{commitButton, cancelButton});
                SaveCookie[] saveCookies = panel.getSaveCookies();
                if (cancelButton == e.getSource()) {
                    if (saveCookies.length > 0) {
                        if (SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies) || !panel.isShowing()) {
                            EditorCookie[] editorCookies;
                            for (EditorCookie cookie : editorCookies = panel.getEditorCookies()) {
                                cookie.open();
                            }
                        } else {
                            dd.setClosingOptions(new Object[0]);
                        }
                    }
                    dd.setValue((Object)cancelButton);
                } else if (commitButton == e.getSource()) {
                    if (saveCookies.length > 0 && !SaveBeforeCommitConfirmation.allSaved((SaveCookie[])saveCookies)) {
                        dd.setClosingOptions(new Object[0]);
                    } else if (!panel.canCommit()) {
                        dd.setClosingOptions(new Object[0]);
                    }
                    dd.setValue((Object)commitButton);
                }
            }
        };
        dd.setButtonListener(al);
        CommitAction.computeNodes(data, panel, ctx, repository, cancelButton, afterMerge);
        HgProgressSupport incomingChanges = CommitAction.checkForIncomingChanges(repository, panel, afterMerge);
        commitButton.setEnabled(false);
        panel.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent event) {
                CommitAction.refreshCommitDialog(panel, data, commitButton, branchName, afterMerge);
            }
        });
        data.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CommitAction.refreshCommitDialog(panel, data, commitButton, branchName, afterMerge);
            }
        });
        commitButton.setEnabled(CommitAction.containsCommitable(data));
        panel.putClientProperty("contentTitle", contentTitle);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        DialogBoundsPreserver windowListener = new DialogBoundsPreserver(HgModuleConfig.getDefault().getPreferences(), "hg.commit.dialog");
        dialog.addWindowListener((WindowListener)windowListener);
        dialog.pack();
        windowListener.windowOpened(new WindowEvent(dialog, 200));
        dialog.setVisible(true);
        if (incomingChanges != null) {
            incomingChanges.cancel();
        }
        final String message = panel.getCommitMessage().trim();
        if (dd.getValue() != commitButton && !message.isEmpty()) {
            HgModuleConfig.getDefault().setLastCanceledCommitMessage(KEY_CANCELED_MESSAGE, message);
        }
        if (dd.getValue() == DialogDescriptor.CLOSED_OPTION) {
            al.actionPerformed(new ActionEvent(cancelButton, 1001, null));
            panel.closed();
        } else if (dd.getValue() == commitButton) {
            panel.closed();
            final Map<HgFileNode, CommitOptions> commitFiles = data.getCommitFiles();
            final Map<File, Set<File>> rootFiles = HgUtils.sortUnderRepository(ctx, true);
            final boolean commitAllFiles = panel.cbAllFiles.isSelected() || afterMerge.get();
            HgModuleConfig.getDefault().setLastCanceledCommitMessage(KEY_CANCELED_MESSAGE, "");
            Utils.insert((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)message.trim(), (int)20);
            final String user = panel.getUser();
            if (user != null) {
                HgModuleConfig.getDefault().putRecentCommitAuthors(user);
            }
            RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
            HgProgressSupport support = new HgProgressSupport(){

                @Override
                public void perform() {
                    OutputLogger logger = this.getLogger();
                    CommitAction.performCommit(message, commitFiles, rootFiles, this, logger, hooks, user, commitAllFiles, closingBranch, afterMerge.get());
                }
            };
            support.start(rp, repository, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
        }
    }

    public void closeBranch(String branchName, VCSContext ctx, String contentTitle) {
        CommitAction.commit(contentTitle, ctx, branchName);
    }

    private static void computeNodes(final CommitTable table, final CommitPanel panel, final VCSContext ctx, final File repository, JButton cancel, final AtomicBoolean afterMerge) {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(NbBundle.getMessage(CommitAction.class, (String)"Progress_Preparing_Commit"), cancel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                try {
                    afterMerge.set(WorkingCopyInfo.getInstance(repository).getWorkingCopyParents().length > 1);
                    panel.progressPanel.setVisible(true);
                    this.setupUsers();
                    StatusAction.executeStatus(ctx, this);
                    FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
                    File[] roots = ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]);
                    File[][] split = Utils.splitFlatOthers((File[])roots);
                    ArrayList<File> fileList = new ArrayList<File>();
                    for (int c = 0; c < split.length; ++c) {
                        boolean recursive;
                        roots = split[c];
                        boolean bl = recursive = c == 1;
                        if (recursive) {
                            Set<File> repositories = HgUtils.getRepositoryRoots(ctx);
                            File[] files = cache.listFiles(ctx, 6612);
                            for (int i = 0; i < files.length; ++i) {
                                for (int r = 0; r < roots.length; ++r) {
                                    if (!repositories.contains(Mercurial.getInstance().getRepositoryRoot(files[i])) || !HgUtils.isParentOrEqual(roots[r], files[i]) || fileList.contains(files[i])) continue;
                                    fileList.add(files[i]);
                                }
                            }
                            continue;
                        }
                        File[] files = HgUtils.flatten(roots, 6612);
                        for (int i = 0; i < files.length; ++i) {
                            if (fileList.contains(files[i])) continue;
                            fileList.add(files[i]);
                        }
                    }
                    ArrayList<HgFileNode> nodesList = new ArrayList<HgFileNode>(fileList.size());
                    for (File file : fileList) {
                        HgFileNode node = new HgFileNode(repository, file);
                        nodesList.add(node);
                    }
                    final HgFileNode[] nodes = nodesList.toArray(new HgFileNode[fileList.size()]);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            table.setNodes(nodes);
                            if (nodes.length > 0 && ctx.getRootFiles().size() == 1 && ((File)ctx.getRootFiles().iterator().next()).equals(repository)) {
                                panel.cbAllFiles.setEnabled(true);
                            }
                        }
                    });
                }
                finally {
                    panel.progressPanel.setVisible(false);
                }
            }

            private void setupUsers() {
                HgConfigFiles config = new HgConfigFiles(repository);
                String userName = config.getUserName(false);
                if (userName.isEmpty()) {
                    config = HgConfigFiles.getSysInstance();
                    userName = config.getUserName(false);
                }
                List<String> recentUsers = HgModuleConfig.getDefault().getRecentCommitAuthors();
                if (!userName.isEmpty()) {
                    recentUsers.remove(userName);
                    recentUsers.add(0, userName);
                }
                final DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(recentUsers.toArray(new String[recentUsers.size()]));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        panel.cmbUser.setModel(model);
                        panel.cbAuthor.setEnabled(true);
                    }
                });
            }
        };
        panel.progressPanel.add((Component)support.getProgressComponent());
        panel.progressPanel.setVisible(true);
        support.start(rp);
    }

    private static boolean containsCommitable(CommitTable data) {
        Map<HgFileNode, CommitOptions> map = data.getCommitFiles();
        for (CommitOptions co : map.values()) {
            if (co == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel panel, CommitTable table, JButton commit, String branchToClose, AtomicBoolean afterMerge) {
        assert (EventQueue.isDispatchThread());
        ResourceBundle loc = NbBundle.getBundle(CommitAction.class);
        Map<HgFileNode, CommitOptions> files = table.getCommitFiles();
        boolean errors = false;
        boolean enabled = commit.isEnabled();
        for (HgFileNode fileNode : files.keySet()) {
            int status;
            CommitOptions options = files.get((Object)fileNode);
            if (options == CommitOptions.EXCLUDE || ((status = fileNode.getInformation().getStatus()) & 0x6A0) == 0 && status != 64) continue;
            enabled = false;
            String msg = status == 64 ? loc.getString("MSG_CommitForm_ErrorConflicts") : loc.getString("MSG_CommitForm_ErrorRemoteChanges");
            panel.setErrorLabel("<html><font color=\"" + ERROR_COLOR + "\">" + msg + "</font></html>");
            errors = true;
        }
        if (!errors && !panel.isUserValid()) {
            String msg = Bundle.MSG_CommitForm_ErrorInvalidAuthor();
            panel.setErrorLabel("<html><font color=\"" + INFO_COLOR + "\">" + msg + "</font></html>");
            errors = true;
        }
        table.setColumns(new String[]{KEY_CANCELED_MESSAGE, "name", "status", "action", "path"});
        String contentTitle = (String)panel.getClientProperty("contentTitle");
        DialogDescriptor dd = (DialogDescriptor)panel.getClientProperty("DialogDescriptor");
        dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title"), contentTitle));
        if (!errors) {
            if (afterMerge.get()) {
                panel.setErrorLabel("<html><font color=\"" + INFO_COLOR + "\">" + NbBundle.getMessage(CommitAction.class, (String)"CommitPanel.info.merge.allFiles") + "</font></html>");
            } else if (panel.cbAllFiles.isSelected()) {
                panel.setErrorLabel("<html><font color=\"" + INFO_COLOR + "\">" + NbBundle.getMessage(CommitAction.class, (String)"CommitPanel.info.closingBranch.allFiles", (Object)branchToClose) + "</font></html>");
            } else {
                panel.setErrorLabel("");
            }
            enabled = true;
        }
        commit.setEnabled(enabled && (afterMerge.get() || panel.cbAllFiles.isSelected() || CommitAction.containsCommitable(table)));
    }

    public static void performCommit(String message, Map<HgFileNode, CommitOptions> commitFiles, Map<File, Set<File>> rootFiles, HgProgressSupport support, OutputLogger logger, Collection<HgHook> hooks) {
        CommitAction.performCommit(message, commitFiles, rootFiles, support, logger, hooks, null, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCommit(String message, Map<HgFileNode, CommitOptions> commitFiles, Map<File, Set<File>> rootFiles, HgProgressSupport support, OutputLogger logger, Collection<HgHook> hooks, String user, boolean commitAllFiles, boolean closeBranch, boolean afterMerge) {
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        HashMap<File, List<File>> addCandidates = new HashMap<File, List<File>>();
        HashMap<File, List<File>> deleteCandidates = new HashMap<File, List<File>>();
        HashMap<File, List<File>> commitCandidates = new HashMap<File, List<File>>();
        HashMap<File, Set<File>> filesToRefresh = new HashMap<File, Set<File>>();
        ArrayList<String> excPaths = new ArrayList<String>();
        HashMap<File, Boolean> locallyModifiedExcluded = new HashMap<File, Boolean>();
        ArrayList<String> incPaths = new ArrayList<String>();
        if (commitAllFiles && closeBranch) {
            assert (rootFiles.size() == 1);
            for (File file : rootFiles.keySet()) {
                commitCandidates.put(file, Collections.emptyList());
            }
        } else {
            for (Map.Entry entry : commitFiles.entrySet()) {
                int status;
                if (support.isCanceled()) {
                    return;
                }
                HgFileNode node = (HgFileNode)((Object)entry.getKey());
                CommitOptions option = (CommitOptions)entry.getValue();
                File repository = Mercurial.getInstance().getRepositoryRoot(node.getFile());
                if (option != CommitOptions.EXCLUDE) {
                    status = cache.getStatus(node.getFile()).getStatus();
                    if ((status & 4) != 0) {
                        CommitAction.putCandidate(addCandidates, repository, node.getFile());
                    } else if ((status & 0x800) != 0) {
                        CommitAction.putCandidate(deleteCandidates, repository, node.getFile());
                    }
                    CommitAction.putCandidate(commitCandidates, repository, node.getFile());
                    incPaths.add(node.getFile().getAbsolutePath());
                    continue;
                }
                excPaths.add(node.getFile().getAbsolutePath());
                if (Boolean.TRUE.equals(locallyModifiedExcluded.get(repository))) continue;
                status = cache.getCachedStatus(node.getFile()).getStatus();
                locallyModifiedExcluded.put(repository, (status & 4) == 0);
            }
        }
        if (support.isCanceled()) {
            return;
        }
        if (!excPaths.isEmpty()) {
            HgModuleConfig.getDefault().addExclusionPaths(excPaths);
        }
        if (!incPaths.isEmpty()) {
            HgModuleConfig.getDefault().removeExclusionPaths(incPaths);
        }
        try {
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
            logger.output(message);
            new Cmd.AddCmd(addCandidates, logger, null, "hg add {0} into {1}").handle();
            new Cmd.RemoveCmd(deleteCandidates, logger, null, "hg delete {0} from {1}").handle();
            CommitAction.removeDeletedTemporaryFiles(commitCandidates, deleteCandidates);
            if (support.isCanceled()) {
                return;
            }
            File[] hookFiles = null;
            if (hooks.size() > 0) {
                LinkedList linkedList = new LinkedList();
                for (Object values : commitCandidates.values()) {
                    linkedList.addAll(values);
                }
                hookFiles = linkedList.toArray(new File[linkedList.size()]);
            }
            String string = message;
            HgHookContext context = new HgHookContext(hookFiles, message, new HgHookContext.LogEntry[0]);
            for (HgHook hook : hooks) {
                try {
                    if ((context = hook.beforeCommit(context)) == null) continue;
                    message = context.getMessage();
                }
                catch (IOException iOException) {}
            }
            Cmd.CommitCmd commitCmd = new Cmd.CommitCmd(commitCandidates, logger, message, support, rootFiles, locallyModifiedExcluded, filesToRefresh, user, closeBranch, afterMerge);
            commitCmd.setCommitHooks(context, hooks, hookFiles, string);
            commitCmd.handle();
        }
        catch (HgException.HgCommandCanceledException hookFiles) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            CommitAction.refreshFS(filesToRefresh);
            cache.refreshAllRoots(filesToRefresh);
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
            logger.output("");
        }
    }

    private static void refreshFS(Map<File, Set<File>> filesPerRepository) {
        final HashSet<File> files = new HashSet<File>();
        for (Set<File> values : filesPerRepository.values()) {
            files.addAll(values);
        }
        Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])files.toArray(new File[files.size()]));
            }
        }, 100);
    }

    private static void putCandidate(Map<File, List<File>> m, File repository, File file) {
        List<File> l = m.get(repository);
        if (l == null) {
            l = new ArrayList<File>();
            m.put(repository, l);
        }
        l.add(file);
    }

    private static boolean commitAfterMerge(boolean locallyModifiedExcluded, File repository) {
        if (locallyModifiedExcluded || HgModuleConfig.getDefault().getConfirmCommitAfterMerge()) {
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_AFTER_MERGE_QUERY"));
            descriptor.setTitle(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_AFTER_MERGE_TITLE"));
            descriptor.setMessageType(2);
            descriptor.setOptionType(0);
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return res == NotifyDescriptor.YES_OPTION;
        }
        return true;
    }

    private static HgProgressSupport checkForIncomingChanges(final File repository, final CommitPanel panel, final AtomicBoolean afterMerge) {
        HgProgressSupport supp = new HgProgressSupport(){

            @Override
            protected void perform() {
                if (afterMerge.get()) {
                    return;
                }
                try {
                    String defaultPush = new HgConfigFiles(repository).getDefaultPush(false);
                    if (!HgUtils.isNullOrEmpty(defaultPush)) {
                        try {
                            HgURL pushUrl = new HgURL(defaultPush);
                            if (pushUrl.getScheme().toString().contains("ssh")) {
                                Mercurial.LOG.log(Level.FINE, "Commit: Cannot handle ssh authentication silently: {0}", pushUrl.toHgCommandStringWithNoPassword());
                                return;
                            }
                        }
                        catch (URISyntaxException ex) {
                            Mercurial.LOG.log(Level.INFO, "Commit: Invalid push url: {0}, falling back to command without target", defaultPush);
                        }
                    }
                    final String branch = HgCommand.getBranch(repository);
                    HgCommand.runWithoutUI(new Callable<Void>(){

                        @Override
                        public Void call() throws HgException {
                            if (HgCommand.getOutMessages(repository, null, branch, true, false, 1, OutputLogger.getLogger(null)).length == 0 && !this.isCanceled() && HgCommand.getIncomingMessages(repository, null, branch, true, false, false, 1, OutputLogger.getLogger(null)).length > 0) {
                                panel.setWarningMessage(Bundle.MSG_CommitAction_warning_incomingChanges());
                            }
                            return null;
                        }
                    });
                }
                catch (HgException.HgCommandCanceledException defaultPush) {
                }
                catch (HgException ex) {
                    Logger.getLogger(CommitAction.class.getName()).log(Level.FINE, null, ex);
                }
            }

            @Override
            protected ProgressHandle getProgressHandle() {
                return null;
            }

            @Override
            protected void startProgress() {
            }

            @Override
            protected void finnishProgress() {
            }
        };
        supp.start(Mercurial.getInstance().getRequestProcessor(repository));
        return supp;
    }

    private static void removeDeletedTemporaryFiles(Map<File, List<File>> commitCandidates, Map<File, List<File>> deleteCandidates) {
        for (Map.Entry<File, List<File>> e : deleteCandidates.entrySet()) {
            File root = e.getKey();
            List<File> files = e.getValue();
            if (files.isEmpty()) continue;
            try {
                List<File> commitFiles = commitCandidates.get(root);
                Map<File, FileInformation> status = HgCommand.getStatus(root, files, null, null);
                for (File f : files) {
                    if (status.get(f) != null) continue;
                    commitFiles.remove(f);
                }
            }
            catch (HgException.HgCommandCanceledException ex) {
                return;
            }
            catch (HgException ex) {
                Logger.getLogger(CommitAction.class.getName()).log(Level.FINE, null, ex);
            }
        }
    }

    static /* synthetic */ boolean access$300(boolean x0, File x1) {
        return CommitAction.commitAfterMerge(x0, x1);
    }

    static {
        Color c = UIManager.getColor("nb.errorForeground");
        ERROR_COLOR = c == null ? "#CC0000" : HgUtils.getColorString(c);
        c = UIManager.getColor("nb.warningForeground");
        INFO_COLOR = c == null ? "#002080" : HgUtils.getColorString(c);
    }

    private static abstract class Cmd {
        protected final Map<File, List<File>> m;
        protected final OutputLogger logger;
        protected final String logMsgFormat;
        protected final String msg;

        public Cmd(Map<File, List<File>> m, OutputLogger logger, String msg, String logMsgFormat) {
            this.m = m;
            this.logger = logger;
            this.logMsgFormat = logMsgFormat;
            this.msg = msg;
        }

        void handle() throws HgException {
            if (this.m.isEmpty()) {
                return;
            }
            for (Map.Entry<File, List<File>> e : this.m.entrySet()) {
                this.doCmd(e.getKey(), e.getValue());
                for (File f : e.getValue()) {
                    this.logger.output(MessageFormat.format(this.logMsgFormat, f.getName(), e.getKey()));
                }
            }
        }

        abstract void doCmd(File var1, List<File> var2) throws HgException;

        static class CommitCmd
        extends Cmd {
            private HgHookContext context;
            private Collection<HgHook> hooks;
            private final HgProgressSupport support;
            private File[] hookFiles;
            private final Map<File, Set<File>> rootFilesPerRepository;
            private final Map<File, Set<File>> refreshFilesPerRepository;
            private final Map<File, Boolean> locallyModifiedExcluded;
            private final boolean closingBranch;
            private String originalMessage;
            private final String user;
            private boolean afterMerge;

            public CommitCmd(Map<File, List<File>> m, OutputLogger logger, String commitMessage, HgProgressSupport support, Map<File, Set<File>> rootFilesPerRepository, Map<File, Boolean> locallyModifiedExcluded, Map<File, Set<File>> filesToRefresh, String user, boolean closingBranch, boolean afterMerge) {
                super(m, logger, commitMessage, null);
                this.support = support;
                this.rootFilesPerRepository = rootFilesPerRepository;
                this.locallyModifiedExcluded = locallyModifiedExcluded;
                this.refreshFilesPerRepository = filesToRefresh;
                this.user = user;
                this.closingBranch = closingBranch;
                this.afterMerge = afterMerge;
            }

            public void setCommitHooks(HgHookContext context, Collection<HgHook> hooks, File[] hookFiles, String originalMessage) {
                this.context = context;
                this.hooks = hooks;
                this.hookFiles = hookFiles;
                this.originalMessage = originalMessage;
            }

            @Override
            void handle() throws HgException {
                if (this.m.isEmpty()) {
                    return;
                }
                for (Map.Entry e : this.m.entrySet()) {
                    this.doCmd((File)e.getKey(), (List)e.getValue());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            void doCmd(File repository, List<File> candidates) throws HgException {
                block31: {
                    block29: {
                        commitAfterMerge = false;
                        refreshFiles /* !! */  = new HashSet<File>(candidates);
                        commitedFiles = null;
                        try {
                            if (this.afterMerge) {
                                if (CommitAction.access$300(Boolean.TRUE.equals(this.locallyModifiedExcluded.get(repository)), repository)) {
                                    HgCommand.doCommit(repository, Collections.emptyList(), this.msg, this.user, this.closingBranch, this.logger);
                                    refreshFiles /* !! */  = new HashSet<File>(Mercurial.getInstance().getSeenRoots(repository));
                                    commitAfterMerge = true;
                                    break block29;
                                }
                                this.refreshFilesPerRepository.put(repository, refreshFiles /* !! */ );
                            }
                            ** GOTO lbl-1000
                        }
                        catch (HgException.HgTooLongArgListException e) {
                            Mercurial.LOG.log(Level.INFO, null, e);
                            offeredFileNames = "";
                            roots = this.rootFilesPerRepository.get(repository);
                            if (roots != null && roots.size() < 5) {
                                reducedCommitCandidates = new ArrayList<File>(roots);
                                refreshFiles /* !! */  = new HashSet<File>(roots);
                                var10_13 = reducedCommitCandidates.iterator();
                                while (var10_13.hasNext()) {
                                    f = (File)var10_13.next();
                                    offeredFileNames = offeredFileNames + "\n" + f.getName();
                                }
                            } else {
                                reducedCommitCandidates = Collections.emptyList();
                                refreshFiles /* !! */  = Collections.singleton(repository);
                                offeredFileNames = "\n" + repository.getName();
                            }
                            descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CommitAction.class, (String)"MSG_LONG_COMMAND_QUERY", (Object)offeredFileNames));
                            descriptor.setTitle(NbBundle.getMessage(CommitAction.class, (String)"MSG_LONG_COMMAND_TITLE"));
                            descriptor.setMessageType(2);
                            descriptor.setOptionType(0);
                            res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                            if (res == NotifyDescriptor.NO_OPTION) {
                                this.refreshFilesPerRepository.put(repository, refreshFiles /* !! */ );
                                if (commitedFiles == null) return;
                                Mercurial.getInstance().getMercurialHistoryProvider().fireHistoryChange(commitedFiles.toArray(new File[commitedFiles.size()]));
                                return;
                            }
                            try {
                                Mercurial.LOG.log(Level.INFO, "CommitAction: committing with a reduced set of files: {0}", reducedCommitCandidates.toString());
                                HgCommand.doCommit(repository, reducedCommitCandidates, this.msg, this.user, this.closingBranch, this.logger);
                                commitedFiles = reducedCommitCandidates;
                                break block29;
                            }
                            catch (HgException ex) {
                                block30: {
                                    if ("commitAfterMerge".equals(ex.getMessage()) == false) throw ex;
                                    if (!this.support.isCanceled()) break block30;
                                    this.refreshFilesPerRepository.put(repository, refreshFiles /* !! */ );
                                    if (commitedFiles == null) return;
                                    Mercurial.getInstance().getMercurialHistoryProvider().fireHistoryChange(commitedFiles.toArray(new File[commitedFiles.size()]));
                                    return;
                                }
                                ** try [egrp 5[TRYBLOCK] [9 : 610->633)] { 
lbl59:
                                // 1 sources

                                if (!CommitAction.access$300(Boolean.TRUE.equals(this.locallyModifiedExcluded.get(repository)), repository)) {
                                    return;
                                }
                                HgCommand.doCommit(repository, Collections.emptyList(), this.msg, this.user, this.closingBranch, this.logger);
                                refreshFiles /* !! */  = new HashSet<File>(Mercurial.getInstance().getSeenRoots(repository));
                                commitAfterMerge = true;
                                break block31;
lbl65:
                                // 1 sources

                                finally {
                                    this.refreshFilesPerRepository.put(repository, refreshFiles /* !! */ );
                                    if (commitedFiles != null) {
                                        Mercurial.getInstance().getMercurialHistoryProvider().fireHistoryChange(commitedFiles.toArray(new File[commitedFiles.size()]));
                                    }
                                }
                            }
                        }
                        if (commitedFiles == null) return;
                        Mercurial.getInstance().getMercurialHistoryProvider().fireHistoryChange(commitedFiles.toArray(new File[commitedFiles.size()]));
                        return;
lbl-1000:
                        // 1 sources

                        {
                            HgCommand.doCommit(repository, candidates, this.msg, this.user, this.closingBranch, this.logger);
                            commitedFiles = candidates;
                        }
                    }
                    this.refreshFilesPerRepository.put(repository, refreshFiles /* !! */ );
                    if (commitedFiles != null) {
                        Mercurial.getInstance().getMercurialHistoryProvider().fireHistoryChange(commitedFiles.toArray(new File[commitedFiles.size()]));
                    }
                }
                tip = HgCommand.doTip(repository, this.logger);
                this.context = new HgHookContext(this.hookFiles, this.originalMessage, new HgHookContext.LogEntry[]{new HgHookContext.LogEntry(tip.getMessage(), tip.getAuthor(), tip.getCSetShortID(), tip.getDate())});
                for (HgHook hook : this.hooks) {
                    hook.afterCommit(this.context);
                }
                if (commitAfterMerge) {
                    this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMITED_FILES_AFTER_MERGE"));
                } else {
                    if (candidates.size() == 1) {
                        this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP_ONE", (Object)candidates.size()));
                    } else if (!candidates.isEmpty()) {
                        this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP", (Object)candidates.size()));
                    }
                    for (File f : candidates) {
                        this.logger.output("\t" + f.getAbsolutePath());
                    }
                }
                HgUtils.logHgLog(tip, this.logger);
                if (this.closingBranch == false) return;
                try {
                    branchName = HgCommand.getBranch(repository);
                }
                catch (HgException ex) {
                    branchName = "";
                }
                this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_BRANCH_CLOSED", (Object)branchName));
            }
        }

        static class RemoveCmd
        extends Cmd {
            public RemoveCmd(Map<File, List<File>> m, OutputLogger logger, String msgFormat, String msg) {
                super(m, logger, msgFormat, msg);
            }

            @Override
            void doCmd(File repository, List<File> candidates) throws HgException {
                HgCommand.doRemove(repository, candidates, this.logger);
            }
        }

        static class AddCmd
        extends Cmd {
            public AddCmd(Map<File, List<File>> m, OutputLogger logger, String msgFormat, String msg) {
                super(m, logger, msgFormat, msg);
            }

            @Override
            void doCmd(File repository, List<File> candidates) throws HgException {
                HgCommand.doAdd(repository, candidates, this.logger);
            }
        }
    }
}

