/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;

public abstract class BundleSupport
extends BodyTagSupport {
    private static final Locale EMPTY_LOCALE = new Locale("", "");
    protected String basename;
    protected String prefix;
    private Locale fallbackLocale;
    private LocalizationContext locCtxt;

    public BundleSupport() {
        this.init();
    }

    private void init() {
        this.prefix = null;
        this.basename = null;
        this.locCtxt = null;
    }

    public LocalizationContext getLocalizationContext() {
        return this.locCtxt;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int doStartTag() throws JspException {
        this.locCtxt = BundleSupport.getLocalizationContext(this.pageContext, this.basename);
        return 2;
    }

    public int doEndTag() throws JspException {
        if (this.bodyContent != null) {
            try {
                this.pageContext.getOut().print(this.bodyContent.getString());
            }
            catch (IOException ioe) {
                throw new JspTagException(ioe.getMessage());
            }
        }
        return 6;
    }

    public void release() {
        this.init();
    }

    public static LocalizationContext getLocalizationContext(PageContext pc) {
        LocalizationContext locCtxt = null;
        Object obj = Config.find((PageContext)pc, (String)"javax.servlet.jsp.jstl.fmt.localizationContext");
        if (obj == null) {
            return null;
        }
        locCtxt = obj instanceof LocalizationContext ? (LocalizationContext)obj : BundleSupport.getLocalizationContext(pc, (String)obj);
        return locCtxt;
    }

    public static LocalizationContext getLocalizationContext(PageContext pc, String basename) {
        LocalizationContext locCtxt = null;
        ResourceBundle bundle = null;
        if (basename == null || basename.equals("")) {
            return new LocalizationContext();
        }
        Locale pref = SetLocaleSupport.getLocale(pc, "javax.servlet.jsp.jstl.fmt.locale");
        if (pref != null) {
            bundle = BundleSupport.findMatch(basename, pref);
            if (bundle != null) {
                locCtxt = new LocalizationContext(bundle, pref);
            }
        } else {
            locCtxt = BundleSupport.findMatch(pc, basename);
        }
        if (locCtxt == null && (pref = SetLocaleSupport.getLocale(pc, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null && (bundle = BundleSupport.findMatch(basename, pref)) != null) {
            locCtxt = new LocalizationContext(bundle, pref);
        }
        if (locCtxt == null) {
            try {
                bundle = ResourceBundle.getBundle(basename, EMPTY_LOCALE, Thread.currentThread().getContextClassLoader());
                if (bundle != null) {
                    locCtxt = new LocalizationContext(bundle, null);
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (locCtxt != null) {
            if (locCtxt.getLocale() != null) {
                SetLocaleSupport.setResponseLocale(pc, locCtxt.getLocale());
            }
        } else {
            locCtxt = new LocalizationContext();
        }
        return locCtxt;
    }

    private static LocalizationContext findMatch(PageContext pageContext, String basename) {
        LocalizationContext locCtxt = null;
        Enumeration enumeration = pageContext.getRequest().getLocales();
        while (enumeration.hasMoreElements()) {
            Locale pref = (Locale)enumeration.nextElement();
            ResourceBundle match = BundleSupport.findMatch(basename, pref);
            if (match == null) continue;
            locCtxt = new LocalizationContext(match, pref);
            break;
        }
        return locCtxt;
    }

    private static ResourceBundle findMatch(String basename, Locale pref) {
        ResourceBundle match = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(basename, pref, Thread.currentThread().getContextClassLoader());
            Locale avail = bundle.getLocale();
            if (pref.equals(avail)) {
                match = bundle;
            } else if (pref.getLanguage().equals(avail.getLanguage()) && ("".equals(avail.getCountry()) || pref.getCountry().equals(avail.getCountry()))) {
                match = bundle;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return match;
    }
}

