/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer.vmo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.JavaVMOption;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.VMOptionsTableModel;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.ValueCellEditor;
import org.openide.util.NbBundle;

public class VMOptionEditorPanel
extends JPanel {
    private ValueCellEditor cellEditor;
    private final Callback callback;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JTable optionsTable;
    private JTextField variablePreviewTextField;

    public VMOptionEditorPanel(Callback callback, VMOptionsTableModel model) {
        this.callback = callback;
        this.initComponents();
        this.optionsTable.setModel(model);
        this.cellEditor = new ValueCellEditor();
        this.configureTable();
    }

    private void configureTable() {
        final TableColumnModel tcm = this.optionsTable.getColumnModel();
        this.setUpColumns(tcm, 0, tcm.getColumnCount() - 1);
        tcm.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                VMOptionEditorPanel.this.setUpColumns(tcm, e.getFromIndex(), e.getToIndex());
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.optionsTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                VMOptionEditorPanel.this.processText();
            }
        });
        this.processText();
        this.optionsTable.setFillsViewportHeight(true);
        this.optionsTable.setShowVerticalLines(false);
    }

    private void processText() {
        List<JavaVMOption<?>> list = this.getOptions();
        StringBuilder sb = new StringBuilder();
        for (JavaVMOption<?> option : list) {
            option.print(sb);
            sb.append(" ");
        }
        this.variablePreviewTextField.setText(sb.toString());
    }

    private void setUpColumns(TableColumnModel tcm, int start, int stop) {
        for (int i = start; i <= stop; ++i) {
            TableColumn column = tcm.getColumn(i);
            this.setUpColumn(column);
            if (i != 0) continue;
            column.setPreferredWidth(150);
            column.setMaxWidth(150);
        }
    }

    private void setUpColumn(TableColumn column) {
        column.setCellRenderer(this.cellEditor);
        column.setCellEditor(this.cellEditor);
    }

    private void initComponents() {
        this.variablePreviewTextField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.optionsTable = new JTable();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.variablePreviewTextField.setEditable(false);
        this.variablePreviewTextField.setText(NbBundle.getMessage(VMOptionEditorPanel.class, (String)"VMOptionEditorPanel.variablePreviewTextField.text"));
        this.optionsTable.setModel(new VMOptionsTableModel());
        this.jScrollPane1.setViewportView(this.optionsTable);
        this.cancelButton.setText(NbBundle.getMessage(VMOptionEditorPanel.class, (String)"VMOptionEditorPanel.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VMOptionEditorPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText(NbBundle.getMessage(VMOptionEditorPanel.class, (String)"VMOptionEditorPanel.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VMOptionEditorPanel.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 417, Short.MAX_VALUE).addComponent(this.variablePreviewTextField, GroupLayout.Alignment.LEADING, -1, 417, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.variablePreviewTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 246, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.callback != null) {
            this.callback.okButtonActionPerformed(evt);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.callback != null) {
            this.callback.cancelButtonActionPerformed(evt);
        }
    }

    void setText(String text) {
        this.variablePreviewTextField.setText(text);
    }

    List<JavaVMOption<?>> getOptions() {
        VMOptionsTableModel tableModel = (VMOptionsTableModel)this.optionsTable.getModel();
        return tableModel.getValidOptions();
    }

    public static interface Callback {
        public void okButtonActionPerformed(ActionEvent var1);

        public void cancelButtonActionPerformed(ActionEvent var1);
    }
}

