/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.html.palette.HtmlPaletteUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private FileFilter filter;
    public static final FileFilter imageFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return FileUtil.toFileObject((File)pathname).getMIMEType().startsWith("image/");
        }
    };
    private JPanel folderPanel;
    private JLabel jLabel1;

    public BrowseFolders(SourceGroup[] folders, FileFilter filter) {
        this.initComponents();
        this.filter = filter;
        if (this.filter == null) {
            this.filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        this.manager = new ExplorerManager();
        AbstractNode rootNode = new AbstractNode((Children)new SourceGroupsChildren(folders));
        this.manager.setRootContext((Node)rootNode);
        BeanTreeView btv = new BeanTreeView();
        btv.setRootVisible(false);
        btv.setSelectionMode(1);
        btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        btv.setDefaultActionAllowed(false);
        this.expandFirstLevel(btv);
        this.folderPanel.add((Component)btv, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void expandFirstLevel(BeanTreeView btv) {
        Node root = this.manager.getRootContext();
        Children ch = root.getChildren();
        if (ch == Children.LEAF) {
            return;
        }
        Node[] nodes = ch.getNodes(true);
        btv.expandNode(root);
        for (int i = 0; i < nodes.length; ++i) {
            btv.expandNode(nodes[i]);
            if (i != 0) continue;
            try {
                this.manager.setSelectedNodes(new Node[]{nodes[i]});
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        this.jLabel1.setText(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Folders"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
    }

    public static FileObject showDialog(SourceGroup[] folders) {
        return BrowseFolders.showDialog(folders, null);
    }

    public static FileObject showDialog(SourceGroup[] folders, FileFilter filter) {
        final BrowseFolders bf = new BrowseFolders(folders, filter);
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_SelectFile")), new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Cancel"))};
        options[0].setEnabled(false);
        JTree tree = HtmlPaletteUtilities.findTreeComponent(bf);
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener((JButton[])options){
            final /* synthetic */ JButton[] val$options;
            {
                this.val$options = jButtonArray;
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FileObject fileObject = bf.getSelectedFileObject();
                this.val$options[0].setEnabled(fileObject != null && !fileObject.isFolder());
            }
        });
        OptionsListener optionsListener = new OptionsListener(bf);
        options[0].setActionCommand("SELECT");
        options[0].addActionListener(optionsListener);
        options[1].setActionCommand("CANCEL");
        options[1].addActionListener(optionsListener);
        TreeMouseAdapter ml = new TreeMouseAdapter(tree, bf, (JButton[])options);
        tree.addMouseListener(ml);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)bf, NbBundle.getMessage(BrowseFolders.class, (String)"LBL_BrowseFiles"), true, options, (Object)options[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return optionsListener.getResult();
    }

    private FileObject getSelectedFileObject() {
        Node[] selection = this.getExplorerManager().getSelectedNodes();
        if (selection != null && selection.length > 0) {
            DataObject dobj = (DataObject)selection[0].getLookup().lookup(DataObject.class);
            return dobj.getPrimaryFile();
        }
        return null;
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private BrowseFolders browsePanel;
        private FileObject result;

        public OptionsListener(BrowseFolders browsePanel) {
            this.browsePanel = browsePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (COMMAND_SELECT.equals(command)) {
                this.result = this.browsePanel.getSelectedFileObject();
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    private class FileObjectComparator
    implements Comparator {
        private FileObjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            FileObject fo1 = (FileObject)o1;
            FileObject fo2 = (FileObject)o2;
            return fo1.getName().compareTo(fo2.getName());
        }
    }

    private final class SourceGroupsChildren
    extends Children.Keys {
        private SourceGroup[] groups;
        private SourceGroup group;
        private FileObject fo;

        public SourceGroupsChildren(SourceGroup[] groups) {
            this.groups = groups;
        }

        public SourceGroupsChildren(FileObject fo, SourceGroup group) {
            this.fo = fo;
            this.group = group;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            FileObject fObj = null;
            SourceGroup group = null;
            boolean isFile = false;
            if (key instanceof SourceGroup) {
                fObj = ((SourceGroup)key).getRootFolder();
                group = (SourceGroup)key;
            } else if (key instanceof Key) {
                fObj = ((Key)key).folder;
                group = ((Key)key).group;
                if (!fObj.isFolder()) {
                    isFile = true;
                }
            }
            try {
                FilterNode fn;
                DataObject dobj = DataObject.find((FileObject)fObj);
                FilterNode filterNode = fn = isFile ? new FilterNode(dobj.getNodeDelegate(), Children.LEAF) : new FilterNode(dobj.getNodeDelegate(), (Children)new SourceGroupsChildren(fObj, group));
                if (key instanceof SourceGroup) {
                    fn.setDisplayName(group.getDisplayName());
                }
                return new Node[]{fn};
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        private Collection getKeys() {
            FileObject file;
            int i;
            if (this.groups != null) {
                return Arrays.asList(this.groups);
            }
            FileObject[] files = this.fo.getChildren();
            Arrays.sort(files, new FileObjectComparator());
            ArrayList<Key> children = new ArrayList<Key>(files.length);
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                if (!this.group.contains(files[i]) || !file.isFolder()) continue;
                children.add(new Key(files[i], this.group));
            }
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                if (!this.group.contains(file) || files[i].isFolder() || !BrowseFolders.this.filter.accept(FileUtil.toFile((FileObject)file))) continue;
                children.add(new Key(files[i], this.group));
            }
            return children;
        }

        private class Key {
            private FileObject folder;
            private SourceGroup group;

            private Key(FileObject folder, SourceGroup group) {
                this.folder = folder;
                this.group = group;
            }
        }
    }

    static class TreeMouseAdapter
    extends MouseAdapter {
        JTree tree;
        BrowseFolders bf;
        JButton[] options;

        TreeMouseAdapter(JTree tree, BrowseFolders bf, JButton[] options) {
            this.tree = tree;
            this.bf = bf;
            this.options = options;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FileObject fileObject;
            int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow != -1 && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0 && (fileObject = this.bf.getSelectedFileObject()) != null && !fileObject.isFolder()) {
                this.options[0].doClick();
            }
        }
    }
}

